/*
 * Decompiled with CFR 0.152.
 */
package com.sas.entities;

import com.sas.codepolicy.SASScope;
import com.sas.entities.AttributeDescriptor;
import com.sas.entities.AttributeDescriptorInterface;
import com.sas.entities.AttributeGroup;
import com.sas.entities.AttributeGroupInterface;
import com.sas.entities.AttributeSetException;
import com.sas.entities.AttributeTypeFactory;
import com.sas.entities.AttributeTypeFactoryInterface;
import com.sas.entities.AttributeTypeInterface;
import com.sas.entities.AttributeTypeUtility;
import com.sas.entities.BaseEntity;
import com.sas.entities.EntityDate;
import com.sas.entities.EntityInterface;
import com.sas.entities.EntityRB;
import com.sas.entities.RemoteEntity;
import com.sas.entities.RemoteEntityInterface;
import java.beans.PropertyDescriptor;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

@SASScope(value="ALL")
public class Entity
extends BaseEntity
implements EntityInterface,
Cloneable {
    public static final String RB_KEY = "Entity.";
    private RemoteEntityInterface prototype;
    private static AttributeTypeFactoryInterface atfi;
    private AttributeGroupInterface attributeGroup;
    private String customizer;
    private ArrayList attributesSet;
    private static String EMPTY_STRING;
    @SASScope
    protected VetoableChangeSupport vcs;
    @SASScope
    protected Map supplementalProperties;
    protected Map dynamicSupplementalProperties;
    @SASScope
    protected static ArrayList classLoaders;
    private static Object[] _getterObjectArray;

    public Entity() {
        Map propDescriptors = this.getPropertyDescriptors();
        atfi = new AttributeTypeFactory();
        if (this.attributesSet == null) {
            this.attributesSet = new ArrayList();
        }
        if (this.attributeGroup == null) {
            this.attributeGroup = new AttributeGroup(this, propDescriptors);
        }
        AttributeDescriptorInterface[] attributes = this.getAttributeDescriptors();
        int numberOfAttributes = attributes.length;
        for (int i = 0; i < numberOfAttributes; ++i) {
            if (!propDescriptors.containsKey(attributes[i].getName())) continue;
            attributes[i].setProperty(true);
        }
        this.vcs = new VetoableChangeSupport(this);
    }

    public Entity(Map supplementalAttributeProperties) {
        Map propDescriptors = this.getPropertyDescriptors();
        atfi = new AttributeTypeFactory();
        if (supplementalAttributeProperties == null) {
            throw new IllegalArgumentException(EntityRB.getStringResource("emptyMap.ex.txt"));
        }
        this.supplementalProperties = supplementalAttributeProperties;
        if (this.attributesSet == null) {
            this.attributesSet = new ArrayList();
        }
        if (this.attributeGroup == null) {
            this.attributeGroup = new AttributeGroup((RemoteEntityInterface)this, propDescriptors, this.supplementalProperties);
        }
        AttributeDescriptorInterface[] attributes = this.getAttributeDescriptors();
        int numberOfAttributes = attributes.length;
        for (int i = 0; i < numberOfAttributes; ++i) {
            if (!propDescriptors.containsKey(attributes[i].getName())) continue;
            attributes[i].setProperty(true);
        }
        this.vcs = new VetoableChangeSupport(this);
    }

    public Entity(AttributeTypeFactoryInterface atfi) {
        if (atfi != null) {
            Entity.atfi = atfi;
        } else {
            atfi = new AttributeTypeFactory();
        }
        Map propDescriptors = this.getPropertyDescriptors();
        if (this.attributesSet == null) {
            this.attributesSet = new ArrayList();
        }
        if (this.attributeGroup == null) {
            this.attributeGroup = new AttributeGroup((RemoteEntityInterface)this, propDescriptors, atfi);
        }
        AttributeDescriptorInterface[] attributes = this.getAttributeDescriptors();
        int numberOfAttributes = attributes.length;
        for (int i = 0; i < numberOfAttributes; ++i) {
            if (!propDescriptors.containsKey(attributes[i].getName())) continue;
            attributes[i].setProperty(true);
        }
        this.vcs = new VetoableChangeSupport(this);
    }

    public Entity(Map supplementalAttributeProperties, AttributeTypeFactoryInterface atfi) {
        Map propDescriptors = this.getPropertyDescriptors();
        if (atfi != null) {
            Entity.atfi = atfi;
        } else {
            atfi = new AttributeTypeFactory();
        }
        if (supplementalAttributeProperties == null) {
            throw new IllegalArgumentException(EntityRB.getStringResource("emptyMap.ex.txt"));
        }
        this.supplementalProperties = supplementalAttributeProperties;
        if (this.attributesSet == null) {
            this.attributesSet = new ArrayList();
        }
        if (this.attributeGroup == null) {
            this.attributeGroup = new AttributeGroup(this, propDescriptors, atfi, this.supplementalProperties);
        }
        AttributeDescriptorInterface[] attributes = this.getAttributeDescriptors();
        int numberOfAttributes = attributes.length;
        for (int i = 0; i < numberOfAttributes; ++i) {
            if (!propDescriptors.containsKey(attributes[i].getName())) continue;
            attributes[i].setProperty(true);
        }
        this.vcs = new VetoableChangeSupport(this);
    }

    @Override
    public void setEntityKey(String guid) {
        super.setEntityKey(guid);
    }

    public synchronized boolean equals(Entity p) {
        return this.getAttributeCount() == p.getAttributeCount() && this.getDelegate().equals(p.getDelegate());
    }

    @Override
    public synchronized boolean equals(Object o) {
        return o instanceof Entity && this.equals((Entity)o);
    }

    @Override
    public String getCustomizer(String contextNotYetImplementedThusIGNORED) {
        return this.customizer;
    }

    @Override
    public void setCustomizer(String contextNotYetImplementedThusIGNORED, String customizer) {
        this.customizer = customizer;
    }

    @Override
    public List getCustomizerContexts() {
        return null;
    }

    @Override
    public void addAttributeValidator(String attributeName, VetoableChangeListener listener) {
        this.addVetoableChangeListener(attributeName, listener);
    }

    @Override
    public void removeAttributeValidator(String attributeName, VetoableChangeListener listener) {
        this.removeVetoableChangeListener(attributeName, listener);
    }

    @Override
    public Map getAttributeValidators() {
        return null;
    }

    @Override
    public AttributeGroupInterface getAttributeGroup() {
        return this.attributeGroup;
    }

    @Override
    public RemoteEntityInterface getPrototype() {
        return this.prototype;
    }

    @Override
    public void setPrototype(RemoteEntityInterface prototype) {
        this.prototype = prototype;
    }

    @Override
    public AttributeTypeInterface getAttributeType(String attributeName) {
        if (!this.attributeGroup.containsAttributeDescriptorNamed(attributeName, true)) {
            throw new NoSuchElementException(attributeName);
        }
        AttributeDescriptorInterface adi = this.attributeGroup.getAttributeDescriptor(attributeName, true);
        return adi.getType();
    }

    @Override
    public String getStringAttribute(String attributeName, String defaultValue) {
        Object value = defaultValue;
        AttributeDescriptorInterface adi = this.getAttributeDescriptor(attributeName);
        AttributeTypeInterface ati = adi.getType();
        PropertyDescriptor pd = (PropertyDescriptor)propertyDescriptors.get(attributeName);
        if (pd == null) {
            value = ((Map)this.getDelegate()).get(attributeName);
            if ((value = RemoteEntity.unmap(value)) == null) {
                if (defaultValue != null) {
                    return defaultValue;
                }
                return adi.getStringDefault();
            }
            return AttributeTypeUtility.transformValueToSASFormat(value, ati);
        }
        Method getter = pd.getReadMethod();
        if (getter != null) {
            value = this.invokeGetter(getter);
        }
        return value;
    }

    @Override
    public Object getAttribute(String attributeName) throws NoSuchElementException {
        AttributeDescriptorInterface adi = this.getAttributeDescriptor(attributeName);
        if (adi == null) {
            throw new NoSuchElementException(attributeName);
        }
        Object val = this.getAttribute(attributeName, adi.getDefault(), this.getPropertyDescriptors(this.getClass()));
        if (attributeName.equals("entityKey")) {
            return val;
        }
        if (this.attributesSet.contains(attributeName)) {
            AttributeTypeInterface ati = adi.getType();
            if (ati != null) {
                Class componentClass = AttributeTypeUtility.getJavaClassToConstruct(ati.getSQLType(), ati.getName());
                if (componentClass != null) {
                    if (componentClass.getName().equals(AttributeTypeUtility.JAVA_AWT_COLOR)) {
                        return AttributeTypeUtility.convertValueToColor(val);
                    }
                    if (ati.getSQLType() == 91) {
                        return AttributeTypeUtility.convertValueToDate(val);
                    }
                    return AttributeTypeUtility.transformAttributeValue(val, adi);
                }
                return val;
            }
            return val;
        }
        return val;
    }

    @Override
    @SASScope
    protected Object getAttribute(String attributeName, Object defaultValue, Map propertyDescriptors) {
        Object value = defaultValue;
        PropertyDescriptor pd = (PropertyDescriptor)propertyDescriptors.get(attributeName);
        if (pd == null) {
            value = ((Map)this.getDelegate()).get(attributeName);
            if ((value = RemoteEntity.unmap(value)) == null && defaultValue != null) {
                value = defaultValue;
            }
        } else {
            Method getter = pd.getReadMethod();
            if (getter != null) {
                value = this.invokeGetter(getter);
            }
        }
        return value;
    }

    @SASScope
    public Object invokeGetter(Method getter) {
        Object o = null;
        try {
            o = getter.invoke((Object)this, _getterObjectArray);
            return o;
        }
        catch (InvocationTargetException ite) {
            throw new IllegalArgumentException(ite.getLocalizedMessage());
        }
        catch (IllegalAccessException ite) {
            throw new IllegalArgumentException(ite.getLocalizedMessage());
        }
        finally {
            return o;
        }
    }

    public List listAllRequiredAttributesNotAssigned() {
        ArrayList<String> notAssigned = new ArrayList<String>();
        AttributeDescriptorInterface[] adi = this.attributeGroup.getAttributeDescriptors(true);
        int numberOfAttributes = adi.length;
        String attributeName = null;
        for (int i = 0; i < adi.length; ++i) {
            if (!adi[i].isRequired() || this.isAttributeAssigned(attributeName = adi[i].getName())) continue;
            notAssigned.add(attributeName);
        }
        return notAssigned;
    }

    @Override
    @SASScope
    protected boolean setAttribute(String attributeName, Map propertyDescriptors, Object[] args) throws AttributeSetException {
        Object oldValue = null;
        boolean returnType = false;
        PropertyDescriptor pd = (PropertyDescriptor)propertyDescriptors.get(attributeName);
        if (pd == null) {
            oldValue = ((HashMap)this.getDelegate()).get(attributeName);
            if (!this.attributeGroup.containsAttributeDescriptorNamed(attributeName, true)) {
                AttributeDescriptor ad = new AttributeDescriptor(attributeName, this.dynamicSupplementalProperties != null ? this.dynamicSupplementalProperties : this.supplementalProperties);
                if (args[0] == null) {
                    ad.setType(AttributeTypeFactory.NULL_ATTRIBUTE_TYPE);
                } else {
                    Class<?> objectClass = args[0].getClass();
                    if (objectClass.isArray()) {
                        Class<?> componentClass = objectClass.getComponentType();
                        String componentType = componentClass.getName();
                        ad.setType(atfi.createAttributeType(null, 2003, componentType));
                    } else {
                        int sqlType = AttributeTypeUtility.NO_SQL_TYPE_DEFINED;
                        String objectClassName = objectClass.getName();
                        String objectType = null;
                        if (AttributeTypeUtility.isArrayPropertyType(objectClassName)) {
                            sqlType = 2003;
                            objectType = AttributeTypeUtility.getArrayComponentType(objectClassName);
                        } else {
                            ad.setType(AttributeTypeUtility.createAttributeTypeFromClassName(atfi, objectClassName));
                            ClassLoader objectClassLoader = objectClass.getClassLoader();
                            if (objectClassLoader != this.getSystemClassLoader() && objectClassLoader != null) {
                                classLoaders.add(objectClassLoader);
                            }
                        }
                    }
                }
                this.attributeGroup.addAttributeDescriptor(ad, -1);
                ((HashMap)this.getDelegate()).put(attributeName, RemoteEntity.map(args[0]));
                this.attributesSet.add(attributeName);
            } else {
                AttributeDescriptorInterface ad = this.getAttributeGroup().getAttributeDescriptor(attributeName, true);
                if (!ad.isModifiable()) {
                    throw new AttributeSetException(MessageFormat.format(EntityRB.getStringResource("attributeNotModifiable.ex.txt"), attributeName));
                }
                AttributeTypeInterface at = ad.getType();
                if (at == null) {
                    if (args[0] == null) {
                        ad.setType(AttributeTypeFactory.NULL_ATTRIBUTE_TYPE);
                    } else {
                        Class<?> objectClass = args[0].getClass();
                        if (objectClass.isArray()) {
                            Class<?> componentClass = objectClass.getComponentType();
                            String componentType = componentClass.getName();
                            ad.setType(atfi.createAttributeType(null, 2003, componentType));
                        } else {
                            int sqlType = AttributeTypeUtility.NO_SQL_TYPE_DEFINED;
                            String objectClassName = objectClass.getName();
                            String objectType = null;
                            if (AttributeTypeUtility.isArrayPropertyType(objectClassName)) {
                                sqlType = 2003;
                                objectType = AttributeTypeUtility.getArrayComponentType(objectClassName);
                            } else {
                                ad.setType(AttributeTypeUtility.createAttributeTypeFromClassName(atfi, objectClassName));
                                ClassLoader objectClassLoader = objectClass.getClassLoader();
                                if (objectClassLoader != this.getSystemClassLoader() && objectClassLoader != null) {
                                    classLoaders.add(objectClassLoader);
                                }
                            }
                        }
                    }
                    ((HashMap)this.getDelegate()).put(attributeName, RemoteEntity.map(args[0]));
                    if (!this.attributesSet.contains(attributeName)) {
                        this.attributesSet.add(attributeName);
                    }
                } else {
                    boolean goodAttributeType = true;
                    if (args != null && args[0] instanceof List) {
                        if (at != null && at.getSQLType() == 16) {
                            throw new AttributeSetException(MessageFormat.format(EntityRB.getStringResource("illegalListForBoolean.ex.txt"), attributeName));
                        }
                        List valueItems = (List)args[0];
                        int listSize = valueItems.size();
                        for (int i = 0; i < listSize; ++i) {
                            this.verifyAttributeType(attributeName, new Object[]{valueItems.get(i)});
                        }
                        ((HashMap)this.getDelegate()).put(attributeName, RemoteEntity.map(args[0]));
                    } else {
                        goodAttributeType = this.verifyAttributeType(attributeName, args);
                    }
                    if (goodAttributeType) {
                        ((HashMap)this.getDelegate()).put(attributeName, RemoteEntity.map(args[0]));
                        if (!this.attributesSet.contains(attributeName)) {
                            this.attributesSet.add(attributeName);
                        }
                    }
                }
                if (ad.isDefaultValueHasBeenSet()) {
                    if (at != null && at.getName() != null && at.getName().equals("Color")) {
                        AttributeTypeUtility.validateDefaultValue(ad.getStringDefault(), ad.getType(), true, attributeName);
                    } else {
                        AttributeTypeUtility.validateDefaultValue(ad.getDefault(), ad.getType(), true, attributeName);
                    }
                }
            }
        } else {
            if (!this.attributeGroup.containsAttributeDescriptorNamed(attributeName, true)) {
                throw new AttributeSetException(MessageFormat.format(EntityRB.getStringResource("attributeNotFoundInAttributeGroup.ex.txt"), attributeName));
            }
            if (!this.attributeGroup.getAttributeDescriptor(attributeName, true).isModifiable()) {
                throw new AttributeSetException(MessageFormat.format(EntityRB.getStringResource("attributeNotModifiable.ex.txt"), attributeName));
            }
            Method setter = pd.getWriteMethod();
            if (setter != null) {
                try {
                    Method getter = pd.getWriteMethod();
                    if (getter != null) {
                        oldValue = getter.invoke((Object)this, args);
                    }
                    setter.invoke((Object)this, args);
                    if (!this.attributesSet.contains(attributeName)) {
                        this.attributesSet.add(attributeName);
                    }
                }
                catch (InvocationTargetException ite) {
                    AttributeSetException ase = new AttributeSetException(ite.getMessage());
                    ase.initCause(ite);
                    throw ase;
                }
                catch (IllegalAccessException ite) {
                    AttributeSetException ase = new AttributeSetException(ite.getMessage());
                    ase.initCause(ite);
                    throw ase;
                }
            }
            returnType = true;
        }
        this.fireVetoableChange(attributeName, oldValue, args[0]);
        return returnType;
    }

    @Override
    public synchronized void removeAttribute(String attributeName) {
        if (!this.getAttributeDescriptor(attributeName).isProperty()) {
            ((HashMap)this.getDelegate()).remove(attributeName);
            this.getAttributesMap().remove(attributeName);
            this.attributesSet.remove(attributeName);
            this.getAttributeGroup().removeAttributeDescriptor(attributeName, true);
        }
    }

    @Override
    public synchronized void removeAllAttributes() {
        String[] attributeNames = this.getAttributeGroup().getAttributeDescriptorNames(true);
        int arrayLength = attributeNames.length;
        for (int i = arrayLength - 1; i >= 0; --i) {
            this.removeAttribute(attributeNames[i]);
        }
    }

    @Override
    public AttributeDescriptorInterface[] getAttributeDescriptors() {
        return this.attributeGroup.getAttributeDescriptors(true);
    }

    @Override
    public AttributeDescriptorInterface getAttributeDescriptor(String attributeName) throws NoSuchElementException {
        if (!this.attributeGroup.containsAttributeDescriptorNamed(attributeName, true)) {
            throw new NoSuchElementException(attributeName);
        }
        return this.attributeGroup.getAttributeDescriptor(attributeName, true);
    }

    @Override
    public boolean isAttributeAssigned(String attributeName) throws NoSuchElementException {
        if (!this.attributeGroup.containsAttributeDescriptorNamed(attributeName, true)) {
            throw new NoSuchElementException(attributeName);
        }
        if (this.attributesSet.contains(attributeName) || this.attributeGroup.getAttributeDescriptor(attributeName, true).isDefaultValueHasBeenSet()) {
            Object value = this.getAttribute(attributeName);
            return value != null && value.toString().trim().length() != 0;
        }
        return false;
    }

    @Override
    public AttributeDescriptorInterface[] getBooleanSpecifiedAttributeDescriptors(Map map) throws NoSuchMethodException {
        ArrayList<AttributeDescriptorInterface> descriptors = new ArrayList<AttributeDescriptorInterface>();
        int count = map.size();
        if (count == 0) {
            throw new IllegalArgumentException(EntityRB.getStringResource("emptyMap.txt"));
        }
        AttributeDescriptorInterface[] adi = this.attributeGroup.getAttributeDescriptors(true);
        int numberOfAttributes = adi.length;
        Class<?> attributeDescriptorClass = null;
        if (numberOfAttributes <= 0) {
            return new AttributeDescriptor[0];
        }
        attributeDescriptorClass = adi[0].getClass();
        boolean addDescriptor = true;
        for (int i = 0; i < numberOfAttributes; ++i) {
            HashMap copyMap = new HashMap(map);
            Set keySet = copyMap.keySet();
            Iterator iter = keySet.iterator();
            while (iter.hasNext() && addDescriptor) {
                String methodName = (String)iter.next();
                Method m = attributeDescriptorClass.getDeclaredMethod(methodName, new Class[0]);
                Class<?> returnType = m.getReturnType();
                if (!returnType.equals(Boolean.TYPE)) continue;
                Boolean b = (Boolean)map.get(methodName);
                if (!(b instanceof Boolean)) {
                    throw new IllegalArgumentException(MessageFormat.format("notBoolean.txt", b));
                }
                try {
                    Boolean methodResult = (Boolean)m.invoke((Object)adi[i], new Object[0]);
                    if (methodResult.booleanValue() == b.booleanValue()) continue;
                    addDescriptor = false;
                }
                catch (InvocationTargetException ite) {
                    throw new IllegalArgumentException(ite.getLocalizedMessage());
                }
                catch (IllegalAccessException iae) {
                    throw new IllegalArgumentException(iae.getLocalizedMessage());
                }
            }
            if (addDescriptor && !descriptors.contains(adi[i])) {
                descriptors.add(adi[i]);
            }
            addDescriptor = true;
        }
        return descriptors.toArray(new AttributeDescriptorInterface[descriptors.size()]);
    }

    @Override
    public boolean isAllRequiredAttributesAssigned() {
        AttributeDescriptorInterface[] adi = this.attributeGroup.getAttributeDescriptors(true);
        int numberOfAttributes = adi.length;
        for (int i = 0; i < adi.length; ++i) {
            if (!adi[i].isRequired() || this.isAttributeAssigned(adi[i].getName())) continue;
            return false;
        }
        return true;
    }

    @Override
    public void clear() {
        String[] attributeNames = this.getAttributeGroup().getAttributeDescriptorNames(true);
        int arrayLength = attributeNames.length;
        for (int i = arrayLength - 1; i >= 0; --i) {
            this.clearAttribute(attributeNames[i]);
        }
    }

    @Override
    public void clearAttribute(String attributeName) {
        ((Map)this.getDelegate()).remove(attributeName);
        this.attributesSet.remove(attributeName);
    }

    public synchronized String[] listAttributeNames(boolean includeDynamicAttributes, boolean includeStaticAttributes) {
        String[] attNames = this.attributeGroup.getAttributeDescriptorNames(true);
        ArrayList<String> attributeNames = new ArrayList<String>();
        int numberOfAtrributes = attNames.length;
        String attributeName = null;
        AttributeDescriptorInterface attrDesc = null;
        for (int i = 0; i < numberOfAtrributes; ++i) {
            attributeName = attNames[i];
            attrDesc = this.attributeGroup.getAttributeDescriptor(attributeName, true);
            if (this.containsAttributeNamed(attributeName)) {
                if (!attrDesc.isProperty()) {
                    attributeNames.add(attributeName);
                    continue;
                }
                if (!includeStaticAttributes) continue;
                attributeNames.add(attributeName);
                continue;
            }
            if (!includeDynamicAttributes || !attrDesc.isDefaultValueHasBeenSet()) continue;
            attributeNames.add(attributeName);
        }
        int listSize = attributeNames.size();
        String[] returnAttrs = new String[listSize];
        for (int j = 0; j < listSize; ++j) {
            returnAttrs[j] = (String)attributeNames.get(j);
        }
        return returnAttrs;
    }

    public void addVetoableChangeListener(String propertyName, VetoableChangeListener listener) {
        if (this.vcs == null) {
            this.vcs = new VetoableChangeSupport(this);
        }
        this.vcs.addVetoableChangeListener(propertyName, listener);
    }

    public void removeVetoableChangeListener(String propertyName, VetoableChangeListener listener) {
        if (this.vcs != null) {
            this.vcs.removeVetoableChangeListener(propertyName, listener);
        }
    }

    public void fireVetoableChange(String propertyName, Object oldValue, Object newValue) {
        if (this.vcs == null) {
            this.vcs = new VetoableChangeSupport(this);
        }
        try {
            this.vcs.fireVetoableChange(propertyName, oldValue, newValue);
        }
        catch (PropertyVetoException pve) {
            pve.printStackTrace();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @SASScope
    protected boolean verifyAttributeType(String attributeName, Object[] args) throws AttributeSetException {
        boolean goodAttributeType = false;
        AttributeTypeInterface at = this.getAttributeDescriptor(attributeName).getType();
        if (at == null) {
            throw new AttributeSetException(EntityRB.getStringResource("attributeTypeNotDefined.ex.txt"));
        }
        int sqlType = at.getSQLType();
        if (sqlType == AttributeTypeUtility.NO_SQL_TYPE_DEFINED) {
            throw new AttributeSetException(EntityRB.getStringResource("attributeTypeNotDefined.ex.txt"));
        }
        if (args[0] == null) {
            if (AttributeTypeUtility.isNullValidForAttributeType(sqlType)) return true;
            throw new AttributeSetException(MessageFormat.format(EntityRB.getStringResource("invalidAttributeValue.ex.txt"), null, attributeName));
        }
        Class argsClass = null;
        argsClass = args[0] == null ? Object.class : RemoteEntity.map(args[0]).getClass();
        if (sqlType == 0) {
            ClassLoader argsClassLoader;
            if (argsClass.isArray()) {
                this.getAttributeDescriptor(attributeName).setType(atfi.createAttributeType(null, 2003, argsClass.getComponentType().getName()));
                return true;
            }
            Class<Object> objectClass = Object.class;
            if (args[0] == null) return goodAttributeType;
            goodAttributeType = true;
            String argsClassName = argsClass.getName();
            if (!AttributeTypeUtility.isWrapperType(argsClassName) && (argsClassLoader = argsClass.getClassLoader()) != this.getSystemClassLoader() && argsClassLoader != null) {
                classLoaders.add(argsClassLoader);
            }
            this.getAttributeDescriptor(attributeName).setType(AttributeTypeUtility.createAttributeTypeFromClassName(atfi, argsClass.getName()));
            return goodAttributeType;
        }
        if (sqlType == 2003) {
            if (!argsClass.isArray()) {
                throw new AttributeSetException(EntityRB.getStringResource("notArrayAttributeType.ex.txt"));
            }
            String componentType = at.getObjectType();
            if (!argsClass.getComponentType().getName().equals(componentType)) throw new AttributeSetException(MessageFormat.format(EntityRB.getStringResource("incorrectArrayType.ex.txt"), componentType));
            return true;
        }
        if (sqlType == 91) {
            if (args[0] instanceof Date) {
                if (args[0] instanceof EntityDate) return true;
                EntityDate componentType = new EntityDate(((Date)args[0]).getTime());
                return true;
            }
            if (!(args[0] instanceof String)) return goodAttributeType;
            try {
                return AttributeTypeUtility.isValidDate((String)args[0], attributeName, true);
            }
            catch (IllegalArgumentException iae) {
                AttributeSetException ase = new AttributeSetException(iae.getMessage());
                ase.initCause(iae);
                throw ase;
            }
        }
        if (sqlType == 92) {
            if (args[0] instanceof Time) return true;
            if (args[0] instanceof Date) {
                return true;
            }
            if (args[0] == null || !args[0].toString().equals(EMPTY_STRING)) throw new AttributeSetException(MessageFormat.format(EntityRB.getStringResource("invalidAttributeValue.ex.txt"), args[0], attributeName));
            throw new AttributeSetException(MessageFormat.format(EntityRB.getStringResource("blankValueNotValid.ex.txt"), attributeName));
        }
        if (sqlType == 93) {
            if (args[0] instanceof Timestamp) return true;
            if (args[0] instanceof Date) {
                return true;
            }
            if (args[0] == null || !args[0].toString().equals(EMPTY_STRING)) throw new AttributeSetException(MessageFormat.format(EntityRB.getStringResource("invalidAttributeValue.ex.txt"), args[0], attributeName));
            throw new AttributeSetException(MessageFormat.format(EntityRB.getStringResource("blankValueNotValid.ex.txt"), attributeName));
        }
        if (sqlType == 2000 || sqlType == 1111) {
            String componentType = at.getObjectType();
            try {
                Class componentClass;
                block39: {
                    componentClass = null;
                    if (componentType == null) {
                        componentClass = Object.class;
                    } else {
                        try {
                            componentClass = Class.forName(componentType);
                        }
                        catch (ClassNotFoundException e) {
                            for (int i = 0; i < classLoaders.size(); ++i) {
                                try {
                                    componentClass = Class.forName(componentType, false, (ClassLoader)classLoaders.get(i));
                                    break;
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    continue;
                                }
                            }
                            if (componentClass != null) break block39;
                            return false;
                        }
                    }
                }
                if (componentClass.isAssignableFrom(argsClass)) {
                    return true;
                }
                if (!argsClass.getName().equals(AttributeTypeUtility.JAVA_LANG_STRING)) throw new AttributeSetException(MessageFormat.format(EntityRB.getStringResource("incorrectAttributeType.ex.txt"), componentClass.getName()));
                Class[] stringArgsClass = new Class[]{String.class};
                Object[] stringArgs = new Object[]{args[0]};
                try {
                    Constructor stringArgsConstructor = componentClass.getConstructor(stringArgsClass);
                    Object o = stringArgsConstructor.newInstance(stringArgs);
                    args[0] = o;
                    return true;
                }
                catch (Exception e) {
                    if (stringArgs[0] == null || !stringArgs[0].equals(EMPTY_STRING)) throw new AttributeSetException(MessageFormat.format(EntityRB.getStringResource("invalidAttributeValue.ex.txt"), stringArgs[0], attributeName));
                    throw new AttributeSetException(MessageFormat.format(EntityRB.getStringResource("blankValueNotValid.ex.txt"), attributeName));
                }
            }
            catch (Exception cnfe) {
                cnfe.printStackTrace();
            }
            return goodAttributeType;
        }
        Class c = AttributeTypeUtility.getJavaClass(at.getSQLType());
        if (c == null) {
            throw new AttributeSetException(EntityRB.getStringResource("attributeTypeNotDefined.ex.txt"));
        }
        String typeClassName = c.getName();
        String className = argsClass.getName();
        String primitiveClassName = AttributeTypeUtility.getPrimitiveTypeFromWrapper(className);
        if (primitiveClassName == null || !primitiveClassName.equals(typeClassName)) {
            if (AttributeTypeUtility.isColorStringClass(at)) {
                try {
                    return AttributeTypeUtility.isValidColor(args[0], attributeName, true);
                }
                catch (IllegalArgumentException iae) {
                    AttributeSetException ase = new AttributeSetException(iae.getMessage());
                    ase.initCause(iae);
                    throw ase;
                }
            }
            if (!AttributeTypeUtility.wrapperTypeHasStringArgConstructor(sqlType)) throw new AttributeSetException(MessageFormat.format(EntityRB.getStringResource("incorrectAttributeType.ex.txt"), typeClassName));
            Class[] stringArgsClass = new Class[]{String.class};
            Class componentClass = AttributeTypeUtility.getJavaClassToConstruct(at.getSQLType(), null);
            Object[] stringArgs = new Object[]{args[0]};
            try {
                Constructor stringArgsConstructor = componentClass.getConstructor(stringArgsClass);
                Object o = stringArgsConstructor.newInstance(stringArgs);
                return true;
            }
            catch (Exception e) {
                if (stringArgs[0] != null && stringArgs[0].equals(EMPTY_STRING)) {
                    throw new AttributeSetException(MessageFormat.format(EntityRB.getStringResource("blankValueNotValid.ex.txt"), attributeName));
                }
                if (sqlType != 6 && sqlType != 8 || !className.equals("com.sas.MissingValues")) throw new AttributeSetException(MessageFormat.format(EntityRB.getStringResource("invalidAttributeValue.ex.txt"), stringArgs[0], attributeName));
                return true;
            }
        }
        if (!AttributeTypeUtility.isColorStringClass(at)) return true;
        try {
            return AttributeTypeUtility.isValidColor(args[0], attributeName, true);
        }
        catch (IllegalArgumentException iae) {
            AttributeSetException ase = new AttributeSetException(iae.getMessage());
            ase.initCause(iae);
            throw ase;
        }
    }

    public void setDynamicSupplementalPropertiesDefaultMap(Map dynamicSupplementalProperties) {
        if (dynamicSupplementalProperties == null) {
            throw new IllegalArgumentException(EntityRB.getStringResource("emptyMap.ex.txt"));
        }
        this.dynamicSupplementalProperties = dynamicSupplementalProperties;
    }

    private ClassLoader getSystemClassLoader() {
        return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return ClassLoader.getSystemClassLoader();
            }
        });
    }

    static {
        EMPTY_STRING = "";
        classLoaders = new ArrayList();
        _getterObjectArray = new Object[0];
    }
}

