/*
 * Decompiled with CFR 0.152.
 */
package com.sas.entities;

import com.sas.codepolicy.SASScope;
import com.sas.entities.AttributeDescriptor;
import com.sas.entities.AttributeDescriptorInterface;
import com.sas.entities.AttributeGroupInterface;
import com.sas.entities.AttributeType;
import com.sas.entities.AttributeTypeFactory;
import com.sas.entities.AttributeTypeFactoryInterface;
import com.sas.entities.AttributeTypeUtility;
import com.sas.entities.BaseAttributeDescriptor;
import com.sas.entities.EntityRB;
import com.sas.entities.EntityUtil;
import com.sas.entities.RemoteEntityInterface;
import java.beans.PropertyDescriptor;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;

@SASScope(value="ALL")
public class AttributeGroup
extends BaseAttributeDescriptor
implements AttributeGroupInterface {
    @SASScope
    public static final String RB_KEY = "AttributeGroup.";
    public static final int LAST_POSITION = -1;
    @SASScope
    public static final int SUBGROUP_NOT_FOUND = Integer.MIN_VALUE;
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final AttributeDescriptorInterface[] EMPTY_ATTRIBUTE_ARRAY = new AttributeDescriptorInterface[0];
    private ArrayList propertyList = new ArrayList();
    private HashMap properties = new HashMap();
    private ArrayList subgroups;
    private AttributeGroupInterface[] cachedList;
    private AttributeDescriptorInterface[] cachedDescriptorList;
    private AttributeTypeFactoryInterface atfi;
    private boolean visible;
    private boolean modifiable;
    private boolean expert;
    private boolean dirtyGroups = true;
    private boolean dirtyDescriptors = true;
    private ArrayList orphans = new ArrayList();

    public AttributeGroup() {
    }

    public AttributeGroup(String name) {
        this();
        this.setName(name);
    }

    public AttributeGroup(RemoteEntityInterface entity) {
        this(entity, null, null, null);
    }

    public AttributeGroup(RemoteEntityInterface entity, Map entityStaticProperties, AttributeTypeFactoryInterface atfi) {
        this();
        if (entityStaticProperties != null) {
            int mapSize = entityStaticProperties.size();
            this.atfi = atfi;
            AttributeDescriptorInterface[] props = new AttributeDescriptorInterface[mapSize];
            String propertyName = null;
            PropertyDescriptor pd = null;
            Set keySet = entityStaticProperties.keySet();
            Iterator iter = keySet.iterator();
            int i = 0;
            AttributeDescriptor prop = null;
            while (iter.hasNext()) {
                propertyName = (String)iter.next();
                prop = new AttributeDescriptor(propertyName);
                props[i] = prop;
                pd = (PropertyDescriptor)entityStaticProperties.get(propertyName);
                if (atfi == null) {
                    atfi = new AttributeTypeFactory();
                }
                int sqlType = AttributeTypeUtility.NO_SQL_TYPE_DEFINED;
                String objectClassName = pd.getPropertyType().getName();
                prop.setType(AttributeTypeUtility.createAttributeTypeFromClassName(atfi, objectClassName));
                if (propertyName.equals("entityKey")) {
                    prop.setVisible(false);
                }
                prop.setProperty(true);
                ++i;
            }
            this.addAttributeDescriptors(props);
        }
    }

    public AttributeGroup(RemoteEntityInterface entity, Map entityStaticProperties, AttributeTypeFactoryInterface atfi, Map supplementalProperties) {
        this();
        if (entityStaticProperties != null) {
            int mapSize = entityStaticProperties.size();
            this.atfi = atfi;
            AttributeDescriptorInterface[] props = new AttributeDescriptorInterface[mapSize];
            String propertyName = null;
            PropertyDescriptor pd = null;
            Set keySet = entityStaticProperties.keySet();
            Iterator iter = keySet.iterator();
            int i = 0;
            AttributeDescriptor prop = null;
            while (iter.hasNext()) {
                propertyName = (String)iter.next();
                prop = new AttributeDescriptor(propertyName, supplementalProperties);
                props[i] = prop;
                pd = (PropertyDescriptor)entityStaticProperties.get(propertyName);
                if (atfi == null) {
                    atfi = new AttributeTypeFactory();
                }
                int sqlType = AttributeTypeUtility.NO_SQL_TYPE_DEFINED;
                String objectClassName = pd.getPropertyType().getName();
                prop.setType(AttributeTypeUtility.createAttributeTypeFromClassName(atfi, objectClassName));
                if (propertyName.equals("entityKey")) {
                    prop.setVisible(false);
                }
                prop.setProperty(true);
                ++i;
            }
            this.addAttributeDescriptors(props);
        }
    }

    public AttributeGroup(RemoteEntityInterface entity, Map entityStaticProperties) {
        this();
        if (entityStaticProperties != null) {
            int mapSize = entityStaticProperties.size();
            AttributeDescriptorInterface[] props = new AttributeDescriptorInterface[mapSize];
            String propertyName = null;
            PropertyDescriptor pd = null;
            Set keySet = entityStaticProperties.keySet();
            Iterator iter = keySet.iterator();
            int i = 0;
            AttributeDescriptor prop = null;
            while (iter.hasNext()) {
                propertyName = (String)iter.next();
                prop = new AttributeDescriptor(propertyName);
                props[i] = prop;
                pd = (PropertyDescriptor)entityStaticProperties.get(propertyName);
                prop.setType(new AttributeType(null, pd.getPropertyType().getName()));
                if (propertyName.equals("entityKey")) {
                    prop.setVisible(false);
                }
                prop.setProperty(true);
                ++i;
            }
            this.addAttributeDescriptors(props);
        }
    }

    public AttributeGroup(RemoteEntityInterface entity, Map entityStaticProperties, Map supplementalProperties) {
        this();
        if (entityStaticProperties != null) {
            int mapSize = entityStaticProperties.size();
            AttributeDescriptorInterface[] props = new AttributeDescriptorInterface[mapSize];
            String propertyName = null;
            PropertyDescriptor pd = null;
            Set keySet = entityStaticProperties.keySet();
            Iterator iter = keySet.iterator();
            int i = 0;
            AttributeDescriptor prop = null;
            while (iter.hasNext()) {
                propertyName = (String)iter.next();
                prop = new AttributeDescriptor(propertyName, supplementalProperties);
                props[i] = prop;
                pd = (PropertyDescriptor)entityStaticProperties.get(propertyName);
                prop.setType(new AttributeType(null, pd.getPropertyType().getName()));
                if (propertyName.equals("entityKey")) {
                    prop.setVisible(false);
                }
                prop.setProperty(true);
                ++i;
            }
            this.addAttributeDescriptors(props);
        }
    }

    @Override
    public void addAttributeDescriptor(AttributeDescriptorInterface attribute, int index) {
        this.addAttributeDescriptor(attribute, index, true);
    }

    @Override
    public void addAttributeDescriptor(AttributeDescriptorInterface attribute, int index, boolean replace) {
        String name = attribute.getName();
        if (!this.containsAttributeDescriptorNamed(name, true)) {
            if (index == -1) {
                this.propertyList.add(attribute);
            } else {
                this.propertyList.add(index, attribute);
            }
            this.properties.put(name, attribute);
        } else {
            if (!replace) {
                throw new IllegalArgumentException(MessageFormat.format(EntityRB.getStringResource(RB_KEY, "duplicateAttributeDescriptor.ex.txt"), name));
            }
            if (this.containsAttributeDescriptorNamed(name, false)) {
                if (index == -1) {
                    this.propertyList.add(attribute);
                } else {
                    this.propertyList.add(index, attribute);
                }
                this.properties.put(name, attribute);
            } else {
                throw new IllegalArgumentException(MessageFormat.format(EntityRB.getStringResource(RB_KEY, "duplicateAttributeDescriptor.ex.txt"), name));
            }
        }
        this.dirtyDescriptors = true;
    }

    @Override
    public void addAttributeDescriptors(AttributeDescriptorInterface[] newAttributes) {
        this.addAttributeDescriptors(newAttributes, true);
    }

    @Override
    public void addAttributeDescriptors(AttributeDescriptorInterface[] newAttributes, boolean replace) {
        for (int i = 0; i < newAttributes.length; ++i) {
            AttributeDescriptorInterface prop = newAttributes[i];
            try {
                this.addAttributeDescriptor(prop, -1, replace);
                continue;
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    @Override
    public void addAttributeGroup(AttributeGroupInterface group, int index) {
        this.addAttributeGroup(group, index, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void addAttributeGroup(AttributeGroupInterface group, int index, boolean replace) {
        String[] groupNames = this.getAttributeGroupNames();
        int groupsLength = groupNames.length;
        String groupToAdd = group.getName();
        String sourceGroup = this.getName();
        boolean foundName = false;
        boolean addedGroup = false;
        DefaultTreeModel groups = EntityUtil.getAttributeGroupsTreeModel(this, true);
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)groups.getRoot();
        Enumeration<TreeNode> nodes = root.preorderEnumeration();
        String groupName = null;
        DefaultMutableTreeNode node = null;
        while (nodes.hasMoreElements()) {
            AttributeGroupInterface currentGroup;
            node = (DefaultMutableTreeNode)nodes.nextElement();
            if (!(node.getUserObject() instanceof AttributeGroupInterface) || (groupName = (currentGroup = (AttributeGroupInterface)node.getUserObject()).getName()) == null || groupToAdd == null || !groupToAdd.equals(groupName)) continue;
            if (!replace) {
                throw new IllegalArgumentException(MessageFormat.format(EntityRB.getStringResource(RB_KEY, "duplicateAttributeGroup.ex.txt"), groupToAdd));
            }
            if (node.getParent() == null) {
                throw new IllegalArgumentException(MessageFormat.format(EntityRB.getStringResource(RB_KEY, "duplicateAttributeGroup.ex.txt"), groupToAdd));
            }
            DefaultMutableTreeNode parent = (DefaultMutableTreeNode)node.getParent();
            String parentName = ((AttributeGroupInterface)parent.getUserObject()).getName();
            if (parentName == null) continue;
            if (!parentName.equals(sourceGroup)) throw new IllegalArgumentException(MessageFormat.format(EntityRB.getStringResource(RB_KEY, "duplicateAttributeGroup.ex.txt"), groupToAdd));
            int location = this.findLocationOfSubgroup(groupToAdd);
            if (location != Integer.MIN_VALUE) {
                String duplicateAttribute = this.findDuplicateAttribute(group, currentGroup);
                if (duplicateAttribute != null) throw new IllegalArgumentException(MessageFormat.format(EntityRB.getStringResource(RB_KEY, "duplicateAttributeGroup.ex.txt"), groupToAdd));
                this.getSubgroups().set(location, group);
            } else if (index == -1) {
                this.getSubgroups().add(group);
            } else {
                this.getSubgroups().add(index, group);
            }
            addedGroup = true;
        }
        if (addedGroup) return;
        String[] attributeNames = group.getAttributeDescriptorNames(true);
        int namesLength = attributeNames.length;
        String attributeName = null;
        for (int i = 0; i < namesLength; ++i) {
            attributeName = attributeNames[i];
            if (!this.containsAttributeDescriptorNamed(attributeName, true)) continue;
            throw new IllegalArgumentException(MessageFormat.format(EntityRB.getStringResource(RB_KEY, "duplicateAttributeDescriptor.ex.txt"), attributeName));
        }
        if (index == -1) {
            this.getSubgroups().add(group);
        } else {
            this.getSubgroups().add(index, group);
        }
        this.dirtyGroups = true;
    }

    @Override
    public void addAttributeGroups(AttributeGroupInterface[] groups) {
        this.addAttributeGroups(groups, true);
    }

    @Override
    public void addAttributeGroups(AttributeGroupInterface[] groups, boolean replace) {
        for (int i = 0; i < groups.length; ++i) {
            AttributeGroupInterface group = groups[i];
            this.addAttributeGroup(group, -1, replace);
        }
    }

    @Override
    public boolean containsAttributeDescriptorNamed(String attributeName, boolean recursive) {
        boolean returnValue = false;
        if (this.properties.containsKey(attributeName)) {
            return true;
        }
        if (recursive) {
            AttributeGroupInterface[] agi = this.getCachedAttributeGroups();
            int groupSize = agi.length;
            for (int i = 0; i < groupSize && !(returnValue = agi[i].containsAttributeDescriptorNamed(attributeName, true)); ++i) {
            }
        }
        return returnValue;
    }

    @Override
    public int count(boolean recursive) {
        return recursive ? this.countRecursively() : this.propertyList.size();
    }

    @SASScope
    protected int countRecursively() {
        int count = this.count(false);
        if (this.subgroups != null && this.subgroups.size() > 0) {
            for (AttributeGroupInterface subGroup : this.subgroups) {
                count += ((AttributeGroup)subGroup).countRecursively();
            }
        }
        return count;
    }

    @Override
    public AttributeDescriptorInterface getAttributeDescriptor(String attributeName, boolean recursive) {
        AttributeDescriptorInterface adi = null;
        AttributeGroupInterface[] agi = this.getCachedAttributeGroups();
        int groupSize = agi.length;
        if (this.containsAttributeDescriptorNamed(attributeName, false) || groupSize == 0) {
            return (AttributeDescriptorInterface)this.properties.get(attributeName);
        }
        if (recursive) {
            for (int i = 0; i < groupSize && (adi = agi[i].getAttributeDescriptor(attributeName, true)) == null; ++i) {
            }
        }
        return adi;
    }

    @Override
    public String[] getAttributeDescriptorNames(boolean recursive) {
        ArrayList<String> orphansNames = new ArrayList<String>();
        for (int k = 0; k < this.propertyList.size(); ++k) {
            orphansNames.add(((AttributeDescriptorInterface)this.propertyList.get(k)).getName());
        }
        if (recursive) {
            AttributeGroupInterface[] agi = this.getCachedAttributeGroups();
            int groupSize = agi.length;
            for (int i = 0; i < groupSize; ++i) {
                AttributeDescriptorInterface[] children = agi[i].getAttributeDescriptors(true);
                int n = children.length;
                for (int j = 0; j < n; ++j) {
                    orphansNames.add(children[j].getName());
                }
            }
        }
        if (orphansNames.size() == 0) {
            return EMPTY_STRING_ARRAY;
        }
        Object[] array = orphansNames.toArray();
        String[] stringArray = new String[array.length];
        System.arraycopy(array, 0, stringArray, 0, array.length);
        return stringArray;
    }

    private boolean isDescriptorsDirty() {
        boolean dirtyCheck = this.dirtyDescriptors;
        if (!dirtyCheck) {
            AttributeGroupInterface[] agi = this.getCachedAttributeGroups();
            int groupSize = agi.length;
            if (groupSize == 0) {
                return this.dirtyDescriptors;
            }
            for (int i = 0; i < groupSize; ++i) {
                dirtyCheck |= ((AttributeGroup)agi[i]).isDescriptorsDirty();
            }
        }
        return dirtyCheck;
    }

    @Override
    public AttributeDescriptorInterface[] getAttributeDescriptors(boolean recursive) {
        this.orphans.clear();
        for (int i = 0; i < this.propertyList.size(); ++i) {
            this.orphans.add(this.propertyList.get(i));
        }
        if (recursive) {
            AttributeGroupInterface[] agi = this.getCachedAttributeGroups();
            int groupSize = agi.length;
            if (groupSize == 0) {
                return this.propertyList.toArray(new AttributeDescriptorInterface[this.count(false)]);
            }
            for (int i = 0; i < groupSize; ++i) {
                AttributeDescriptorInterface[] children = ((AttributeGroup)agi[i]).getCachedAttributeDescriptors(true);
                int n = children.length;
                for (int j = 0; j < n; ++j) {
                    this.orphans.add(children[j]);
                }
            }
        }
        if (this.orphans.size() == 0) {
            return EMPTY_ATTRIBUTE_ARRAY;
        }
        return this.orphans.toArray(new AttributeDescriptorInterface[this.orphans.size()]);
    }

    @Override
    public AttributeGroupInterface getAttributeGroup(String groupName) {
        AttributeGroupInterface agi = null;
        if (this.subgroups != null && this.subgroups.size() > 0) {
            int n = this.subgroups.size();
            for (int i = 0; i < n; ++i) {
                AttributeGroupInterface group = (AttributeGroupInterface)this.subgroups.get(i);
                if (!group.getName().equals(groupName)) continue;
                return group;
            }
        }
        return agi;
    }

    @Override
    public String[] getAttributeGroupNames() {
        if (this.subgroups != null && this.subgroups.size() > 0) {
            int n = this.subgroups.size();
            String[] names = new String[n];
            for (int i = 0; i < n; ++i) {
                AttributeGroupInterface group = (AttributeGroupInterface)this.subgroups.get(i);
                names[i] = group.getName();
            }
            return names;
        }
        return new String[0];
    }

    private AttributeDescriptorInterface[] getCachedAttributeDescriptors(boolean recursive) {
        if (this.isDescriptorsDirty()) {
            this.cachedDescriptorList = null;
            this.cachedDescriptorList = this.getAttributeDescriptors(recursive);
            this.dirtyDescriptors = false;
        }
        return this.cachedDescriptorList;
    }

    private AttributeGroupInterface[] getCachedAttributeGroups() {
        if (this.dirtyGroups) {
            this.cachedList = null;
            this.cachedList = this.getAttributeGroups();
            this.dirtyGroups = false;
        }
        return this.cachedList;
    }

    @Override
    public AttributeGroupInterface[] getAttributeGroups() {
        if (this.subgroups != null && this.subgroups.size() > 0) {
            return this.subgroups.toArray(new AttributeGroupInterface[this.subgroups.size()]);
        }
        return new AttributeGroupInterface[0];
    }

    @Override
    public boolean isExpert() {
        return this.expert;
    }

    @Override
    public boolean isModifiable() {
        return this.modifiable;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public boolean removeAttributeDescriptor(String attributeName, boolean recursive) {
        boolean exists = this.properties.containsKey(attributeName);
        if (exists) {
            AttributeDescriptorInterface adi = this.getAttributeDescriptor(attributeName, recursive);
            this.properties.remove(attributeName);
            this.propertyList.remove(adi);
            return true;
        }
        if (recursive) {
            AttributeGroupInterface[] agi = this.getCachedAttributeGroups();
            int groupSize = agi.length;
            for (int i = 0; i < groupSize; ++i) {
                exists = agi[i].removeAttributeDescriptor(attributeName, recursive);
                if (!exists) continue;
                return true;
            }
        }
        this.dirtyDescriptors = true;
        return exists;
    }

    @Override
    public String[] removeAttributeDescriptors(String[] attributeNames, boolean recursive) {
        ArrayList removed = new ArrayList();
        ArrayList<String> namesToRemove = new ArrayList<String>();
        int arrayLength = attributeNames.length;
        for (int i = 0; i < arrayLength; ++i) {
            namesToRemove.add(attributeNames[i]);
        }
        try {
            for (int j = arrayLength - 1; j >= 0; --j) {
                boolean removedAttribute = this.removeAttributeDescriptor((String)namesToRemove.get(j), false);
                if (!removedAttribute) continue;
                removed.add(namesToRemove.get(j));
                int position = namesToRemove.indexOf(namesToRemove.get(j));
                namesToRemove.remove(position);
            }
        }
        catch (NullPointerException j) {
            // empty catch block
        }
        if (recursive) {
            AttributeGroupInterface[] agi = this.getCachedAttributeGroups();
            int groupSize = agi.length;
            for (int i = 0; i < groupSize; ++i) {
                String[] newSearchList = namesToRemove.toArray(new String[namesToRemove.size()]);
                String[] children = agi[i].removeAttributeDescriptors(newSearchList, recursive);
                int p = children.length;
                for (int j = 0; j < p; ++j) {
                    removed.add(children[j]);
                }
            }
        }
        if (removed.size() == 0) {
            return EMPTY_STRING_ARRAY;
        }
        return removed.toArray(new String[removed.size()]);
    }

    @Override
    public AttributeDescriptorInterface[] removeAttributeGroup(String groupName) {
        if (this.subgroups == null || this.subgroups.size() == 0) {
            return EMPTY_ATTRIBUTE_ARRAY;
        }
        ArrayList<AttributeDescriptorInterface> orphansRemoved = new ArrayList<AttributeDescriptorInterface>(this.count(true));
        Iterator groups = this.subgroups.iterator();
        while (groups.hasNext()) {
            AttributeGroupInterface subGroup = (AttributeGroupInterface)groups.next();
            if (subGroup.getName().equals(groupName)) {
                AttributeDescriptorInterface[] children = subGroup.getAttributeDescriptors(true);
                int n = children.length;
                for (int j = 0; j < n; ++j) {
                    orphansRemoved.add(children[j]);
                }
                groups.remove();
                this.subgroups.remove(subGroup.getName());
                break;
            }
            this.dirtyGroups = true;
            this.dirtyDescriptors = true;
        }
        return orphansRemoved.toArray(new AttributeDescriptorInterface[orphansRemoved.size()]);
    }

    @Override
    public AttributeDescriptorInterface[] removeAttributeGroups(String[] groupNames) {
        if (this.subgroups == null || this.subgroups.size() == 0) {
            return EMPTY_ATTRIBUTE_ARRAY;
        }
        ArrayList<AttributeDescriptorInterface> orphansRemoved = new ArrayList<AttributeDescriptorInterface>(this.count(true));
        for (int i = 0; i < groupNames.length; ++i) {
            String groupName = groupNames[i];
            AttributeDescriptorInterface[] children = this.removeAttributeGroup(groupName);
            int n = children.length;
            for (int j = 0; j < n; ++j) {
                this.addAttributeDescriptor(children[j], -1);
                orphansRemoved.add(children[j]);
            }
        }
        return orphansRemoved.toArray(new AttributeDescriptorInterface[orphansRemoved.size()]);
    }

    @Override
    public void setAttributeDescriptor(AttributeDescriptorInterface attribute) throws IllegalArgumentException {
        this.addAttributeDescriptor(attribute, -1);
    }

    @Override
    public void setAttributeDescriptors(AttributeDescriptorInterface[] attributes) throws IllegalArgumentException {
        this.addAttributeDescriptors(attributes);
    }

    @Override
    public void setExpert(boolean expert) {
        this.expert = expert;
    }

    @Override
    public void setModifiable(boolean modifiable) {
        this.modifiable = modifiable;
    }

    @Override
    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    @SASScope
    protected int findLocationOfSubgroup(String subgroupName) {
        if (this.subgroups == null || this.subgroups.size() == 0) {
            return Integer.MIN_VALUE;
        }
        int subgroupSize = this.subgroups.size();
        for (int i = 0; i < subgroupSize; ++i) {
            String name = ((AttributeGroupInterface)this.subgroups.get(i)).getName();
            if (!name.equals(subgroupName)) continue;
            return i;
        }
        return Integer.MIN_VALUE;
    }

    @SASScope
    protected String findDuplicateAttribute(AttributeGroupInterface group, AttributeGroupInterface currentGroup) {
        String[] attributeNames = group.getAttributeDescriptorNames(true);
        int namesLength = attributeNames.length;
        String attributeName = null;
        for (int i = 0; i < namesLength; ++i) {
            attributeName = attributeNames[i];
            if (!this.containsAttributeDescriptorNamed(attributeNames[i], true)) continue;
            if (currentGroup.containsAttributeDescriptorNamed(attributeNames[i], true)) {
                return null;
            }
            return attributeName;
        }
        return null;
    }

    private List getSubgroups() {
        if (this.subgroups == null) {
            this.subgroups = new ArrayList();
        }
        return this.subgroups;
    }
}

