/*
 * Decompiled with CFR 0.152.
 */
package MITI.server.services.common.mir;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class StitchingRule
implements Comparable<StitchingRule> {
    private String modelPath = "";
    private Map<String, String> mappedSchemas = new HashMap<String, String>();
    private Set<String> ignoredSchemas = new HashSet<String>();
    private Map<String, String> parameters = new HashMap<String, String>();
    private int matchingScore = -1;
    private int stitchingScore = -1;
    private boolean approved = false;
    private static final String RULE_MODEL_PATH = "MODEL_PATH.";
    private static final String RULE_CLIENT_SCHEMA = "CLIENT_SCHEMA.";
    private static final String RULE_SUPPLIER_SCHEMA = "SUPPLIER_SCHEMA.";
    private static final String RULE_STITCHING_PARAMETER = "PARAMETER.";
    private static final String MITI_NULL_SUPPLIER_NAME = "__MITI_NULL_SUPPLIER_NAME__@@";
    private static final String MITI_IGNORED_SCHEMA_NAME = "__MITI_IGNORED_SCHEMA_NAME__@@";
    private static final String MATCHING_SCORE = "MATCHING_SCORE";
    private static final String STITCHING_SCORE = "STICHING_SCORE";
    private static final String IS_APPROVED = "IS_APPROVED";

    public StitchingRule() {
    }

    public StitchingRule(StitchingRule stitchingRule) {
        this.modelPath = stitchingRule.modelPath;
        this.mappedSchemas = new HashMap<String, String>(stitchingRule.mappedSchemas);
        this.ignoredSchemas = new HashSet<String>(stitchingRule.ignoredSchemas);
        this.parameters = new HashMap<String, String>(stitchingRule.parameters);
        this.approved = stitchingRule.approved;
        this.matchingScore = stitchingRule.matchingScore;
        this.stitchingScore = stitchingRule.stitchingScore;
    }

    public String getModelPath() {
        return this.modelPath;
    }

    public void setModelPath(String string) {
        this.modelPath = string != null ? string : "";
    }

    public String getDefaultSchema() {
        return this.mappedSchemas.get("");
    }

    public void setDefaultSchema(String string) {
        this.addMappedSchema("", string);
    }

    public void addMappedSchema(String string, String string2) {
        this.ignoredSchemas.remove(string);
        this.mappedSchemas.put(string, string2);
    }

    public void addIgnoredSchema(String string) {
        this.mappedSchemas.remove(string);
        this.ignoredSchemas.add(string);
    }

    public String getParameter(String string) {
        return this.parameters.get(string);
    }

    public void addParameter(String string, String string2) {
        this.parameters.put(string, string2);
    }

    public Map<String, String> getMappedSchemas() {
        return this.mappedSchemas;
    }

    public Collection<String> getIgnoredSchemas() {
        return this.ignoredSchemas;
    }

    public final String serialize() {
        StringWriter stringWriter = new StringWriter();
        Properties properties = new Properties();
        if (!this.modelPath.isEmpty()) {
            properties.put(RULE_MODEL_PATH, this.modelPath);
        }
        int n = 0;
        for (Map.Entry<String, String> object : this.mappedSchemas.entrySet()) {
            properties.put(RULE_CLIENT_SCHEMA + String.valueOf(n), object.getKey());
            properties.put(RULE_SUPPLIER_SCHEMA + String.valueOf(n), object.getValue());
            ++n;
        }
        for (String string : this.ignoredSchemas) {
            properties.put(RULE_CLIENT_SCHEMA + String.valueOf(n), string);
            properties.put(RULE_SUPPLIER_SCHEMA + String.valueOf(n), MITI_IGNORED_SCHEMA_NAME);
            ++n;
        }
        if (!this.parameters.isEmpty()) {
            for (Map.Entry entry : this.parameters.entrySet()) {
                properties.put(RULE_STITCHING_PARAMETER + (String)entry.getKey(), entry.getValue());
            }
        }
        properties.put(MATCHING_SCORE, String.valueOf(this.matchingScore));
        properties.put(STITCHING_SCORE, String.valueOf(this.stitchingScore));
        properties.put(IS_APPROVED, String.valueOf(this.approved));
        try {
            properties.store(stringWriter, null);
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException(iOException.getMessage(), iOException);
        }
        return stringWriter.toString();
    }

    public static StitchingRule deserialize(String string) {
        StitchingRule stitchingRule = new StitchingRule();
        if (string != null) {
            String string2;
            Properties properties = new Properties();
            try {
                properties.load(new StringReader(string));
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException(iOException.getMessage(), iOException);
            }
            for (Object object : properties.keySet()) {
                string2 = (String)object;
                if (string2.startsWith(RULE_STITCHING_PARAMETER)) {
                    String string3 = string2.substring(RULE_STITCHING_PARAMETER.length());
                    String string4 = properties.getProperty(string2);
                    stitchingRule.addParameter(string3, string4);
                    continue;
                }
                if (RULE_MODEL_PATH.equals(string2)) {
                    stitchingRule.setModelPath(properties.getProperty(string2));
                    continue;
                }
                if (MATCHING_SCORE.equals(string2)) {
                    stitchingRule.setMatchingScore(Integer.parseInt(properties.getProperty(string2)));
                    continue;
                }
                if (STITCHING_SCORE.equals(string2)) {
                    stitchingRule.setStitchingScore(Integer.parseInt(properties.getProperty(string2)));
                    continue;
                }
                if (!IS_APPROVED.equals(string2)) continue;
                stitchingRule.setApproved(Boolean.parseBoolean(properties.getProperty(string2)));
            }
            int n = 0;
            while (true) {
                Object object;
                if ((object = properties.getProperty(RULE_CLIENT_SCHEMA + String.valueOf(n))) != null) {
                    string2 = properties.getProperty(RULE_SUPPLIER_SCHEMA + String.valueOf(n));
                    if (string2.equals(MITI_IGNORED_SCHEMA_NAME)) {
                        stitchingRule.addIgnoredSchema((String)object);
                    } else if (!string2.equals(MITI_NULL_SUPPLIER_NAME)) {
                        stitchingRule.addMappedSchema((String)object, string2);
                    }
                } else if (n > 0) break;
                ++n;
            }
        }
        return stitchingRule;
    }

    @Override
    public int compareTo(StitchingRule stitchingRule) {
        int n = this.modelPath.compareTo(stitchingRule.modelPath);
        if (n == 0 && (n = this.mappedSchemas.size() - stitchingRule.mappedSchemas.size()) == 0) {
            for (Map.Entry<String, String> entry : this.mappedSchemas.entrySet()) {
                if (stitchingRule.mappedSchemas.containsKey(entry.getKey())) {
                    n = entry.getValue().compareTo(stitchingRule.mappedSchemas.get(entry.getKey()));
                    if (n == 0) continue;
                    break;
                }
                n = 1;
                break;
            }
        }
        return n;
    }

    public int getMatchingScore() {
        return this.matchingScore;
    }

    public void setMatchingScore(int n) {
        this.matchingScore = n;
    }

    public boolean isApproved() {
        return this.approved;
    }

    public void setApproved(boolean bl) {
        this.approved = bl;
    }

    public int getStitchingScore() {
        return this.stitchingScore;
    }

    public void setStitchingScore(int n) {
        this.stitchingScore = n;
    }
}

