/*
 * Decompiled with CFR 0.152.
 */
package MITI.server.services.common.mir;

import MITI.server.services.common.mir.ObjectIdentifier;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public interface ObjectIdentity {
    public static final Comparator<ObjectIdentity> COMPARATOR = new Comparator<ObjectIdentity>(){

        @Override
        public int compare(ObjectIdentity objectIdentity, ObjectIdentity objectIdentity2) {
            return objectIdentity.getId().compareTo(objectIdentity2.getId());
        }
    };

    public ObjectIdentifier getId();

    public static <T extends ObjectIdentity> Set<T> toSet(Collection<T> collection) {
        if (collection != null) {
            if (collection instanceof Set) {
                return (Set)collection;
            }
            TreeSet<ObjectIdentity> treeSet = new TreeSet<ObjectIdentity>(COMPARATOR);
            treeSet.addAll(collection);
            return treeSet;
        }
        return null;
    }

    public static <T extends ObjectIdentity> Map<ObjectIdentifier, T> toMap(Collection<T> collection) {
        if (collection != null) {
            TreeMap<ObjectIdentifier, ObjectIdentity> treeMap = new TreeMap<ObjectIdentifier, ObjectIdentity>();
            for (ObjectIdentity objectIdentity : collection) {
                treeMap.put(objectIdentity.getId(), objectIdentity);
            }
            return treeMap;
        }
        return null;
    }
}

