/*
 * Decompiled with CFR 0.152.
 */
package MITI.server.services.common.mir;

import MITI.server.services.common.mir.LinkPart;
import java.util.ArrayList;
import java.util.Arrays;

public class LinkIdentifier
implements Comparable<LinkIdentifier> {
    private LinkPart[] associations = null;

    public LinkIdentifier() {
    }

    public LinkIdentifier(LinkIdentifier linkIdentifier) {
        if (linkIdentifier.getAssociations() != null) {
            this.associations = new LinkPart[linkIdentifier.getAssociations().length];
            for (int i = 0; i < this.associations.length; ++i) {
                this.associations[i] = new LinkPart(linkIdentifier.getAssociations()[i]);
            }
        }
    }

    public LinkIdentifier(short s) {
        this.associations = new LinkPart[]{new LinkPart(s)};
    }

    public final short getId() {
        return this.associations != null && this.associations.length == 1 ? this.associations[0].getId() : (short)-1;
    }

    public LinkPart[] getAssociations() {
        return this.associations;
    }

    public void setAssociations(LinkPart[] linkPartArray) {
        this.associations = linkPartArray;
    }

    public boolean equals(Object object) {
        if (object instanceof LinkIdentifier) {
            LinkIdentifier linkIdentifier = (LinkIdentifier)object;
            return Arrays.equals(this.associations, linkIdentifier.associations);
        }
        if (object instanceof Short) {
            return this.getId() == ((Short)object).shortValue();
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.associations);
    }

    @Override
    public int compareTo(LinkIdentifier linkIdentifier) {
        if (this.associations == null) {
            if (linkIdentifier.associations == null) {
                return 0;
            }
            return -1;
        }
        if (linkIdentifier.associations == null) {
            return 1;
        }
        if (this.associations.length < linkIdentifier.associations.length) {
            return -1;
        }
        if (this.associations.length > linkIdentifier.associations.length) {
            return 1;
        }
        for (int i = 0; i < this.associations.length; ++i) {
            int n = this.associations[i].compareTo(linkIdentifier.associations[i]);
            if (n == 0) continue;
            return n;
        }
        return 0;
    }

    public short associationType() {
        if (this.associations != null && this.associations.length != 0) {
            return this.associations[this.associations.length - 1].getAssociationType();
        }
        return -1;
    }

    public short destinationElementType() {
        if (this.associations != null && this.associations.length != 0) {
            return this.associations[this.associations.length - 1].destinationElementType();
        }
        return -1;
    }

    public boolean unary() {
        if (this.associations != null && this.associations.length != 0) {
            for (int i = 0; i < this.associations.length; ++i) {
                if (this.associations[i].unary()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean aggregation() {
        if (this.associations != null && this.associations.length != 0) {
            for (int i = 0; i < this.associations.length; ++i) {
                if (this.associations[i].aggregation()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public String toMPath() {
        if (this.associations == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.associations.length; ++i) {
            if (i != 0) {
                stringBuffer.append("/");
            }
            stringBuffer.append(this.associations[i].toMPath());
        }
        return stringBuffer.toString();
    }

    public LinkIdentifier reverseLink() {
        Comparable<LinkIdentifier> comparable;
        int n = 0;
        int n2 = this.associations.length;
        if (this.associations == null || n2 == 0) {
            return null;
        }
        ArrayList<LinkPart> arrayList = new ArrayList<LinkPart>();
        for (n = n2 - 1; n >= 0; --n) {
            comparable = this.associations[n];
            short s = ((LinkPart)comparable).reverseAssociationType();
            if (s == -1) {
                return null;
            }
            if (((LinkPart)comparable).getCondition() != null) {
                if (arrayList.size() == 0) {
                    arrayList.add(new LinkPart(-2));
                }
                ((LinkPart)arrayList.get(arrayList.size() - 1)).setCondition(((LinkPart)comparable).getCondition());
            }
            LinkPart linkPart = new LinkPart(s);
            if (n == 0 && s == -2) break;
            arrayList.add(linkPart);
        }
        comparable = new LinkIdentifier();
        ((LinkIdentifier)comparable).associations = arrayList.toArray(new LinkPart[arrayList.size()]);
        return comparable;
    }

    public String toString() {
        return this.toMPath();
    }
}

