/*
 * Decompiled with CFR 0.152.
 */
package MITI.server.services.common.mir;

import MITI.sdk.MIRMetaAttribute;
import MITI.server.services.common.mir.AttributeIdentifier;

public class AttributeValue
extends AttributeIdentifier {
    private String value = null;
    private String valueType = null;
    private String[] possibleValues = null;
    private String udpDescription = null;

    public AttributeValue() {
    }

    public AttributeValue(AttributeIdentifier attributeIdentifier, String string) {
        super(attributeIdentifier);
        this.setValue(string);
    }

    public AttributeValue(short s, String string) {
        super(s);
        this.setValue(string);
    }

    public AttributeValue(short s, byte by) {
        super(s);
        this.setValue(by);
    }

    public AttributeValue(String string, String string2) {
        super(string);
        this.setValue(string2);
    }

    public AttributeValue(AttributeValue attributeValue) {
        super(attributeValue);
        this.setValue(attributeValue.value);
        this.valueType = attributeValue.valueType;
        this.possibleValues = attributeValue.possibleValues;
        this.udpDescription = attributeValue.udpDescription;
    }

    @Override
    public String toString() {
        return super.toString() + ": '" + this.value + "'";
    }

    public String getValue() {
        return this.value;
    }

    public boolean toBoolean() {
        try {
            return Boolean.parseBoolean(this.value);
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public byte toEnum() {
        Object object;
        MIRMetaAttribute mIRMetaAttribute = MIRMetaAttribute.getByAttributeType(this.getType());
        if (mIRMetaAttribute != null && (object = mIRMetaAttribute.getValueFromString(this.value, false)) != null && object instanceof Byte) {
            return (Byte)object;
        }
        return -1;
    }

    public int toInt() {
        try {
            return Integer.parseInt(this.value);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public void setValue(byte by) {
        MIRMetaAttribute mIRMetaAttribute = MIRMetaAttribute.getByAttributeType(this.getType());
        if (mIRMetaAttribute != null) {
            this.value = mIRMetaAttribute.getValueToString(by, false);
            if (this.value != null) {
                return;
            }
        }
        throw new IllegalArgumentException("Invalid attribute value");
    }

    public void setValue(String string) {
        MIRMetaAttribute mIRMetaAttribute = MIRMetaAttribute.getByAttributeType(this.getType());
        if (mIRMetaAttribute != null && mIRMetaAttribute.getValueFromString(string, false) == null) {
            throw new IllegalArgumentException("Invalid attribute value");
        }
        this.value = string;
    }

    public String getValueType() {
        return this.valueType;
    }

    public void setValueType(String string) {
        this.valueType = string;
    }

    public String[] getPossibleValues() {
        return this.possibleValues;
    }

    public void setPossibleValues(String[] stringArray) {
        this.possibleValues = stringArray;
    }

    public String getUdpDescription() {
        return this.udpDescription;
    }

    public void setUdpDescription(String string) {
        this.udpDescription = string;
    }
}

