/*
 * Decompiled with CFR 0.152.
 */
package MITI.sdk.validation;

import MITI.MIRException;
import MITI.messages.MIR.MVLD;
import MITI.sdk.MIRAssociation;
import MITI.sdk.MIRAssociationRole;
import MITI.sdk.MIRAttribute;
import MITI.sdk.MIRCandidateKey;
import MITI.sdk.MIRClass;
import MITI.sdk.MIRClassifier;
import MITI.sdk.MIRElement;
import MITI.sdk.MIRForeignKey;
import MITI.sdk.MIRGeneralization;
import MITI.sdk.MIRGeneralizationRole;
import MITI.sdk.MIRKey;
import MITI.sdk.MIRModelObject;
import MITI.sdk.MIRObject;
import MITI.sdk.MIRSQLViewAssociation;
import MITI.sdk.MIRSQLViewEntity;
import MITI.sdk.MIR_Object;
import MITI.sdk.validation.MIRValidation;
import java.util.ArrayList;
import java.util.Iterator;

public class MIRLoopDetector
implements MIR_Object.MIRTraversalOperation {
    private ArrayList<MIRElement> detectedInheritLoopElements = new ArrayList();
    private ArrayList<MIRElement> detectedFKLoopElements = new ArrayList();
    private ArrayList<MIRElement> detectedAggLoopElements = new ArrayList();
    private ArrayList<MIRElement> detectedAssLoopElements = new ArrayList();

    public boolean hasGeneralizationLoop(MIRClass mIRClass, ArrayList<MIRElement> arrayList) {
        ArrayList<MIRElement> arrayList2 = new ArrayList<MIRElement>(16);
        arrayList2.add(mIRClass);
        return this.hasGeneralizationLoop(mIRClass, arrayList2, arrayList);
    }

    private boolean hasGeneralizationLoop(MIRClass mIRClass, ArrayList<MIRElement> arrayList, ArrayList<MIRElement> arrayList2) {
        Iterator<MIRGeneralizationRole> iterator = mIRClass.getGeneralizationRoleIterator();
        while (iterator.hasNext()) {
            MIRGeneralizationRole mIRGeneralizationRole = iterator.next();
            if (mIRGeneralizationRole.getSubtypeOfGeneralization() == null) continue;
            MIRGeneralization mIRGeneralization = mIRGeneralizationRole.getSubtypeOfGeneralization();
            Iterator<MIRGeneralizationRole> iterator2 = mIRGeneralization.getSupertypeGeneralizationRoleIterator();
            while (iterator2.hasNext()) {
                MIRGeneralizationRole mIRGeneralizationRole2 = iterator2.next();
                MIRClass mIRClass2 = mIRGeneralizationRole2.getAssociatedClass();
                if (arrayList.contains(mIRClass2)) {
                    if (arrayList.get(0) != mIRClass2) continue;
                    arrayList2.addAll(arrayList);
                    return true;
                }
                arrayList.add(mIRClass2);
                boolean bl = this.hasGeneralizationLoop(mIRClass2, arrayList, arrayList2);
                if (!bl) continue;
                return true;
            }
        }
        return false;
    }

    private boolean hasAssociationLoop(MIRClass mIRClass, ArrayList<MIRElement> arrayList) {
        ArrayList<MIRElement> arrayList2 = new ArrayList<MIRElement>(16);
        arrayList2.add(mIRClass);
        return this.hasAssociationLoop(mIRClass, arrayList2, arrayList);
    }

    private boolean hasAssociationLoop(MIRClass mIRClass, ArrayList<MIRElement> arrayList, ArrayList<MIRElement> arrayList2) {
        MIRModelObject mIRModelObject;
        Object object;
        Object object2;
        MIRModelObject mIRModelObject2;
        Object object3;
        Iterator<MIRAssociationRole> iterator = mIRClass.getAssociationRoleIterator();
        while (iterator.hasNext()) {
            object3 = iterator.next();
            if (((MIRAssociationRole)object3).getSource() || (mIRModelObject2 = ((MIRAssociationRole)object3).getAssociation()) == null || !((MIRAssociation)mIRModelObject2).getAggregation()) continue;
            object2 = ((MIRAssociation)mIRModelObject2).getAssociationRoleIterator();
            while (object2.hasNext()) {
                object = (MIRAssociationRole)object2.next();
                if (object == object3 || !((MIRAssociationRole)object).getSource() || (mIRModelObject = ((MIRAssociationRole)object).getAssociatedClass()) == null) continue;
                if (arrayList.contains(mIRModelObject)) {
                    if (arrayList.get(0) != mIRModelObject) continue;
                    arrayList2.addAll(arrayList);
                    return true;
                }
                arrayList.add(mIRModelObject);
                boolean bl = this.hasAssociationLoop((MIRClass)mIRModelObject, arrayList, arrayList2);
                if (!bl) continue;
                return true;
            }
        }
        object3 = mIRClass.getGeneralizationRoleIterator();
        while (object3.hasNext()) {
            mIRModelObject2 = (MIRGeneralizationRole)object3.next();
            if (((MIRGeneralizationRole)mIRModelObject2).getSubtypeOfGeneralization() == null) continue;
            object2 = ((MIRGeneralizationRole)mIRModelObject2).getSubtypeOfGeneralization();
            object = ((MIRGeneralization)object2).getSupertypeGeneralizationRoleIterator();
            while (object.hasNext()) {
                mIRModelObject = object.next();
                MIRClass mIRClass2 = mIRModelObject.getAssociatedClass();
                if (arrayList.contains(mIRClass2)) {
                    if (arrayList.get(0) != mIRClass2) continue;
                    arrayList2.addAll(arrayList);
                    return true;
                }
                arrayList.add(mIRClass2);
                boolean bl = this.hasAssociationLoop(mIRClass2, arrayList, arrayList2);
                if (!bl) continue;
                return true;
            }
        }
        return false;
    }

    private boolean hasSQLViewAssociationLoop(MIRSQLViewEntity mIRSQLViewEntity, ArrayList<MIRElement> arrayList) {
        ArrayList<MIRElement> arrayList2 = new ArrayList<MIRElement>(16);
        arrayList2.add(mIRSQLViewEntity);
        return this.hasSQLViewAssociationLoop(mIRSQLViewEntity, arrayList2, arrayList);
    }

    private boolean hasSQLViewAssociationLoop(MIRSQLViewEntity mIRSQLViewEntity, ArrayList<MIRElement> arrayList, ArrayList<MIRElement> arrayList2) {
        Iterator<MIRSQLViewAssociation> iterator = mIRSQLViewEntity.getDestinationOfSQLViewAssociationIterator();
        while (iterator.hasNext()) {
            MIRSQLViewAssociation mIRSQLViewAssociation = iterator.next();
            MIRClassifier mIRClassifier = mIRSQLViewAssociation.getSourceClassifier();
            if (mIRClassifier.getElementType() != 25) continue;
            if (arrayList.contains(mIRClassifier)) {
                if (arrayList.get(0) != mIRClassifier) continue;
                arrayList2.addAll(arrayList);
                return true;
            }
            arrayList.add(mIRClassifier);
            boolean bl = this.hasSQLViewAssociationLoop((MIRSQLViewEntity)mIRClassifier, arrayList, arrayList2);
            if (!bl) continue;
            return true;
        }
        return false;
    }

    private boolean hasForeignKeyLoop(MIRForeignKey mIRForeignKey, ArrayList<MIRElement> arrayList) {
        ArrayList<MIRElement> arrayList2 = new ArrayList<MIRElement>(16);
        arrayList2.add(mIRForeignKey);
        return this.hasForeignKeyLoop(mIRForeignKey, arrayList2, arrayList);
    }

    private boolean hasForeignKeyLoop(MIRForeignKey mIRForeignKey, ArrayList<MIRElement> arrayList, ArrayList<MIRElement> arrayList2) {
        if (!this.FK_Belongs_PK(mIRForeignKey)) {
            return false;
        }
        MIRCandidateKey mIRCandidateKey = mIRForeignKey.getCandidateKey();
        if (mIRCandidateKey == null) {
            return false;
        }
        MIRClass mIRClass = mIRCandidateKey.getAssociatedClass();
        if (mIRClass == null) {
            return false;
        }
        Iterator<MIRKey> iterator = mIRClass.getKeyIterator();
        while (iterator.hasNext()) {
            MIRKey mIRKey = iterator.next();
            if (mIRKey == null || mIRKey.getElementType() != 22) continue;
            MIRForeignKey mIRForeignKey2 = (MIRForeignKey)mIRKey;
            if (arrayList.contains(mIRForeignKey2)) {
                if (arrayList.get(0) == mIRForeignKey2) {
                    arrayList2.addAll(arrayList);
                    return true;
                }
                return false;
            }
            arrayList.add(mIRForeignKey2);
            boolean bl = this.hasForeignKeyLoop(mIRForeignKey2, arrayList, arrayList2);
            if (!bl) continue;
            return true;
        }
        return false;
    }

    private boolean FK_Belongs_PK(MIRForeignKey mIRForeignKey) {
        MIRCandidateKey mIRCandidateKey = mIRForeignKey.getAssociatedClass().getPrimaryCandidateKey();
        if (mIRCandidateKey == null) {
            return false;
        }
        Iterator<MIRAttribute> iterator = mIRForeignKey.getAttributeIterator();
        while (iterator.hasNext()) {
            MIRAttribute mIRAttribute = iterator.next();
            if (mIRCandidateKey.containsAttribute(mIRAttribute)) continue;
            return false;
        }
        return true;
    }

    private void hasLoop(MIRClassifier mIRClassifier) {
        ArrayList<MIRElement> arrayList = new ArrayList<MIRElement>();
        if (mIRClassifier.getElementType() == 13) {
            if (!this.detectedInheritLoopElements.contains(mIRClassifier)) {
                if (this.hasGeneralizationLoop((MIRClass)mIRClassifier, arrayList)) {
                    MVLD.VALID_GENERALIZATION_LOOP.log(MIRValidation.buildValidationName(mIRClassifier), this.getLoopElementNames(arrayList));
                    this.detectedInheritLoopElements = arrayList;
                }
                arrayList.clear();
            }
            if (!this.detectedAggLoopElements.contains(mIRClassifier)) {
                if (this.hasAssociationLoop((MIRClass)mIRClassifier, arrayList)) {
                    MVLD.VALID_ASSOCIATION_LOOP.log(MIRValidation.buildValidationName(mIRClassifier), this.getLoopElementNames(arrayList));
                    this.detectedAggLoopElements = arrayList;
                }
                arrayList.clear();
            }
            Iterator<MIRKey> iterator = ((MIRClass)mIRClassifier).getKeyIterator();
            while (iterator.hasNext()) {
                MIRKey mIRKey = iterator.next();
                if (mIRKey.getElementType() != 22 || this.detectedFKLoopElements.contains(mIRKey)) continue;
                if (this.hasForeignKeyLoop((MIRForeignKey)mIRKey, arrayList)) {
                    MVLD.VALID_FOREIGNKEY_LOOP.log(MIRValidation.buildValidationName(mIRKey), this.getLoopElementNames(arrayList));
                    this.detectedFKLoopElements = arrayList;
                }
                arrayList.clear();
            }
        } else if (mIRClassifier.getElementType() == 25 && !this.detectedAssLoopElements.contains(mIRClassifier)) {
            if (this.hasSQLViewAssociationLoop((MIRSQLViewEntity)mIRClassifier, arrayList)) {
                MVLD.VALID_SQLVIEWASSOCIATION_LOOP.log(MIRValidation.buildValidationName(mIRClassifier), this.getLoopElementNames(arrayList));
                this.detectedAssLoopElements = arrayList;
            }
            arrayList.clear();
        }
    }

    private String getLoopElementNames(ArrayList<MIRElement> arrayList) {
        String string = "";
        for (int i = 0; i < arrayList.size(); ++i) {
            MIRObject mIRObject = arrayList.get(i);
            string = !string.isEmpty() ? string + "', '" + MIRValidation.buildValidationName(mIRObject) : MIRValidation.buildValidationName(mIRObject);
        }
        return string;
    }

    public boolean hasFKLoop(MIRForeignKey mIRForeignKey) {
        ArrayList<MIRElement> arrayList = new ArrayList<MIRElement>(16);
        this.detectedFKLoopElements.clear();
        boolean bl = this.hasForeignKeyLoop(mIRForeignKey, arrayList);
        arrayList.clear();
        this.detectedFKLoopElements.clear();
        return bl;
    }

    public void hasLoop(MIRObject mIRObject) throws MIRException {
        mIRObject.depthTraversal(this);
    }

    @Override
    public boolean traverse(MIRObject mIRObject) throws MIRException {
        return true;
    }

    @Override
    public void pre_process(MIRObject mIRObject, boolean bl) throws MIRException {
        if (mIRObject.getElementType() == 13 || mIRObject.getElementType() == 25) {
            this.hasLoop((MIRClassifier)mIRObject);
        }
    }

    @Override
    public void post_process(MIRObject mIRObject) {
    }
}

