/*
 * Decompiled with CFR 0.152.
 */
package MITI.sdk.mix.ids;

import MITI.sdk.MIRMetaClass;
import MITI.sdk.MIRMetaLink;
import MITI.sdk.MIRModel;
import MITI.sdk.MIRObject;
import MITI.sdk.MIRType;
import MITI.sdk.MIR_Object;
import MITI.sdk.mix.MIRMixIdMap;
import MITI.server.services.common.mir.ObjectIdentifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public class MixIdDoubleMap
extends MIRMixIdMap {
    private Map<Integer, MIRMixModelIdMap> modelIds = new HashMap<Integer, MIRMixModelIdMap>();
    private static Comparator<MIRObject> childrenComparator = new Comparator<MIRObject>(){

        @Override
        public int compare(MIRObject mIRObject, MIRObject mIRObject2) {
            int n = 0;
            n = mIRObject.getElementType() - mIRObject2.getElementType();
            if (n == 0) {
                n = mIRObject.getName().compareTo(mIRObject2.getName());
                if (n == 0 && mIRObject instanceof MIRType) {
                    n = ((MIRType)mIRObject).getDataType().compareTo(((MIRType)mIRObject2).getDataType());
                }
                if (n == 0) {
                    n = mIRObject.toString().compareTo(mIRObject2.toString());
                }
            }
            return n;
        }
    };

    @Override
    protected void put(ObjectIdentifier objectIdentifier, MIRObject mIRObject) {
        MIRMixModelIdMap mIRMixModelIdMap = this.modelIds.get(objectIdentifier.getModelId());
        if (mIRMixModelIdMap == null) {
            mIRMixModelIdMap = new MIRMixModelIdMap(objectIdentifier.getModelId());
            this.modelIds.put(objectIdentifier.getModelId(), mIRMixModelIdMap);
        }
        mIRMixModelIdMap.put(objectIdentifier, mIRObject);
    }

    @Override
    protected void add(MIRObject mIRObject, int n) {
        MIRMixModelIdMap mIRMixModelIdMap = this.modelIds.get(n);
        if (mIRMixModelIdMap == null) {
            mIRMixModelIdMap = new MIRMixModelIdMap(n);
            this.modelIds.put(n, mIRMixModelIdMap);
        }
        mIRMixModelIdMap.add(mIRObject);
    }

    @Override
    public MIRObject getMirObject(ObjectIdentifier objectIdentifier) {
        MIRMixModelIdMap mIRMixModelIdMap = this.modelIds.get(objectIdentifier.getModelId());
        if (mIRMixModelIdMap == null) {
            return null;
        }
        return mIRMixModelIdMap.getObject(objectIdentifier);
    }

    @Override
    public ObjectIdentifier getObjectIdentifier(MIRObject mIRObject) {
        ObjectIdentifier objectIdentifier;
        MIRMixModelIdMap mIRMixModelIdMap2;
        Object object;
        if (mIRObject == null) {
            return null;
        }
        MIRModel mIRModel = mIRObject.getRootModel();
        if (mIRModel != null && (object = mIRModel.getContent()) != null && (mIRMixModelIdMap2 = this.modelIds.get(0)) != null && (objectIdentifier = mIRMixModelIdMap2.getId((MIRObject)object)) != null && (mIRMixModelIdMap2 = this.modelIds.get(objectIdentifier.getObjectId())) != null) {
            return mIRMixModelIdMap2.getId(mIRObject);
        }
        for (MIRMixModelIdMap mIRMixModelIdMap2 : this.modelIds.values()) {
            objectIdentifier = mIRMixModelIdMap2.getId(mIRObject);
            if (objectIdentifier == null) continue;
            return objectIdentifier;
        }
        return null;
    }

    @Override
    protected void remove(ObjectIdentifier objectIdentifier) {
        MIRMixModelIdMap mIRMixModelIdMap = this.modelIds.remove(objectIdentifier.getModelId());
        if (mIRMixModelIdMap != null) {
            mIRMixModelIdMap.clear();
        }
    }

    private class MIRMixModelIdMap {
        private int modelId = 0;
        private int maxId = 0;
        private Map<ObjectIdentifier, MIRObject> id2Objects = null;
        private Map<MIRObject, ObjectIdentifier> object2Ids = null;

        public MIRMixModelIdMap(int n) {
            this.modelId = n;
            this.maxId = 0;
            this.id2Objects = new TreeMap<ObjectIdentifier, MIRObject>();
            this.object2Ids = new TreeMap<MIRObject, ObjectIdentifier>();
        }

        public void clear() {
            this.modelId = 0;
            this.maxId = 0;
            this.id2Objects.clear();
            this.id2Objects = null;
            this.object2Ids.clear();
            this.object2Ids = null;
        }

        public void put(ObjectIdentifier objectIdentifier, MIRObject mIRObject) {
            if (objectIdentifier.getObjectId() > this.maxId) {
                this.maxId = objectIdentifier.getObjectId();
            }
            if (this.id2Objects.get(objectIdentifier) == null && this.object2Ids.get(mIRObject) == null) {
                this.id2Objects.put(objectIdentifier, mIRObject);
                this.object2Ids.put(mIRObject, objectIdentifier);
            }
        }

        public void add(MIRObject mIRObject) {
            new PopulateIds().run(mIRObject);
        }

        public MIRObject getObject(ObjectIdentifier objectIdentifier) {
            return this.id2Objects.get(objectIdentifier);
        }

        public ObjectIdentifier getId(MIRObject mIRObject) {
            return this.object2Ids.get(mIRObject);
        }

        public int hashCode() {
            return this.modelId;
        }

        public boolean equals(Object object) {
            MIRMixModelIdMap mIRMixModelIdMap = (MIRMixModelIdMap)object;
            return this.modelId == mIRMixModelIdMap.modelId;
        }

        private class PopulateIds {
            private boolean useIds = false;
            private ArrayList<MIRObject> objs = new ArrayList();

            private PopulateIds() {
            }

            public void run(MIRObject mIRObject) {
                this.useIds = mIRObject.getModelId() != 0 && mIRObject.getObjectId() != 0;
                this.traverse(mIRObject);
                for (MIRObject mIRObject2 : this.objs) {
                    ObjectIdentifier objectIdentifier = new ObjectIdentifier(MIRMixModelIdMap.this.modelId, ++MIRMixModelIdMap.this.maxId);
                    MIRMixModelIdMap.this.put(objectIdentifier, mIRObject2);
                }
            }

            private void traverse(MIRObject mIRObject) {
                ObjectIdentifier objectIdentifier = MIRMixModelIdMap.this.getId(mIRObject);
                if (objectIdentifier == null) {
                    if (this.useIds && mIRObject.getModelId() != 0 && mIRObject.getObjectId() != 0) {
                        objectIdentifier = new ObjectIdentifier(MIRMixModelIdMap.this.modelId, mIRObject.getObjectId());
                        MIRMixModelIdMap.this.put(objectIdentifier, mIRObject);
                    } else {
                        this.objs.add(mIRObject);
                    }
                }
                MIRMetaClass mIRMetaClass = mIRObject.getMetaClass();
                for (MIRMetaLink mIRMetaLink : mIRMetaClass.getLinks()) {
                    if (mIRMetaLink.getType() != 3) continue;
                    ArrayList<Object> arrayList = new ArrayList<Object>();
                    Iterator<? extends MIRObject> iterator = mIRMetaLink.getIterator((MIR_Object)mIRObject);
                    while (iterator.hasNext()) {
                        MIRObject mIRObject2 = iterator.next();
                        if (mIRObject2.isInstanceOf((short)218)) continue;
                        arrayList.add(mIRObject2);
                    }
                    Collections.sort(arrayList, childrenComparator);
                    for (MIRObject mIRObject3 : arrayList) {
                        this.traverse(mIRObject3);
                    }
                }
            }
        }
    }
}

