/*
 * Decompiled with CFR 0.152.
 */
package MITI.sdk.mix;

import MITI.util.XmlUtil;
import MITI.util.XmlVersion;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Stack;

public class MIRXmlStreamWriter {
    private Writer writer;
    private Stack<String> elementNamesStack = new Stack();
    private Stack<String> prefixesStack = new Stack();
    private HashMap<String, String> prefixToUri = new HashMap();
    private int ELEMENT_STATE_NEW = 0;
    private int ELEMENT_STATE_STARTED = 1;
    private int currentElementState = this.ELEMENT_STATE_NEW;
    private XmlVersion xmlVersion;
    private String indent = "";
    private String currentIndentation = "";
    private boolean hasElementValue = false;

    public MIRXmlStreamWriter(Writer writer, boolean bl) {
        this(writer, bl, "");
    }

    public MIRXmlStreamWriter(Writer writer, boolean bl, String string) {
        this.writer = writer;
        this.xmlVersion = bl ? XmlVersion.XML_11 : XmlVersion.XML_10;
        this.indent = string;
    }

    public void writeStartDocument() throws IOException {
        this.writer.write(this.xmlVersion.getDecl("UTF-8"));
        this.writer.write("\n");
    }

    public void writeStartElement(String string) throws IOException {
        this.writeStartElement(null, string);
    }

    public void writeStartElement(String string, String string2) throws IOException {
        this.ensureElementEnd(true);
        if (this.hasElementValue) {
            this.hasElementValue = false;
        } else {
            this.writer.write(this.currentIndentation);
        }
        this.currentIndentation = this.currentIndentation + this.indent;
        if (string == null || string.length() == 0) {
            String string3;
            string = !this.prefixesStack.isEmpty() ? ((string3 = this.prefixesStack.peek()) == null ? "" : string3) : "";
        }
        this.writer.write(60);
        if (string.length() > 0 && (this.prefixesStack.isEmpty() || !string.equals(this.prefixesStack.peek()))) {
            string2 = string + ":" + string2;
        }
        this.writer.write(string2);
        this.currentElementState = this.ELEMENT_STATE_STARTED;
        if (!this.prefixesStack.isEmpty() && !string.equals(this.prefixesStack.peek())) {
            this.writeAttribute("xmlns", this.prefixToUri.get(string));
        }
        this.elementNamesStack.push(string2);
        this.prefixesStack.push(string);
    }

    public void writeEndElement() throws IOException {
        if (this.elementNamesStack.isEmpty()) {
            throw new IllegalStateException("Elements stack is empty");
        }
        int n = this.currentIndentation.length() - this.indent.length();
        if (n >= 0 && n < this.currentIndentation.length()) {
            this.currentIndentation = this.currentIndentation.substring(0, n);
        }
        String string = this.elementNamesStack.pop();
        this.prefixesStack.pop();
        if (this.currentElementState == this.ELEMENT_STATE_NEW) {
            if (this.hasElementValue) {
                this.hasElementValue = false;
            } else {
                this.writer.write(this.currentIndentation);
            }
            this.writer.write("</");
            this.writer.write(string);
            this.writer.write(">\n");
        } else {
            this.writer.write("/>\n");
        }
        this.currentElementState = this.ELEMENT_STATE_NEW;
    }

    public void writeNamespace(String string, String string2) throws IOException {
        this.writeAttribute("xmlns:" + string, string2);
        this.prefixToUri.put(string, string2);
        if (!this.prefixesStack.isEmpty() && string.equals(this.prefixesStack.peek())) {
            this.writeAttribute("xmlns", string2);
        }
    }

    public void writeAttribute(String string, String string2) throws IOException {
        if (this.currentElementState == this.ELEMENT_STATE_NEW) {
            throw new IllegalStateException("Invalid XML writer state: " + this.currentElementState);
        }
        this.writer.write(32);
        this.writer.write(string);
        this.writer.write("=\"");
        this.writer.write(XmlUtil.escapeXml(string2, this.xmlVersion));
        this.writer.write(34);
    }

    public void writeAttribute(String string, String string2, String string3) throws IOException {
        this.writeAttribute(string + ":" + string2, string3);
    }

    public void writeCharacters(String string) throws IOException {
        this.ensureElementEnd(false);
        this.writer.write(XmlUtil.escapeXml(string, this.xmlVersion));
        this.hasElementValue = true;
    }

    public void flush() throws IOException {
        this.writer.flush();
    }

    private void checkElementsClosure() {
        if (!this.elementNamesStack.isEmpty()) {
            String string = "";
            while (!this.elementNamesStack.isEmpty()) {
                string = string + " " + this.elementNamesStack.pop();
            }
            throw new IllegalStateException("Closing document without closing elements: " + string);
        }
    }

    public void writeEndDocument() {
        this.checkElementsClosure();
    }

    private void ensureElementEnd(boolean bl) throws IOException {
        if (this.currentElementState != this.ELEMENT_STATE_NEW && !this.elementNamesStack.isEmpty()) {
            this.writer.write(">");
            if (bl) {
                this.writer.write(10);
            }
        }
        this.currentElementState = this.ELEMENT_STATE_NEW;
    }

    public void writeComment(String string) throws IOException {
        this.ensureElementEnd(true);
        if (this.hasElementValue) {
            this.hasElementValue = false;
        } else {
            this.writer.write(this.currentIndentation);
        }
        this.writer.write("<!--");
        if (string != null) {
            this.writer.write(string);
        }
        this.writer.write("-->\n");
    }

    public void writeProcessingInstruction(String string) throws IOException {
        this.ensureElementEnd(true);
        this.writer.write("<?");
        this.writer.write(string);
        this.writer.write("?>\n");
    }

    public void close() throws IOException {
        this.checkElementsClosure();
        this.writer.flush();
        this.writer.close();
    }
}

