/*
 * Decompiled with CFR 0.152.
 */
package MITI.sdk.mix;

import MITI.MIRException;
import MITI.sdk.MIRObject;
import MITI.sdk.mix.MIRObjectCache;
import MITI.server.services.common.mir.ObjectDefinition;
import MITI.server.services.common.mir.ObjectIdentifier;

public abstract class MIRMixIdMap
implements MIRObjectCache {
    protected abstract void put(ObjectIdentifier var1, MIRObject var2);

    protected abstract void add(MIRObject var1, int var2);

    @Override
    public abstract MIRObject getMirObject(ObjectIdentifier var1);

    @Override
    public abstract ObjectIdentifier getObjectIdentifier(MIRObject var1);

    @Override
    public ObjectDefinition getObjectDefinition(MIRObject mIRObject) {
        ObjectIdentifier objectIdentifier = this.getObjectIdentifier(mIRObject);
        if (objectIdentifier != null) {
            return new ObjectDefinition(objectIdentifier, mIRObject.getElementType(), mIRObject.getName());
        }
        return null;
    }

    protected abstract void remove(ObjectIdentifier var1);

    protected static ObjectIdentifier parseHref(String string) throws MIRException {
        if (string == null) {
            return null;
        }
        int n = string.indexOf("#");
        if (n == -1) {
            return null;
        }
        return new ObjectIdentifier(MIRMixIdMap.normalizeModelId(string.substring(0, n)), MIRMixIdMap.normalizeObjectId(string.substring(n + 1)));
    }

    protected static int normalizeModelId(String string) {
        int n = 0;
        if (string != null) {
            if (string.endsWith(".xml") || string.endsWith(".mix") || string.endsWith(".tmp")) {
                string = string.substring(0, string.length() - 4);
            }
            try {
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return n;
    }

    protected static int normalizeObjectId(String string) {
        int n = 0;
        if (string != null) {
            if (string.startsWith("_")) {
                string = string.substring(1);
            }
            try {
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return n;
    }
}

