/*
 * Decompiled with CFR 0.152.
 */
package MITI.sdk.mix;

import MITI.sdk.MIRDirectoryStructureModel;
import MITI.sdk.MIRModel;
import MITI.sdk.MIRObject;
import MITI.sdk.mix.MIRMixManager;
import MITI.sdk.mix.MIRObjectCache;
import MITI.server.services.common.mir.ObjectDefinition;
import MITI.server.services.common.mir.ObjectIdentifier;
import MITI.server.services.common.mir.ProfiledObjectDefinition;
import java.io.File;

public class MIRMixCache
extends MIRMixManager
implements MIRObjectCache {
    public MIRMixCache() {
    }

    public MIRMixCache(File file) {
        super(file);
    }

    public MIRMixCache(MIRMixManager mIRMixManager) {
        super(mIRMixManager.multiModelFile);
        this.ids = mIRMixManager.ids;
    }

    @Override
    public ObjectIdentifier getObjectIdentifier(MIRObject mIRObject) {
        if (mIRObject == null) {
            return null;
        }
        return this.ids.getObjectIdentifier(mIRObject);
    }

    @Override
    public ObjectDefinition getObjectDefinition(MIRObject mIRObject) {
        if (mIRObject == null) {
            return null;
        }
        ObjectIdentifier objectIdentifier = this.ids.getObjectIdentifier(mIRObject);
        if (objectIdentifier == null) {
            return null;
        }
        return new ObjectDefinition(objectIdentifier, mIRObject.getElementType(), mIRObject.getName());
    }

    @Override
    public MIRObject getMirObject(ObjectIdentifier objectIdentifier) {
        if (objectIdentifier == null) {
            return null;
        }
        if (objectIdentifier instanceof ProfiledObjectDefinition && ((ProfiledObjectDefinition)objectIdentifier).getGroupName() != null) {
            return this.ids.getMirObject(new ObjectIdentifier(objectIdentifier.getModelId(), objectIdentifier.getObjectId()));
        }
        return this.ids.getMirObject(objectIdentifier);
    }

    public void removeDirectoryStructure(MIRDirectoryStructureModel mIRDirectoryStructureModel) {
        this.remove(mIRDirectoryStructureModel);
    }

    public void removeModel(MIRModel mIRModel) {
        this.remove(mIRModel);
        mIRModel.removeContent();
    }

    @Override
    protected void unload(MIRModel mIRModel) {
    }
}

