/*
 * Decompiled with CFR 0.152.
 */
package MITI.sdk.mix;

import MITI.MIRException;
import MITI.messages.MIR.XSER;
import MITI.sdk.MIRElementType;
import MITI.sdk.MIRObject;
import MITI.sdk.mix.MIRMIXWriter;
import MITI.sdk.mix.MIRMixIdMap;
import MITI.sdk.mix.checksum.MixChecksum;
import MITI.sdk.mix.ids.SingleModelMixIds;
import MITI.server.services.common.mir.ObjectIdentifier;
import MITI.util.file.FileUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

public class MIRMIXExport
extends MIRMIXWriter {
    public static final byte MAXIMUM_OPTIMIZATION = 0;
    public static final byte MINIMUM_OPTIMIZATION = 1;
    public static final byte LOW_OPTIMIZATION = 2;
    private MIRMixIdMap ids = null;

    public MIRMIXExport() {
        this(0);
    }

    public MIRMIXExport(byte by) {
        if (by == 1) {
            this.setOptimizeDefaultValues(false);
            this.setOptimizeReverseLinks(false);
            this.setOptimizeIdrefs(false);
            this.setOptimizeID(false);
            this.setOptimizeTagNames(false);
        } else if (by == 0) {
            this.setOptimizeDefaultValues(true);
            this.setOptimizeReverseLinks(true);
            this.setOptimizeIdrefs(true);
            this.setOptimizeID(true);
            this.setOptimizeTagNames(true);
        }
    }

    public void run(File file, MIRObject mIRObject) throws MIRException {
        this.run(file, mIRObject, null, new SingleModelMixIds());
    }

    protected void run(File file, MIRObject mIRObject, MixChecksum mixChecksum, MIRMixIdMap mIRMixIdMap) throws MIRException {
        if (mIRObject == null) {
            XSER.OBJECT_IS_MISSING.log("Root");
            return;
        }
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new MIRException(fileNotFoundException);
        }
        this.ids = mIRMixIdMap;
        this.ids.add(mIRObject, MIRMixIdMap.normalizeModelId(file.getName()));
        this.print(fileOutputStream, mIRObject, mixChecksum);
    }

    protected String run(MIRObject mIRObject, String string) throws MIRException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.ids = new SingleModelMixIds();
        this.ids.add(mIRObject, MIRMixIdMap.normalizeModelId(string));
        this.print(byteArrayOutputStream, mIRObject, null);
        String string2 = "";
        try {
            string2 = byteArrayOutputStream.toString(FileUtil.UTF8.name());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return string2;
    }

    private void print(OutputStream outputStream, MIRObject mIRObject, MixChecksum mixChecksum) throws MIRException {
        try {
            this.openDocument(outputStream, mixChecksum);
            this.printObject(mIRObject, null);
            this.closeDocument();
        }
        catch (MIRException mIRException) {
            throw mIRException;
        }
        finally {
            try {
                outputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    @Override
    protected ObjectIdentifier getXmiId(MIRObject mIRObject) throws MIRException {
        ObjectIdentifier objectIdentifier = this.ids.getObjectIdentifier(mIRObject);
        if (objectIdentifier == null) {
            throw new MIRException(XSER.OBJECT_IS_MISSING_XMI_ID.getMessage(mIRObject.getPath(), MIRElementType.getName(mIRObject.getElementType())));
        }
        return objectIdentifier;
    }
}

