/*
 * Decompiled with CFR 0.152.
 */
package MITI.sdk.id;

import MITI.sdk.MIRModel;
import MITI.sdk.MIRObject;
import MITI.sdk.id.MIRSystemId;
import java.util.HashSet;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;

public class MIRSystemIdCache {
    private AtomicInteger uniqueIdGenerator = new AtomicInteger();
    private TreeMap<MIRModel, MIRSystemIdMap> cache = new TreeMap();

    public int generateUniqueId() {
        return this.uniqueIdGenerator.incrementAndGet();
    }

    public MIRSystemId getObjectIdentity(MIRObject mIRObject) {
        MIRSystemId mIRSystemId;
        MIRModel mIRModel = mIRObject.getRootModel();
        MIRSystemIdMap mIRSystemIdMap = this.cache.get(mIRModel);
        if (mIRSystemIdMap == null) {
            mIRSystemIdMap = new MIRSystemIdMap();
            this.cache.put(mIRModel, mIRSystemIdMap);
        }
        if ((mIRSystemId = mIRSystemIdMap.get(mIRObject)) == null && !mIRSystemIdMap.add(mIRObject, mIRSystemId = new MIRSystemId(this, mIRObject))) {
            throw new IllegalArgumentException("Could not generate a unique system id for " + mIRObject);
        }
        return mIRSystemId;
    }

    public void remove(MIRModel mIRModel) {
        MIRSystemIdMap mIRSystemIdMap = this.cache.remove(mIRModel);
        if (mIRSystemIdMap != null) {
            mIRSystemIdMap.clear();
        }
    }

    protected boolean isUnique(MIRObject mIRObject, MIRSystemId mIRSystemId) {
        MIRModel mIRModel = mIRObject.getRootModel();
        MIRSystemIdMap mIRSystemIdMap = this.cache.get(mIRModel);
        if (mIRSystemIdMap != null) {
            return !mIRSystemIdMap.contains(mIRSystemId);
        }
        return true;
    }

    private class MIRSystemIdMap {
        private TreeMap<MIRObject, MIRSystemId> cache = new TreeMap();
        private HashSet<MIRSystemId> ids = new HashSet();

        protected MIRSystemIdMap() {
        }

        protected boolean add(MIRObject mIRObject, MIRSystemId mIRSystemId) {
            if (this.ids.add(mIRSystemId)) {
                this.cache.put(mIRObject, mIRSystemId);
                return true;
            }
            return false;
        }

        protected boolean contains(MIRSystemId mIRSystemId) {
            return this.ids.contains(mIRSystemId);
        }

        protected MIRSystemId get(MIRObject mIRObject) {
            return this.cache.get(mIRObject);
        }

        protected void clear() {
            this.cache.clear();
            this.ids.clear();
        }
    }
}

