/*
 * Decompiled with CFR 0.152.
 */
package MITI.sdk.collections;

import MITI.sdk.MIRModelObject;
import MITI.sdk.MIRObject;
import MITI.sdk.MIRTypeValue;
import MITI.sdk.collections.MIRObjectCollection;
import MITI.sdk.collections.MIRSdkCollection;
import MITI.sdk.collections.MIRSingleObjectCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.TreeMap;

public class MIRMultiObjectCollection<T extends MIRObject>
implements MIRObjectCollection<T> {
    private TreeMap<String, LinkedCollection<T>> values;
    private LinkedEntry<T> first;
    private LinkedEntry<T> last;
    private int size;
    private int modCount;
    private MIRSdkCollection.Type type = MIRSdkCollection.Type.OBJECT;
    private boolean caseSensitive = true;

    public MIRMultiObjectCollection(MIRSingleObjectCollection<T> mIRSingleObjectCollection) {
        this.values = new TreeMap();
        this.type = mIRSingleObjectCollection.getType();
        this.caseSensitive = mIRSingleObjectCollection.isCaseSensitive();
        if (mIRSingleObjectCollection.get() != null) {
            this.add(mIRSingleObjectCollection.get());
        }
    }

    @Override
    public MIRSdkCollection.Type getType() {
        return this.type;
    }

    @Override
    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    @Override
    public T get(String string) {
        if (string == null) {
            return this.first();
        }
        LinkedCollection<T> linkedCollection = this.values.get(this.getKeyName(string));
        if (linkedCollection != null) {
            return (T)((LinkedEntry)linkedCollection.first()).val;
        }
        return null;
    }

    private String getKeyName(String string) {
        return this.caseSensitive ? string : string.toUpperCase();
    }

    private String getKeyName(T t) {
        return this.caseSensitive ? this.getName((MIRObject)t) : this.getName((MIRObject)t).toUpperCase();
    }

    @Override
    public boolean allowName(MIRObject mIRObject) {
        if (this.type == MIRSdkCollection.Type.OBJECT) {
            return true;
        }
        String string = this.getName(mIRObject);
        if (this.type == MIRSdkCollection.Type.OPTIONAL_NAME && string.isEmpty()) {
            return true;
        }
        T t = this.get(string);
        return t == null || t == mIRObject;
    }

    @Override
    public String getName(MIRObject mIRObject) {
        if (this.type == MIRSdkCollection.Type.PHYSICAL_NAME) {
            String string;
            if (mIRObject.isInstanceOf((short)59) && !(string = ((MIRModelObject)mIRObject).getPhysicalName()).isEmpty()) {
                return string;
            }
        } else if (this.type == MIRSdkCollection.Type.NAME_VALUE && mIRObject.getName().isEmpty() && mIRObject.isInstanceOf((short)7)) {
            return ((MIRTypeValue)mIRObject).getValue();
        }
        return mIRObject.getName();
    }

    @Override
    public boolean add(T t) {
        if (this.allowName((MIRObject)t)) {
            Map.Entry<String, LinkedCollection<T>> entry;
            String string = this.getKeyName(t);
            LinkedEntry<Object> linkedEntry = null;
            LinkedCollection linkedCollection = this.values.get(string);
            if (linkedCollection == null) {
                linkedCollection = this.type == MIRSdkCollection.Type.OBJECT || this.type == MIRSdkCollection.Type.OPTIONAL_NAME && string.isEmpty() ? new LinkedMap<T>() : new LinkedSingleton<T>();
                entry = this.values.floorEntry(string);
                if (entry != null) {
                    linkedEntry = ((LinkedCollection)entry.getValue()).last();
                }
                this.values.put(string, linkedCollection);
            } else {
                linkedEntry = linkedCollection.last();
            }
            entry = linkedEntry != null ? ((LinkedEntry)linkedEntry).next : this.first;
            LinkedEntry<T> linkedEntry2 = new LinkedEntry<T>(t, linkedEntry, entry);
            if (linkedCollection.add(linkedEntry2)) {
                if (linkedEntry != null) {
                    ((LinkedEntry)linkedEntry).next = (LinkedEntry)linkedEntry2;
                }
                if (entry != null) {
                    ((LinkedEntry)((Object)entry)).previous = (LinkedEntry)linkedEntry2;
                }
                if (((LinkedEntry)linkedEntry2).previous == null) {
                    this.first = linkedEntry2;
                }
                if (((LinkedEntry)linkedEntry2).next == null) {
                    this.last = linkedEntry2;
                }
                ++this.size;
                ++this.modCount;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean contains(T t) {
        String string = this.getKeyName(t);
        LinkedCollection<T> linkedCollection = this.values.get(string);
        return linkedCollection != null && linkedCollection.contains(t);
    }

    @Override
    public Iterator<T> iterator() {
        return new LinkedIterator(this.first, this.modCount);
    }

    private boolean remove(String string, T t) {
        LinkedEntry<T> linkedEntry;
        LinkedCollection<T> linkedCollection = this.values.get(string);
        if (linkedCollection != null && (linkedEntry = linkedCollection.remove(t)) != null) {
            if (linkedCollection.isEmpty()) {
                this.values.remove(string);
            }
            if (((LinkedEntry)linkedEntry).previous != null) {
                ((LinkedEntry)linkedEntry).previous.next = ((LinkedEntry)linkedEntry).next;
            } else {
                this.first = ((LinkedEntry)linkedEntry).next;
            }
            if (((LinkedEntry)linkedEntry).next != null) {
                ((LinkedEntry)linkedEntry).next.previous = ((LinkedEntry)linkedEntry).previous;
            } else {
                this.last = ((LinkedEntry)linkedEntry).previous;
            }
            ((LinkedEntry)linkedEntry).val = null;
            ((LinkedEntry)linkedEntry).next = null;
            ((LinkedEntry)linkedEntry).previous = null;
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    @Override
    public boolean remove(T t) {
        return this.remove(this.getKeyName(t), t);
    }

    @Override
    public void rename(T t, String string) {
        String string2;
        String string3 = this.getKeyName(string);
        if (!string3.equals(string2 = this.getKeyName(t)) && this.remove(string3, t)) {
            this.add(t);
        }
    }

    @Override
    public T first() {
        if (this.first != null) {
            return (T)((LinkedEntry)this.first).val;
        }
        return null;
    }

    @Override
    public T last() {
        if (this.last != null) {
            return (T)((LinkedEntry)this.last).val;
        }
        return null;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Collection<T> values() {
        ArrayList<MIRObject> arrayList = new ArrayList<MIRObject>();
        LinkedEntry linkedEntry = this.first;
        while (linkedEntry != null) {
            arrayList.add(linkedEntry.val);
            linkedEntry = linkedEntry.next;
        }
        return arrayList;
    }

    private static class LinkedMap<E extends MIRObject>
    extends LinkedCollection<E> {
        private HashMap<E, LinkedEntry<E>> map = new HashMap();
        private LinkedEntry<E> first;
        private LinkedEntry<E> last;

        @Override
        public boolean add(LinkedEntry<E> linkedEntry) {
            if (this.map.putIfAbsent(((LinkedEntry)linkedEntry).val, linkedEntry) == null) {
                if (this.first == null) {
                    this.last = linkedEntry;
                    this.first = this.last;
                }
                if (this.last == ((LinkedEntry)linkedEntry).previous) {
                    this.last = linkedEntry;
                }
                return true;
            }
            return false;
        }

        @Override
        public boolean contains(E e) {
            return this.map.containsKey(e);
        }

        @Override
        public LinkedEntry<E> remove(E e) {
            LinkedEntry<E> linkedEntry = this.map.remove(e);
            if (linkedEntry != null) {
                if (this.first == this.last) {
                    this.last = null;
                    this.first = null;
                } else if (this.first == linkedEntry) {
                    this.first = ((LinkedEntry)linkedEntry).next;
                } else if (this.last == linkedEntry) {
                    this.last = ((LinkedEntry)linkedEntry).previous;
                }
            }
            return linkedEntry;
        }

        @Override
        public LinkedEntry<E> first() {
            return this.first;
        }

        @Override
        public LinkedEntry<E> last() {
            return this.last;
        }

        @Override
        public boolean isEmpty() {
            return this.map.isEmpty();
        }
    }

    private static class LinkedSingleton<E extends MIRObject>
    extends LinkedCollection<E> {
        private LinkedEntry<E> singleton;

        private LinkedSingleton() {
        }

        @Override
        public boolean add(LinkedEntry<E> linkedEntry) {
            if (this.singleton == null) {
                this.singleton = linkedEntry;
                return true;
            }
            return false;
        }

        @Override
        public boolean contains(E e) {
            return this.singleton != null && ((LinkedEntry)this.singleton).val == e;
        }

        @Override
        public LinkedEntry<E> remove(E e) {
            LinkedEntry<E> linkedEntry = null;
            if (this.singleton != null && ((LinkedEntry)this.singleton).val == e) {
                linkedEntry = this.singleton;
                this.singleton = null;
            }
            return linkedEntry;
        }

        @Override
        public LinkedEntry<E> first() {
            return this.singleton;
        }

        @Override
        public LinkedEntry<E> last() {
            return this.singleton;
        }

        @Override
        public boolean isEmpty() {
            return this.singleton == null;
        }
    }

    private static abstract class LinkedCollection<E extends MIRObject> {
        private LinkedCollection() {
        }

        public abstract boolean add(LinkedEntry<E> var1);

        public abstract boolean contains(E var1);

        public abstract LinkedEntry<E> remove(E var1);

        public abstract LinkedEntry<E> first();

        public abstract LinkedEntry<E> last();

        public abstract boolean isEmpty();
    }

    private class LinkedIterator
    implements Iterator<T> {
        private LinkedEntry<T> entry;
        private int expectedModCount;

        private LinkedIterator(LinkedEntry<T> linkedEntry, int n) {
            this.entry = linkedEntry;
            this.expectedModCount = n;
        }

        @Override
        public boolean hasNext() {
            return this.entry != null;
        }

        @Override
        public T next() {
            if (MIRMultiObjectCollection.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            if (this.entry == null) {
                throw new NoSuchElementException();
            }
            MIRObject mIRObject = this.entry.val;
            this.entry = this.entry.next;
            return mIRObject;
        }
    }

    private static class LinkedEntry<E extends MIRObject> {
        private E val;
        private LinkedEntry<E> previous;
        private LinkedEntry<E> next;

        LinkedEntry(E e, LinkedEntry<E> linkedEntry, LinkedEntry<E> linkedEntry2) {
            this.val = e;
            this.previous = linkedEntry;
            this.next = linkedEntry2;
        }
    }
}

