/*
 * Decompiled with CFR 0.152.
 */
package MITI.sdk;

import MITI.messages.MIR.MIRSDK;
import MITI.sdk.MIRConfigurationContent;
import MITI.sdk.MIRMetaAttribute;
import MITI.sdk.MIRMetaClass;
import MITI.sdk.MIRMetaLink;
import MITI.sdk.MIRObject;
import MITI.sdk.MIRObjectCollections;
import MITI.sdk.MIRRepositoryObject;
import MITI.sdk.MIRUser;
import MITI.sdk.MIR_Object;
import MITI.sdk.collections.MIRObjectCollection;
import MITI.sdk.collections.MIRSdkCollection;
import java.util.Iterator;
import java.util.SortedSet;

public abstract class MIRUserObject
extends MIRRepositoryObject {
    protected transient String aBlob = "";
    protected transient String aScope = "";
    protected transient boolean aSystem = false;
    protected transient MIRObjectCollection<MIRConfigurationContent> configurationContents = null;
    protected transient MIRObjectCollection<MIRUser> favoriteOfUsers = null;
    protected transient MIRUser hasUser = null;
    private static MIRMetaClass metaClass = MIRUserObject.staticGetMetaClass();

    @Override
    public short getElementType() {
        return 369;
    }

    @Override
    public void setFrom(MIR_Object mIR_Object) {
        super.setFrom(mIR_Object);
        if (mIR_Object.isInstanceOf((short)369)) {
            this.setBlob(((MIRUserObject)mIR_Object).getBlob());
            this.setScope(((MIRUserObject)mIR_Object).getScope());
            this.setSystem(((MIRUserObject)mIR_Object).getSystem());
        }
    }

    @Override
    public MIRObject getParent() {
        if (this.hasUser != null) {
            return this.hasUser;
        }
        return super.getParent();
    }

    @Override
    public int getParentCount() {
        return (this.hasUser != null ? 1 : 0) + super.getParentCount();
    }

    public final void setBlob(String string) {
        this.aBlob = string == null ? "" : string;
    }

    public final String getBlob() {
        return this.aBlob;
    }

    public final void setScope(String string) {
        this.aScope = string == null ? "" : string;
    }

    public final String getScope() {
        return this.aScope;
    }

    public final void setSystem(boolean bl) {
        this.aSystem = bl;
    }

    public final boolean getSystem() {
        return this.aSystem;
    }

    protected MIRObjectCollection<MIRConfigurationContent> getConfigurationContentCollection() {
        this.configurationContents = MIRObjectCollections.get(this.configurationContents, MIRSdkCollection.Type.OBJECT);
        return this.configurationContents;
    }

    public SortedSet<MIRConfigurationContent> getConfigurationContents() {
        return MIRObjectCollections.sortedSet(this.configurationContents);
    }

    public final void addConfigurationContent(MIRConfigurationContent mIRConfigurationContent) {
        if (mIRConfigurationContent == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("UserObject", "ConfigurationContent"));
        }
        if (mIRConfigurationContent._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("UserObject", "ConfigurationContent"));
        }
        if (this.configurationContents != null && this.configurationContents.contains(mIRConfigurationContent)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("UserObject", "ConfigurationContent"));
        }
        this.getConfigurationContentCollection().add(mIRConfigurationContent);
        mIRConfigurationContent.getUserObjectCollection().add(this);
    }

    public final int getConfigurationContentCount() {
        if (this.configurationContents != null) {
            return this.configurationContents.size();
        }
        return 0;
    }

    public final boolean containsConfigurationContent(MIRConfigurationContent mIRConfigurationContent) {
        if (mIRConfigurationContent != null && this.configurationContents != null) {
            return this.configurationContents.contains(mIRConfigurationContent);
        }
        return false;
    }

    public final MIRConfigurationContent getConfigurationContent(String string) {
        if (this.configurationContents != null) {
            return this.configurationContents.get(string);
        }
        return null;
    }

    public final Iterator<MIRConfigurationContent> getConfigurationContentIterator() {
        if (this.configurationContents != null) {
            return this.configurationContents.iterator();
        }
        return MIRObjectCollections.emptySet().iterator();
    }

    public final boolean removeConfigurationContent(MIRConfigurationContent mIRConfigurationContent) {
        if (mIRConfigurationContent != null && this.configurationContents != null && this.configurationContents.remove(mIRConfigurationContent)) {
            mIRConfigurationContent.userObjects.remove(this);
            if (mIRConfigurationContent.userObjects.isEmpty()) {
                mIRConfigurationContent.userObjects = null;
            }
            if (this.configurationContents.isEmpty()) {
                this.configurationContents = null;
            }
            return true;
        }
        return false;
    }

    public final void removeConfigurationContents() {
        if (this.configurationContents != null) {
            for (MIRConfigurationContent mIRConfigurationContent : this.configurationContents) {
                mIRConfigurationContent.userObjects.remove(this);
                if (!mIRConfigurationContent.userObjects.isEmpty()) continue;
                mIRConfigurationContent.userObjects = null;
            }
            this.configurationContents = null;
        }
    }

    protected MIRObjectCollection<MIRUser> getFavoriteOfUserCollection() {
        this.favoriteOfUsers = MIRObjectCollections.get(this.favoriteOfUsers, MIRSdkCollection.Type.OBJECT);
        return this.favoriteOfUsers;
    }

    public SortedSet<MIRUser> getFavoriteOfUsers() {
        return MIRObjectCollections.sortedSet(this.favoriteOfUsers);
    }

    public final void addFavoriteOfUser(MIRUser mIRUser) {
        if (mIRUser == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("UserObject", "FavoriteOfUser"));
        }
        if (mIRUser._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("UserObject", "FavoriteOfUser"));
        }
        if (this.favoriteOfUsers != null && this.favoriteOfUsers.contains(mIRUser)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("UserObject", "FavoriteOfUser"));
        }
        this.getFavoriteOfUserCollection().add(mIRUser);
        mIRUser.getFavoriteUserObjectCollection().add(this);
    }

    public final int getFavoriteOfUserCount() {
        if (this.favoriteOfUsers != null) {
            return this.favoriteOfUsers.size();
        }
        return 0;
    }

    public final boolean containsFavoriteOfUser(MIRUser mIRUser) {
        if (mIRUser != null && this.favoriteOfUsers != null) {
            return this.favoriteOfUsers.contains(mIRUser);
        }
        return false;
    }

    public final MIRUser getFavoriteOfUser(String string) {
        if (this.favoriteOfUsers != null) {
            return this.favoriteOfUsers.get(string);
        }
        return null;
    }

    public final Iterator<MIRUser> getFavoriteOfUserIterator() {
        if (this.favoriteOfUsers != null) {
            return this.favoriteOfUsers.iterator();
        }
        return MIRObjectCollections.emptySet().iterator();
    }

    public final boolean removeFavoriteOfUser(MIRUser mIRUser) {
        if (mIRUser != null && this.favoriteOfUsers != null && this.favoriteOfUsers.remove(mIRUser)) {
            mIRUser.favoriteUserObjects.remove(this);
            if (mIRUser.favoriteUserObjects.isEmpty()) {
                mIRUser.favoriteUserObjects = null;
            }
            if (this.favoriteOfUsers.isEmpty()) {
                this.favoriteOfUsers = null;
            }
            return true;
        }
        return false;
    }

    public final void removeFavoriteOfUsers() {
        if (this.favoriteOfUsers != null) {
            for (MIRUser mIRUser : this.favoriteOfUsers) {
                mIRUser.favoriteUserObjects.remove(this);
                if (!mIRUser.favoriteUserObjects.isEmpty()) continue;
                mIRUser.favoriteUserObjects = null;
            }
            this.favoriteOfUsers = null;
        }
    }

    public final void addUser(MIRUser mIRUser) {
        if (mIRUser == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("UserObject", "User"));
        }
        if (mIRUser._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("UserObject", "User"));
        }
        if (this.hasUser != null) {
            if (this.hasUser._equals(mIRUser)) {
                throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("UserObject", "User"));
            }
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("UserObject", "User"));
        }
        this.hasUser = mIRUser;
        mIRUser.getUserObjectCollection().add(this);
    }

    public final MIRUser getUser() {
        return this.hasUser;
    }

    public final boolean removeUser() {
        if (this.hasUser != null) {
            this.hasUser.userObjects.remove(this);
            if (this.hasUser.userObjects.isEmpty()) {
                this.hasUser.userObjects = null;
            }
            this.hasUser = null;
            return true;
        }
        return false;
    }

    public static MIRMetaClass staticGetMetaClass() {
        if (metaClass == null) {
            metaClass = new MIRMetaClass(MIRRepositoryObject.staticGetMetaClass(), 369, "UserObject", true);
            new MIRMetaAttribute(metaClass, 536, "Scope", "java.lang.String", null, "");
            new MIRMetaAttribute(metaClass, 535, "Blob", "java.lang.String", null, "");
            new MIRMetaAttribute(metaClass, 537, "System", "java.lang.Boolean", null, false);
            new MIRMetaLink(metaClass, 1157, "ConfigurationContent", false, 0, 168, 1154);
            new MIRMetaLink(metaClass, 1158, "FavoriteOfUser", false, 1, 176, 1155);
            new MIRMetaLink(metaClass, 1159, "User", true, 2, 176, 1156);
        }
        return metaClass;
    }

    @Override
    public MIRMetaClass getMetaClass() {
        return MIRUserObject.staticGetMetaClass();
    }

    @Override
    protected void _rename(String string) {
        if (this.configurationContents != null) {
            for (MIRConfigurationContent mIRRepositoryObject : this.configurationContents) {
                mIRRepositoryObject.userObjects.rename(this, string);
            }
        }
        if (this.favoriteOfUsers != null) {
            for (MIRUser mIRUser : this.favoriteOfUsers) {
                mIRUser.favoriteUserObjects.rename(this, string);
            }
        }
        if (this.hasUser != null) {
            this.hasUser.userObjects.rename(this, string);
        }
        super._rename(string);
    }
}

