/*
 * Decompiled with CFR 0.152.
 */
package MITI.sdk;

import MITI.messages.MIR.MIRSDK;
import MITI.sdk.MIRBookmark;
import MITI.sdk.MIRMetaAttribute;
import MITI.sdk.MIRMetaClass;
import MITI.sdk.MIRMetaLink;
import MITI.sdk.MIRModelUser;
import MITI.sdk.MIRObject;
import MITI.sdk.MIRObjectCollections;
import MITI.sdk.MIRRepository;
import MITI.sdk.MIRSecurityObject;
import MITI.sdk.MIRUserGroup;
import MITI.sdk.MIRUserObject;
import MITI.sdk.MIR_Object;
import MITI.sdk.collections.MIRObjectCollection;
import MITI.sdk.collections.MIRSdkCollection;
import java.util.Iterator;
import java.util.SortedSet;

public class MIRUser
extends MIRSecurityObject {
    protected transient String aDistinguishedName = "";
    protected transient String aFullName = "";
    protected transient int aLocked = 0;
    protected transient int aNotification = 0;
    protected transient String aPassword = "";
    protected transient int aStatus = 0;
    protected transient MIRObjectCollection<MIRBookmark> bookmarks = null;
    protected transient MIRObjectCollection<MIRUserObject> favoriteUserObjects = null;
    protected transient MIRObjectCollection<MIRModelUser> modelUsers = null;
    protected transient MIRRepository hasRepository = null;
    protected transient MIRObjectCollection<MIRUserGroup> userGroups = null;
    protected transient MIRObjectCollection<MIRUserObject> userObjects = null;
    private static MIRMetaClass metaClass = MIRUser.staticGetMetaClass();

    public MIRUser() {
    }

    public MIRUser(MIRUser mIRUser) {
        this.setFrom(mIRUser);
    }

    @Override
    public Object clone() {
        return new MIRUser(this);
    }

    @Override
    public short getElementType() {
        return 176;
    }

    @Override
    public void setFrom(MIR_Object mIR_Object) {
        super.setFrom(mIR_Object);
        if (mIR_Object.isInstanceOf((short)176)) {
            this.setDistinguishedName(((MIRUser)mIR_Object).getDistinguishedName());
            this.setFullName(((MIRUser)mIR_Object).getFullName());
            this.setLocked(((MIRUser)mIR_Object).getLocked());
            this.setNotification(((MIRUser)mIR_Object).getNotification());
            this.setPassword(((MIRUser)mIR_Object).getPassword());
            this.setStatus(((MIRUser)mIR_Object).getStatus());
        }
    }

    @Override
    public MIRObject getParent() {
        if (this.hasRepository != null) {
            return this.hasRepository;
        }
        return super.getParent();
    }

    @Override
    public int getParentCount() {
        return (this.hasRepository != null ? 1 : 0) + super.getParentCount();
    }

    public final void setDistinguishedName(String string) {
        this.aDistinguishedName = string == null ? "" : string;
    }

    public final String getDistinguishedName() {
        return this.aDistinguishedName;
    }

    public final void setFullName(String string) {
        this.aFullName = string == null ? "" : string;
    }

    public final String getFullName() {
        return this.aFullName;
    }

    public final void setLocked(int n) {
        this.aLocked = n;
    }

    public final int getLocked() {
        return this.aLocked;
    }

    public final void setNotification(int n) {
        this.aNotification = n;
    }

    public final int getNotification() {
        return this.aNotification;
    }

    public final void setPassword(String string) {
        this.aPassword = string == null ? "" : string;
    }

    public final String getPassword() {
        return this.aPassword;
    }

    public final void setStatus(int n) {
        this.aStatus = n;
    }

    public final int getStatus() {
        return this.aStatus;
    }

    protected MIRObjectCollection<MIRBookmark> getBookmarkCollection() {
        this.bookmarks = MIRObjectCollections.get(this.bookmarks, MIRSdkCollection.Type.OBJECT);
        return this.bookmarks;
    }

    public SortedSet<MIRBookmark> getBookmarks() {
        return MIRObjectCollections.sortedSet(this.bookmarks);
    }

    public final void addBookmark(MIRBookmark mIRBookmark) {
        if (mIRBookmark == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("User", "Bookmark"));
        }
        if (mIRBookmark._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("User", "Bookmark"));
        }
        if (mIRBookmark.hasUser != null) {
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("Bookmark", "User"));
        }
        if (this.bookmarks != null && this.bookmarks.contains(mIRBookmark)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("User", "Bookmark"));
        }
        this.getBookmarkCollection().add(mIRBookmark);
        mIRBookmark.hasUser = this;
    }

    public final int getBookmarkCount() {
        if (this.bookmarks != null) {
            return this.bookmarks.size();
        }
        return 0;
    }

    public final boolean containsBookmark(MIRBookmark mIRBookmark) {
        if (mIRBookmark != null && this.bookmarks != null) {
            return this.bookmarks.contains(mIRBookmark);
        }
        return false;
    }

    public final MIRBookmark getBookmark(String string) {
        if (this.bookmarks != null) {
            return this.bookmarks.get(string);
        }
        return null;
    }

    public final Iterator<MIRBookmark> getBookmarkIterator() {
        if (this.bookmarks != null) {
            return this.bookmarks.iterator();
        }
        return MIRObjectCollections.emptySet().iterator();
    }

    public final boolean removeBookmark(MIRBookmark mIRBookmark) {
        if (mIRBookmark != null && this.bookmarks != null && this.bookmarks.remove(mIRBookmark)) {
            mIRBookmark.hasUser = null;
            if (this.bookmarks.isEmpty()) {
                this.bookmarks = null;
            }
            return true;
        }
        return false;
    }

    public final void removeBookmarks() {
        if (this.bookmarks != null) {
            for (MIRBookmark mIRBookmark : this.bookmarks) {
                mIRBookmark.hasUser = null;
            }
            this.bookmarks = null;
        }
    }

    protected MIRObjectCollection<MIRUserObject> getFavoriteUserObjectCollection() {
        this.favoriteUserObjects = MIRObjectCollections.get(this.favoriteUserObjects, MIRSdkCollection.Type.OBJECT);
        return this.favoriteUserObjects;
    }

    public SortedSet<MIRUserObject> getFavoriteUserObjects() {
        return MIRObjectCollections.sortedSet(this.favoriteUserObjects);
    }

    public final void addFavoriteUserObject(MIRUserObject mIRUserObject) {
        if (mIRUserObject == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("User", "FavoriteUserObject"));
        }
        if (mIRUserObject._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("User", "FavoriteUserObject"));
        }
        if (this.favoriteUserObjects != null && this.favoriteUserObjects.contains(mIRUserObject)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("User", "FavoriteUserObject"));
        }
        this.getFavoriteUserObjectCollection().add(mIRUserObject);
        mIRUserObject.getFavoriteOfUserCollection().add(this);
    }

    public final int getFavoriteUserObjectCount() {
        if (this.favoriteUserObjects != null) {
            return this.favoriteUserObjects.size();
        }
        return 0;
    }

    public final boolean containsFavoriteUserObject(MIRUserObject mIRUserObject) {
        if (mIRUserObject != null && this.favoriteUserObjects != null) {
            return this.favoriteUserObjects.contains(mIRUserObject);
        }
        return false;
    }

    public final MIRUserObject getFavoriteUserObject(String string) {
        if (this.favoriteUserObjects != null) {
            return this.favoriteUserObjects.get(string);
        }
        return null;
    }

    public final Iterator<MIRUserObject> getFavoriteUserObjectIterator() {
        if (this.favoriteUserObjects != null) {
            return this.favoriteUserObjects.iterator();
        }
        return MIRObjectCollections.emptySet().iterator();
    }

    public final boolean removeFavoriteUserObject(MIRUserObject mIRUserObject) {
        if (mIRUserObject != null && this.favoriteUserObjects != null && this.favoriteUserObjects.remove(mIRUserObject)) {
            mIRUserObject.favoriteOfUsers.remove(this);
            if (mIRUserObject.favoriteOfUsers.isEmpty()) {
                mIRUserObject.favoriteOfUsers = null;
            }
            if (this.favoriteUserObjects.isEmpty()) {
                this.favoriteUserObjects = null;
            }
            return true;
        }
        return false;
    }

    public final void removeFavoriteUserObjects() {
        if (this.favoriteUserObjects != null) {
            for (MIRUserObject mIRUserObject : this.favoriteUserObjects) {
                mIRUserObject.favoriteOfUsers.remove(this);
                if (!mIRUserObject.favoriteOfUsers.isEmpty()) continue;
                mIRUserObject.favoriteOfUsers = null;
            }
            this.favoriteUserObjects = null;
        }
    }

    protected MIRObjectCollection<MIRModelUser> getModelUserCollection() {
        this.modelUsers = MIRObjectCollections.get(this.modelUsers, MIRSdkCollection.Type.OBJECT);
        return this.modelUsers;
    }

    public SortedSet<MIRModelUser> getModelUsers() {
        return MIRObjectCollections.sortedSet(this.modelUsers);
    }

    public final void addModelUser(MIRModelUser mIRModelUser) {
        if (mIRModelUser == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("User", "ModelUser"));
        }
        if (mIRModelUser._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("User", "ModelUser"));
        }
        if (mIRModelUser.hasUser != null) {
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("ModelUser", "User"));
        }
        if (this.modelUsers != null && this.modelUsers.contains(mIRModelUser)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("User", "ModelUser"));
        }
        this.getModelUserCollection().add(mIRModelUser);
        mIRModelUser.hasUser = this;
    }

    public final int getModelUserCount() {
        if (this.modelUsers != null) {
            return this.modelUsers.size();
        }
        return 0;
    }

    public final boolean containsModelUser(MIRModelUser mIRModelUser) {
        if (mIRModelUser != null && this.modelUsers != null) {
            return this.modelUsers.contains(mIRModelUser);
        }
        return false;
    }

    public final MIRModelUser getModelUser(String string) {
        if (this.modelUsers != null) {
            return this.modelUsers.get(string);
        }
        return null;
    }

    public final Iterator<MIRModelUser> getModelUserIterator() {
        if (this.modelUsers != null) {
            return this.modelUsers.iterator();
        }
        return MIRObjectCollections.emptySet().iterator();
    }

    public final boolean removeModelUser(MIRModelUser mIRModelUser) {
        if (mIRModelUser != null && this.modelUsers != null && this.modelUsers.remove(mIRModelUser)) {
            mIRModelUser.hasUser = null;
            if (this.modelUsers.isEmpty()) {
                this.modelUsers = null;
            }
            return true;
        }
        return false;
    }

    public final void removeModelUsers() {
        if (this.modelUsers != null) {
            for (MIRModelUser mIRModelUser : this.modelUsers) {
                mIRModelUser.hasUser = null;
            }
            this.modelUsers = null;
        }
    }

    public final void addRepository(MIRRepository mIRRepository) {
        if (mIRRepository == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("User", "Repository"));
        }
        if (mIRRepository._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("User", "Repository"));
        }
        if (this.hasRepository != null) {
            if (this.hasRepository._equals(mIRRepository)) {
                throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("User", "Repository"));
            }
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("User", "Repository"));
        }
        if (mIRRepository.users != null && !mIRRepository._allowName(mIRRepository.users, this)) {
            throw new IllegalArgumentException(MIRSDK.NAME_COLLISION.getMessage("Repository", mIRRepository.getPath(), "User", "Object", this.getName()));
        }
        this.hasRepository = mIRRepository;
        mIRRepository.getUserCollection().add(this);
    }

    public final MIRRepository getRepository() {
        return this.hasRepository;
    }

    public final boolean removeRepository() {
        if (this.hasRepository != null) {
            this.hasRepository.users.remove(this);
            if (this.hasRepository.users.isEmpty()) {
                this.hasRepository.users = null;
            }
            this.hasRepository = null;
            return true;
        }
        return false;
    }

    protected MIRObjectCollection<MIRUserGroup> getUserGroupCollection() {
        this.userGroups = MIRObjectCollections.get(this.userGroups, MIRSdkCollection.Type.OBJECT);
        return this.userGroups;
    }

    public SortedSet<MIRUserGroup> getUserGroups() {
        return MIRObjectCollections.sortedSet(this.userGroups);
    }

    public final void addUserGroup(MIRUserGroup mIRUserGroup) {
        if (mIRUserGroup == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("User", "UserGroup"));
        }
        if (mIRUserGroup._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("User", "UserGroup"));
        }
        if (this.userGroups != null && this.userGroups.contains(mIRUserGroup)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("User", "UserGroup"));
        }
        this.getUserGroupCollection().add(mIRUserGroup);
        mIRUserGroup.getUserCollection().add(this);
    }

    public final int getUserGroupCount() {
        if (this.userGroups != null) {
            return this.userGroups.size();
        }
        return 0;
    }

    public final boolean containsUserGroup(MIRUserGroup mIRUserGroup) {
        if (mIRUserGroup != null && this.userGroups != null) {
            return this.userGroups.contains(mIRUserGroup);
        }
        return false;
    }

    public final MIRUserGroup getUserGroup(String string) {
        if (this.userGroups != null) {
            return this.userGroups.get(string);
        }
        return null;
    }

    public final Iterator<MIRUserGroup> getUserGroupIterator() {
        if (this.userGroups != null) {
            return this.userGroups.iterator();
        }
        return MIRObjectCollections.emptySet().iterator();
    }

    public final boolean removeUserGroup(MIRUserGroup mIRUserGroup) {
        if (mIRUserGroup != null && this.userGroups != null && this.userGroups.remove(mIRUserGroup)) {
            mIRUserGroup.users.remove(this);
            if (mIRUserGroup.users.isEmpty()) {
                mIRUserGroup.users = null;
            }
            if (this.userGroups.isEmpty()) {
                this.userGroups = null;
            }
            return true;
        }
        return false;
    }

    public final void removeUserGroups() {
        if (this.userGroups != null) {
            for (MIRUserGroup mIRUserGroup : this.userGroups) {
                mIRUserGroup.users.remove(this);
                if (!mIRUserGroup.users.isEmpty()) continue;
                mIRUserGroup.users = null;
            }
            this.userGroups = null;
        }
    }

    protected MIRObjectCollection<MIRUserObject> getUserObjectCollection() {
        this.userObjects = MIRObjectCollections.get(this.userObjects, MIRSdkCollection.Type.OBJECT);
        return this.userObjects;
    }

    public SortedSet<MIRUserObject> getUserObjects() {
        return MIRObjectCollections.sortedSet(this.userObjects);
    }

    public final void addUserObject(MIRUserObject mIRUserObject) {
        if (mIRUserObject == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("User", "UserObject"));
        }
        if (mIRUserObject._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("User", "UserObject"));
        }
        if (mIRUserObject.hasUser != null) {
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("UserObject", "User"));
        }
        if (this.userObjects != null && this.userObjects.contains(mIRUserObject)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("User", "UserObject"));
        }
        this.getUserObjectCollection().add(mIRUserObject);
        mIRUserObject.hasUser = this;
    }

    public final int getUserObjectCount() {
        if (this.userObjects != null) {
            return this.userObjects.size();
        }
        return 0;
    }

    public final boolean containsUserObject(MIRUserObject mIRUserObject) {
        if (mIRUserObject != null && this.userObjects != null) {
            return this.userObjects.contains(mIRUserObject);
        }
        return false;
    }

    public final MIRUserObject getUserObject(String string) {
        if (this.userObjects != null) {
            return this.userObjects.get(string);
        }
        return null;
    }

    public final Iterator<MIRUserObject> getUserObjectIterator() {
        if (this.userObjects != null) {
            return this.userObjects.iterator();
        }
        return MIRObjectCollections.emptySet().iterator();
    }

    public final boolean removeUserObject(MIRUserObject mIRUserObject) {
        if (mIRUserObject != null && this.userObjects != null && this.userObjects.remove(mIRUserObject)) {
            mIRUserObject.hasUser = null;
            if (this.userObjects.isEmpty()) {
                this.userObjects = null;
            }
            return true;
        }
        return false;
    }

    public final void removeUserObjects() {
        if (this.userObjects != null) {
            for (MIRUserObject mIRUserObject : this.userObjects) {
                mIRUserObject.hasUser = null;
            }
            this.userObjects = null;
        }
    }

    public static MIRMetaClass staticGetMetaClass() {
        if (metaClass == null) {
            metaClass = new MIRMetaClass(MIRSecurityObject.staticGetMetaClass(), 176, "User", false);
            new MIRMetaAttribute(metaClass, 295, "FullName", "java.lang.String", null, "");
            new MIRMetaAttribute(metaClass, 265, "Password", "java.lang.String", null, "");
            new MIRMetaAttribute(metaClass, 420, "DistinguishedName", "java.lang.String", null, "");
            new MIRMetaAttribute(metaClass, 445, "Status", "java.lang.Integer", null, 0);
            new MIRMetaAttribute(metaClass, 523, "Locked", "java.lang.Integer", null, 0);
            new MIRMetaAttribute(metaClass, 531, "Notification", "java.lang.Integer", null, 0);
            new MIRMetaLink(metaClass, 1013, "Bookmark", false, 3, 330, 1012);
            new MIRMetaLink(metaClass, 1155, "FavoriteUserObject", false, 0, 369, 1158);
            new MIRMetaLink(metaClass, 591, "ModelUser", false, 0, 201, 592);
            new MIRMetaLink(metaClass, 452, "Repository", true, 2, 156, 451);
            new MIRMetaLink(metaClass, 454, "UserGroup", false, 1, 170, 453);
            new MIRMetaLink(metaClass, 1156, "UserObject", false, 3, 369, 1159);
        }
        return metaClass;
    }

    @Override
    public MIRMetaClass getMetaClass() {
        return MIRUser.staticGetMetaClass();
    }

    @Override
    protected boolean _isValidName() {
        if (this.hasRepository != null && !this.hasRepository._allowName(this.hasRepository.users, this)) {
            return false;
        }
        return super._isValidName();
    }

    @Override
    protected void _rename(String string) {
        if (this.favoriteUserObjects != null) {
            for (MIRUserObject mIRRepositoryObject : this.favoriteUserObjects) {
                mIRRepositoryObject.favoriteOfUsers.rename(this, string);
            }
        }
        if (this.hasRepository != null) {
            this.hasRepository.users.rename(this, string);
        }
        if (this.userGroups != null) {
            for (MIRUserGroup mIRUserGroup : this.userGroups) {
                mIRUserGroup.users.rename(this, string);
            }
        }
        super._rename(string);
    }
}

