/*
 * Decompiled with CFR 0.152.
 */
package MITI.sdk;

import MITI.messages.MIR.MIRSDK;
import MITI.sdk.MIRMetaAttribute;
import MITI.sdk.MIRMetaClass;
import MITI.sdk.MIRMetaLink;
import MITI.sdk.MIRObjectCollections;
import MITI.sdk.MIRRepositoryObject;
import MITI.sdk.MIRSecurityObject;
import MITI.sdk.MIR_Object;
import MITI.sdk.collections.MIRObjectCollection;
import MITI.sdk.collections.MIRSdkCollection;
import java.util.Iterator;
import java.util.SortedSet;

public abstract class MIRSecurityRole
extends MIRRepositoryObject {
    protected transient String aCapabilities = "";
    protected transient MIRObjectCollection<MIRSecurityObject> securityObjects = null;
    private static MIRMetaClass metaClass = MIRSecurityRole.staticGetMetaClass();

    @Override
    public short getElementType() {
        return 359;
    }

    @Override
    public void setFrom(MIR_Object mIR_Object) {
        super.setFrom(mIR_Object);
        if (mIR_Object.isInstanceOf((short)359)) {
            this.setCapabilities(((MIRSecurityRole)mIR_Object).getCapabilities());
        }
    }

    public final void setCapabilities(String string) {
        this.aCapabilities = string == null ? "" : string;
    }

    public final String getCapabilities() {
        return this.aCapabilities;
    }

    protected MIRObjectCollection<MIRSecurityObject> getSecurityObjectCollection() {
        this.securityObjects = MIRObjectCollections.get(this.securityObjects, MIRSdkCollection.Type.OBJECT);
        return this.securityObjects;
    }

    public SortedSet<MIRSecurityObject> getSecurityObjects() {
        return MIRObjectCollections.sortedSet(this.securityObjects);
    }

    public final void addSecurityObject(MIRSecurityObject mIRSecurityObject) {
        if (mIRSecurityObject == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("SecurityRole", "SecurityObject"));
        }
        if (mIRSecurityObject._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("SecurityRole", "SecurityObject"));
        }
        if (this.securityObjects != null && this.securityObjects.contains(mIRSecurityObject)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("SecurityRole", "SecurityObject"));
        }
        this.getSecurityObjectCollection().add(mIRSecurityObject);
        mIRSecurityObject.getSecurityRoleCollection().add(this);
    }

    public final int getSecurityObjectCount() {
        if (this.securityObjects != null) {
            return this.securityObjects.size();
        }
        return 0;
    }

    public final boolean containsSecurityObject(MIRSecurityObject mIRSecurityObject) {
        if (mIRSecurityObject != null && this.securityObjects != null) {
            return this.securityObjects.contains(mIRSecurityObject);
        }
        return false;
    }

    public final MIRSecurityObject getSecurityObject(String string) {
        if (this.securityObjects != null) {
            return this.securityObjects.get(string);
        }
        return null;
    }

    public final Iterator<MIRSecurityObject> getSecurityObjectIterator() {
        if (this.securityObjects != null) {
            return this.securityObjects.iterator();
        }
        return MIRObjectCollections.emptySet().iterator();
    }

    public final boolean removeSecurityObject(MIRSecurityObject mIRSecurityObject) {
        if (mIRSecurityObject != null && this.securityObjects != null && this.securityObjects.remove(mIRSecurityObject)) {
            mIRSecurityObject.securityRoles.remove(this);
            if (mIRSecurityObject.securityRoles.isEmpty()) {
                mIRSecurityObject.securityRoles = null;
            }
            if (this.securityObjects.isEmpty()) {
                this.securityObjects = null;
            }
            return true;
        }
        return false;
    }

    public final void removeSecurityObjects() {
        if (this.securityObjects != null) {
            for (MIRSecurityObject mIRSecurityObject : this.securityObjects) {
                mIRSecurityObject.securityRoles.remove(this);
                if (!mIRSecurityObject.securityRoles.isEmpty()) continue;
                mIRSecurityObject.securityRoles = null;
            }
            this.securityObjects = null;
        }
    }

    public static MIRMetaClass staticGetMetaClass() {
        if (metaClass == null) {
            metaClass = new MIRMetaClass(MIRRepositoryObject.staticGetMetaClass(), 359, "SecurityRole", true);
            new MIRMetaAttribute(metaClass, 528, "Capabilities", "java.lang.String", null, "");
            new MIRMetaLink(metaClass, 1141, "SecurityObject", false, 0, 345, 1140);
        }
        return metaClass;
    }

    @Override
    public MIRMetaClass getMetaClass() {
        return MIRSecurityRole.staticGetMetaClass();
    }

    @Override
    protected void _rename(String string) {
        if (this.securityObjects != null) {
            for (MIRSecurityObject mIRSecurityObject : this.securityObjects) {
                mIRSecurityObject.securityRoles.rename(this, string);
            }
        }
        super._rename(string);
    }
}

