/*
 * Decompiled with CFR 0.152.
 */
package MITI.sdk;

import MITI.messages.MIR.MIRSDK;
import MITI.sdk.MIRClassifier;
import MITI.sdk.MIRMetaClass;
import MITI.sdk.MIRMetaLink;
import MITI.sdk.MIRModelElement;
import MITI.sdk.MIRObjectCollections;
import MITI.sdk.MIRReportItem;
import MITI.sdk.collections.MIRObjectCollection;
import MITI.sdk.collections.MIRSdkCollection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;

public class MIRReport
extends MIRModelElement {
    protected transient MIRObjectCollection<MIRClassifier> classifiers = null;
    protected transient MIRObjectCollection<MIRReportItem> reportItems = null;
    private static MIRMetaClass metaClass = MIRReport.staticGetMetaClass();

    public MIRReport() {
    }

    public MIRReport(MIRReport mIRReport) {
        this.setFrom(mIRReport);
    }

    @Override
    public Object clone() {
        return new MIRReport(this);
    }

    @Override
    public short getElementType() {
        return 119;
    }

    protected MIRObjectCollection<MIRClassifier> getClassifierCollection() {
        this.classifiers = MIRObjectCollections.get(this.classifiers, MIRSdkCollection.Type.OBJECT);
        return this.classifiers;
    }

    public SortedSet<MIRClassifier> getClassifiers() {
        return MIRObjectCollections.sortedSet(this.classifiers);
    }

    public final void addClassifier(MIRClassifier mIRClassifier) {
        if (mIRClassifier == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("Report", "Classifier"));
        }
        if (mIRClassifier._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("Report", "Classifier"));
        }
        if (mIRClassifier.hasReport != null) {
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("Classifier", "Report"));
        }
        if (this.classifiers != null && this.classifiers.contains(mIRClassifier)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("Report", "Classifier"));
        }
        this.getClassifierCollection().add(mIRClassifier);
        mIRClassifier.hasReport = this;
    }

    public final int getClassifierCount() {
        if (this.classifiers != null) {
            return this.classifiers.size();
        }
        return 0;
    }

    public final boolean containsClassifier(MIRClassifier mIRClassifier) {
        if (mIRClassifier != null && this.classifiers != null) {
            return this.classifiers.contains(mIRClassifier);
        }
        return false;
    }

    public final MIRClassifier getClassifier(String string) {
        if (this.classifiers != null) {
            return this.classifiers.get(string);
        }
        return null;
    }

    public final Iterator<MIRClassifier> getClassifierIterator() {
        if (this.classifiers != null) {
            return this.classifiers.iterator();
        }
        return MIRObjectCollections.emptySet().iterator();
    }

    public final boolean removeClassifier(MIRClassifier mIRClassifier) {
        if (mIRClassifier != null && this.classifiers != null && this.classifiers.remove(mIRClassifier)) {
            mIRClassifier.hasReport = null;
            if (this.classifiers.isEmpty()) {
                this.classifiers = null;
            }
            return true;
        }
        return false;
    }

    public final void removeClassifiers() {
        if (this.classifiers != null) {
            for (MIRClassifier mIRClassifier : this.classifiers) {
                mIRClassifier.hasReport = null;
            }
            this.classifiers = null;
        }
    }

    protected MIRObjectCollection<MIRReportItem> getReportItemCollection() {
        this.reportItems = MIRObjectCollections.get(this.reportItems, MIRSdkCollection.Type.OBJECT);
        return this.reportItems;
    }

    public SortedSet<MIRReportItem> getReportItems() {
        return MIRObjectCollections.sortedSet(this.reportItems);
    }

    public final void addReportItem(MIRReportItem mIRReportItem) {
        if (mIRReportItem == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("Report", "ReportItem"));
        }
        if (mIRReportItem._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("Report", "ReportItem"));
        }
        if (mIRReportItem.hasReport != null) {
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("ReportItem", "Report"));
        }
        if (this.reportItems != null && this.reportItems.contains(mIRReportItem)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("Report", "ReportItem"));
        }
        this.getReportItemCollection().add(mIRReportItem);
        mIRReportItem.hasReport = this;
    }

    public final int getReportItemCount() {
        if (this.reportItems != null) {
            return this.reportItems.size();
        }
        return 0;
    }

    public final boolean containsReportItem(MIRReportItem mIRReportItem) {
        if (mIRReportItem != null && this.reportItems != null) {
            return this.reportItems.contains(mIRReportItem);
        }
        return false;
    }

    public final MIRReportItem getReportItem(String string) {
        if (this.reportItems != null) {
            return this.reportItems.get(string);
        }
        return null;
    }

    public final Iterator<MIRReportItem> getReportItemIterator() {
        if (this.reportItems != null) {
            return this.reportItems.iterator();
        }
        return MIRObjectCollections.emptySet().iterator();
    }

    public final List<MIRReportItem> getReportItemByPosition() {
        if (this.reportItems != null) {
            ArrayList<MIRReportItem> arrayList = new ArrayList<MIRReportItem>();
            arrayList.addAll(this.reportItems.values());
            MIRObjectCollections.sort(arrayList, MIRReportItem.ByPosition);
            return arrayList;
        }
        return MIRObjectCollections.emptyList();
    }

    public final boolean removeReportItem(MIRReportItem mIRReportItem) {
        if (mIRReportItem != null && this.reportItems != null && this.reportItems.remove(mIRReportItem)) {
            mIRReportItem.hasReport = null;
            if (this.reportItems.isEmpty()) {
                this.reportItems = null;
            }
            return true;
        }
        return false;
    }

    public final void removeReportItems() {
        if (this.reportItems != null) {
            for (MIRReportItem mIRReportItem : this.reportItems) {
                mIRReportItem.hasReport = null;
            }
            this.reportItems = null;
        }
    }

    public static MIRMetaClass staticGetMetaClass() {
        if (metaClass == null) {
            metaClass = new MIRMetaClass(MIRModelElement.staticGetMetaClass(), 119, "Report", false);
            new MIRMetaLink(metaClass, 371, "Classifier", false, 3, 75, 372);
            new MIRMetaLink(metaClass, 315, "ReportItem", false, 3, 124, 320);
        }
        return metaClass;
    }

    @Override
    public MIRMetaClass getMetaClass() {
        return MIRReport.staticGetMetaClass();
    }
}

