/*
 * Decompiled with CFR 0.152.
 */
package MITI.sdk;

import MITI.messages.MIR.MIRSDK;
import MITI.sdk.MIRMetaClass;
import MITI.sdk.MIRMetaLink;
import MITI.sdk.MIRObject;
import MITI.sdk.MIRObjectCollections;
import MITI.sdk.MIRQueryColumn;
import MITI.sdk.MIRQueryTable;
import MITI.sdk.collections.MIRObjectCollection;
import MITI.sdk.collections.MIRSdkCollection;
import java.util.Iterator;
import java.util.SortedSet;

public class MIRQueryGroupBy
extends MIRObject {
    protected transient MIRObjectCollection<MIRQueryColumn> queryColumns = null;
    protected transient MIRQueryTable hasQueryTable = null;
    private static MIRMetaClass metaClass = MIRQueryGroupBy.staticGetMetaClass();

    public MIRQueryGroupBy() {
    }

    public MIRQueryGroupBy(MIRQueryGroupBy mIRQueryGroupBy) {
        this.setFrom(mIRQueryGroupBy);
    }

    @Override
    public Object clone() {
        return new MIRQueryGroupBy(this);
    }

    @Override
    public short getElementType() {
        return 340;
    }

    @Override
    public MIRObject getParent() {
        if (this.hasQueryTable != null) {
            return this.hasQueryTable;
        }
        return super.getParent();
    }

    @Override
    public int getParentCount() {
        return (this.hasQueryTable != null ? 1 : 0) + super.getParentCount();
    }

    protected MIRObjectCollection<MIRQueryColumn> getQueryColumnCollection() {
        this.queryColumns = MIRObjectCollections.get(this.queryColumns, MIRSdkCollection.Type.OBJECT);
        return this.queryColumns;
    }

    public SortedSet<MIRQueryColumn> getQueryColumns() {
        return MIRObjectCollections.sortedSet(this.queryColumns);
    }

    public final void addQueryColumn(MIRQueryColumn mIRQueryColumn) {
        if (mIRQueryColumn == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("QueryGroupBy", "QueryColumn"));
        }
        if (mIRQueryColumn._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("QueryGroupBy", "QueryColumn"));
        }
        if (mIRQueryColumn.hasQueryGroupBy != null) {
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("QueryColumn", "QueryGroupBy"));
        }
        if (this.queryColumns != null && this.queryColumns.contains(mIRQueryColumn)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("QueryGroupBy", "QueryColumn"));
        }
        this.getQueryColumnCollection().add(mIRQueryColumn);
        mIRQueryColumn.hasQueryGroupBy = this;
    }

    public final int getQueryColumnCount() {
        if (this.queryColumns != null) {
            return this.queryColumns.size();
        }
        return 0;
    }

    public final boolean containsQueryColumn(MIRQueryColumn mIRQueryColumn) {
        if (mIRQueryColumn != null && this.queryColumns != null) {
            return this.queryColumns.contains(mIRQueryColumn);
        }
        return false;
    }

    public final MIRQueryColumn getQueryColumn(String string) {
        if (this.queryColumns != null) {
            return this.queryColumns.get(string);
        }
        return null;
    }

    public final Iterator<MIRQueryColumn> getQueryColumnIterator() {
        if (this.queryColumns != null) {
            return this.queryColumns.iterator();
        }
        return MIRObjectCollections.emptySet().iterator();
    }

    public final boolean removeQueryColumn(MIRQueryColumn mIRQueryColumn) {
        if (mIRQueryColumn != null && this.queryColumns != null && this.queryColumns.remove(mIRQueryColumn)) {
            mIRQueryColumn.hasQueryGroupBy = null;
            if (this.queryColumns.isEmpty()) {
                this.queryColumns = null;
            }
            return true;
        }
        return false;
    }

    public final void removeQueryColumns() {
        if (this.queryColumns != null) {
            for (MIRQueryColumn mIRQueryColumn : this.queryColumns) {
                mIRQueryColumn.hasQueryGroupBy = null;
            }
            this.queryColumns = null;
        }
    }

    public final void addQueryTable(MIRQueryTable mIRQueryTable) {
        if (mIRQueryTable == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("QueryGroupBy", "QueryTable"));
        }
        if (mIRQueryTable._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("QueryGroupBy", "QueryTable"));
        }
        if (this.hasQueryTable != null) {
            if (this.hasQueryTable._equals(mIRQueryTable)) {
                throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("QueryGroupBy", "QueryTable"));
            }
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("QueryGroupBy", "QueryTable"));
        }
        if (mIRQueryTable.hasQueryGroupBy != null) {
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("QueryTable", "QueryGroupBy"));
        }
        this.hasQueryTable = mIRQueryTable;
        mIRQueryTable.hasQueryGroupBy = this;
    }

    public final MIRQueryTable getQueryTable() {
        return this.hasQueryTable;
    }

    public final boolean removeQueryTable() {
        if (this.hasQueryTable != null) {
            this.hasQueryTable.hasQueryGroupBy = null;
            this.hasQueryTable = null;
            return true;
        }
        return false;
    }

    public static MIRMetaClass staticGetMetaClass() {
        if (metaClass == null) {
            metaClass = new MIRMetaClass(MIRObject.staticGetMetaClass(), 340, "QueryGroupBy", false);
            new MIRMetaLink(metaClass, 1092, "QueryColumn", false, 0, 242, 1091);
            new MIRMetaLink(metaClass, 1093, "QueryTable", true, 2, 243, 1097);
        }
        return metaClass;
    }

    @Override
    public MIRMetaClass getMetaClass() {
        return MIRQueryGroupBy.staticGetMetaClass();
    }
}

