/*
 * Decompiled with CFR 0.152.
 */
package MITI.sdk;

import MITI.messages.MIR.MIRSDK;
import MITI.sdk.MIRExpressionNode;
import MITI.sdk.MIRMetaClass;
import MITI.sdk.MIRMetaLink;
import MITI.sdk.MIRObjectCollections;
import MITI.sdk.MIRPredicate;
import MITI.sdk.collections.MIRObjectCollection;
import MITI.sdk.collections.MIRSdkCollection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;

public class MIRPredicateNode
extends MIRExpressionNode {
    protected transient MIRExpressionNode hasExpressionNode = null;
    protected transient MIRObjectCollection<MIRPredicate> predicates = null;
    private static MIRMetaClass metaClass = MIRPredicateNode.staticGetMetaClass();

    public MIRPredicateNode() {
    }

    public MIRPredicateNode(MIRPredicateNode mIRPredicateNode) {
        this.setFrom(mIRPredicateNode);
    }

    @Override
    public Object clone() {
        return new MIRPredicateNode(this);
    }

    @Override
    public short getElementType() {
        return 118;
    }

    public final void addExpressionNode(MIRExpressionNode mIRExpressionNode) {
        if (mIRExpressionNode == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("PredicateNode", "ExpressionNode"));
        }
        if (mIRExpressionNode._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("PredicateNode", "ExpressionNode"));
        }
        if (this.hasExpressionNode != null) {
            if (this.hasExpressionNode._equals(mIRExpressionNode)) {
                throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("PredicateNode", "ExpressionNode"));
            }
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("PredicateNode", "ExpressionNode"));
        }
        if (mIRExpressionNode.hasPredicateNode != null) {
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("ExpressionNode", "PredicateNode"));
        }
        this.hasExpressionNode = mIRExpressionNode;
        mIRExpressionNode.hasPredicateNode = this;
    }

    public final MIRExpressionNode getExpressionNode() {
        return this.hasExpressionNode;
    }

    public final boolean removeExpressionNode() {
        if (this.hasExpressionNode != null) {
            this.hasExpressionNode.hasPredicateNode = null;
            this.hasExpressionNode = null;
            return true;
        }
        return false;
    }

    protected MIRObjectCollection<MIRPredicate> getPredicateCollection() {
        this.predicates = MIRObjectCollections.get(this.predicates, MIRSdkCollection.Type.OBJECT);
        return this.predicates;
    }

    public SortedSet<MIRPredicate> getPredicates() {
        return MIRObjectCollections.sortedSet(this.predicates);
    }

    public final void addPredicate(MIRPredicate mIRPredicate) {
        if (mIRPredicate == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("PredicateNode", "Predicate"));
        }
        if (mIRPredicate._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("PredicateNode", "Predicate"));
        }
        if (mIRPredicate.hasPredicateNode != null) {
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("Predicate", "PredicateNode"));
        }
        if (this.predicates != null && this.predicates.contains(mIRPredicate)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("PredicateNode", "Predicate"));
        }
        this.getPredicateCollection().add(mIRPredicate);
        mIRPredicate.hasPredicateNode = this;
    }

    public final int getPredicateCount() {
        if (this.predicates != null) {
            return this.predicates.size();
        }
        return 0;
    }

    public final boolean containsPredicate(MIRPredicate mIRPredicate) {
        if (mIRPredicate != null && this.predicates != null) {
            return this.predicates.contains(mIRPredicate);
        }
        return false;
    }

    public final MIRPredicate getPredicate(String string) {
        if (this.predicates != null) {
            return this.predicates.get(string);
        }
        return null;
    }

    public final Iterator<MIRPredicate> getPredicateIterator() {
        if (this.predicates != null) {
            return this.predicates.iterator();
        }
        return MIRObjectCollections.emptySet().iterator();
    }

    public final List<MIRPredicate> getPredicateByPosition() {
        if (this.predicates != null) {
            ArrayList<MIRPredicate> arrayList = new ArrayList<MIRPredicate>();
            arrayList.addAll(this.predicates.values());
            MIRObjectCollections.sort(arrayList, MIRPredicate.ByPosition);
            return arrayList;
        }
        return MIRObjectCollections.emptyList();
    }

    public final boolean removePredicate(MIRPredicate mIRPredicate) {
        if (mIRPredicate != null && this.predicates != null && this.predicates.remove(mIRPredicate)) {
            mIRPredicate.hasPredicateNode = null;
            if (this.predicates.isEmpty()) {
                this.predicates = null;
            }
            return true;
        }
        return false;
    }

    public final void removePredicates() {
        if (this.predicates != null) {
            for (MIRPredicate mIRPredicate : this.predicates) {
                mIRPredicate.hasPredicateNode = null;
            }
            this.predicates = null;
        }
    }

    public static MIRMetaClass staticGetMetaClass() {
        if (metaClass == null) {
            metaClass = new MIRMetaClass(MIRExpressionNode.staticGetMetaClass(), 118, "PredicateNode", false);
            new MIRMetaLink(metaClass, 313, "ExpressionNode", true, 3, 113, 291);
            new MIRMetaLink(metaClass, 314, "Predicate", false, 3, 117, 312);
        }
        return metaClass;
    }

    @Override
    public MIRMetaClass getMetaClass() {
        return MIRPredicateNode.staticGetMetaClass();
    }
}

