/*
 * Decompiled with CFR 0.152.
 */
package MITI.sdk;

import MITI.messages.MIR.MIRSDK;
import MITI.sdk.MIRMetaAttribute;
import MITI.sdk.MIRMetaClass;
import MITI.sdk.MIRMetaLink;
import MITI.sdk.MIRModelObject;
import MITI.sdk.MIRObject;
import MITI.sdk.MIRObjectCollections;
import MITI.sdk.MIRPhysicalObjectType;
import MITI.sdk.MIRPhysicalRelationship;
import MITI.sdk.MIRPhysicalTarget;
import MITI.sdk.MIR_Object;
import MITI.sdk.collections.MIRObjectCollection;
import MITI.sdk.collections.MIRSdkCollection;
import java.util.Iterator;
import java.util.SortedSet;

public class MIRPhysicalObject
extends MIRModelObject {
    protected transient byte aObjectType = 0;
    protected transient MIRObjectCollection<MIRPhysicalRelationship> destinationOfPhysicalRelationships = null;
    protected transient MIRObjectCollection<MIRModelObject> modelObjects = null;
    protected transient MIRPhysicalTarget hasPhysicalTarget = null;
    protected transient MIRObjectCollection<MIRPhysicalRelationship> sourceOfPhysicalRelationships = null;
    private static MIRMetaClass metaClass = MIRPhysicalObject.staticGetMetaClass();

    public MIRPhysicalObject() {
    }

    public MIRPhysicalObject(MIRPhysicalObject mIRPhysicalObject) {
        this.setFrom(mIRPhysicalObject);
    }

    @Override
    public Object clone() {
        return new MIRPhysicalObject(this);
    }

    @Override
    public short getElementType() {
        return 54;
    }

    @Override
    public void setFrom(MIR_Object mIR_Object) {
        super.setFrom(mIR_Object);
        if (mIR_Object.isInstanceOf((short)54)) {
            this.setObjectType(((MIRPhysicalObject)mIR_Object).getObjectType());
        }
    }

    @Override
    public MIRObject getParent() {
        if (this.hasPhysicalTarget != null) {
            return this.hasPhysicalTarget;
        }
        return super.getParent();
    }

    @Override
    public int getParentCount() {
        return (this.hasPhysicalTarget != null ? 1 : 0) + super.getParentCount();
    }

    public final void setObjectType(byte by) {
        this.aObjectType = by;
    }

    public final byte getObjectType() {
        return this.aObjectType;
    }

    protected MIRObjectCollection<MIRPhysicalRelationship> getDestinationOfPhysicalRelationshipCollection() {
        this.destinationOfPhysicalRelationships = MIRObjectCollections.get(this.destinationOfPhysicalRelationships, MIRSdkCollection.Type.OBJECT);
        return this.destinationOfPhysicalRelationships;
    }

    public SortedSet<MIRPhysicalRelationship> getDestinationOfPhysicalRelationships() {
        return MIRObjectCollections.sortedSet(this.destinationOfPhysicalRelationships);
    }

    public final void addDestinationOfPhysicalRelationship(MIRPhysicalRelationship mIRPhysicalRelationship) {
        if (mIRPhysicalRelationship == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("PhysicalObject", "DestinationOfPhysicalRelationship"));
        }
        if (mIRPhysicalRelationship._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("PhysicalObject", "DestinationOfPhysicalRelationship"));
        }
        if (mIRPhysicalRelationship.hasDestinationPhysicalObject != null) {
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("PhysicalRelationship", "DestinationPhysicalObject"));
        }
        if (this.destinationOfPhysicalRelationships != null && this.destinationOfPhysicalRelationships.contains(mIRPhysicalRelationship)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("PhysicalObject", "DestinationOfPhysicalRelationship"));
        }
        this.getDestinationOfPhysicalRelationshipCollection().add(mIRPhysicalRelationship);
        mIRPhysicalRelationship.hasDestinationPhysicalObject = this;
    }

    public final int getDestinationOfPhysicalRelationshipCount() {
        if (this.destinationOfPhysicalRelationships != null) {
            return this.destinationOfPhysicalRelationships.size();
        }
        return 0;
    }

    public final boolean containsDestinationOfPhysicalRelationship(MIRPhysicalRelationship mIRPhysicalRelationship) {
        if (mIRPhysicalRelationship != null && this.destinationOfPhysicalRelationships != null) {
            return this.destinationOfPhysicalRelationships.contains(mIRPhysicalRelationship);
        }
        return false;
    }

    public final MIRPhysicalRelationship getDestinationOfPhysicalRelationship(String string) {
        if (this.destinationOfPhysicalRelationships != null) {
            return this.destinationOfPhysicalRelationships.get(string);
        }
        return null;
    }

    public final Iterator<MIRPhysicalRelationship> getDestinationOfPhysicalRelationshipIterator() {
        if (this.destinationOfPhysicalRelationships != null) {
            return this.destinationOfPhysicalRelationships.iterator();
        }
        return MIRObjectCollections.emptySet().iterator();
    }

    public final boolean removeDestinationOfPhysicalRelationship(MIRPhysicalRelationship mIRPhysicalRelationship) {
        if (mIRPhysicalRelationship != null && this.destinationOfPhysicalRelationships != null && this.destinationOfPhysicalRelationships.remove(mIRPhysicalRelationship)) {
            mIRPhysicalRelationship.hasDestinationPhysicalObject = null;
            if (this.destinationOfPhysicalRelationships.isEmpty()) {
                this.destinationOfPhysicalRelationships = null;
            }
            return true;
        }
        return false;
    }

    public final void removeDestinationOfPhysicalRelationships() {
        if (this.destinationOfPhysicalRelationships != null) {
            for (MIRPhysicalRelationship mIRPhysicalRelationship : this.destinationOfPhysicalRelationships) {
                mIRPhysicalRelationship.hasDestinationPhysicalObject = null;
            }
            this.destinationOfPhysicalRelationships = null;
        }
    }

    protected MIRObjectCollection<MIRModelObject> getModelObjectCollection() {
        this.modelObjects = MIRObjectCollections.get(this.modelObjects, MIRSdkCollection.Type.OBJECT);
        return this.modelObjects;
    }

    public SortedSet<MIRModelObject> getModelObjects() {
        return MIRObjectCollections.sortedSet(this.modelObjects);
    }

    public final void addModelObject(MIRModelObject mIRModelObject) {
        if (mIRModelObject == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("PhysicalObject", "ModelObject"));
        }
        if (mIRModelObject._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("PhysicalObject", "ModelObject"));
        }
        if (this.modelObjects != null && this.modelObjects.contains(mIRModelObject)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("PhysicalObject", "ModelObject"));
        }
        this.getModelObjectCollection().add(mIRModelObject);
        mIRModelObject.getAssociatedPhysicalObjectCollection().add(this);
    }

    public final int getModelObjectCount() {
        if (this.modelObjects != null) {
            return this.modelObjects.size();
        }
        return 0;
    }

    public final boolean containsModelObject(MIRModelObject mIRModelObject) {
        if (mIRModelObject != null && this.modelObjects != null) {
            return this.modelObjects.contains(mIRModelObject);
        }
        return false;
    }

    public final MIRModelObject getModelObject(String string) {
        if (this.modelObjects != null) {
            return this.modelObjects.get(string);
        }
        return null;
    }

    public final Iterator<MIRModelObject> getModelObjectIterator() {
        if (this.modelObjects != null) {
            return this.modelObjects.iterator();
        }
        return MIRObjectCollections.emptySet().iterator();
    }

    public final boolean removeModelObject(MIRModelObject mIRModelObject) {
        if (mIRModelObject != null && this.modelObjects != null && this.modelObjects.remove(mIRModelObject)) {
            mIRModelObject.associatedPhysicalObjects.remove(this);
            if (mIRModelObject.associatedPhysicalObjects.isEmpty()) {
                mIRModelObject.associatedPhysicalObjects = null;
            }
            if (this.modelObjects.isEmpty()) {
                this.modelObjects = null;
            }
            return true;
        }
        return false;
    }

    public final void removeModelObjects() {
        if (this.modelObjects != null) {
            for (MIRModelObject mIRModelObject : this.modelObjects) {
                mIRModelObject.associatedPhysicalObjects.remove(this);
                if (!mIRModelObject.associatedPhysicalObjects.isEmpty()) continue;
                mIRModelObject.associatedPhysicalObjects = null;
            }
            this.modelObjects = null;
        }
    }

    public final void addPhysicalTarget(MIRPhysicalTarget mIRPhysicalTarget) {
        if (mIRPhysicalTarget == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("PhysicalObject", "PhysicalTarget"));
        }
        if (mIRPhysicalTarget._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("PhysicalObject", "PhysicalTarget"));
        }
        if (this.hasPhysicalTarget != null) {
            if (this.hasPhysicalTarget._equals(mIRPhysicalTarget)) {
                throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("PhysicalObject", "PhysicalTarget"));
            }
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("PhysicalObject", "PhysicalTarget"));
        }
        this.hasPhysicalTarget = mIRPhysicalTarget;
        mIRPhysicalTarget.getPhysicalObjectCollection().add(this);
    }

    public final MIRPhysicalTarget getPhysicalTarget() {
        return this.hasPhysicalTarget;
    }

    public final boolean removePhysicalTarget() {
        if (this.hasPhysicalTarget != null) {
            this.hasPhysicalTarget.physicalObjects.remove(this);
            if (this.hasPhysicalTarget.physicalObjects.isEmpty()) {
                this.hasPhysicalTarget.physicalObjects = null;
            }
            this.hasPhysicalTarget = null;
            return true;
        }
        return false;
    }

    protected MIRObjectCollection<MIRPhysicalRelationship> getSourceOfPhysicalRelationshipCollection() {
        this.sourceOfPhysicalRelationships = MIRObjectCollections.get(this.sourceOfPhysicalRelationships, MIRSdkCollection.Type.OBJECT);
        return this.sourceOfPhysicalRelationships;
    }

    public SortedSet<MIRPhysicalRelationship> getSourceOfPhysicalRelationships() {
        return MIRObjectCollections.sortedSet(this.sourceOfPhysicalRelationships);
    }

    public final void addSourceOfPhysicalRelationship(MIRPhysicalRelationship mIRPhysicalRelationship) {
        if (mIRPhysicalRelationship == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("PhysicalObject", "SourceOfPhysicalRelationship"));
        }
        if (mIRPhysicalRelationship._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("PhysicalObject", "SourceOfPhysicalRelationship"));
        }
        if (mIRPhysicalRelationship.hasSourcePhysicalObject != null) {
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("PhysicalRelationship", "SourcePhysicalObject"));
        }
        if (this.sourceOfPhysicalRelationships != null && this.sourceOfPhysicalRelationships.contains(mIRPhysicalRelationship)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("PhysicalObject", "SourceOfPhysicalRelationship"));
        }
        this.getSourceOfPhysicalRelationshipCollection().add(mIRPhysicalRelationship);
        mIRPhysicalRelationship.hasSourcePhysicalObject = this;
    }

    public final int getSourceOfPhysicalRelationshipCount() {
        if (this.sourceOfPhysicalRelationships != null) {
            return this.sourceOfPhysicalRelationships.size();
        }
        return 0;
    }

    public final boolean containsSourceOfPhysicalRelationship(MIRPhysicalRelationship mIRPhysicalRelationship) {
        if (mIRPhysicalRelationship != null && this.sourceOfPhysicalRelationships != null) {
            return this.sourceOfPhysicalRelationships.contains(mIRPhysicalRelationship);
        }
        return false;
    }

    public final MIRPhysicalRelationship getSourceOfPhysicalRelationship(String string) {
        if (this.sourceOfPhysicalRelationships != null) {
            return this.sourceOfPhysicalRelationships.get(string);
        }
        return null;
    }

    public final Iterator<MIRPhysicalRelationship> getSourceOfPhysicalRelationshipIterator() {
        if (this.sourceOfPhysicalRelationships != null) {
            return this.sourceOfPhysicalRelationships.iterator();
        }
        return MIRObjectCollections.emptySet().iterator();
    }

    public final boolean removeSourceOfPhysicalRelationship(MIRPhysicalRelationship mIRPhysicalRelationship) {
        if (mIRPhysicalRelationship != null && this.sourceOfPhysicalRelationships != null && this.sourceOfPhysicalRelationships.remove(mIRPhysicalRelationship)) {
            mIRPhysicalRelationship.hasSourcePhysicalObject = null;
            if (this.sourceOfPhysicalRelationships.isEmpty()) {
                this.sourceOfPhysicalRelationships = null;
            }
            return true;
        }
        return false;
    }

    public final void removeSourceOfPhysicalRelationships() {
        if (this.sourceOfPhysicalRelationships != null) {
            for (MIRPhysicalRelationship mIRPhysicalRelationship : this.sourceOfPhysicalRelationships) {
                mIRPhysicalRelationship.hasSourcePhysicalObject = null;
            }
            this.sourceOfPhysicalRelationships = null;
        }
    }

    public static MIRMetaClass staticGetMetaClass() {
        if (metaClass == null) {
            metaClass = new MIRMetaClass(MIRModelObject.staticGetMetaClass(), 54, "PhysicalObject", false);
            new MIRMetaAttribute(metaClass, 122, "ObjectType", "java.lang.Byte", MIRPhysicalObjectType.class, (byte)0);
            new MIRMetaLink(metaClass, 204, "DestinationOfPhysicalRelationship", false, 1, 56, 207);
            new MIRMetaLink(metaClass, 205, "ModelObject", false, 1, 59, 187);
            new MIRMetaLink(metaClass, 202, "PhysicalTarget", true, 2, 53, 208);
            new MIRMetaLink(metaClass, 203, "SourceOfPhysicalRelationship", false, 3, 56, 206);
        }
        return metaClass;
    }

    @Override
    public MIRMetaClass getMetaClass() {
        return MIRPhysicalObject.staticGetMetaClass();
    }

    @Override
    protected void _rename(String string) {
        if (this.modelObjects != null) {
            for (MIRModelObject mIRModelObject : this.modelObjects) {
                mIRModelObject.associatedPhysicalObjects.rename(this, string);
            }
        }
        if (this.hasPhysicalTarget != null) {
            this.hasPhysicalTarget.physicalObjects.rename(this, string);
        }
        super._rename(string);
    }
}

