/*
 * Decompiled with CFR 0.152.
 */
package MITI.sdk;

import MITI.messages.MIR.MIRSDK;
import MITI.sdk.MIRMetaClass;
import MITI.sdk.MIRMetaLink;
import MITI.sdk.MIRNamespace;
import MITI.sdk.MIRNamespaceElement;
import MITI.sdk.MIRObject;
import MITI.sdk.MIRObjectCollections;
import MITI.sdk.collections.MIRObjectCollection;
import MITI.sdk.collections.MIRObjectIterator;
import MITI.sdk.collections.MIRSdkCollection;
import java.util.Iterator;
import java.util.SortedSet;

public abstract class MIRPackage
extends MIRNamespace {
    protected transient MIRObjectCollection<MIRNamespaceElement> importedNamespaceElements = null;
    private static MIRMetaClass metaClass = MIRPackage.staticGetMetaClass();

    @Override
    public short getElementType() {
        return 144;
    }

    protected MIRObjectCollection<MIRNamespaceElement> getImportedNamespaceElementCollection() {
        this.importedNamespaceElements = MIRObjectCollections.get(this.importedNamespaceElements, MIRSdkCollection.Type.OPTIONAL_NAME);
        return this.importedNamespaceElements;
    }

    public SortedSet<MIRNamespaceElement> getImportedNamespaceElements() {
        return MIRObjectCollections.sortedSet(this.importedNamespaceElements);
    }

    public final void addImportedNamespaceElement(MIRNamespaceElement mIRNamespaceElement) {
        if (mIRNamespaceElement == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("Package", "ImportedNamespaceElement"));
        }
        if (mIRNamespaceElement._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("Package", "ImportedNamespaceElement"));
        }
        if (this.importedNamespaceElements != null) {
            if (this.importedNamespaceElements.contains(mIRNamespaceElement)) {
                throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("Package", "ImportedNamespaceElement"));
            }
            if (!this._allowName(this.importedNamespaceElements, mIRNamespaceElement)) {
                throw new IllegalArgumentException(MIRSDK.NAME_COLLISION.getMessage("Package", this.getPath(), "ImportedNamespaceElement", "OptionalName", mIRNamespaceElement.getPath()));
            }
        }
        this.getImportedNamespaceElementCollection().add(mIRNamespaceElement);
        mIRNamespaceElement.getImportedByPackageCollection().add(this);
    }

    public final boolean addImportedNamespaceElementUniqueName(MIRNamespaceElement mIRNamespaceElement) {
        return this.addImportedNamespaceElementUniqueName(mIRNamespaceElement, '/');
    }

    public final boolean addImportedNamespaceElementUniqueName(MIRNamespaceElement mIRNamespaceElement, char c) {
        if (mIRNamespaceElement == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("Package", "ImportedNamespaceElement"));
        }
        if (mIRNamespaceElement._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("Package", "ImportedNamespaceElement"));
        }
        this.getImportedNamespaceElementCollection();
        boolean bl = false;
        if (this.importedNamespaceElements != null) {
            if (this.importedNamespaceElements.contains(mIRNamespaceElement)) {
                throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("Package", "ImportedNamespaceElement"));
            }
            if (!this._allowName(this.importedNamespaceElements, mIRNamespaceElement)) {
                mIRNamespaceElement.getImportedByPackageCollection().add(this);
                mIRNamespaceElement._rename(mIRNamespaceElement._setUniqueName(this.importedNamespaceElements, c));
                bl = true;
            }
        }
        this.getImportedNamespaceElementCollection().add(mIRNamespaceElement);
        mIRNamespaceElement.getImportedByPackageCollection().add(this);
        return bl;
    }

    public final int getImportedNamespaceElementCount() {
        if (this.importedNamespaceElements != null) {
            return this.importedNamespaceElements.size();
        }
        return 0;
    }

    public final boolean containsImportedNamespaceElement(MIRNamespaceElement mIRNamespaceElement) {
        if (mIRNamespaceElement != null && this.importedNamespaceElements != null) {
            return this.importedNamespaceElements.contains(mIRNamespaceElement);
        }
        return false;
    }

    public final MIRNamespaceElement getImportedNamespaceElement(String string) {
        if (this.importedNamespaceElements != null) {
            return this.importedNamespaceElements.get(string);
        }
        return null;
    }

    public final Iterator<MIRNamespaceElement> getImportedNamespaceElementIterator() {
        if (this.importedNamespaceElements != null) {
            return this.importedNamespaceElements.iterator();
        }
        return MIRObjectCollections.emptySet().iterator();
    }

    public final boolean removeImportedNamespaceElement(MIRNamespaceElement mIRNamespaceElement) {
        if (mIRNamespaceElement != null && this.importedNamespaceElements != null && this.importedNamespaceElements.remove(mIRNamespaceElement)) {
            mIRNamespaceElement.importedByPackages.remove(this);
            if (mIRNamespaceElement.importedByPackages.isEmpty()) {
                mIRNamespaceElement.importedByPackages = null;
            }
            if (this.importedNamespaceElements.isEmpty()) {
                this.importedNamespaceElements = null;
            }
            return true;
        }
        return false;
    }

    public final void removeImportedNamespaceElements() {
        if (this.importedNamespaceElements != null) {
            for (MIRNamespaceElement mIRNamespaceElement : this.importedNamespaceElements) {
                mIRNamespaceElement.importedByPackages.remove(this);
                if (!mIRNamespaceElement.importedByPackages.isEmpty()) continue;
                mIRNamespaceElement.importedByPackages = null;
            }
            this.importedNamespaceElements = null;
        }
    }

    public static MIRMetaClass staticGetMetaClass() {
        if (metaClass == null) {
            metaClass = new MIRMetaClass(MIRNamespace.staticGetMetaClass(), 144, "Package", true);
            new MIRMetaLink(metaClass, 597, "ImportedNamespaceElement", false, 0, 211, 598);
        }
        return metaClass;
    }

    @Override
    public MIRMetaClass getMetaClass() {
        return MIRPackage.staticGetMetaClass();
    }

    public final Iterator<MIRNamespaceElement> getAllNamespaceElementIterator() {
        return new MIRObjectIterator<MIRNamespaceElement>(this.getNamespaceElementIterator(), this.getImportedNamespaceElementIterator());
    }

    @Override
    protected boolean _allowName(MIRObjectCollection<? extends MIRObject> mIRObjectCollection, MIRObject mIRObject) {
        if (this.namespaceElements != null && this.importedNamespaceElements != null) {
            if (mIRObjectCollection == this.namespaceElements) {
                return this.namespaceElements.allowName(mIRObject) && !this.importedNamespaceElements.contains((MIRNamespaceElement)mIRObject) && this.importedNamespaceElements.allowName(mIRObject);
            }
            if (mIRObjectCollection == this.importedNamespaceElements) {
                return this.importedNamespaceElements.allowName(mIRObject) && !this.namespaceElements.contains((MIRNamespaceElement)mIRObject) && this.namespaceElements.allowName(mIRObject);
            }
        }
        return mIRObjectCollection.allowName(mIRObject);
    }

    @Override
    protected void _rename(String string) {
        if (this.importedNamespaceElements != null) {
            for (MIRNamespaceElement mIRNamespaceElement : this.importedNamespaceElements) {
                mIRNamespaceElement.importedByPackages.rename(this, string);
            }
        }
        super._rename(string);
    }
}

