/*
 * Decompiled with CFR 0.152.
 */
package MITI.sdk;

import MITI.messages.MIR.MIRSDK;
import MITI.sdk.MIRDataPackage;
import MITI.sdk.MIRMetaClass;
import MITI.sdk.MIRMetaLink;
import MITI.sdk.MIRModelObject;
import MITI.sdk.MIRNamespace;
import MITI.sdk.MIRObject;
import MITI.sdk.MIRObjectCollections;
import MITI.sdk.MIRPackage;
import MITI.sdk.collections.MIRObjectCollection;
import MITI.sdk.collections.MIRSdkCollection;
import java.util.Iterator;
import java.util.SortedSet;

public abstract class MIRNamespaceElement
extends MIRModelObject {
    protected transient MIRObjectCollection<MIRPackage> importedByPackages = null;
    protected transient MIRNamespace hasNamespace = null;
    private static MIRMetaClass metaClass = MIRNamespaceElement.staticGetMetaClass();

    @Override
    public short getElementType() {
        return 211;
    }

    @Override
    public MIRObject getParent() {
        if (this.hasNamespace != null) {
            return this.hasNamespace;
        }
        return super.getParent();
    }

    @Override
    public int getParentCount() {
        return (this.hasNamespace != null ? 1 : 0) + super.getParentCount();
    }

    protected MIRObjectCollection<MIRPackage> getImportedByPackageCollection() {
        this.importedByPackages = MIRObjectCollections.get(this.importedByPackages, MIRSdkCollection.Type.OBJECT);
        return this.importedByPackages;
    }

    public SortedSet<MIRPackage> getImportedByPackages() {
        return MIRObjectCollections.sortedSet(this.importedByPackages);
    }

    public final void addImportedByPackage(MIRPackage mIRPackage) {
        if (mIRPackage == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("NamespaceElement", "ImportedByPackage"));
        }
        if (mIRPackage._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("NamespaceElement", "ImportedByPackage"));
        }
        if (mIRPackage.importedNamespaceElements != null && !mIRPackage._allowName(mIRPackage.importedNamespaceElements, this)) {
            throw new IllegalArgumentException(MIRSDK.NAME_COLLISION.getMessage("Package", mIRPackage.getPath(), "ImportedNamespaceElement", "Object", this.getName()));
        }
        if (this.importedByPackages != null && this.importedByPackages.contains(mIRPackage)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("NamespaceElement", "ImportedByPackage"));
        }
        this.getImportedByPackageCollection().add(mIRPackage);
        mIRPackage.getImportedNamespaceElementCollection().add(this);
    }

    public final int getImportedByPackageCount() {
        if (this.importedByPackages != null) {
            return this.importedByPackages.size();
        }
        return 0;
    }

    public final boolean containsImportedByPackage(MIRPackage mIRPackage) {
        if (mIRPackage != null && this.importedByPackages != null) {
            return this.importedByPackages.contains(mIRPackage);
        }
        return false;
    }

    public final MIRPackage getImportedByPackage(String string) {
        if (this.importedByPackages != null) {
            return this.importedByPackages.get(string);
        }
        return null;
    }

    public final Iterator<MIRPackage> getImportedByPackageIterator() {
        if (this.importedByPackages != null) {
            return this.importedByPackages.iterator();
        }
        return MIRObjectCollections.emptySet().iterator();
    }

    public final boolean removeImportedByPackage(MIRPackage mIRPackage) {
        if (mIRPackage != null && this.importedByPackages != null && this.importedByPackages.remove(mIRPackage)) {
            mIRPackage.importedNamespaceElements.remove(this);
            if (mIRPackage.importedNamespaceElements.isEmpty()) {
                mIRPackage.importedNamespaceElements = null;
            }
            if (this.importedByPackages.isEmpty()) {
                this.importedByPackages = null;
            }
            return true;
        }
        return false;
    }

    public final void removeImportedByPackages() {
        if (this.importedByPackages != null) {
            for (MIRPackage mIRPackage : this.importedByPackages) {
                mIRPackage.importedNamespaceElements.remove(this);
                if (!mIRPackage.importedNamespaceElements.isEmpty()) continue;
                mIRPackage.importedNamespaceElements = null;
            }
            this.importedByPackages = null;
        }
    }

    public final void addNamespace(MIRNamespace mIRNamespace) {
        if (mIRNamespace == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("NamespaceElement", "Namespace"));
        }
        if (mIRNamespace._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("NamespaceElement", "Namespace"));
        }
        if (this.hasNamespace != null) {
            if (this.hasNamespace._equals(mIRNamespace)) {
                throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("NamespaceElement", "Namespace"));
            }
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("NamespaceElement", "Namespace"));
        }
        if (mIRNamespace.namespaceElements != null && !mIRNamespace._allowName(mIRNamespace.namespaceElements, this)) {
            throw new IllegalArgumentException(MIRSDK.NAME_COLLISION.getMessage("Namespace", mIRNamespace.getPath(), "NamespaceElement", "Object", this.getName()));
        }
        this.hasNamespace = mIRNamespace;
        mIRNamespace.getNamespaceElementCollection().add(this);
    }

    public final MIRNamespace getNamespace() {
        return this.hasNamespace;
    }

    public final boolean removeNamespace() {
        if (this.hasNamespace != null) {
            this.hasNamespace.namespaceElements.remove(this);
            if (this.hasNamespace.namespaceElements.isEmpty()) {
                this.hasNamespace.namespaceElements = null;
            }
            this.hasNamespace = null;
            return true;
        }
        return false;
    }

    public static MIRMetaClass staticGetMetaClass() {
        if (metaClass == null) {
            metaClass = new MIRMetaClass(MIRModelObject.staticGetMetaClass(), 211, "NamespaceElement", true);
            new MIRMetaLink(metaClass, 598, "ImportedByPackage", false, 1, 144, 597);
            new MIRMetaLink(metaClass, 596, "Namespace", true, 2, 198, 595);
        }
        return metaClass;
    }

    @Override
    public MIRMetaClass getMetaClass() {
        return MIRNamespaceElement.staticGetMetaClass();
    }

    public final String getNamespaceName(MIRNamespace mIRNamespace) {
        if (mIRNamespace != null && mIRNamespace instanceof MIRDataPackage && this.aPhysicalName.length() != 0) {
            return this.aPhysicalName;
        }
        return this.aName;
    }

    public MIRDataPackage getDataPackage() {
        if (this.hasNamespace != null && this.hasNamespace instanceof MIRDataPackage) {
            return (MIRDataPackage)this.hasNamespace;
        }
        Iterator<MIRPackage> iterator = this.getImportedByPackageIterator();
        while (iterator.hasNext()) {
            MIRPackage mIRPackage = iterator.next();
            if (!(mIRPackage instanceof MIRDataPackage)) continue;
            return (MIRDataPackage)mIRPackage;
        }
        return null;
    }

    @Override
    protected boolean _isValidName() {
        if (this.importedByPackages != null) {
            for (MIRPackage mIRPackage : this.importedByPackages) {
                if (mIRPackage._allowName(mIRPackage.importedNamespaceElements, this)) continue;
                return false;
            }
        }
        if (this.hasNamespace != null && !this.hasNamespace._allowName(this.hasNamespace.namespaceElements, this)) {
            return false;
        }
        return super._isValidName();
    }

    @Override
    protected void _rename(String string) {
        if (this.importedByPackages != null) {
            for (MIRPackage mIRPackage : this.importedByPackages) {
                mIRPackage.importedNamespaceElements.rename(this, string);
            }
        }
        if (this.hasNamespace != null) {
            this.hasNamespace.namespaceElements.rename(this, string);
        }
        super._rename(string);
    }
}

