/*
 * Decompiled with CFR 0.152.
 */
package MITI.sdk;

import MITI.sdk.MIRElementType;
import MITI.sdk.MIRMetaAttribute;
import MITI.sdk.MIRMetaLink;
import MITI.sdk.MIRMetaObject;
import MITI.sdk.MIRObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class MIRMetaClass
extends MIRMetaObject {
    private MIRMetaClass parent;
    private List<MIRMetaClass> children;
    private boolean abstractClass;
    private List<MIRMetaAttribute> attributes;
    private List<MIRMetaLink> links;

    MIRMetaClass(MIRMetaClass mIRMetaClass, short s, String string, boolean bl) {
        super(s, string);
        this.parent = mIRMetaClass;
        this.abstractClass = bl;
        this.children = new ArrayList<MIRMetaClass>();
        this.attributes = new ArrayList<MIRMetaAttribute>();
        this.links = new ArrayList<MIRMetaLink>();
        if (mIRMetaClass != null) {
            mIRMetaClass.children.add(this);
            this.attributes.addAll(mIRMetaClass.attributes);
            this.links.addAll(mIRMetaClass.links);
        }
    }

    public final MIRMetaClass getParent() {
        return this.parent;
    }

    public final int getChildCount() {
        return this.children.size();
    }

    public final MIRMetaClass getChild(int n) {
        return this.children.get(n);
    }

    public final List<MIRMetaClass> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    public final short getElementType() {
        return this.id;
    }

    public final Class<? extends MIRObject> getJavaClass() {
        return MIRElementType.getJavaClass(this.id);
    }

    public final boolean isAbstract() {
        return this.abstractClass;
    }

    public final int getAttributeCount() {
        return this.attributes.size();
    }

    public final MIRMetaAttribute getAttribute(int n) {
        return this.attributes.get(n);
    }

    public final MIRMetaAttribute getAttributeByID(short s) {
        for (MIRMetaAttribute mIRMetaAttribute : this.attributes) {
            if (mIRMetaAttribute.getID() != s) continue;
            return mIRMetaAttribute;
        }
        return null;
    }

    public final MIRMetaAttribute getAttributeByName(String string) {
        for (MIRMetaAttribute mIRMetaAttribute : this.attributes) {
            if (!mIRMetaAttribute.getName().equals(string)) continue;
            return mIRMetaAttribute;
        }
        return null;
    }

    public final List<MIRMetaAttribute> getAttributes() {
        return Collections.unmodifiableList(this.attributes);
    }

    public final int getLinkCount() {
        return this.links.size();
    }

    public final MIRMetaLink getLink(int n) {
        return this.links.get(n);
    }

    public final MIRMetaLink getLinkByID(short s) {
        for (MIRMetaLink mIRMetaLink : this.links) {
            if (mIRMetaLink.getID() != s) continue;
            return mIRMetaLink;
        }
        return null;
    }

    public final MIRMetaLink getLinkByName(String string) {
        for (MIRMetaLink mIRMetaLink : this.links) {
            if (!mIRMetaLink.getName().equals(string)) continue;
            return mIRMetaLink;
        }
        return null;
    }

    public final List<MIRMetaLink> getLinks() {
        return Collections.unmodifiableList(this.links);
    }

    public final boolean isSuperClassOf(short s) {
        MIRMetaClass mIRMetaClass = MIRMetaClass.getByElementType(s);
        if (mIRMetaClass != null) {
            return mIRMetaClass.isSubClassOf(this.id);
        }
        return false;
    }

    public final boolean isSubClassOf(short s) {
        if (this.id == s) {
            return true;
        }
        if (this.parent != null) {
            return this.parent.isSubClassOf(s);
        }
        return false;
    }

    public static MIRMetaClass getByElementType(short s) {
        if (s < 0 || s >= metaClasses.length) {
            return null;
        }
        return metaClasses[s];
    }

    public static class Member
    extends MIRMetaObject {
        protected MIRMetaClass owner;

        protected Member(MIRMetaClass mIRMetaClass, short s, String string) {
            super(s, string);
            this.owner = mIRMetaClass;
            if (this instanceof MIRMetaAttribute) {
                mIRMetaClass.attributes.add((MIRMetaAttribute)this);
            } else if (this instanceof MIRMetaLink) {
                mIRMetaClass.links.add((MIRMetaLink)this);
            }
        }

        public final MIRMetaClass getOwner() {
            return this.owner;
        }

        public final String getFullName() {
            return this.owner.getName() + "." + this.getName();
        }
    }
}

