/*
 * Decompiled with CFR 0.152.
 */
package MITI.sdk;

import MITI.messages.MIR.MIRSDK;
import MITI.sdk.MIRMetaClass;
import MITI.sdk.MIRMetaLink;
import MITI.sdk.MIRModel;
import MITI.sdk.MIRObjectCollections;
import MITI.sdk.MIRStoreConnection;
import MITI.sdk.collections.MIRObjectCollection;
import MITI.sdk.collections.MIRSdkCollection;
import java.util.Iterator;
import java.util.SortedSet;

public abstract class MIRMappingModel
extends MIRModel {
    protected transient MIRObjectCollection<MIRStoreConnection> destinationStoreConnections = null;
    protected transient MIRObjectCollection<MIRStoreConnection> sourceStoreConnections = null;
    private static MIRMetaClass metaClass = MIRMappingModel.staticGetMetaClass();

    @Override
    public short getElementType() {
        return 80;
    }

    protected MIRObjectCollection<MIRStoreConnection> getDestinationStoreConnectionCollection() {
        this.destinationStoreConnections = MIRObjectCollections.get(this.destinationStoreConnections, MIRSdkCollection.Type.OBJECT);
        return this.destinationStoreConnections;
    }

    public SortedSet<MIRStoreConnection> getDestinationStoreConnections() {
        return MIRObjectCollections.sortedSet(this.destinationStoreConnections);
    }

    public final void addDestinationStoreConnection(MIRStoreConnection mIRStoreConnection) {
        if (mIRStoreConnection == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("MappingModel", "DestinationStoreConnection"));
        }
        if (mIRStoreConnection._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("MappingModel", "DestinationStoreConnection"));
        }
        if (mIRStoreConnection.hasDestinationOfMappingModel != null) {
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("StoreConnection", "DestinationOfMappingModel"));
        }
        if (this.destinationStoreConnections != null && this.destinationStoreConnections.contains(mIRStoreConnection)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("MappingModel", "DestinationStoreConnection"));
        }
        this.getDestinationStoreConnectionCollection().add(mIRStoreConnection);
        mIRStoreConnection.hasDestinationOfMappingModel = this;
    }

    public final int getDestinationStoreConnectionCount() {
        if (this.destinationStoreConnections != null) {
            return this.destinationStoreConnections.size();
        }
        return 0;
    }

    public final boolean containsDestinationStoreConnection(MIRStoreConnection mIRStoreConnection) {
        if (mIRStoreConnection != null && this.destinationStoreConnections != null) {
            return this.destinationStoreConnections.contains(mIRStoreConnection);
        }
        return false;
    }

    public final MIRStoreConnection getDestinationStoreConnection(String string) {
        if (this.destinationStoreConnections != null) {
            return this.destinationStoreConnections.get(string);
        }
        return null;
    }

    public final Iterator<MIRStoreConnection> getDestinationStoreConnectionIterator() {
        if (this.destinationStoreConnections != null) {
            return this.destinationStoreConnections.iterator();
        }
        return MIRObjectCollections.emptySet().iterator();
    }

    public final boolean removeDestinationStoreConnection(MIRStoreConnection mIRStoreConnection) {
        if (mIRStoreConnection != null && this.destinationStoreConnections != null && this.destinationStoreConnections.remove(mIRStoreConnection)) {
            mIRStoreConnection.hasDestinationOfMappingModel = null;
            if (this.destinationStoreConnections.isEmpty()) {
                this.destinationStoreConnections = null;
            }
            return true;
        }
        return false;
    }

    public final void removeDestinationStoreConnections() {
        if (this.destinationStoreConnections != null) {
            for (MIRStoreConnection mIRStoreConnection : this.destinationStoreConnections) {
                mIRStoreConnection.hasDestinationOfMappingModel = null;
            }
            this.destinationStoreConnections = null;
        }
    }

    protected MIRObjectCollection<MIRStoreConnection> getSourceStoreConnectionCollection() {
        this.sourceStoreConnections = MIRObjectCollections.get(this.sourceStoreConnections, MIRSdkCollection.Type.OBJECT);
        return this.sourceStoreConnections;
    }

    public SortedSet<MIRStoreConnection> getSourceStoreConnections() {
        return MIRObjectCollections.sortedSet(this.sourceStoreConnections);
    }

    public final void addSourceStoreConnection(MIRStoreConnection mIRStoreConnection) {
        if (mIRStoreConnection == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("MappingModel", "SourceStoreConnection"));
        }
        if (mIRStoreConnection._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("MappingModel", "SourceStoreConnection"));
        }
        if (mIRStoreConnection.hasSourceOfMappingModel != null) {
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("StoreConnection", "SourceOfMappingModel"));
        }
        if (this.sourceStoreConnections != null && this.sourceStoreConnections.contains(mIRStoreConnection)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("MappingModel", "SourceStoreConnection"));
        }
        this.getSourceStoreConnectionCollection().add(mIRStoreConnection);
        mIRStoreConnection.hasSourceOfMappingModel = this;
    }

    public final int getSourceStoreConnectionCount() {
        if (this.sourceStoreConnections != null) {
            return this.sourceStoreConnections.size();
        }
        return 0;
    }

    public final boolean containsSourceStoreConnection(MIRStoreConnection mIRStoreConnection) {
        if (mIRStoreConnection != null && this.sourceStoreConnections != null) {
            return this.sourceStoreConnections.contains(mIRStoreConnection);
        }
        return false;
    }

    public final MIRStoreConnection getSourceStoreConnection(String string) {
        if (this.sourceStoreConnections != null) {
            return this.sourceStoreConnections.get(string);
        }
        return null;
    }

    public final Iterator<MIRStoreConnection> getSourceStoreConnectionIterator() {
        if (this.sourceStoreConnections != null) {
            return this.sourceStoreConnections.iterator();
        }
        return MIRObjectCollections.emptySet().iterator();
    }

    public final boolean removeSourceStoreConnection(MIRStoreConnection mIRStoreConnection) {
        if (mIRStoreConnection != null && this.sourceStoreConnections != null && this.sourceStoreConnections.remove(mIRStoreConnection)) {
            mIRStoreConnection.hasSourceOfMappingModel = null;
            if (this.sourceStoreConnections.isEmpty()) {
                this.sourceStoreConnections = null;
            }
            return true;
        }
        return false;
    }

    public final void removeSourceStoreConnections() {
        if (this.sourceStoreConnections != null) {
            for (MIRStoreConnection mIRStoreConnection : this.sourceStoreConnections) {
                mIRStoreConnection.hasSourceOfMappingModel = null;
            }
            this.sourceStoreConnections = null;
        }
    }

    public static MIRMetaClass staticGetMetaClass() {
        if (metaClass == null) {
            metaClass = new MIRMetaClass(MIRModel.staticGetMetaClass(), 80, "MappingModel", true);
            new MIRMetaLink(metaClass, 733, "DestinationStoreConnection", false, 0, 216, 734);
            new MIRMetaLink(metaClass, 735, "SourceStoreConnection", false, 0, 216, 736);
        }
        return metaClass;
    }

    @Override
    public MIRMetaClass getMetaClass() {
        return MIRMappingModel.staticGetMetaClass();
    }
}

