/*
 * Decompiled with CFR 0.152.
 */
package MITI.sdk;

import MITI.messages.MIR.MIRSDK;
import MITI.sdk.MIRLevel;
import MITI.sdk.MIRLevelAttribute;
import MITI.sdk.MIRMetaClass;
import MITI.sdk.MIRMetaLink;
import MITI.sdk.MIRModelObject;
import MITI.sdk.MIRObject;
import MITI.sdk.MIRObjectCollections;
import MITI.sdk.collections.MIRObjectCollection;
import MITI.sdk.collections.MIRSdkCollection;
import java.util.Iterator;
import java.util.SortedSet;

public class MIRLevelKey
extends MIRModelObject {
    protected transient MIRLevel hasLevel = null;
    protected transient MIRObjectCollection<MIRLevelAttribute> levelAttributes = null;
    private static MIRMetaClass metaClass = MIRLevelKey.staticGetMetaClass();

    public MIRLevelKey() {
    }

    public MIRLevelKey(MIRLevelKey mIRLevelKey) {
        this.setFrom(mIRLevelKey);
    }

    @Override
    public Object clone() {
        return new MIRLevelKey(this);
    }

    @Override
    public short getElementType() {
        return 96;
    }

    @Override
    public MIRObject getParent() {
        if (this.hasLevel != null) {
            return this.hasLevel;
        }
        return super.getParent();
    }

    @Override
    public int getParentCount() {
        return (this.hasLevel != null ? 1 : 0) + super.getParentCount();
    }

    public final void addLevel(MIRLevel mIRLevel) {
        if (mIRLevel == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("LevelKey", "Level"));
        }
        if (mIRLevel._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("LevelKey", "Level"));
        }
        if (this.hasLevel != null) {
            if (this.hasLevel._equals(mIRLevel)) {
                throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("LevelKey", "Level"));
            }
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("LevelKey", "Level"));
        }
        if (mIRLevel.hasLevelKey != null) {
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("Level", "LevelKey"));
        }
        this.hasLevel = mIRLevel;
        mIRLevel.hasLevelKey = this;
    }

    public final MIRLevel getLevel() {
        return this.hasLevel;
    }

    public final boolean removeLevel() {
        if (this.hasLevel != null) {
            this.hasLevel.hasLevelKey = null;
            this.hasLevel = null;
            return true;
        }
        return false;
    }

    protected MIRObjectCollection<MIRLevelAttribute> getLevelAttributeCollection() {
        this.levelAttributes = MIRObjectCollections.get(this.levelAttributes, MIRSdkCollection.Type.OBJECT);
        return this.levelAttributes;
    }

    public SortedSet<MIRLevelAttribute> getLevelAttributes() {
        return MIRObjectCollections.sortedSet(this.levelAttributes);
    }

    public final void addLevelAttribute(MIRLevelAttribute mIRLevelAttribute) {
        if (mIRLevelAttribute == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("LevelKey", "LevelAttribute"));
        }
        if (mIRLevelAttribute._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("LevelKey", "LevelAttribute"));
        }
        if (mIRLevelAttribute.hasLevelKey != null) {
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("LevelAttribute", "LevelKey"));
        }
        if (this.levelAttributes != null && this.levelAttributes.contains(mIRLevelAttribute)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("LevelKey", "LevelAttribute"));
        }
        this.getLevelAttributeCollection().add(mIRLevelAttribute);
        mIRLevelAttribute.hasLevelKey = this;
    }

    public final int getLevelAttributeCount() {
        if (this.levelAttributes != null) {
            return this.levelAttributes.size();
        }
        return 0;
    }

    public final boolean containsLevelAttribute(MIRLevelAttribute mIRLevelAttribute) {
        if (mIRLevelAttribute != null && this.levelAttributes != null) {
            return this.levelAttributes.contains(mIRLevelAttribute);
        }
        return false;
    }

    public final MIRLevelAttribute getLevelAttribute(String string) {
        if (this.levelAttributes != null) {
            return this.levelAttributes.get(string);
        }
        return null;
    }

    public final Iterator<MIRLevelAttribute> getLevelAttributeIterator() {
        if (this.levelAttributes != null) {
            return this.levelAttributes.iterator();
        }
        return MIRObjectCollections.emptySet().iterator();
    }

    public final boolean removeLevelAttribute(MIRLevelAttribute mIRLevelAttribute) {
        if (mIRLevelAttribute != null && this.levelAttributes != null && this.levelAttributes.remove(mIRLevelAttribute)) {
            mIRLevelAttribute.hasLevelKey = null;
            if (this.levelAttributes.isEmpty()) {
                this.levelAttributes = null;
            }
            return true;
        }
        return false;
    }

    public final void removeLevelAttributes() {
        if (this.levelAttributes != null) {
            for (MIRLevelAttribute mIRLevelAttribute : this.levelAttributes) {
                mIRLevelAttribute.hasLevelKey = null;
            }
            this.levelAttributes = null;
        }
    }

    public static MIRMetaClass staticGetMetaClass() {
        if (metaClass == null) {
            metaClass = new MIRMetaClass(MIRModelObject.staticGetMetaClass(), 96, "LevelKey", false);
            new MIRMetaLink(metaClass, 166, "Level", true, 2, 94, 162);
            new MIRMetaLink(metaClass, 167, "LevelAttribute", false, 0, 95, 164);
        }
        return metaClass;
    }

    @Override
    public MIRMetaClass getMetaClass() {
        return MIRLevelKey.staticGetMetaClass();
    }
}

