/*
 * Decompiled with CFR 0.152.
 */
package MITI.sdk;

import MITI.messages.MIR.MIRSDK;
import MITI.sdk.MIRClassifier;
import MITI.sdk.MIRJoinCondition;
import MITI.sdk.MIRJoinRelationshipType;
import MITI.sdk.MIRMetaAttribute;
import MITI.sdk.MIRMetaClass;
import MITI.sdk.MIRMetaLink;
import MITI.sdk.MIRObject;
import MITI.sdk.MIRObjectCollections;
import MITI.sdk.MIR_Object;
import MITI.sdk.collections.MIRObjectCollection;
import MITI.sdk.collections.MIRSdkCollection;
import java.util.Iterator;
import java.util.SortedSet;

public class MIRJoinRelationship
extends MIRObject {
    protected transient String aCondition = "";
    protected transient String aContexts = "";
    protected transient byte aType = 0;
    protected transient MIRObjectCollection<MIRJoinCondition> joinConditions = null;
    protected transient MIRClassifier hasLeftClassifier = null;
    protected transient MIRClassifier hasRightClassifier = null;
    private static MIRMetaClass metaClass = MIRJoinRelationship.staticGetMetaClass();

    public MIRJoinRelationship() {
    }

    public MIRJoinRelationship(MIRJoinRelationship mIRJoinRelationship) {
        this.setFrom(mIRJoinRelationship);
    }

    @Override
    public Object clone() {
        return new MIRJoinRelationship(this);
    }

    @Override
    public short getElementType() {
        return 346;
    }

    @Override
    public void setFrom(MIR_Object mIR_Object) {
        super.setFrom(mIR_Object);
        if (mIR_Object.isInstanceOf((short)346)) {
            this.setCondition(((MIRJoinRelationship)mIR_Object).getCondition());
            this.setContexts(((MIRJoinRelationship)mIR_Object).getContexts());
            this.setType(((MIRJoinRelationship)mIR_Object).getType());
        }
    }

    @Override
    public MIRObject getParent() {
        if (this.hasLeftClassifier != null) {
            return this.hasLeftClassifier;
        }
        return super.getParent();
    }

    @Override
    public int getParentCount() {
        return (this.hasLeftClassifier != null ? 1 : 0) + super.getParentCount();
    }

    public final void setCondition(String string) {
        this.aCondition = string == null ? "" : string;
    }

    public final String getCondition() {
        return this.aCondition;
    }

    public final void setContexts(String string) {
        this.aContexts = string == null ? "" : string;
    }

    public final String getContexts() {
        return this.aContexts;
    }

    public final void setType(byte by) {
        this.aType = by;
    }

    public final byte getType() {
        return this.aType;
    }

    protected MIRObjectCollection<MIRJoinCondition> getJoinConditionCollection() {
        this.joinConditions = MIRObjectCollections.get(this.joinConditions, MIRSdkCollection.Type.OBJECT);
        return this.joinConditions;
    }

    public SortedSet<MIRJoinCondition> getJoinConditions() {
        return MIRObjectCollections.sortedSet(this.joinConditions);
    }

    public final void addJoinCondition(MIRJoinCondition mIRJoinCondition) {
        if (mIRJoinCondition == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("JoinRelationship", "JoinCondition"));
        }
        if (mIRJoinCondition._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("JoinRelationship", "JoinCondition"));
        }
        if (mIRJoinCondition.hasJoinRelationship != null) {
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("JoinCondition", "JoinRelationship"));
        }
        if (this.joinConditions != null && this.joinConditions.contains(mIRJoinCondition)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("JoinRelationship", "JoinCondition"));
        }
        this.getJoinConditionCollection().add(mIRJoinCondition);
        mIRJoinCondition.hasJoinRelationship = this;
    }

    public final int getJoinConditionCount() {
        if (this.joinConditions != null) {
            return this.joinConditions.size();
        }
        return 0;
    }

    public final boolean containsJoinCondition(MIRJoinCondition mIRJoinCondition) {
        if (mIRJoinCondition != null && this.joinConditions != null) {
            return this.joinConditions.contains(mIRJoinCondition);
        }
        return false;
    }

    public final MIRJoinCondition getJoinCondition(String string) {
        if (this.joinConditions != null) {
            return this.joinConditions.get(string);
        }
        return null;
    }

    public final Iterator<MIRJoinCondition> getJoinConditionIterator() {
        if (this.joinConditions != null) {
            return this.joinConditions.iterator();
        }
        return MIRObjectCollections.emptySet().iterator();
    }

    public final boolean removeJoinCondition(MIRJoinCondition mIRJoinCondition) {
        if (mIRJoinCondition != null && this.joinConditions != null && this.joinConditions.remove(mIRJoinCondition)) {
            mIRJoinCondition.hasJoinRelationship = null;
            if (this.joinConditions.isEmpty()) {
                this.joinConditions = null;
            }
            return true;
        }
        return false;
    }

    public final void removeJoinConditions() {
        if (this.joinConditions != null) {
            for (MIRJoinCondition mIRJoinCondition : this.joinConditions) {
                mIRJoinCondition.hasJoinRelationship = null;
            }
            this.joinConditions = null;
        }
    }

    public final void addLeftClassifier(MIRClassifier mIRClassifier) {
        if (mIRClassifier == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("JoinRelationship", "LeftClassifier"));
        }
        if (mIRClassifier._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("JoinRelationship", "LeftClassifier"));
        }
        if (this.hasLeftClassifier != null) {
            if (this.hasLeftClassifier._equals(mIRClassifier)) {
                throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("JoinRelationship", "LeftClassifier"));
            }
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("JoinRelationship", "LeftClassifier"));
        }
        this.hasLeftClassifier = mIRClassifier;
        mIRClassifier.getLeftOfJoinRelationshipCollection().add(this);
    }

    public final MIRClassifier getLeftClassifier() {
        return this.hasLeftClassifier;
    }

    public final boolean removeLeftClassifier() {
        if (this.hasLeftClassifier != null) {
            this.hasLeftClassifier.leftOfJoinRelationships.remove(this);
            if (this.hasLeftClassifier.leftOfJoinRelationships.isEmpty()) {
                this.hasLeftClassifier.leftOfJoinRelationships = null;
            }
            this.hasLeftClassifier = null;
            return true;
        }
        return false;
    }

    public final void addRightClassifier(MIRClassifier mIRClassifier) {
        if (mIRClassifier == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("JoinRelationship", "RightClassifier"));
        }
        if (mIRClassifier._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("JoinRelationship", "RightClassifier"));
        }
        if (this.hasRightClassifier != null) {
            if (this.hasRightClassifier._equals(mIRClassifier)) {
                throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("JoinRelationship", "RightClassifier"));
            }
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("JoinRelationship", "RightClassifier"));
        }
        this.hasRightClassifier = mIRClassifier;
        mIRClassifier.getRightOfJoinRelationshipCollection().add(this);
    }

    public final MIRClassifier getRightClassifier() {
        return this.hasRightClassifier;
    }

    public final boolean removeRightClassifier() {
        if (this.hasRightClassifier != null) {
            this.hasRightClassifier.rightOfJoinRelationships.remove(this);
            if (this.hasRightClassifier.rightOfJoinRelationships.isEmpty()) {
                this.hasRightClassifier.rightOfJoinRelationships = null;
            }
            this.hasRightClassifier = null;
            return true;
        }
        return false;
    }

    public static MIRMetaClass staticGetMetaClass() {
        if (metaClass == null) {
            metaClass = new MIRMetaClass(MIRObject.staticGetMetaClass(), 346, "JoinRelationship", false);
            new MIRMetaAttribute(metaClass, 501, "Type", "java.lang.Byte", MIRJoinRelationshipType.class, (byte)0);
            new MIRMetaAttribute(metaClass, 499, "Condition", "java.lang.String", null, "");
            new MIRMetaAttribute(metaClass, 500, "Contexts", "java.lang.String", null, "");
            new MIRMetaLink(metaClass, 1127, "JoinCondition", false, 3, 355, 1124);
            new MIRMetaLink(metaClass, 1107, "LeftClassifier", true, 2, 75, 1104);
            new MIRMetaLink(metaClass, 1108, "RightClassifier", true, 1, 75, 1105);
        }
        return metaClass;
    }

    @Override
    public MIRMetaClass getMetaClass() {
        return MIRJoinRelationship.staticGetMetaClass();
    }

    @Override
    protected void _rename(String string) {
        if (this.hasLeftClassifier != null) {
            this.hasLeftClassifier.leftOfJoinRelationships.rename(this, string);
        }
        if (this.hasRightClassifier != null) {
            this.hasRightClassifier.rightOfJoinRelationships.rename(this, string);
        }
        super._rename(string);
    }
}

