/*
 * Decompiled with CFR 0.152.
 */
package MITI.sdk;

import MITI.messages.MIR.MIRSDK;
import MITI.sdk.MIRCubeDimensionAssociation;
import MITI.sdk.MIRDimension;
import MITI.sdk.MIRHierarchyLevelAssociation;
import MITI.sdk.MIRHierarchyType;
import MITI.sdk.MIRMetaAttribute;
import MITI.sdk.MIRMetaClass;
import MITI.sdk.MIRMetaLink;
import MITI.sdk.MIRModelObject;
import MITI.sdk.MIRObject;
import MITI.sdk.MIRObjectCollections;
import MITI.sdk.MIR_Object;
import MITI.sdk.collections.MIRObjectCollection;
import MITI.sdk.collections.MIRSdkCollection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;

public class MIRHierarchy
extends MIRModelObject {
    protected transient byte aType = 0;
    protected transient MIRObjectCollection<MIRHierarchyLevelAssociation> bottomHierarchyLevelAssociations = null;
    protected transient MIRObjectCollection<MIRCubeDimensionAssociation> cubeDimensionAssociations = null;
    protected transient MIRDimension hasDefaultOfDimension = null;
    protected transient MIRDimension hasDimension = null;
    protected transient MIRObjectCollection<MIRHierarchyLevelAssociation> hierarchyLevelAssociations = null;
    protected transient MIRHierarchyLevelAssociation hasTopHierarchyLevelAssociation = null;
    private static MIRMetaClass metaClass = MIRHierarchy.staticGetMetaClass();

    public MIRHierarchy() {
    }

    public MIRHierarchy(MIRHierarchy mIRHierarchy) {
        this.setFrom(mIRHierarchy);
    }

    @Override
    public Object clone() {
        return new MIRHierarchy(this);
    }

    @Override
    public short getElementType() {
        return 90;
    }

    @Override
    public void setFrom(MIR_Object mIR_Object) {
        super.setFrom(mIR_Object);
        if (mIR_Object.isInstanceOf((short)90)) {
            this.setType(((MIRHierarchy)mIR_Object).getType());
        }
    }

    @Override
    public MIRObject getParent() {
        if (this.hasDimension != null) {
            return this.hasDimension;
        }
        return super.getParent();
    }

    @Override
    public int getParentCount() {
        return (this.hasDimension != null ? 1 : 0) + super.getParentCount();
    }

    public final void setType(byte by) {
        this.aType = by;
    }

    public final byte getType() {
        return this.aType;
    }

    protected MIRObjectCollection<MIRHierarchyLevelAssociation> getBottomHierarchyLevelAssociationCollection() {
        this.bottomHierarchyLevelAssociations = MIRObjectCollections.get(this.bottomHierarchyLevelAssociations, MIRSdkCollection.Type.OBJECT);
        return this.bottomHierarchyLevelAssociations;
    }

    public SortedSet<MIRHierarchyLevelAssociation> getBottomHierarchyLevelAssociations() {
        return MIRObjectCollections.sortedSet(this.bottomHierarchyLevelAssociations);
    }

    public final void addBottomHierarchyLevelAssociation(MIRHierarchyLevelAssociation mIRHierarchyLevelAssociation) {
        if (mIRHierarchyLevelAssociation == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("Hierarchy", "BottomHierarchyLevelAssociation"));
        }
        if (mIRHierarchyLevelAssociation._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("Hierarchy", "BottomHierarchyLevelAssociation"));
        }
        if (mIRHierarchyLevelAssociation.hasBottomOfHierarchy != null) {
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("HierarchyLevelAssociation", "BottomOfHierarchy"));
        }
        if (this.bottomHierarchyLevelAssociations != null && this.bottomHierarchyLevelAssociations.contains(mIRHierarchyLevelAssociation)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("Hierarchy", "BottomHierarchyLevelAssociation"));
        }
        this.getBottomHierarchyLevelAssociationCollection().add(mIRHierarchyLevelAssociation);
        mIRHierarchyLevelAssociation.hasBottomOfHierarchy = this;
    }

    public final int getBottomHierarchyLevelAssociationCount() {
        if (this.bottomHierarchyLevelAssociations != null) {
            return this.bottomHierarchyLevelAssociations.size();
        }
        return 0;
    }

    public final boolean containsBottomHierarchyLevelAssociation(MIRHierarchyLevelAssociation mIRHierarchyLevelAssociation) {
        if (mIRHierarchyLevelAssociation != null && this.bottomHierarchyLevelAssociations != null) {
            return this.bottomHierarchyLevelAssociations.contains(mIRHierarchyLevelAssociation);
        }
        return false;
    }

    public final MIRHierarchyLevelAssociation getBottomHierarchyLevelAssociation(String string) {
        if (this.bottomHierarchyLevelAssociations != null) {
            return this.bottomHierarchyLevelAssociations.get(string);
        }
        return null;
    }

    public final Iterator<MIRHierarchyLevelAssociation> getBottomHierarchyLevelAssociationIterator() {
        if (this.bottomHierarchyLevelAssociations != null) {
            return this.bottomHierarchyLevelAssociations.iterator();
        }
        return MIRObjectCollections.emptySet().iterator();
    }

    public final boolean removeBottomHierarchyLevelAssociation(MIRHierarchyLevelAssociation mIRHierarchyLevelAssociation) {
        if (mIRHierarchyLevelAssociation != null && this.bottomHierarchyLevelAssociations != null && this.bottomHierarchyLevelAssociations.remove(mIRHierarchyLevelAssociation)) {
            mIRHierarchyLevelAssociation.hasBottomOfHierarchy = null;
            if (this.bottomHierarchyLevelAssociations.isEmpty()) {
                this.bottomHierarchyLevelAssociations = null;
            }
            return true;
        }
        return false;
    }

    public final void removeBottomHierarchyLevelAssociations() {
        if (this.bottomHierarchyLevelAssociations != null) {
            for (MIRHierarchyLevelAssociation mIRHierarchyLevelAssociation : this.bottomHierarchyLevelAssociations) {
                mIRHierarchyLevelAssociation.hasBottomOfHierarchy = null;
            }
            this.bottomHierarchyLevelAssociations = null;
        }
    }

    protected MIRObjectCollection<MIRCubeDimensionAssociation> getCubeDimensionAssociationCollection() {
        this.cubeDimensionAssociations = MIRObjectCollections.get(this.cubeDimensionAssociations, MIRSdkCollection.Type.OBJECT);
        return this.cubeDimensionAssociations;
    }

    public SortedSet<MIRCubeDimensionAssociation> getCubeDimensionAssociations() {
        return MIRObjectCollections.sortedSet(this.cubeDimensionAssociations);
    }

    public final void addCubeDimensionAssociation(MIRCubeDimensionAssociation mIRCubeDimensionAssociation) {
        if (mIRCubeDimensionAssociation == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("Hierarchy", "CubeDimensionAssociation"));
        }
        if (mIRCubeDimensionAssociation._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("Hierarchy", "CubeDimensionAssociation"));
        }
        if (mIRCubeDimensionAssociation.hasHierarchy != null) {
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("CubeDimensionAssociation", "Hierarchy"));
        }
        if (this.cubeDimensionAssociations != null && this.cubeDimensionAssociations.contains(mIRCubeDimensionAssociation)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("Hierarchy", "CubeDimensionAssociation"));
        }
        this.getCubeDimensionAssociationCollection().add(mIRCubeDimensionAssociation);
        mIRCubeDimensionAssociation.hasHierarchy = this;
    }

    public final int getCubeDimensionAssociationCount() {
        if (this.cubeDimensionAssociations != null) {
            return this.cubeDimensionAssociations.size();
        }
        return 0;
    }

    public final boolean containsCubeDimensionAssociation(MIRCubeDimensionAssociation mIRCubeDimensionAssociation) {
        if (mIRCubeDimensionAssociation != null && this.cubeDimensionAssociations != null) {
            return this.cubeDimensionAssociations.contains(mIRCubeDimensionAssociation);
        }
        return false;
    }

    public final MIRCubeDimensionAssociation getCubeDimensionAssociation(String string) {
        if (this.cubeDimensionAssociations != null) {
            return this.cubeDimensionAssociations.get(string);
        }
        return null;
    }

    public final Iterator<MIRCubeDimensionAssociation> getCubeDimensionAssociationIterator() {
        if (this.cubeDimensionAssociations != null) {
            return this.cubeDimensionAssociations.iterator();
        }
        return MIRObjectCollections.emptySet().iterator();
    }

    public final boolean removeCubeDimensionAssociation(MIRCubeDimensionAssociation mIRCubeDimensionAssociation) {
        if (mIRCubeDimensionAssociation != null && this.cubeDimensionAssociations != null && this.cubeDimensionAssociations.remove(mIRCubeDimensionAssociation)) {
            mIRCubeDimensionAssociation.hasHierarchy = null;
            if (this.cubeDimensionAssociations.isEmpty()) {
                this.cubeDimensionAssociations = null;
            }
            return true;
        }
        return false;
    }

    public final void removeCubeDimensionAssociations() {
        if (this.cubeDimensionAssociations != null) {
            for (MIRCubeDimensionAssociation mIRCubeDimensionAssociation : this.cubeDimensionAssociations) {
                mIRCubeDimensionAssociation.hasHierarchy = null;
            }
            this.cubeDimensionAssociations = null;
        }
    }

    public final void addDefaultOfDimension(MIRDimension mIRDimension) {
        if (mIRDimension == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("Hierarchy", "DefaultOfDimension"));
        }
        if (mIRDimension._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("Hierarchy", "DefaultOfDimension"));
        }
        if (this.hasDefaultOfDimension != null) {
            if (this.hasDefaultOfDimension._equals(mIRDimension)) {
                throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("Hierarchy", "DefaultOfDimension"));
            }
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("Hierarchy", "DefaultOfDimension"));
        }
        if (mIRDimension.hasDefaultHierarchy != null) {
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("Dimension", "DefaultHierarchy"));
        }
        this.hasDefaultOfDimension = mIRDimension;
        mIRDimension.hasDefaultHierarchy = this;
    }

    public final MIRDimension getDefaultOfDimension() {
        return this.hasDefaultOfDimension;
    }

    public final boolean removeDefaultOfDimension() {
        if (this.hasDefaultOfDimension != null) {
            this.hasDefaultOfDimension.hasDefaultHierarchy = null;
            this.hasDefaultOfDimension = null;
            return true;
        }
        return false;
    }

    public final void addDimension(MIRDimension mIRDimension) {
        if (mIRDimension == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("Hierarchy", "Dimension"));
        }
        if (mIRDimension._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("Hierarchy", "Dimension"));
        }
        if (this.hasDimension != null) {
            if (this.hasDimension._equals(mIRDimension)) {
                throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("Hierarchy", "Dimension"));
            }
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("Hierarchy", "Dimension"));
        }
        if (mIRDimension.hierarchies != null && !mIRDimension._allowName(mIRDimension.hierarchies, this)) {
            throw new IllegalArgumentException(MIRSDK.NAME_COLLISION.getMessage("Dimension", mIRDimension.getPath(), "Hierarchy", "Object", this.getName()));
        }
        this.hasDimension = mIRDimension;
        mIRDimension.getHierarchyCollection().add(this);
    }

    public final MIRDimension getDimension() {
        return this.hasDimension;
    }

    public final boolean removeDimension() {
        if (this.hasDimension != null) {
            this.hasDimension.hierarchies.remove(this);
            if (this.hasDimension.hierarchies.isEmpty()) {
                this.hasDimension.hierarchies = null;
            }
            this.hasDimension = null;
            return true;
        }
        return false;
    }

    protected MIRObjectCollection<MIRHierarchyLevelAssociation> getHierarchyLevelAssociationCollection() {
        this.hierarchyLevelAssociations = MIRObjectCollections.get(this.hierarchyLevelAssociations, MIRSdkCollection.Type.OBJECT);
        return this.hierarchyLevelAssociations;
    }

    public SortedSet<MIRHierarchyLevelAssociation> getHierarchyLevelAssociations() {
        return MIRObjectCollections.sortedSet(this.hierarchyLevelAssociations);
    }

    public final void addHierarchyLevelAssociation(MIRHierarchyLevelAssociation mIRHierarchyLevelAssociation) {
        if (mIRHierarchyLevelAssociation == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("Hierarchy", "HierarchyLevelAssociation"));
        }
        if (mIRHierarchyLevelAssociation._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("Hierarchy", "HierarchyLevelAssociation"));
        }
        if (mIRHierarchyLevelAssociation.hasHierarchy != null) {
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("HierarchyLevelAssociation", "Hierarchy"));
        }
        if (this.hierarchyLevelAssociations != null && this.hierarchyLevelAssociations.contains(mIRHierarchyLevelAssociation)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("Hierarchy", "HierarchyLevelAssociation"));
        }
        this.getHierarchyLevelAssociationCollection().add(mIRHierarchyLevelAssociation);
        mIRHierarchyLevelAssociation.hasHierarchy = this;
    }

    public final int getHierarchyLevelAssociationCount() {
        if (this.hierarchyLevelAssociations != null) {
            return this.hierarchyLevelAssociations.size();
        }
        return 0;
    }

    public final boolean containsHierarchyLevelAssociation(MIRHierarchyLevelAssociation mIRHierarchyLevelAssociation) {
        if (mIRHierarchyLevelAssociation != null && this.hierarchyLevelAssociations != null) {
            return this.hierarchyLevelAssociations.contains(mIRHierarchyLevelAssociation);
        }
        return false;
    }

    public final MIRHierarchyLevelAssociation getHierarchyLevelAssociation(String string) {
        if (this.hierarchyLevelAssociations != null) {
            return this.hierarchyLevelAssociations.get(string);
        }
        return null;
    }

    public final Iterator<MIRHierarchyLevelAssociation> getHierarchyLevelAssociationIterator() {
        if (this.hierarchyLevelAssociations != null) {
            return this.hierarchyLevelAssociations.iterator();
        }
        return MIRObjectCollections.emptySet().iterator();
    }

    public final List<MIRHierarchyLevelAssociation> getHierarchyLevelAssociationByPosition() {
        if (this.hierarchyLevelAssociations != null) {
            ArrayList<MIRHierarchyLevelAssociation> arrayList = new ArrayList<MIRHierarchyLevelAssociation>();
            arrayList.addAll(this.hierarchyLevelAssociations.values());
            MIRObjectCollections.sort(arrayList, MIRHierarchyLevelAssociation.ByPosition);
            return arrayList;
        }
        return MIRObjectCollections.emptyList();
    }

    public final boolean removeHierarchyLevelAssociation(MIRHierarchyLevelAssociation mIRHierarchyLevelAssociation) {
        if (mIRHierarchyLevelAssociation != null && this.hierarchyLevelAssociations != null && this.hierarchyLevelAssociations.remove(mIRHierarchyLevelAssociation)) {
            mIRHierarchyLevelAssociation.hasHierarchy = null;
            if (this.hierarchyLevelAssociations.isEmpty()) {
                this.hierarchyLevelAssociations = null;
            }
            return true;
        }
        return false;
    }

    public final void removeHierarchyLevelAssociations() {
        if (this.hierarchyLevelAssociations != null) {
            for (MIRHierarchyLevelAssociation mIRHierarchyLevelAssociation : this.hierarchyLevelAssociations) {
                mIRHierarchyLevelAssociation.hasHierarchy = null;
            }
            this.hierarchyLevelAssociations = null;
        }
    }

    public final void addTopHierarchyLevelAssociation(MIRHierarchyLevelAssociation mIRHierarchyLevelAssociation) {
        if (mIRHierarchyLevelAssociation == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("Hierarchy", "TopHierarchyLevelAssociation"));
        }
        if (mIRHierarchyLevelAssociation._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("Hierarchy", "TopHierarchyLevelAssociation"));
        }
        if (this.hasTopHierarchyLevelAssociation != null) {
            if (this.hasTopHierarchyLevelAssociation._equals(mIRHierarchyLevelAssociation)) {
                throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("Hierarchy", "TopHierarchyLevelAssociation"));
            }
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("Hierarchy", "TopHierarchyLevelAssociation"));
        }
        if (mIRHierarchyLevelAssociation.hasTopOfHierarchy != null) {
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("HierarchyLevelAssociation", "TopOfHierarchy"));
        }
        this.hasTopHierarchyLevelAssociation = mIRHierarchyLevelAssociation;
        mIRHierarchyLevelAssociation.hasTopOfHierarchy = this;
    }

    public final MIRHierarchyLevelAssociation getTopHierarchyLevelAssociation() {
        return this.hasTopHierarchyLevelAssociation;
    }

    public final boolean removeTopHierarchyLevelAssociation() {
        if (this.hasTopHierarchyLevelAssociation != null) {
            this.hasTopHierarchyLevelAssociation.hasTopOfHierarchy = null;
            this.hasTopHierarchyLevelAssociation = null;
            return true;
        }
        return false;
    }

    public static MIRMetaClass staticGetMetaClass() {
        if (metaClass == null) {
            metaClass = new MIRMetaClass(MIRModelObject.staticGetMetaClass(), 90, "Hierarchy", false);
            new MIRMetaAttribute(metaClass, 191, "Type", "java.lang.Byte", MIRHierarchyType.class, (byte)0);
            new MIRMetaLink(metaClass, 357, "BottomHierarchyLevelAssociation", false, 0, 91, 358);
            new MIRMetaLink(metaClass, 140, "CubeDimensionAssociation", false, 0, 86, 80);
            new MIRMetaLink(metaClass, 138, "DefaultOfDimension", true, 0, 87, 92);
            new MIRMetaLink(metaClass, 137, "Dimension", true, 2, 87, 91);
            new MIRMetaLink(metaClass, 139, "HierarchyLevelAssociation", false, 3, 91, 141);
            new MIRMetaLink(metaClass, 355, "TopHierarchyLevelAssociation", true, 0, 91, 356);
        }
        return metaClass;
    }

    @Override
    public MIRMetaClass getMetaClass() {
        return MIRHierarchy.staticGetMetaClass();
    }

    @Override
    protected boolean _isValidName() {
        if (this.hasDimension != null && !this.hasDimension._allowName(this.hasDimension.hierarchies, this)) {
            return false;
        }
        return super._isValidName();
    }

    @Override
    protected void _rename(String string) {
        if (this.hasDimension != null) {
            this.hasDimension.hierarchies.rename(this, string);
        }
        super._rename(string);
    }
}

