/*
 * Decompiled with CFR 0.152.
 */
package MITI.sdk;

import MITI.messages.MIR.MIRSDK;
import MITI.sdk.MIRFolder;
import MITI.sdk.MIRFolderContentModel;
import MITI.sdk.MIRMetaClass;
import MITI.sdk.MIRMetaLink;
import MITI.sdk.MIRObject;
import MITI.sdk.MIRObjectCollections;
import MITI.sdk.MIRObjectRole;
import MITI.sdk.MIRRepositoryContentParameters;
import MITI.sdk.MIRRepositoryObject;
import MITI.sdk.MIRScheduledEvent;
import MITI.sdk.collections.MIRObjectCollection;
import MITI.sdk.collections.MIRSdkCollection;
import java.util.Iterator;
import java.util.SortedSet;

public abstract class MIRFolderContent
extends MIRRepositoryObject {
    protected transient MIRFolder hasFolder = null;
    protected transient MIRFolderContentModel hasFolderContentModel = null;
    protected transient MIRObjectCollection<MIRObjectRole> objectRoles = null;
    protected transient MIRObjectCollection<MIRFolder> referencedByFolders = null;
    protected transient MIRRepositoryContentParameters hasRepositoryContentParameters = null;
    protected transient MIRObjectCollection<MIRScheduledEvent> scheduledEventForScheduledEvents = null;
    private static MIRMetaClass metaClass = MIRFolderContent.staticGetMetaClass();

    @Override
    public short getElementType() {
        return 158;
    }

    @Override
    public MIRObject getParent() {
        if (this.hasFolder != null) {
            return this.hasFolder;
        }
        if (this.hasFolderContentModel != null) {
            return this.hasFolderContentModel;
        }
        return super.getParent();
    }

    @Override
    public int getParentCount() {
        return (this.hasFolder != null ? 1 : 0) + (this.hasFolderContentModel != null ? 1 : 0) + super.getParentCount();
    }

    public final void addFolder(MIRFolder mIRFolder) {
        if (mIRFolder == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("FolderContent", "Folder"));
        }
        if (mIRFolder._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("FolderContent", "Folder"));
        }
        if (this.hasFolder != null) {
            if (this.hasFolder._equals(mIRFolder)) {
                throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("FolderContent", "Folder"));
            }
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("FolderContent", "Folder"));
        }
        if (mIRFolder.folderContents != null && !mIRFolder._allowName(mIRFolder.folderContents, this)) {
            throw new IllegalArgumentException(MIRSDK.NAME_COLLISION.getMessage("Folder", mIRFolder.getPath(), "FolderContent", "Object", this.getName()));
        }
        this.hasFolder = mIRFolder;
        mIRFolder.getFolderContentCollection().add(this);
    }

    public final MIRFolder getFolder() {
        return this.hasFolder;
    }

    public final boolean removeFolder() {
        if (this.hasFolder != null) {
            this.hasFolder.folderContents.remove(this);
            if (this.hasFolder.folderContents.isEmpty()) {
                this.hasFolder.folderContents = null;
            }
            this.hasFolder = null;
            return true;
        }
        return false;
    }

    public final void addFolderContentModel(MIRFolderContentModel mIRFolderContentModel) {
        if (mIRFolderContentModel == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("FolderContent", "FolderContentModel"));
        }
        if (mIRFolderContentModel._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("FolderContent", "FolderContentModel"));
        }
        if (this.hasFolderContentModel != null) {
            if (this.hasFolderContentModel._equals(mIRFolderContentModel)) {
                throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("FolderContent", "FolderContentModel"));
            }
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("FolderContent", "FolderContentModel"));
        }
        if (mIRFolderContentModel.folderContents != null && !mIRFolderContentModel._allowName(mIRFolderContentModel.folderContents, this)) {
            throw new IllegalArgumentException(MIRSDK.NAME_COLLISION.getMessage("FolderContentModel", mIRFolderContentModel.getPath(), "FolderContent", "Object", this.getName()));
        }
        this.hasFolderContentModel = mIRFolderContentModel;
        mIRFolderContentModel.getFolderContentCollection().add(this);
    }

    public final MIRFolderContentModel getFolderContentModel() {
        return this.hasFolderContentModel;
    }

    public final boolean removeFolderContentModel() {
        if (this.hasFolderContentModel != null) {
            this.hasFolderContentModel.folderContents.remove(this);
            if (this.hasFolderContentModel.folderContents.isEmpty()) {
                this.hasFolderContentModel.folderContents = null;
            }
            this.hasFolderContentModel = null;
            return true;
        }
        return false;
    }

    protected MIRObjectCollection<MIRObjectRole> getObjectRoleCollection() {
        this.objectRoles = MIRObjectCollections.get(this.objectRoles, MIRSdkCollection.Type.OBJECT);
        return this.objectRoles;
    }

    public SortedSet<MIRObjectRole> getObjectRoles() {
        return MIRObjectCollections.sortedSet(this.objectRoles);
    }

    public final void addObjectRole(MIRObjectRole mIRObjectRole) {
        if (mIRObjectRole == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("FolderContent", "ObjectRole"));
        }
        if (mIRObjectRole._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("FolderContent", "ObjectRole"));
        }
        if (this.objectRoles != null && this.objectRoles.contains(mIRObjectRole)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("FolderContent", "ObjectRole"));
        }
        this.getObjectRoleCollection().add(mIRObjectRole);
        mIRObjectRole.getFolderContentCollection().add(this);
    }

    public final int getObjectRoleCount() {
        if (this.objectRoles != null) {
            return this.objectRoles.size();
        }
        return 0;
    }

    public final boolean containsObjectRole(MIRObjectRole mIRObjectRole) {
        if (mIRObjectRole != null && this.objectRoles != null) {
            return this.objectRoles.contains(mIRObjectRole);
        }
        return false;
    }

    public final MIRObjectRole getObjectRole(String string) {
        if (this.objectRoles != null) {
            return this.objectRoles.get(string);
        }
        return null;
    }

    public final Iterator<MIRObjectRole> getObjectRoleIterator() {
        if (this.objectRoles != null) {
            return this.objectRoles.iterator();
        }
        return MIRObjectCollections.emptySet().iterator();
    }

    public final boolean removeObjectRole(MIRObjectRole mIRObjectRole) {
        if (mIRObjectRole != null && this.objectRoles != null && this.objectRoles.remove(mIRObjectRole)) {
            mIRObjectRole.folderContents.remove(this);
            if (mIRObjectRole.folderContents.isEmpty()) {
                mIRObjectRole.folderContents = null;
            }
            if (this.objectRoles.isEmpty()) {
                this.objectRoles = null;
            }
            return true;
        }
        return false;
    }

    public final void removeObjectRoles() {
        if (this.objectRoles != null) {
            for (MIRObjectRole mIRObjectRole : this.objectRoles) {
                mIRObjectRole.folderContents.remove(this);
                if (!mIRObjectRole.folderContents.isEmpty()) continue;
                mIRObjectRole.folderContents = null;
            }
            this.objectRoles = null;
        }
    }

    protected MIRObjectCollection<MIRFolder> getReferencedByFolderCollection() {
        this.referencedByFolders = MIRObjectCollections.get(this.referencedByFolders, MIRSdkCollection.Type.OBJECT);
        return this.referencedByFolders;
    }

    public SortedSet<MIRFolder> getReferencedByFolders() {
        return MIRObjectCollections.sortedSet(this.referencedByFolders);
    }

    public final void addReferencedByFolder(MIRFolder mIRFolder) {
        if (mIRFolder == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("FolderContent", "ReferencedByFolder"));
        }
        if (mIRFolder._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("FolderContent", "ReferencedByFolder"));
        }
        if (this.referencedByFolders != null && this.referencedByFolders.contains(mIRFolder)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("FolderContent", "ReferencedByFolder"));
        }
        this.getReferencedByFolderCollection().add(mIRFolder);
        mIRFolder.getReferencedFolderContentCollection().add(this);
    }

    public final int getReferencedByFolderCount() {
        if (this.referencedByFolders != null) {
            return this.referencedByFolders.size();
        }
        return 0;
    }

    public final boolean containsReferencedByFolder(MIRFolder mIRFolder) {
        if (mIRFolder != null && this.referencedByFolders != null) {
            return this.referencedByFolders.contains(mIRFolder);
        }
        return false;
    }

    public final MIRFolder getReferencedByFolder(String string) {
        if (this.referencedByFolders != null) {
            return this.referencedByFolders.get(string);
        }
        return null;
    }

    public final Iterator<MIRFolder> getReferencedByFolderIterator() {
        if (this.referencedByFolders != null) {
            return this.referencedByFolders.iterator();
        }
        return MIRObjectCollections.emptySet().iterator();
    }

    public final boolean removeReferencedByFolder(MIRFolder mIRFolder) {
        if (mIRFolder != null && this.referencedByFolders != null && this.referencedByFolders.remove(mIRFolder)) {
            mIRFolder.referencedFolderContents.remove(this);
            if (mIRFolder.referencedFolderContents.isEmpty()) {
                mIRFolder.referencedFolderContents = null;
            }
            if (this.referencedByFolders.isEmpty()) {
                this.referencedByFolders = null;
            }
            return true;
        }
        return false;
    }

    public final void removeReferencedByFolders() {
        if (this.referencedByFolders != null) {
            for (MIRFolder mIRFolder : this.referencedByFolders) {
                mIRFolder.referencedFolderContents.remove(this);
                if (!mIRFolder.referencedFolderContents.isEmpty()) continue;
                mIRFolder.referencedFolderContents = null;
            }
            this.referencedByFolders = null;
        }
    }

    public final void addRepositoryContentParameters(MIRRepositoryContentParameters mIRRepositoryContentParameters) {
        if (mIRRepositoryContentParameters == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("FolderContent", "RepositoryContentParameters"));
        }
        if (mIRRepositoryContentParameters._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("FolderContent", "RepositoryContentParameters"));
        }
        if (this.hasRepositoryContentParameters != null) {
            if (this.hasRepositoryContentParameters._equals(mIRRepositoryContentParameters)) {
                throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("FolderContent", "RepositoryContentParameters"));
            }
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("FolderContent", "RepositoryContentParameters"));
        }
        if (mIRRepositoryContentParameters.hasFolderContent != null) {
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("RepositoryContentParameters", "FolderContent"));
        }
        this.hasRepositoryContentParameters = mIRRepositoryContentParameters;
        mIRRepositoryContentParameters.hasFolderContent = this;
    }

    public final MIRRepositoryContentParameters getRepositoryContentParameters() {
        return this.hasRepositoryContentParameters;
    }

    public final boolean removeRepositoryContentParameters() {
        if (this.hasRepositoryContentParameters != null) {
            this.hasRepositoryContentParameters.hasFolderContent = null;
            this.hasRepositoryContentParameters = null;
            return true;
        }
        return false;
    }

    protected MIRObjectCollection<MIRScheduledEvent> getScheduledEventForScheduledEventCollection() {
        this.scheduledEventForScheduledEvents = MIRObjectCollections.get(this.scheduledEventForScheduledEvents, MIRSdkCollection.Type.OBJECT);
        return this.scheduledEventForScheduledEvents;
    }

    public SortedSet<MIRScheduledEvent> getScheduledEventForScheduledEvents() {
        return MIRObjectCollections.sortedSet(this.scheduledEventForScheduledEvents);
    }

    public final void addScheduledEventForScheduledEvent(MIRScheduledEvent mIRScheduledEvent) {
        if (mIRScheduledEvent == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("FolderContent", "ScheduledEventForScheduledEvent"));
        }
        if (mIRScheduledEvent._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("FolderContent", "ScheduledEventForScheduledEvent"));
        }
        if (mIRScheduledEvent.hasMainObjectFolderContent != null) {
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("ScheduledEvent", "MainObjectFolderContent"));
        }
        if (this.scheduledEventForScheduledEvents != null && this.scheduledEventForScheduledEvents.contains(mIRScheduledEvent)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("FolderContent", "ScheduledEventForScheduledEvent"));
        }
        this.getScheduledEventForScheduledEventCollection().add(mIRScheduledEvent);
        mIRScheduledEvent.hasMainObjectFolderContent = this;
    }

    public final int getScheduledEventForScheduledEventCount() {
        if (this.scheduledEventForScheduledEvents != null) {
            return this.scheduledEventForScheduledEvents.size();
        }
        return 0;
    }

    public final boolean containsScheduledEventForScheduledEvent(MIRScheduledEvent mIRScheduledEvent) {
        if (mIRScheduledEvent != null && this.scheduledEventForScheduledEvents != null) {
            return this.scheduledEventForScheduledEvents.contains(mIRScheduledEvent);
        }
        return false;
    }

    public final MIRScheduledEvent getScheduledEventForScheduledEvent(String string) {
        if (this.scheduledEventForScheduledEvents != null) {
            return this.scheduledEventForScheduledEvents.get(string);
        }
        return null;
    }

    public final Iterator<MIRScheduledEvent> getScheduledEventForScheduledEventIterator() {
        if (this.scheduledEventForScheduledEvents != null) {
            return this.scheduledEventForScheduledEvents.iterator();
        }
        return MIRObjectCollections.emptySet().iterator();
    }

    public final boolean removeScheduledEventForScheduledEvent(MIRScheduledEvent mIRScheduledEvent) {
        if (mIRScheduledEvent != null && this.scheduledEventForScheduledEvents != null && this.scheduledEventForScheduledEvents.remove(mIRScheduledEvent)) {
            mIRScheduledEvent.hasMainObjectFolderContent = null;
            if (this.scheduledEventForScheduledEvents.isEmpty()) {
                this.scheduledEventForScheduledEvents = null;
            }
            return true;
        }
        return false;
    }

    public final void removeScheduledEventForScheduledEvents() {
        if (this.scheduledEventForScheduledEvents != null) {
            for (MIRScheduledEvent mIRScheduledEvent : this.scheduledEventForScheduledEvents) {
                mIRScheduledEvent.hasMainObjectFolderContent = null;
            }
            this.scheduledEventForScheduledEvents = null;
        }
    }

    public static MIRMetaClass staticGetMetaClass() {
        if (metaClass == null) {
            metaClass = new MIRMetaClass(MIRRepositoryObject.staticGetMetaClass(), 158, "FolderContent", true);
            new MIRMetaLink(metaClass, 895, "Folder", true, 2, 157, 893);
            new MIRMetaLink(metaClass, 889, "FolderContentModel", true, 2, 288, 890);
            new MIRMetaLink(metaClass, 1134, "ObjectRole", false, 0, 358, 1136);
            new MIRMetaLink(metaClass, 896, "ReferencedByFolder", false, 0, 157, 894);
            new MIRMetaLink(metaClass, 903, "RepositoryContentParameters", true, 3, 292, 904);
            new MIRMetaLink(metaClass, 472, "ScheduledEventForScheduledEvent", false, 1, 177, 471);
        }
        return metaClass;
    }

    @Override
    public MIRMetaClass getMetaClass() {
        return MIRFolderContent.staticGetMetaClass();
    }

    @Override
    protected boolean _isValidName() {
        if (this.hasFolder != null && !this.hasFolder._allowName(this.hasFolder.folderContents, this)) {
            return false;
        }
        if (this.hasFolderContentModel != null && !this.hasFolderContentModel._allowName(this.hasFolderContentModel.folderContents, this)) {
            return false;
        }
        return super._isValidName();
    }

    @Override
    protected void _rename(String string) {
        if (this.hasFolder != null) {
            this.hasFolder.folderContents.rename(this, string);
        }
        if (this.hasFolderContentModel != null) {
            this.hasFolderContentModel.folderContents.rename(this, string);
        }
        if (this.objectRoles != null) {
            for (MIRObjectRole mIRRepositoryObject : this.objectRoles) {
                mIRRepositoryObject.folderContents.rename(this, string);
            }
        }
        if (this.referencedByFolders != null) {
            for (MIRFolder mIRFolder : this.referencedByFolders) {
                mIRFolder.referencedFolderContents.rename(this, string);
            }
        }
        super._rename(string);
    }
}

