/*
 * Decompiled with CFR 0.152.
 */
package MITI.sdk;

import MITI.messages.MIR.MIRSDK;
import MITI.sdk.MIRClassifier;
import MITI.sdk.MIRCube;
import MITI.sdk.MIRMetaAttribute;
import MITI.sdk.MIRMetaClass;
import MITI.sdk.MIRMetaLink;
import MITI.sdk.MIRObjectCollections;
import MITI.sdk.MIR_Object;
import MITI.sdk.collections.MIRObjectCollection;
import MITI.sdk.collections.MIRSdkCollection;
import java.util.Iterator;
import java.util.SortedSet;

public class MIRFilter
extends MIRClassifier {
    protected transient boolean aHide = false;
    protected transient MIRObjectCollection<MIRCube> cubes = null;
    private static MIRMetaClass metaClass = MIRFilter.staticGetMetaClass();

    public MIRFilter() {
    }

    public MIRFilter(MIRFilter mIRFilter) {
        this.setFrom(mIRFilter);
    }

    @Override
    public Object clone() {
        return new MIRFilter(this);
    }

    @Override
    public short getElementType() {
        return 89;
    }

    @Override
    public void setFrom(MIR_Object mIR_Object) {
        super.setFrom(mIR_Object);
        if (mIR_Object.isInstanceOf((short)89)) {
            this.setHide(((MIRFilter)mIR_Object).getHide());
        }
    }

    public final void setHide(boolean bl) {
        this.aHide = bl;
    }

    public final boolean getHide() {
        return this.aHide;
    }

    protected MIRObjectCollection<MIRCube> getCubeCollection() {
        this.cubes = MIRObjectCollections.get(this.cubes, MIRSdkCollection.Type.OBJECT);
        return this.cubes;
    }

    public SortedSet<MIRCube> getCubes() {
        return MIRObjectCollections.sortedSet(this.cubes);
    }

    public final void addCube(MIRCube mIRCube) {
        if (mIRCube == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("Filter", "Cube"));
        }
        if (mIRCube._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("Filter", "Cube"));
        }
        if (this.cubes != null && this.cubes.contains(mIRCube)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("Filter", "Cube"));
        }
        this.getCubeCollection().add(mIRCube);
        mIRCube.getFilterCollection().add(this);
    }

    public final int getCubeCount() {
        if (this.cubes != null) {
            return this.cubes.size();
        }
        return 0;
    }

    public final boolean containsCube(MIRCube mIRCube) {
        if (mIRCube != null && this.cubes != null) {
            return this.cubes.contains(mIRCube);
        }
        return false;
    }

    public final MIRCube getCube(String string) {
        if (this.cubes != null) {
            return this.cubes.get(string);
        }
        return null;
    }

    public final Iterator<MIRCube> getCubeIterator() {
        if (this.cubes != null) {
            return this.cubes.iterator();
        }
        return MIRObjectCollections.emptySet().iterator();
    }

    public final boolean removeCube(MIRCube mIRCube) {
        if (mIRCube != null && this.cubes != null && this.cubes.remove(mIRCube)) {
            mIRCube.filters.remove(this);
            if (mIRCube.filters.isEmpty()) {
                mIRCube.filters = null;
            }
            if (this.cubes.isEmpty()) {
                this.cubes = null;
            }
            return true;
        }
        return false;
    }

    public final void removeCubes() {
        if (this.cubes != null) {
            for (MIRCube mIRCube : this.cubes) {
                mIRCube.filters.remove(this);
                if (!mIRCube.filters.isEmpty()) continue;
                mIRCube.filters = null;
            }
            this.cubes = null;
        }
    }

    public static MIRMetaClass staticGetMetaClass() {
        if (metaClass == null) {
            metaClass = new MIRMetaClass(MIRClassifier.staticGetMetaClass(), 89, "Filter", false);
            new MIRMetaAttribute(metaClass, 70, "Hide", "java.lang.Boolean", null, false);
            new MIRMetaLink(metaClass, 120, "Cube", false, 1, 85, 75);
        }
        return metaClass;
    }

    @Override
    public MIRMetaClass getMetaClass() {
        return MIRFilter.staticGetMetaClass();
    }

    @Override
    protected void _rename(String string) {
        if (this.cubes != null) {
            for (MIRCube mIRCube : this.cubes) {
                mIRCube.filters.rename(this, string);
            }
        }
        super._rename(string);
    }
}

