/*
 * Decompiled with CFR 0.152.
 */
package MITI.sdk;

import MITI.messages.MIR.MIRSDK;
import MITI.sdk.MIRClassifierMap;
import MITI.sdk.MIRElement;
import MITI.sdk.MIRExpressionNode;
import MITI.sdk.MIRFeatureMap;
import MITI.sdk.MIRMetaClass;
import MITI.sdk.MIRMetaLink;
import MITI.sdk.MIRObject;
import MITI.sdk.MIRObjectCollections;
import MITI.sdk.MIRStatementNode;
import MITI.sdk.collections.MIRObjectCollection;
import MITI.sdk.collections.MIRSdkCollection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;

public class MIRExpression
extends MIRElement {
    protected transient MIRClassifierMap hasClassifierMap = null;
    protected transient MIRFeatureMap hasFeatureMap = null;
    protected transient MIRObjectCollection<MIRStatementNode> statementNodes = null;
    private static MIRMetaClass metaClass = MIRExpression.staticGetMetaClass();

    public MIRExpression() {
    }

    public MIRExpression(MIRExpression mIRExpression) {
        this.setFrom(mIRExpression);
    }

    @Override
    public Object clone() {
        return new MIRExpression(this);
    }

    @Override
    public short getElementType() {
        return 112;
    }

    @Override
    public MIRObject getParent() {
        if (this.hasClassifierMap != null) {
            return this.hasClassifierMap;
        }
        if (this.hasFeatureMap != null) {
            return this.hasFeatureMap;
        }
        return super.getParent();
    }

    @Override
    public int getParentCount() {
        return (this.hasClassifierMap != null ? 1 : 0) + (this.hasFeatureMap != null ? 1 : 0) + super.getParentCount();
    }

    public final void addClassifierMap(MIRClassifierMap mIRClassifierMap) {
        if (mIRClassifierMap == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("Expression", "ClassifierMap"));
        }
        if (mIRClassifierMap._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("Expression", "ClassifierMap"));
        }
        if (this.hasClassifierMap != null) {
            if (this.hasClassifierMap._equals(mIRClassifierMap)) {
                throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("Expression", "ClassifierMap"));
            }
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("Expression", "ClassifierMap"));
        }
        if (mIRClassifierMap.hasExpression != null) {
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("ClassifierMap", "Expression"));
        }
        this.hasClassifierMap = mIRClassifierMap;
        mIRClassifierMap.hasExpression = this;
    }

    public final MIRClassifierMap getClassifierMap() {
        return this.hasClassifierMap;
    }

    public final boolean removeClassifierMap() {
        if (this.hasClassifierMap != null) {
            this.hasClassifierMap.hasExpression = null;
            this.hasClassifierMap = null;
            return true;
        }
        return false;
    }

    public final void addFeatureMap(MIRFeatureMap mIRFeatureMap) {
        if (mIRFeatureMap == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("Expression", "FeatureMap"));
        }
        if (mIRFeatureMap._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("Expression", "FeatureMap"));
        }
        if (this.hasFeatureMap != null) {
            if (this.hasFeatureMap._equals(mIRFeatureMap)) {
                throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("Expression", "FeatureMap"));
            }
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("Expression", "FeatureMap"));
        }
        if (mIRFeatureMap.hasExpression != null) {
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("FeatureMap", "Expression"));
        }
        this.hasFeatureMap = mIRFeatureMap;
        mIRFeatureMap.hasExpression = this;
    }

    public final MIRFeatureMap getFeatureMap() {
        return this.hasFeatureMap;
    }

    public final boolean removeFeatureMap() {
        if (this.hasFeatureMap != null) {
            this.hasFeatureMap.hasExpression = null;
            this.hasFeatureMap = null;
            return true;
        }
        return false;
    }

    protected MIRObjectCollection<MIRStatementNode> getStatementNodeCollection() {
        this.statementNodes = MIRObjectCollections.get(this.statementNodes, MIRSdkCollection.Type.OBJECT);
        return this.statementNodes;
    }

    public SortedSet<MIRStatementNode> getStatementNodes() {
        return MIRObjectCollections.sortedSet(this.statementNodes);
    }

    public final void addStatementNode(MIRStatementNode mIRStatementNode) {
        if (mIRStatementNode == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("Expression", "StatementNode"));
        }
        if (mIRStatementNode._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("Expression", "StatementNode"));
        }
        if (mIRStatementNode.hasExpression != null) {
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("StatementNode", "Expression"));
        }
        if (this.statementNodes != null && this.statementNodes.contains(mIRStatementNode)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("Expression", "StatementNode"));
        }
        this.getStatementNodeCollection().add(mIRStatementNode);
        mIRStatementNode.hasExpression = this;
    }

    public final int getStatementNodeCount() {
        if (this.statementNodes != null) {
            return this.statementNodes.size();
        }
        return 0;
    }

    public final boolean containsStatementNode(MIRStatementNode mIRStatementNode) {
        if (mIRStatementNode != null && this.statementNodes != null) {
            return this.statementNodes.contains(mIRStatementNode);
        }
        return false;
    }

    public final MIRStatementNode getStatementNode(String string) {
        if (this.statementNodes != null) {
            return this.statementNodes.get(string);
        }
        return null;
    }

    public final Iterator<MIRStatementNode> getStatementNodeIterator() {
        if (this.statementNodes != null) {
            return this.statementNodes.iterator();
        }
        return MIRObjectCollections.emptySet().iterator();
    }

    public final List<MIRStatementNode> getStatementNodeByPosition() {
        if (this.statementNodes != null) {
            ArrayList<MIRStatementNode> arrayList = new ArrayList<MIRStatementNode>();
            arrayList.addAll(this.statementNodes.values());
            MIRObjectCollections.sort(arrayList, MIRExpressionNode.ByPosition);
            return arrayList;
        }
        return MIRObjectCollections.emptyList();
    }

    public final boolean removeStatementNode(MIRStatementNode mIRStatementNode) {
        if (mIRStatementNode != null && this.statementNodes != null && this.statementNodes.remove(mIRStatementNode)) {
            mIRStatementNode.hasExpression = null;
            if (this.statementNodes.isEmpty()) {
                this.statementNodes = null;
            }
            return true;
        }
        return false;
    }

    public final void removeStatementNodes() {
        if (this.statementNodes != null) {
            for (MIRStatementNode mIRStatementNode : this.statementNodes) {
                mIRStatementNode.hasExpression = null;
            }
            this.statementNodes = null;
        }
    }

    public static MIRMetaClass staticGetMetaClass() {
        if (metaClass == null) {
            metaClass = new MIRMetaClass(MIRElement.staticGetMetaClass(), 112, "Expression", false);
            new MIRMetaLink(metaClass, 287, "ClassifierMap", true, 2, 76, 270);
            new MIRMetaLink(metaClass, 288, "FeatureMap", true, 2, 78, 300);
            new MIRMetaLink(metaClass, 286, "StatementNode", false, 3, 134, 324);
        }
        return metaClass;
    }

    @Override
    public MIRMetaClass getMetaClass() {
        return MIRExpression.staticGetMetaClass();
    }
}

