/*
 * Decompiled with CFR 0.152.
 */
package MITI.sdk;

import MITI.messages.MIR.MIRSDK;
import MITI.sdk.MIRConnectionElement;
import MITI.sdk.MIRElementMap;
import MITI.sdk.MIRElementNamePart;
import MITI.sdk.MIRElementNode;
import MITI.sdk.MIRMetaAttribute;
import MITI.sdk.MIRMetaClass;
import MITI.sdk.MIRMetaLink;
import MITI.sdk.MIRNote;
import MITI.sdk.MIRObject;
import MITI.sdk.MIRObjectCollections;
import MITI.sdk.MIROperationNode;
import MITI.sdk.MIRPropertyValue;
import MITI.sdk.MIRUsedParameter;
import MITI.sdk.MIR_Object;
import MITI.sdk.collections.MIRObjectCollection;
import MITI.sdk.collections.MIRSdkCollection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;

public abstract class MIRElement
extends MIRObject {
    protected transient String aDescription = "";
    protected transient String aNativeId = "";
    protected transient String aNativeType = "";
    protected transient MIRObjectCollection<MIRElementMap> clientOfElementMaps = null;
    protected transient MIRConnectionElement hasDefinedByConnectionElement = null;
    protected transient MIRObjectCollection<MIRElementNode> elementNodes = null;
    protected transient MIRObjectCollection<MIRNote> notes = null;
    protected transient MIRObjectCollection<MIRPropertyValue> propertyValues = null;
    protected transient MIRObjectCollection<MIRElementNamePart> referencedByElementNameParts = null;
    protected transient MIRObjectCollection<MIROperationNode> referencedByOperationNodes = null;
    protected transient MIRObjectCollection<MIRElementMap> supplierOfElementMaps = null;
    protected transient MIRObjectCollection<MIRUsedParameter> usesUsedParameters = null;
    private static MIRMetaClass metaClass = MIRElement.staticGetMetaClass();

    @Override
    public short getElementType() {
        return 0;
    }

    @Override
    public void setFrom(MIR_Object mIR_Object) {
        super.setFrom(mIR_Object);
        if (mIR_Object.isInstanceOf((short)0)) {
            this.setDescription(((MIRElement)mIR_Object).getDescription());
            this.setNativeId(((MIRElement)mIR_Object).getNativeId());
            this.setNativeType(((MIRElement)mIR_Object).getNativeType());
            if (((MIRElement)mIR_Object).getNoteCount() > 0) {
                Iterator<MIRNote> iterator = ((MIRElement)mIR_Object).getNoteIterator();
                while (iterator.hasNext()) {
                    this.addNote(new MIRNote(iterator.next()));
                }
            }
        }
    }

    public final void setDescription(String string) {
        this.aDescription = string == null ? "" : string;
    }

    public final String getDescription() {
        return this.aDescription;
    }

    public final void setNativeId(String string) {
        this.aNativeId = string == null ? "" : string;
    }

    public final String getNativeId() {
        return this.aNativeId;
    }

    public final void setNativeType(String string) {
        this.aNativeType = string == null ? "" : string;
    }

    public final String getNativeType() {
        return this.aNativeType;
    }

    protected MIRObjectCollection<MIRElementMap> getClientOfElementMapCollection() {
        this.clientOfElementMaps = MIRObjectCollections.get(this.clientOfElementMaps, MIRSdkCollection.Type.OBJECT);
        return this.clientOfElementMaps;
    }

    public SortedSet<MIRElementMap> getClientOfElementMaps() {
        return MIRObjectCollections.sortedSet(this.clientOfElementMaps);
    }

    public final void addClientOfElementMap(MIRElementMap mIRElementMap) {
        if (mIRElementMap == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("Element", "ClientOfElementMap"));
        }
        if (mIRElementMap._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("Element", "ClientOfElementMap"));
        }
        if (mIRElementMap.hasClientElement != null) {
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("ElementMap", "ClientElement"));
        }
        if (this.clientOfElementMaps != null && this.clientOfElementMaps.contains(mIRElementMap)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("Element", "ClientOfElementMap"));
        }
        this.getClientOfElementMapCollection().add(mIRElementMap);
        mIRElementMap.hasClientElement = this;
    }

    public final int getClientOfElementMapCount() {
        if (this.clientOfElementMaps != null) {
            return this.clientOfElementMaps.size();
        }
        return 0;
    }

    public final boolean containsClientOfElementMap(MIRElementMap mIRElementMap) {
        if (mIRElementMap != null && this.clientOfElementMaps != null) {
            return this.clientOfElementMaps.contains(mIRElementMap);
        }
        return false;
    }

    public final MIRElementMap getClientOfElementMap(String string) {
        if (this.clientOfElementMaps != null) {
            return this.clientOfElementMaps.get(string);
        }
        return null;
    }

    public final Iterator<MIRElementMap> getClientOfElementMapIterator() {
        if (this.clientOfElementMaps != null) {
            return this.clientOfElementMaps.iterator();
        }
        return MIRObjectCollections.emptySet().iterator();
    }

    public final boolean removeClientOfElementMap(MIRElementMap mIRElementMap) {
        if (mIRElementMap != null && this.clientOfElementMaps != null && this.clientOfElementMaps.remove(mIRElementMap)) {
            mIRElementMap.hasClientElement = null;
            if (this.clientOfElementMaps.isEmpty()) {
                this.clientOfElementMaps = null;
            }
            return true;
        }
        return false;
    }

    public final void removeClientOfElementMaps() {
        if (this.clientOfElementMaps != null) {
            for (MIRElementMap mIRElementMap : this.clientOfElementMaps) {
                mIRElementMap.hasClientElement = null;
            }
            this.clientOfElementMaps = null;
        }
    }

    public final void addDefinedByConnectionElement(MIRConnectionElement mIRConnectionElement) {
        if (mIRConnectionElement == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("Element", "DefinedByConnectionElement"));
        }
        if (mIRConnectionElement._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("Element", "DefinedByConnectionElement"));
        }
        if (this.hasDefinedByConnectionElement != null) {
            if (this.hasDefinedByConnectionElement._equals(mIRConnectionElement)) {
                throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("Element", "DefinedByConnectionElement"));
            }
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("Element", "DefinedByConnectionElement"));
        }
        this.hasDefinedByConnectionElement = mIRConnectionElement;
        mIRConnectionElement.getDefinedElementCollection().add(this);
    }

    public final MIRConnectionElement getDefinedByConnectionElement() {
        return this.hasDefinedByConnectionElement;
    }

    public final boolean removeDefinedByConnectionElement() {
        if (this.hasDefinedByConnectionElement != null) {
            this.hasDefinedByConnectionElement.definedElements.remove(this);
            if (this.hasDefinedByConnectionElement.definedElements.isEmpty()) {
                this.hasDefinedByConnectionElement.definedElements = null;
            }
            this.hasDefinedByConnectionElement = null;
            return true;
        }
        return false;
    }

    protected MIRObjectCollection<MIRElementNode> getElementNodeCollection() {
        this.elementNodes = MIRObjectCollections.get(this.elementNodes, MIRSdkCollection.Type.OBJECT);
        return this.elementNodes;
    }

    public SortedSet<MIRElementNode> getElementNodes() {
        return MIRObjectCollections.sortedSet(this.elementNodes);
    }

    public final void addElementNode(MIRElementNode mIRElementNode) {
        if (mIRElementNode == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("Element", "ElementNode"));
        }
        if (mIRElementNode._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("Element", "ElementNode"));
        }
        if (mIRElementNode.hasElement != null) {
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("ElementNode", "Element"));
        }
        if (this.elementNodes != null && this.elementNodes.contains(mIRElementNode)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("Element", "ElementNode"));
        }
        this.getElementNodeCollection().add(mIRElementNode);
        mIRElementNode.hasElement = this;
    }

    public final int getElementNodeCount() {
        if (this.elementNodes != null) {
            return this.elementNodes.size();
        }
        return 0;
    }

    public final boolean containsElementNode(MIRElementNode mIRElementNode) {
        if (mIRElementNode != null && this.elementNodes != null) {
            return this.elementNodes.contains(mIRElementNode);
        }
        return false;
    }

    public final MIRElementNode getElementNode(String string) {
        if (this.elementNodes != null) {
            return this.elementNodes.get(string);
        }
        return null;
    }

    public final Iterator<MIRElementNode> getElementNodeIterator() {
        if (this.elementNodes != null) {
            return this.elementNodes.iterator();
        }
        return MIRObjectCollections.emptySet().iterator();
    }

    public final boolean removeElementNode(MIRElementNode mIRElementNode) {
        if (mIRElementNode != null && this.elementNodes != null && this.elementNodes.remove(mIRElementNode)) {
            mIRElementNode.hasElement = null;
            if (this.elementNodes.isEmpty()) {
                this.elementNodes = null;
            }
            return true;
        }
        return false;
    }

    public final void removeElementNodes() {
        if (this.elementNodes != null) {
            for (MIRElementNode mIRElementNode : this.elementNodes) {
                mIRElementNode.hasElement = null;
            }
            this.elementNodes = null;
        }
    }

    protected MIRObjectCollection<MIRNote> getNoteCollection() {
        this.notes = MIRObjectCollections.get(this.notes, MIRSdkCollection.Type.OBJECT);
        return this.notes;
    }

    public SortedSet<MIRNote> getNotes() {
        return MIRObjectCollections.sortedSet(this.notes);
    }

    public final void addNote(MIRNote mIRNote) {
        if (mIRNote == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("Element", "Note"));
        }
        if (mIRNote._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("Element", "Note"));
        }
        if (mIRNote.hasElement != null) {
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("Note", "Element"));
        }
        if (this.notes != null && this.notes.contains(mIRNote)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("Element", "Note"));
        }
        this.getNoteCollection().add(mIRNote);
        mIRNote.hasElement = this;
    }

    public final int getNoteCount() {
        if (this.notes != null) {
            return this.notes.size();
        }
        return 0;
    }

    public final boolean containsNote(MIRNote mIRNote) {
        if (mIRNote != null && this.notes != null) {
            return this.notes.contains(mIRNote);
        }
        return false;
    }

    public final MIRNote getNote(String string) {
        if (this.notes != null) {
            return this.notes.get(string);
        }
        return null;
    }

    public final Iterator<MIRNote> getNoteIterator() {
        if (this.notes != null) {
            return this.notes.iterator();
        }
        return MIRObjectCollections.emptySet().iterator();
    }

    public final List<MIRNote> getNoteByPosition() {
        if (this.notes != null) {
            ArrayList<MIRNote> arrayList = new ArrayList<MIRNote>();
            arrayList.addAll(this.notes.values());
            MIRObjectCollections.sort(arrayList, MIRNote.ByPosition);
            return arrayList;
        }
        return MIRObjectCollections.emptyList();
    }

    public final boolean removeNote(MIRNote mIRNote) {
        if (mIRNote != null && this.notes != null && this.notes.remove(mIRNote)) {
            mIRNote.hasElement = null;
            if (this.notes.isEmpty()) {
                this.notes = null;
            }
            return true;
        }
        return false;
    }

    public final void removeNotes() {
        if (this.notes != null) {
            for (MIRNote mIRNote : this.notes) {
                mIRNote.hasElement = null;
            }
            this.notes = null;
        }
    }

    protected MIRObjectCollection<MIRPropertyValue> getPropertyValueCollection() {
        this.propertyValues = MIRObjectCollections.get(this.propertyValues, MIRSdkCollection.Type.OBJECT);
        return this.propertyValues;
    }

    public SortedSet<MIRPropertyValue> getPropertyValues() {
        return MIRObjectCollections.sortedSet(this.propertyValues);
    }

    public final void addPropertyValue(MIRPropertyValue mIRPropertyValue) {
        if (mIRPropertyValue == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("Element", "PropertyValue"));
        }
        if (mIRPropertyValue._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("Element", "PropertyValue"));
        }
        if (mIRPropertyValue.hasElement != null) {
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("PropertyValue", "Element"));
        }
        if (this.propertyValues != null && this.propertyValues.contains(mIRPropertyValue)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("Element", "PropertyValue"));
        }
        this.getPropertyValueCollection().add(mIRPropertyValue);
        mIRPropertyValue.hasElement = this;
    }

    public final int getPropertyValueCount() {
        if (this.propertyValues != null) {
            return this.propertyValues.size();
        }
        return 0;
    }

    public final boolean containsPropertyValue(MIRPropertyValue mIRPropertyValue) {
        if (mIRPropertyValue != null && this.propertyValues != null) {
            return this.propertyValues.contains(mIRPropertyValue);
        }
        return false;
    }

    public final MIRPropertyValue getPropertyValue(String string) {
        if (this.propertyValues != null) {
            return this.propertyValues.get(string);
        }
        return null;
    }

    public final Iterator<MIRPropertyValue> getPropertyValueIterator() {
        if (this.propertyValues != null) {
            return this.propertyValues.iterator();
        }
        return MIRObjectCollections.emptySet().iterator();
    }

    public final boolean removePropertyValue(MIRPropertyValue mIRPropertyValue) {
        if (mIRPropertyValue != null && this.propertyValues != null && this.propertyValues.remove(mIRPropertyValue)) {
            mIRPropertyValue.hasElement = null;
            if (this.propertyValues.isEmpty()) {
                this.propertyValues = null;
            }
            return true;
        }
        return false;
    }

    public final void removePropertyValues() {
        if (this.propertyValues != null) {
            for (MIRPropertyValue mIRPropertyValue : this.propertyValues) {
                mIRPropertyValue.hasElement = null;
            }
            this.propertyValues = null;
        }
    }

    protected MIRObjectCollection<MIRElementNamePart> getReferencedByElementNamePartCollection() {
        this.referencedByElementNameParts = MIRObjectCollections.get(this.referencedByElementNameParts, MIRSdkCollection.Type.OBJECT);
        return this.referencedByElementNameParts;
    }

    public SortedSet<MIRElementNamePart> getReferencedByElementNameParts() {
        return MIRObjectCollections.sortedSet(this.referencedByElementNameParts);
    }

    public final void addReferencedByElementNamePart(MIRElementNamePart mIRElementNamePart) {
        if (mIRElementNamePart == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("Element", "ReferencedByElementNamePart"));
        }
        if (mIRElementNamePart._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("Element", "ReferencedByElementNamePart"));
        }
        if (this.referencedByElementNameParts != null && this.referencedByElementNameParts.contains(mIRElementNamePart)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("Element", "ReferencedByElementNamePart"));
        }
        this.getReferencedByElementNamePartCollection().add(mIRElementNamePart);
        mIRElementNamePart.getReferencedElementCollection().add(this);
    }

    public final int getReferencedByElementNamePartCount() {
        if (this.referencedByElementNameParts != null) {
            return this.referencedByElementNameParts.size();
        }
        return 0;
    }

    public final boolean containsReferencedByElementNamePart(MIRElementNamePart mIRElementNamePart) {
        if (mIRElementNamePart != null && this.referencedByElementNameParts != null) {
            return this.referencedByElementNameParts.contains(mIRElementNamePart);
        }
        return false;
    }

    public final MIRElementNamePart getReferencedByElementNamePart(String string) {
        if (this.referencedByElementNameParts != null) {
            return this.referencedByElementNameParts.get(string);
        }
        return null;
    }

    public final Iterator<MIRElementNamePart> getReferencedByElementNamePartIterator() {
        if (this.referencedByElementNameParts != null) {
            return this.referencedByElementNameParts.iterator();
        }
        return MIRObjectCollections.emptySet().iterator();
    }

    public final boolean removeReferencedByElementNamePart(MIRElementNamePart mIRElementNamePart) {
        if (mIRElementNamePart != null && this.referencedByElementNameParts != null && this.referencedByElementNameParts.remove(mIRElementNamePart)) {
            mIRElementNamePart.referencedElements.remove(this);
            if (mIRElementNamePart.referencedElements.isEmpty()) {
                mIRElementNamePart.referencedElements = null;
            }
            if (this.referencedByElementNameParts.isEmpty()) {
                this.referencedByElementNameParts = null;
            }
            return true;
        }
        return false;
    }

    public final void removeReferencedByElementNameParts() {
        if (this.referencedByElementNameParts != null) {
            for (MIRElementNamePart mIRElementNamePart : this.referencedByElementNameParts) {
                mIRElementNamePart.referencedElements.remove(this);
                if (!mIRElementNamePart.referencedElements.isEmpty()) continue;
                mIRElementNamePart.referencedElements = null;
            }
            this.referencedByElementNameParts = null;
        }
    }

    protected MIRObjectCollection<MIROperationNode> getReferencedByOperationNodeCollection() {
        this.referencedByOperationNodes = MIRObjectCollections.get(this.referencedByOperationNodes, MIRSdkCollection.Type.OBJECT);
        return this.referencedByOperationNodes;
    }

    public SortedSet<MIROperationNode> getReferencedByOperationNodes() {
        return MIRObjectCollections.sortedSet(this.referencedByOperationNodes);
    }

    public final void addReferencedByOperationNode(MIROperationNode mIROperationNode) {
        if (mIROperationNode == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("Element", "ReferencedByOperationNode"));
        }
        if (mIROperationNode._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("Element", "ReferencedByOperationNode"));
        }
        if (this.referencedByOperationNodes != null && this.referencedByOperationNodes.contains(mIROperationNode)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("Element", "ReferencedByOperationNode"));
        }
        this.getReferencedByOperationNodeCollection().add(mIROperationNode);
        mIROperationNode.getReferencedElementCollection().add(this);
    }

    public final int getReferencedByOperationNodeCount() {
        if (this.referencedByOperationNodes != null) {
            return this.referencedByOperationNodes.size();
        }
        return 0;
    }

    public final boolean containsReferencedByOperationNode(MIROperationNode mIROperationNode) {
        if (mIROperationNode != null && this.referencedByOperationNodes != null) {
            return this.referencedByOperationNodes.contains(mIROperationNode);
        }
        return false;
    }

    public final MIROperationNode getReferencedByOperationNode(String string) {
        if (this.referencedByOperationNodes != null) {
            return this.referencedByOperationNodes.get(string);
        }
        return null;
    }

    public final Iterator<MIROperationNode> getReferencedByOperationNodeIterator() {
        if (this.referencedByOperationNodes != null) {
            return this.referencedByOperationNodes.iterator();
        }
        return MIRObjectCollections.emptySet().iterator();
    }

    public final boolean removeReferencedByOperationNode(MIROperationNode mIROperationNode) {
        if (mIROperationNode != null && this.referencedByOperationNodes != null && this.referencedByOperationNodes.remove(mIROperationNode)) {
            mIROperationNode.referencedElements.remove(this);
            if (mIROperationNode.referencedElements.isEmpty()) {
                mIROperationNode.referencedElements = null;
            }
            if (this.referencedByOperationNodes.isEmpty()) {
                this.referencedByOperationNodes = null;
            }
            return true;
        }
        return false;
    }

    public final void removeReferencedByOperationNodes() {
        if (this.referencedByOperationNodes != null) {
            for (MIROperationNode mIROperationNode : this.referencedByOperationNodes) {
                mIROperationNode.referencedElements.remove(this);
                if (!mIROperationNode.referencedElements.isEmpty()) continue;
                mIROperationNode.referencedElements = null;
            }
            this.referencedByOperationNodes = null;
        }
    }

    protected MIRObjectCollection<MIRElementMap> getSupplierOfElementMapCollection() {
        this.supplierOfElementMaps = MIRObjectCollections.get(this.supplierOfElementMaps, MIRSdkCollection.Type.OBJECT);
        return this.supplierOfElementMaps;
    }

    public SortedSet<MIRElementMap> getSupplierOfElementMaps() {
        return MIRObjectCollections.sortedSet(this.supplierOfElementMaps);
    }

    public final void addSupplierOfElementMap(MIRElementMap mIRElementMap) {
        if (mIRElementMap == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("Element", "SupplierOfElementMap"));
        }
        if (mIRElementMap._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("Element", "SupplierOfElementMap"));
        }
        if (this.supplierOfElementMaps != null && this.supplierOfElementMaps.contains(mIRElementMap)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("Element", "SupplierOfElementMap"));
        }
        this.getSupplierOfElementMapCollection().add(mIRElementMap);
        mIRElementMap.getSupplierElementCollection().add(this);
    }

    public final int getSupplierOfElementMapCount() {
        if (this.supplierOfElementMaps != null) {
            return this.supplierOfElementMaps.size();
        }
        return 0;
    }

    public final boolean containsSupplierOfElementMap(MIRElementMap mIRElementMap) {
        if (mIRElementMap != null && this.supplierOfElementMaps != null) {
            return this.supplierOfElementMaps.contains(mIRElementMap);
        }
        return false;
    }

    public final MIRElementMap getSupplierOfElementMap(String string) {
        if (this.supplierOfElementMaps != null) {
            return this.supplierOfElementMaps.get(string);
        }
        return null;
    }

    public final Iterator<MIRElementMap> getSupplierOfElementMapIterator() {
        if (this.supplierOfElementMaps != null) {
            return this.supplierOfElementMaps.iterator();
        }
        return MIRObjectCollections.emptySet().iterator();
    }

    public final boolean removeSupplierOfElementMap(MIRElementMap mIRElementMap) {
        if (mIRElementMap != null && this.supplierOfElementMaps != null && this.supplierOfElementMaps.remove(mIRElementMap)) {
            mIRElementMap.supplierElements.remove(this);
            if (mIRElementMap.supplierElements.isEmpty()) {
                mIRElementMap.supplierElements = null;
            }
            if (this.supplierOfElementMaps.isEmpty()) {
                this.supplierOfElementMaps = null;
            }
            return true;
        }
        return false;
    }

    public final void removeSupplierOfElementMaps() {
        if (this.supplierOfElementMaps != null) {
            for (MIRElementMap mIRElementMap : this.supplierOfElementMaps) {
                mIRElementMap.supplierElements.remove(this);
                if (!mIRElementMap.supplierElements.isEmpty()) continue;
                mIRElementMap.supplierElements = null;
            }
            this.supplierOfElementMaps = null;
        }
    }

    protected MIRObjectCollection<MIRUsedParameter> getUsesUsedParameterCollection() {
        this.usesUsedParameters = MIRObjectCollections.get(this.usesUsedParameters, MIRSdkCollection.Type.OBJECT);
        return this.usesUsedParameters;
    }

    public SortedSet<MIRUsedParameter> getUsesUsedParameters() {
        return MIRObjectCollections.sortedSet(this.usesUsedParameters);
    }

    public final void addUsesUsedParameter(MIRUsedParameter mIRUsedParameter) {
        if (mIRUsedParameter == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("Element", "UsesUsedParameter"));
        }
        if (mIRUsedParameter._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("Element", "UsesUsedParameter"));
        }
        if (this.usesUsedParameters != null && this.usesUsedParameters.contains(mIRUsedParameter)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("Element", "UsesUsedParameter"));
        }
        this.getUsesUsedParameterCollection().add(mIRUsedParameter);
        mIRUsedParameter.getUsedByElementCollection().add(this);
    }

    public final int getUsesUsedParameterCount() {
        if (this.usesUsedParameters != null) {
            return this.usesUsedParameters.size();
        }
        return 0;
    }

    public final boolean containsUsesUsedParameter(MIRUsedParameter mIRUsedParameter) {
        if (mIRUsedParameter != null && this.usesUsedParameters != null) {
            return this.usesUsedParameters.contains(mIRUsedParameter);
        }
        return false;
    }

    public final MIRUsedParameter getUsesUsedParameter(String string) {
        if (this.usesUsedParameters != null) {
            return this.usesUsedParameters.get(string);
        }
        return null;
    }

    public final Iterator<MIRUsedParameter> getUsesUsedParameterIterator() {
        if (this.usesUsedParameters != null) {
            return this.usesUsedParameters.iterator();
        }
        return MIRObjectCollections.emptySet().iterator();
    }

    public final boolean removeUsesUsedParameter(MIRUsedParameter mIRUsedParameter) {
        if (mIRUsedParameter != null && this.usesUsedParameters != null && this.usesUsedParameters.remove(mIRUsedParameter)) {
            mIRUsedParameter.usedByElements.remove(this);
            if (mIRUsedParameter.usedByElements.isEmpty()) {
                mIRUsedParameter.usedByElements = null;
            }
            if (this.usesUsedParameters.isEmpty()) {
                this.usesUsedParameters = null;
            }
            return true;
        }
        return false;
    }

    public final void removeUsesUsedParameters() {
        if (this.usesUsedParameters != null) {
            for (MIRUsedParameter mIRUsedParameter : this.usesUsedParameters) {
                mIRUsedParameter.usedByElements.remove(this);
                if (!mIRUsedParameter.usedByElements.isEmpty()) continue;
                mIRUsedParameter.usedByElements = null;
            }
            this.usesUsedParameters = null;
        }
    }

    public static MIRMetaClass staticGetMetaClass() {
        if (metaClass == null) {
            metaClass = new MIRMetaClass(MIRObject.staticGetMetaClass(), 0, "Element", true);
            new MIRMetaAttribute(metaClass, 65, "Description", "java.lang.String", null, "");
            new MIRMetaAttribute(metaClass, 206, "NativeId", "java.lang.String", null, "");
            new MIRMetaAttribute(metaClass, 207, "NativeType", "java.lang.String", null, "");
            new MIRMetaLink(metaClass, 578, "ClientOfElementMap", false, 3, 197, 577);
            new MIRMetaLink(metaClass, 1035, "DefinedByConnectionElement", true, 1, 317, 1034);
            new MIRMetaLink(metaClass, 303, "ElementNode", false, 0, 111, 284);
            new MIRMetaLink(metaClass, 102, "Note", false, 3, 1, 191);
            new MIRMetaLink(metaClass, 103, "PropertyValue", false, 3, 71, 223);
            new MIRMetaLink(metaClass, 281, "ReferencedByElementNamePart", false, 0, 110, 283);
            new MIRMetaLink(metaClass, 539, "ReferencedByOperationNode", false, 0, 114, 540);
            new MIRMetaLink(metaClass, 576, "SupplierOfElementMap", false, 1, 197, 575);
            new MIRMetaLink(metaClass, 909, "UsesUsedParameter", false, 0, 268, 910);
        }
        return metaClass;
    }

    @Override
    public MIRMetaClass getMetaClass() {
        return MIRElement.staticGetMetaClass();
    }

    @Override
    protected void _rename(String string) {
        if (this.hasDefinedByConnectionElement != null) {
            this.hasDefinedByConnectionElement.definedElements.rename(this, string);
        }
        if (this.referencedByElementNameParts != null) {
            for (MIRElementNamePart mIRObject : this.referencedByElementNameParts) {
                mIRObject.referencedElements.rename(this, string);
            }
        }
        if (this.referencedByOperationNodes != null) {
            for (MIROperationNode mIROperationNode : this.referencedByOperationNodes) {
                mIROperationNode.referencedElements.rename(this, string);
            }
        }
        if (this.supplierOfElementMaps != null) {
            for (MIRElementMap mIRElementMap : this.supplierOfElementMaps) {
                mIRElementMap.supplierElements.rename(this, string);
            }
        }
        if (this.usesUsedParameters != null) {
            for (MIRUsedParameter mIRUsedParameter : this.usesUsedParameters) {
                mIRUsedParameter.usedByElements.rename(this, string);
            }
        }
        super._rename(string);
    }
}

