/*
 * Decompiled with CFR 0.152.
 */
package MITI.sdk;

import MITI.util.DateUtil;
import java.text.FieldPosition;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class MIRDate {
    public static final MIRDate NONE = new MIRDate();
    private Calendar timestamp = null;
    private static final String SIMPLE_FORMAT = "yyyy-MM-dd HH:mm:ss";

    public static MIRDate getCurrentDate() {
        MIRDate mIRDate = new MIRDate();
        mIRDate.timestamp = DateUtil.getUtcCalendar();
        mIRDate.timestamp.setTimeInMillis(System.currentTimeMillis());
        return mIRDate;
    }

    public MIRDate() {
        this.timestamp = null;
    }

    public MIRDate(Calendar calendar) {
        this.set(calendar);
    }

    public MIRDate(Date date) {
        this.set(date);
    }

    public MIRDate(long l) {
        this.set(l);
    }

    public MIRDate(String string) {
        this.set(string);
    }

    public boolean isNull() {
        return this.timestamp == null;
    }

    public Calendar get() {
        return this.timestamp;
    }

    public int compareTo(MIRDate mIRDate) {
        return this.compareTo(mIRDate.timestamp);
    }

    public int compareTo(Calendar calendar) {
        long l;
        long l2 = this.timestamp == null ? 0L : this.timestamp.getTimeInMillis() / 1000L;
        long l3 = l = calendar == null ? 0L : calendar.getTimeInMillis() / 1000L;
        if (l2 > l) {
            return 1;
        }
        if (l2 < l) {
            return -1;
        }
        return 0;
    }

    public boolean set(Date date) {
        if (date == null) {
            return false;
        }
        return this.set(date.getTime());
    }

    public boolean set(long l) {
        this.timestamp = DateUtil.getUtcCalendar();
        this.timestamp.setTimeInMillis(l);
        return true;
    }

    public boolean set(Calendar calendar) {
        if (calendar == null) {
            return false;
        }
        return this.set(calendar.getTimeInMillis());
    }

    public boolean set(String string) {
        Date date;
        if (string == null) {
            return false;
        }
        String string2 = null;
        boolean bl = true;
        int n = string.length();
        if (n == 8) {
            string2 = "HH:mm:ss";
        } else if (n == 10) {
            string2 = "yyyy-MM-dd";
        } else if (n == 19) {
            string2 = SIMPLE_FORMAT;
        } else if (n >= 20) {
            string2 = "yyyy-MM-dd'T'HH:mm:ss";
            bl = string.endsWith("Z");
        }
        if (string2 == null) {
            return false;
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string2);
        if (bl) {
            simpleDateFormat.setTimeZone(DateUtil.getUtcTimeZone());
        }
        if ((date = simpleDateFormat.parse(string, new ParsePosition(0))) == null) {
            return false;
        }
        this.timestamp = DateUtil.getUtcCalendar();
        this.timestamp.setTimeInMillis(date.getTime());
        return true;
    }

    public String toString() {
        if (this.timestamp == null) {
            return "";
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(SIMPLE_FORMAT);
        simpleDateFormat.setTimeZone(DateUtil.getUtcTimeZone());
        return simpleDateFormat.format(this.timestamp.getTime(), new StringBuffer(""), new FieldPosition(0)).toString();
    }
}

