/*
 * Decompiled with CFR 0.152.
 */
package MITI.sdk;

import MITI.messages.MIR.MIRSDK;
import MITI.sdk.MIRAggregationRule;
import MITI.sdk.MIRCube;
import MITI.sdk.MIRDimension;
import MITI.sdk.MIRHierarchy;
import MITI.sdk.MIRMetaClass;
import MITI.sdk.MIRMetaLink;
import MITI.sdk.MIRModelObject;
import MITI.sdk.MIRObject;
import MITI.sdk.MIRObjectCollections;
import MITI.sdk.collections.MIRObjectCollection;
import MITI.sdk.collections.MIRSdkCollection;
import java.util.Iterator;
import java.util.SortedSet;

public class MIRCubeDimensionAssociation
extends MIRModelObject {
    protected transient MIRObjectCollection<MIRAggregationRule> aggregationRules = null;
    protected transient MIRCube hasCube = null;
    protected transient MIRDimension hasDimension = null;
    protected transient MIRHierarchy hasHierarchy = null;
    private static MIRMetaClass metaClass = MIRCubeDimensionAssociation.staticGetMetaClass();

    public MIRCubeDimensionAssociation() {
    }

    public MIRCubeDimensionAssociation(MIRCubeDimensionAssociation mIRCubeDimensionAssociation) {
        this.setFrom(mIRCubeDimensionAssociation);
    }

    @Override
    public Object clone() {
        return new MIRCubeDimensionAssociation(this);
    }

    @Override
    public short getElementType() {
        return 86;
    }

    @Override
    public MIRObject getParent() {
        if (this.hasCube != null) {
            return this.hasCube;
        }
        return super.getParent();
    }

    @Override
    public int getParentCount() {
        return (this.hasCube != null ? 1 : 0) + super.getParentCount();
    }

    protected MIRObjectCollection<MIRAggregationRule> getAggregationRuleCollection() {
        this.aggregationRules = MIRObjectCollections.get(this.aggregationRules, MIRSdkCollection.Type.OBJECT);
        return this.aggregationRules;
    }

    public SortedSet<MIRAggregationRule> getAggregationRules() {
        return MIRObjectCollections.sortedSet(this.aggregationRules);
    }

    public final void addAggregationRule(MIRAggregationRule mIRAggregationRule) {
        if (mIRAggregationRule == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("CubeDimensionAssociation", "AggregationRule"));
        }
        if (mIRAggregationRule._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("CubeDimensionAssociation", "AggregationRule"));
        }
        if (mIRAggregationRule.hasCubeDimensionAssociation != null) {
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("AggregationRule", "CubeDimensionAssociation"));
        }
        if (this.aggregationRules != null && this.aggregationRules.contains(mIRAggregationRule)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("CubeDimensionAssociation", "AggregationRule"));
        }
        this.getAggregationRuleCollection().add(mIRAggregationRule);
        mIRAggregationRule.hasCubeDimensionAssociation = this;
    }

    public final int getAggregationRuleCount() {
        if (this.aggregationRules != null) {
            return this.aggregationRules.size();
        }
        return 0;
    }

    public final boolean containsAggregationRule(MIRAggregationRule mIRAggregationRule) {
        if (mIRAggregationRule != null && this.aggregationRules != null) {
            return this.aggregationRules.contains(mIRAggregationRule);
        }
        return false;
    }

    public final MIRAggregationRule getAggregationRule(String string) {
        if (this.aggregationRules != null) {
            return this.aggregationRules.get(string);
        }
        return null;
    }

    public final Iterator<MIRAggregationRule> getAggregationRuleIterator() {
        if (this.aggregationRules != null) {
            return this.aggregationRules.iterator();
        }
        return MIRObjectCollections.emptySet().iterator();
    }

    public final boolean removeAggregationRule(MIRAggregationRule mIRAggregationRule) {
        if (mIRAggregationRule != null && this.aggregationRules != null && this.aggregationRules.remove(mIRAggregationRule)) {
            mIRAggregationRule.hasCubeDimensionAssociation = null;
            if (this.aggregationRules.isEmpty()) {
                this.aggregationRules = null;
            }
            return true;
        }
        return false;
    }

    public final void removeAggregationRules() {
        if (this.aggregationRules != null) {
            for (MIRAggregationRule mIRAggregationRule : this.aggregationRules) {
                mIRAggregationRule.hasCubeDimensionAssociation = null;
            }
            this.aggregationRules = null;
        }
    }

    public final void addCube(MIRCube mIRCube) {
        if (mIRCube == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("CubeDimensionAssociation", "Cube"));
        }
        if (mIRCube._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("CubeDimensionAssociation", "Cube"));
        }
        if (this.hasCube != null) {
            if (this.hasCube._equals(mIRCube)) {
                throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("CubeDimensionAssociation", "Cube"));
            }
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("CubeDimensionAssociation", "Cube"));
        }
        this.hasCube = mIRCube;
        mIRCube.getCubeDimensionAssociationCollection().add(this);
    }

    public final MIRCube getCube() {
        return this.hasCube;
    }

    public final boolean removeCube() {
        if (this.hasCube != null) {
            this.hasCube.cubeDimensionAssociations.remove(this);
            if (this.hasCube.cubeDimensionAssociations.isEmpty()) {
                this.hasCube.cubeDimensionAssociations = null;
            }
            this.hasCube = null;
            return true;
        }
        return false;
    }

    public final void addDimension(MIRDimension mIRDimension) {
        if (mIRDimension == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("CubeDimensionAssociation", "Dimension"));
        }
        if (mIRDimension._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("CubeDimensionAssociation", "Dimension"));
        }
        if (this.hasDimension != null) {
            if (this.hasDimension._equals(mIRDimension)) {
                throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("CubeDimensionAssociation", "Dimension"));
            }
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("CubeDimensionAssociation", "Dimension"));
        }
        this.hasDimension = mIRDimension;
        mIRDimension.getCubeDimensionAssociationCollection().add(this);
    }

    public final MIRDimension getDimension() {
        return this.hasDimension;
    }

    public final boolean removeDimension() {
        if (this.hasDimension != null) {
            this.hasDimension.cubeDimensionAssociations.remove(this);
            if (this.hasDimension.cubeDimensionAssociations.isEmpty()) {
                this.hasDimension.cubeDimensionAssociations = null;
            }
            this.hasDimension = null;
            return true;
        }
        return false;
    }

    public final void addHierarchy(MIRHierarchy mIRHierarchy) {
        if (mIRHierarchy == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("CubeDimensionAssociation", "Hierarchy"));
        }
        if (mIRHierarchy._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("CubeDimensionAssociation", "Hierarchy"));
        }
        if (this.hasHierarchy != null) {
            if (this.hasHierarchy._equals(mIRHierarchy)) {
                throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("CubeDimensionAssociation", "Hierarchy"));
            }
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("CubeDimensionAssociation", "Hierarchy"));
        }
        this.hasHierarchy = mIRHierarchy;
        mIRHierarchy.getCubeDimensionAssociationCollection().add(this);
    }

    public final MIRHierarchy getHierarchy() {
        return this.hasHierarchy;
    }

    public final boolean removeHierarchy() {
        if (this.hasHierarchy != null) {
            this.hasHierarchy.cubeDimensionAssociations.remove(this);
            if (this.hasHierarchy.cubeDimensionAssociations.isEmpty()) {
                this.hasHierarchy.cubeDimensionAssociations = null;
            }
            this.hasHierarchy = null;
            return true;
        }
        return false;
    }

    public static MIRMetaClass staticGetMetaClass() {
        if (metaClass == null) {
            metaClass = new MIRMetaClass(MIRModelObject.staticGetMetaClass(), 86, "CubeDimensionAssociation", false);
            new MIRMetaLink(metaClass, 81, "AggregationRule", false, 0, 83, 1);
            new MIRMetaLink(metaClass, 78, "Cube", true, 2, 85, 77);
            new MIRMetaLink(metaClass, 79, "Dimension", true, 1, 87, 94);
            new MIRMetaLink(metaClass, 80, "Hierarchy", true, 1, 90, 140);
        }
        return metaClass;
    }

    @Override
    public MIRMetaClass getMetaClass() {
        return MIRCubeDimensionAssociation.staticGetMetaClass();
    }

    public String getFullName() {
        StringBuffer stringBuffer = new StringBuffer(50);
        MIRDimension mIRDimension = this.getDimension();
        if (mIRDimension != null) {
            stringBuffer.append(mIRDimension.getName());
        }
        if (mIRDimension != null && this.getName().length() > 0) {
            stringBuffer.append("_as_");
        }
        if (this.getName().length() > 0) {
            stringBuffer.append(this.getName());
        }
        return stringBuffer.toString();
    }

    @Override
    protected void _rename(String string) {
        if (this.hasCube != null) {
            this.hasCube.cubeDimensionAssociations.rename(this, string);
        }
        if (this.hasDimension != null) {
            this.hasDimension.cubeDimensionAssociations.rename(this, string);
        }
        if (this.hasHierarchy != null) {
            this.hasHierarchy.cubeDimensionAssociations.rename(this, string);
        }
        super._rename(string);
    }
}

