/*
 * Decompiled with CFR 0.152.
 */
package MITI.sdk;

import MITI.messages.MIR.MIRSDK;
import MITI.sdk.MIRConnection;
import MITI.sdk.MIRFileAttachment;
import MITI.sdk.MIRFolderContent;
import MITI.sdk.MIRMetaAttribute;
import MITI.sdk.MIRMetaClass;
import MITI.sdk.MIRMetaLink;
import MITI.sdk.MIRModel;
import MITI.sdk.MIRObjectCollections;
import MITI.sdk.MIRVersion;
import MITI.sdk.MIR_Object;
import MITI.sdk.collections.MIRObjectCollection;
import MITI.sdk.collections.MIRSdkCollection;
import java.util.Iterator;
import java.util.SortedSet;

public abstract class MIRContent
extends MIRFolderContent {
    protected transient String aModelKey = "";
    protected transient MIRObjectCollection<MIRConnection> clientOfConnections = null;
    protected transient MIRVersion hasEditableVersion = null;
    protected transient MIRObjectCollection<MIRFileAttachment> fileAttachments = null;
    protected transient MIRModel hasModel = null;
    protected transient MIRVersion hasPartOfMultiModelVersion = null;
    protected transient MIRVersion hasRepresentedVersion = null;
    protected transient MIRObjectCollection<MIRContent> usedByContents = null;
    protected transient MIRObjectCollection<MIRContent> usesContents = null;
    protected transient MIRObjectCollection<MIRVersion> versions = null;
    private static MIRMetaClass metaClass = MIRContent.staticGetMetaClass();

    @Override
    public short getElementType() {
        return 159;
    }

    @Override
    public void setFrom(MIR_Object mIR_Object) {
        super.setFrom(mIR_Object);
        if (mIR_Object.isInstanceOf((short)159)) {
            this.setModelKey(((MIRContent)mIR_Object).getModelKey());
        }
    }

    public final void setModelKey(String string) {
        this.aModelKey = string == null ? "" : string;
    }

    public final String getModelKey() {
        return this.aModelKey;
    }

    protected MIRObjectCollection<MIRConnection> getClientOfConnectionCollection() {
        this.clientOfConnections = MIRObjectCollections.get(this.clientOfConnections, MIRSdkCollection.Type.NAME);
        return this.clientOfConnections;
    }

    public SortedSet<MIRConnection> getClientOfConnections() {
        return MIRObjectCollections.sortedSet(this.clientOfConnections);
    }

    public final void addClientOfConnection(MIRConnection mIRConnection) {
        if (mIRConnection == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("Content", "ClientOfConnection"));
        }
        if (mIRConnection._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("Content", "ClientOfConnection"));
        }
        if (mIRConnection.hasClientContent != null) {
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("Connection", "ClientContent"));
        }
        if (this.clientOfConnections != null) {
            if (this.clientOfConnections.contains(mIRConnection)) {
                throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("Content", "ClientOfConnection"));
            }
            if (!this._allowName(this.clientOfConnections, mIRConnection)) {
                throw new IllegalArgumentException(MIRSDK.NAME_COLLISION.getMessage("Content", this.getPath(), "ClientOfConnection", "Name", mIRConnection.getPath()));
            }
        }
        this.getClientOfConnectionCollection().add(mIRConnection);
        mIRConnection.hasClientContent = this;
    }

    public final boolean addClientOfConnectionUniqueName(MIRConnection mIRConnection) {
        return this.addClientOfConnectionUniqueName(mIRConnection, '/');
    }

    public final boolean addClientOfConnectionUniqueName(MIRConnection mIRConnection, char c) {
        if (mIRConnection == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("Content", "ClientOfConnection"));
        }
        if (mIRConnection._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("Content", "ClientOfConnection"));
        }
        if (mIRConnection.hasClientContent != null) {
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("Connection", "ClientContent"));
        }
        boolean bl = false;
        if (this.clientOfConnections != null) {
            if (this.clientOfConnections.contains(mIRConnection)) {
                throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("Content", "ClientOfConnection"));
            }
            if (!this._allowName(this.clientOfConnections, mIRConnection)) {
                mIRConnection._rename(mIRConnection._setUniqueName(this.clientOfConnections, c));
                bl = true;
            }
        }
        this.getClientOfConnectionCollection().add(mIRConnection);
        mIRConnection.hasClientContent = this;
        return bl;
    }

    public final int getClientOfConnectionCount() {
        if (this.clientOfConnections != null) {
            return this.clientOfConnections.size();
        }
        return 0;
    }

    public final boolean containsClientOfConnection(MIRConnection mIRConnection) {
        if (mIRConnection != null && this.clientOfConnections != null) {
            return this.clientOfConnections.contains(mIRConnection);
        }
        return false;
    }

    public final MIRConnection getClientOfConnection(String string) {
        if (this.clientOfConnections != null) {
            return this.clientOfConnections.get(string);
        }
        return null;
    }

    public final Iterator<MIRConnection> getClientOfConnectionIterator() {
        if (this.clientOfConnections != null) {
            return this.clientOfConnections.iterator();
        }
        return MIRObjectCollections.emptySet().iterator();
    }

    public final boolean removeClientOfConnection(MIRConnection mIRConnection) {
        if (mIRConnection != null && this.clientOfConnections != null && this.clientOfConnections.remove(mIRConnection)) {
            mIRConnection.hasClientContent = null;
            if (this.clientOfConnections.isEmpty()) {
                this.clientOfConnections = null;
            }
            return true;
        }
        return false;
    }

    public final void removeClientOfConnections() {
        if (this.clientOfConnections != null) {
            for (MIRConnection mIRConnection : this.clientOfConnections) {
                mIRConnection.hasClientContent = null;
            }
            this.clientOfConnections = null;
        }
    }

    public final void addEditableVersion(MIRVersion mIRVersion) {
        if (mIRVersion == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("Content", "EditableVersion"));
        }
        if (mIRVersion._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("Content", "EditableVersion"));
        }
        if (this.hasEditableVersion != null) {
            if (this.hasEditableVersion._equals(mIRVersion)) {
                throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("Content", "EditableVersion"));
            }
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("Content", "EditableVersion"));
        }
        if (mIRVersion.hasEditableOfContent != null) {
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("Version", "EditableOfContent"));
        }
        this.hasEditableVersion = mIRVersion;
        mIRVersion.hasEditableOfContent = this;
    }

    public final MIRVersion getEditableVersion() {
        return this.hasEditableVersion;
    }

    public final boolean removeEditableVersion() {
        if (this.hasEditableVersion != null) {
            this.hasEditableVersion.hasEditableOfContent = null;
            this.hasEditableVersion = null;
            return true;
        }
        return false;
    }

    protected MIRObjectCollection<MIRFileAttachment> getFileAttachmentCollection() {
        this.fileAttachments = MIRObjectCollections.get(this.fileAttachments, MIRSdkCollection.Type.NAME);
        return this.fileAttachments;
    }

    public SortedSet<MIRFileAttachment> getFileAttachments() {
        return MIRObjectCollections.sortedSet(this.fileAttachments);
    }

    public final void addFileAttachment(MIRFileAttachment mIRFileAttachment) {
        if (mIRFileAttachment == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("Content", "FileAttachment"));
        }
        if (mIRFileAttachment._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("Content", "FileAttachment"));
        }
        if (mIRFileAttachment.hasContent != null) {
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("FileAttachment", "Content"));
        }
        if (this.fileAttachments != null) {
            if (this.fileAttachments.contains(mIRFileAttachment)) {
                throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("Content", "FileAttachment"));
            }
            if (!this._allowName(this.fileAttachments, mIRFileAttachment)) {
                throw new IllegalArgumentException(MIRSDK.NAME_COLLISION.getMessage("Content", this.getPath(), "FileAttachment", "Name", mIRFileAttachment.getPath()));
            }
        }
        this.getFileAttachmentCollection().add(mIRFileAttachment);
        mIRFileAttachment.hasContent = this;
    }

    public final boolean addFileAttachmentUniqueName(MIRFileAttachment mIRFileAttachment) {
        return this.addFileAttachmentUniqueName(mIRFileAttachment, '/');
    }

    public final boolean addFileAttachmentUniqueName(MIRFileAttachment mIRFileAttachment, char c) {
        if (mIRFileAttachment == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("Content", "FileAttachment"));
        }
        if (mIRFileAttachment._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("Content", "FileAttachment"));
        }
        if (mIRFileAttachment.hasContent != null) {
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("FileAttachment", "Content"));
        }
        boolean bl = false;
        if (this.fileAttachments != null) {
            if (this.fileAttachments.contains(mIRFileAttachment)) {
                throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("Content", "FileAttachment"));
            }
            if (!this._allowName(this.fileAttachments, mIRFileAttachment)) {
                mIRFileAttachment._rename(mIRFileAttachment._setUniqueName(this.fileAttachments, c));
                bl = true;
            }
        }
        this.getFileAttachmentCollection().add(mIRFileAttachment);
        mIRFileAttachment.hasContent = this;
        return bl;
    }

    public final int getFileAttachmentCount() {
        if (this.fileAttachments != null) {
            return this.fileAttachments.size();
        }
        return 0;
    }

    public final boolean containsFileAttachment(MIRFileAttachment mIRFileAttachment) {
        if (mIRFileAttachment != null && this.fileAttachments != null) {
            return this.fileAttachments.contains(mIRFileAttachment);
        }
        return false;
    }

    public final MIRFileAttachment getFileAttachment(String string) {
        if (this.fileAttachments != null) {
            return this.fileAttachments.get(string);
        }
        return null;
    }

    public final Iterator<MIRFileAttachment> getFileAttachmentIterator() {
        if (this.fileAttachments != null) {
            return this.fileAttachments.iterator();
        }
        return MIRObjectCollections.emptySet().iterator();
    }

    public final boolean removeFileAttachment(MIRFileAttachment mIRFileAttachment) {
        if (mIRFileAttachment != null && this.fileAttachments != null && this.fileAttachments.remove(mIRFileAttachment)) {
            mIRFileAttachment.hasContent = null;
            if (this.fileAttachments.isEmpty()) {
                this.fileAttachments = null;
            }
            return true;
        }
        return false;
    }

    public final void removeFileAttachments() {
        if (this.fileAttachments != null) {
            for (MIRFileAttachment mIRFileAttachment : this.fileAttachments) {
                mIRFileAttachment.hasContent = null;
            }
            this.fileAttachments = null;
        }
    }

    public final void addModel(MIRModel mIRModel) {
        if (mIRModel == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("Content", "Model"));
        }
        if (mIRModel._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("Content", "Model"));
        }
        if (this.hasModel != null) {
            if (this.hasModel._equals(mIRModel)) {
                throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("Content", "Model"));
            }
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("Content", "Model"));
        }
        if (mIRModel.hasContent != null) {
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("Model", "Content"));
        }
        this.hasModel = mIRModel;
        mIRModel.hasContent = this;
    }

    public final MIRModel getModel() {
        return this.hasModel;
    }

    public final boolean removeModel() {
        if (this.hasModel != null) {
            this.hasModel.hasContent = null;
            this.hasModel = null;
            return true;
        }
        return false;
    }

    public final void addPartOfMultiModelVersion(MIRVersion mIRVersion) {
        if (mIRVersion == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("Content", "PartOfMultiModelVersion"));
        }
        if (mIRVersion._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("Content", "PartOfMultiModelVersion"));
        }
        if (this.hasPartOfMultiModelVersion != null) {
            if (this.hasPartOfMultiModelVersion._equals(mIRVersion)) {
                throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("Content", "PartOfMultiModelVersion"));
            }
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("Content", "PartOfMultiModelVersion"));
        }
        this.hasPartOfMultiModelVersion = mIRVersion;
        mIRVersion.getMultiModelPartContentCollection().add(this);
    }

    public final MIRVersion getPartOfMultiModelVersion() {
        return this.hasPartOfMultiModelVersion;
    }

    public final boolean removePartOfMultiModelVersion() {
        if (this.hasPartOfMultiModelVersion != null) {
            this.hasPartOfMultiModelVersion.multiModelPartContents.remove(this);
            if (this.hasPartOfMultiModelVersion.multiModelPartContents.isEmpty()) {
                this.hasPartOfMultiModelVersion.multiModelPartContents = null;
            }
            this.hasPartOfMultiModelVersion = null;
            return true;
        }
        return false;
    }

    public final void addRepresentedVersion(MIRVersion mIRVersion) {
        if (mIRVersion == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("Content", "RepresentedVersion"));
        }
        if (mIRVersion._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("Content", "RepresentedVersion"));
        }
        if (this.hasRepresentedVersion != null) {
            if (this.hasRepresentedVersion._equals(mIRVersion)) {
                throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("Content", "RepresentedVersion"));
            }
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("Content", "RepresentedVersion"));
        }
        this.hasRepresentedVersion = mIRVersion;
        mIRVersion.getRepresentedByContentCollection().add(this);
    }

    public final MIRVersion getRepresentedVersion() {
        return this.hasRepresentedVersion;
    }

    public final boolean removeRepresentedVersion() {
        if (this.hasRepresentedVersion != null) {
            this.hasRepresentedVersion.representedByContents.remove(this);
            if (this.hasRepresentedVersion.representedByContents.isEmpty()) {
                this.hasRepresentedVersion.representedByContents = null;
            }
            this.hasRepresentedVersion = null;
            return true;
        }
        return false;
    }

    protected MIRObjectCollection<MIRContent> getUsedByContentCollection() {
        this.usedByContents = MIRObjectCollections.get(this.usedByContents, MIRSdkCollection.Type.OBJECT);
        return this.usedByContents;
    }

    public SortedSet<MIRContent> getUsedByContents() {
        return MIRObjectCollections.sortedSet(this.usedByContents);
    }

    public final void addUsedByContent(MIRContent mIRContent) {
        if (mIRContent == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("Content", "UsedByContent"));
        }
        if (mIRContent._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("Content", "UsedByContent"));
        }
        if (this.usedByContents != null && this.usedByContents.contains(mIRContent)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("Content", "UsedByContent"));
        }
        this.getUsedByContentCollection().add(mIRContent);
        mIRContent.getUsesContentCollection().add(this);
    }

    public final int getUsedByContentCount() {
        if (this.usedByContents != null) {
            return this.usedByContents.size();
        }
        return 0;
    }

    public final boolean containsUsedByContent(MIRContent mIRContent) {
        if (mIRContent != null && this.usedByContents != null) {
            return this.usedByContents.contains(mIRContent);
        }
        return false;
    }

    public final MIRContent getUsedByContent(String string) {
        if (this.usedByContents != null) {
            return this.usedByContents.get(string);
        }
        return null;
    }

    public final Iterator<MIRContent> getUsedByContentIterator() {
        if (this.usedByContents != null) {
            return this.usedByContents.iterator();
        }
        return MIRObjectCollections.emptySet().iterator();
    }

    public final boolean removeUsedByContent(MIRContent mIRContent) {
        if (mIRContent != null && this.usedByContents != null && this.usedByContents.remove(mIRContent)) {
            mIRContent.usesContents.remove(this);
            if (mIRContent.usesContents.isEmpty()) {
                mIRContent.usesContents = null;
            }
            if (this.usedByContents.isEmpty()) {
                this.usedByContents = null;
            }
            return true;
        }
        return false;
    }

    public final void removeUsedByContents() {
        if (this.usedByContents != null) {
            for (MIRContent mIRContent : this.usedByContents) {
                mIRContent.usesContents.remove(this);
                if (!mIRContent.usesContents.isEmpty()) continue;
                mIRContent.usesContents = null;
            }
            this.usedByContents = null;
        }
    }

    protected MIRObjectCollection<MIRContent> getUsesContentCollection() {
        this.usesContents = MIRObjectCollections.get(this.usesContents, MIRSdkCollection.Type.OBJECT);
        return this.usesContents;
    }

    public SortedSet<MIRContent> getUsesContents() {
        return MIRObjectCollections.sortedSet(this.usesContents);
    }

    public final void addUsesContent(MIRContent mIRContent) {
        if (mIRContent == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("Content", "UsesContent"));
        }
        if (mIRContent._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("Content", "UsesContent"));
        }
        if (this.usesContents != null && this.usesContents.contains(mIRContent)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("Content", "UsesContent"));
        }
        this.getUsesContentCollection().add(mIRContent);
        mIRContent.getUsedByContentCollection().add(this);
    }

    public final int getUsesContentCount() {
        if (this.usesContents != null) {
            return this.usesContents.size();
        }
        return 0;
    }

    public final boolean containsUsesContent(MIRContent mIRContent) {
        if (mIRContent != null && this.usesContents != null) {
            return this.usesContents.contains(mIRContent);
        }
        return false;
    }

    public final MIRContent getUsesContent(String string) {
        if (this.usesContents != null) {
            return this.usesContents.get(string);
        }
        return null;
    }

    public final Iterator<MIRContent> getUsesContentIterator() {
        if (this.usesContents != null) {
            return this.usesContents.iterator();
        }
        return MIRObjectCollections.emptySet().iterator();
    }

    public final boolean removeUsesContent(MIRContent mIRContent) {
        if (mIRContent != null && this.usesContents != null && this.usesContents.remove(mIRContent)) {
            mIRContent.usedByContents.remove(this);
            if (mIRContent.usedByContents.isEmpty()) {
                mIRContent.usedByContents = null;
            }
            if (this.usesContents.isEmpty()) {
                this.usesContents = null;
            }
            return true;
        }
        return false;
    }

    public final void removeUsesContents() {
        if (this.usesContents != null) {
            for (MIRContent mIRContent : this.usesContents) {
                mIRContent.usedByContents.remove(this);
                if (!mIRContent.usedByContents.isEmpty()) continue;
                mIRContent.usedByContents = null;
            }
            this.usesContents = null;
        }
    }

    protected MIRObjectCollection<MIRVersion> getVersionCollection() {
        this.versions = MIRObjectCollections.get(this.versions, MIRSdkCollection.Type.NAME);
        return this.versions;
    }

    public SortedSet<MIRVersion> getVersions() {
        return MIRObjectCollections.sortedSet(this.versions);
    }

    public final void addVersion(MIRVersion mIRVersion) {
        if (mIRVersion == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("Content", "Version"));
        }
        if (mIRVersion._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("Content", "Version"));
        }
        if (mIRVersion.hasContent != null) {
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("Version", "Content"));
        }
        if (this.versions != null) {
            if (this.versions.contains(mIRVersion)) {
                throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("Content", "Version"));
            }
            if (!this._allowName(this.versions, mIRVersion)) {
                throw new IllegalArgumentException(MIRSDK.NAME_COLLISION.getMessage("Content", this.getPath(), "Version", "Name", mIRVersion.getPath()));
            }
        }
        this.getVersionCollection().add(mIRVersion);
        mIRVersion.hasContent = this;
    }

    public final boolean addVersionUniqueName(MIRVersion mIRVersion) {
        return this.addVersionUniqueName(mIRVersion, '/');
    }

    public final boolean addVersionUniqueName(MIRVersion mIRVersion, char c) {
        if (mIRVersion == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("Content", "Version"));
        }
        if (mIRVersion._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("Content", "Version"));
        }
        if (mIRVersion.hasContent != null) {
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("Version", "Content"));
        }
        boolean bl = false;
        if (this.versions != null) {
            if (this.versions.contains(mIRVersion)) {
                throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("Content", "Version"));
            }
            if (!this._allowName(this.versions, mIRVersion)) {
                mIRVersion._rename(mIRVersion._setUniqueName(this.versions, c));
                bl = true;
            }
        }
        this.getVersionCollection().add(mIRVersion);
        mIRVersion.hasContent = this;
        return bl;
    }

    public final int getVersionCount() {
        if (this.versions != null) {
            return this.versions.size();
        }
        return 0;
    }

    public final boolean containsVersion(MIRVersion mIRVersion) {
        if (mIRVersion != null && this.versions != null) {
            return this.versions.contains(mIRVersion);
        }
        return false;
    }

    public final MIRVersion getVersion(String string) {
        if (this.versions != null) {
            return this.versions.get(string);
        }
        return null;
    }

    public final Iterator<MIRVersion> getVersionIterator() {
        if (this.versions != null) {
            return this.versions.iterator();
        }
        return MIRObjectCollections.emptySet().iterator();
    }

    public final boolean removeVersion(MIRVersion mIRVersion) {
        if (mIRVersion != null && this.versions != null && this.versions.remove(mIRVersion)) {
            mIRVersion.hasContent = null;
            if (this.versions.isEmpty()) {
                this.versions = null;
            }
            return true;
        }
        return false;
    }

    public final void removeVersions() {
        if (this.versions != null) {
            for (MIRVersion mIRVersion : this.versions) {
                mIRVersion.hasContent = null;
            }
            this.versions = null;
        }
    }

    public static MIRMetaClass staticGetMetaClass() {
        if (metaClass == null) {
            metaClass = new MIRMetaClass(MIRFolderContent.staticGetMetaClass(), 159, "Content", true);
            new MIRMetaAttribute(metaClass, 438, "ModelKey", "java.lang.String", null, "");
            new MIRMetaLink(metaClass, 813, "ClientOfConnection", false, 3, 213, 807);
            new MIRMetaLink(metaClass, 599, "EditableVersion", true, 0, 31, 600);
            new MIRMetaLink(metaClass, 1014, "FileAttachment", false, 3, 160, 1015);
            new MIRMetaLink(metaClass, 809, "Model", true, 3, 218, 838);
            new MIRMetaLink(metaClass, 1032, "PartOfMultiModelVersion", true, 0, 31, 1033);
            new MIRMetaLink(metaClass, 811, "RepresentedVersion", true, 0, 31, 853);
            new MIRMetaLink(metaClass, 1121, "UsedByContent", false, 1, 159, 1120);
            new MIRMetaLink(metaClass, 1120, "UsesContent", false, 0, 159, 1121);
            new MIRMetaLink(metaClass, 395, "Version", false, 3, 31, 396);
        }
        return metaClass;
    }

    @Override
    public MIRMetaClass getMetaClass() {
        return MIRContent.staticGetMetaClass();
    }

    @Override
    protected void _rename(String string) {
        if (this.hasPartOfMultiModelVersion != null) {
            this.hasPartOfMultiModelVersion.multiModelPartContents.rename(this, string);
        }
        if (this.hasRepresentedVersion != null) {
            this.hasRepresentedVersion.representedByContents.rename(this, string);
        }
        if (this.usedByContents != null) {
            for (MIRContent mIRContent : this.usedByContents) {
                mIRContent.usesContents.rename(this, string);
            }
        }
        if (this.usesContents != null) {
            for (MIRContent mIRContent : this.usesContents) {
                mIRContent.usedByContents.rename(this, string);
            }
        }
        super._rename(string);
    }
}

