/*
 * Decompiled with CFR 0.152.
 */
package MITI.sdk;

import MITI.messages.MIR.MIRSDK;
import MITI.sdk.MIRClassifier;
import MITI.sdk.MIRDiModel;
import MITI.sdk.MIRElement;
import MITI.sdk.MIRExpression;
import MITI.sdk.MIRFeatureMap;
import MITI.sdk.MIRMetaAttribute;
import MITI.sdk.MIRMetaClass;
import MITI.sdk.MIRMetaLink;
import MITI.sdk.MIRObject;
import MITI.sdk.MIRObjectCollections;
import MITI.sdk.MIROperation;
import MITI.sdk.MIRTransformation;
import MITI.sdk.MIRUsedParameter;
import MITI.sdk.MIR_Object;
import MITI.sdk.collections.MIRObjectCollection;
import MITI.sdk.collections.MIRSdkCollection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;

public class MIRClassifierMap
extends MIRElement {
    protected transient String aOperation = "";
    protected transient MIRClassifier hasClassifier = null;
    protected transient MIRObjectCollection<MIRClassifier> controlClassifiers = null;
    protected transient MIROperation hasDatabaseOperation = null;
    protected transient MIRClassifier hasDestinationClassifier = null;
    protected transient MIRDiModel hasDiModel = null;
    protected transient MIRExpression hasExpression = null;
    protected transient MIRObjectCollection<MIRFeatureMap> featureMaps = null;
    protected transient MIRObjectCollection<MIRClassifier> sourceClassifiers = null;
    protected transient MIRTransformation hasTransformation = null;
    protected transient MIRObjectCollection<MIRUsedParameter> usedParameters = null;
    private static MIRMetaClass metaClass = MIRClassifierMap.staticGetMetaClass();

    public MIRClassifierMap() {
    }

    public MIRClassifierMap(MIRClassifierMap mIRClassifierMap) {
        this.setFrom(mIRClassifierMap);
    }

    @Override
    public Object clone() {
        return new MIRClassifierMap(this);
    }

    @Override
    public short getElementType() {
        return 76;
    }

    @Override
    public void setFrom(MIR_Object mIR_Object) {
        super.setFrom(mIR_Object);
        if (mIR_Object.isInstanceOf((short)76)) {
            this.setOperation(((MIRClassifierMap)mIR_Object).getOperation());
        }
    }

    @Override
    public MIRObject getParent() {
        if (this.hasClassifier != null) {
            return this.hasClassifier;
        }
        if (this.hasDatabaseOperation != null) {
            return this.hasDatabaseOperation;
        }
        if (this.hasDiModel != null) {
            return this.hasDiModel;
        }
        if (this.hasTransformation != null) {
            return this.hasTransformation;
        }
        return super.getParent();
    }

    @Override
    public int getParentCount() {
        return (this.hasClassifier != null ? 1 : 0) + (this.hasDatabaseOperation != null ? 1 : 0) + (this.hasDiModel != null ? 1 : 0) + (this.hasTransformation != null ? 1 : 0) + super.getParentCount();
    }

    public final void setOperation(String string) {
        this.aOperation = string == null ? "" : string;
    }

    public final String getOperation() {
        return this.aOperation;
    }

    public final void addClassifier(MIRClassifier mIRClassifier) {
        if (mIRClassifier == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("ClassifierMap", "Classifier"));
        }
        if (mIRClassifier._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("ClassifierMap", "Classifier"));
        }
        if (this.hasClassifier != null) {
            if (this.hasClassifier._equals(mIRClassifier)) {
                throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("ClassifierMap", "Classifier"));
            }
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("ClassifierMap", "Classifier"));
        }
        if (mIRClassifier.hasClassifierMap != null) {
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("Classifier", "ClassifierMap"));
        }
        this.hasClassifier = mIRClassifier;
        mIRClassifier.hasClassifierMap = this;
    }

    public final MIRClassifier getClassifier() {
        return this.hasClassifier;
    }

    public final boolean removeClassifier() {
        if (this.hasClassifier != null) {
            this.hasClassifier.hasClassifierMap = null;
            this.hasClassifier = null;
            return true;
        }
        return false;
    }

    protected MIRObjectCollection<MIRClassifier> getControlClassifierCollection() {
        this.controlClassifiers = MIRObjectCollections.get(this.controlClassifiers, MIRSdkCollection.Type.OBJECT);
        return this.controlClassifiers;
    }

    public SortedSet<MIRClassifier> getControlClassifiers() {
        return MIRObjectCollections.sortedSet(this.controlClassifiers);
    }

    public final void addControlClassifier(MIRClassifier mIRClassifier) {
        if (mIRClassifier == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("ClassifierMap", "ControlClassifier"));
        }
        if (mIRClassifier._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("ClassifierMap", "ControlClassifier"));
        }
        if (this.controlClassifiers != null && this.controlClassifiers.contains(mIRClassifier)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("ClassifierMap", "ControlClassifier"));
        }
        this.getControlClassifierCollection().add(mIRClassifier);
        mIRClassifier.getControlOfClassifierMapCollection().add(this);
    }

    public final int getControlClassifierCount() {
        if (this.controlClassifiers != null) {
            return this.controlClassifiers.size();
        }
        return 0;
    }

    public final boolean containsControlClassifier(MIRClassifier mIRClassifier) {
        if (mIRClassifier != null && this.controlClassifiers != null) {
            return this.controlClassifiers.contains(mIRClassifier);
        }
        return false;
    }

    public final MIRClassifier getControlClassifier(String string) {
        if (this.controlClassifiers != null) {
            return this.controlClassifiers.get(string);
        }
        return null;
    }

    public final Iterator<MIRClassifier> getControlClassifierIterator() {
        if (this.controlClassifiers != null) {
            return this.controlClassifiers.iterator();
        }
        return MIRObjectCollections.emptySet().iterator();
    }

    public final boolean removeControlClassifier(MIRClassifier mIRClassifier) {
        if (mIRClassifier != null && this.controlClassifiers != null && this.controlClassifiers.remove(mIRClassifier)) {
            mIRClassifier.controlOfClassifierMaps.remove(this);
            if (mIRClassifier.controlOfClassifierMaps.isEmpty()) {
                mIRClassifier.controlOfClassifierMaps = null;
            }
            if (this.controlClassifiers.isEmpty()) {
                this.controlClassifiers = null;
            }
            return true;
        }
        return false;
    }

    public final void removeControlClassifiers() {
        if (this.controlClassifiers != null) {
            for (MIRClassifier mIRClassifier : this.controlClassifiers) {
                mIRClassifier.controlOfClassifierMaps.remove(this);
                if (!mIRClassifier.controlOfClassifierMaps.isEmpty()) continue;
                mIRClassifier.controlOfClassifierMaps = null;
            }
            this.controlClassifiers = null;
        }
    }

    public final void addDatabaseOperation(MIROperation mIROperation) {
        if (mIROperation == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("ClassifierMap", "DatabaseOperation"));
        }
        if (mIROperation._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("ClassifierMap", "DatabaseOperation"));
        }
        if (this.hasDatabaseOperation != null) {
            if (this.hasDatabaseOperation._equals(mIROperation)) {
                throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("ClassifierMap", "DatabaseOperation"));
            }
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("ClassifierMap", "DatabaseOperation"));
        }
        this.hasDatabaseOperation = mIROperation;
        mIROperation.getClassifierMapCollection().add(this);
    }

    public final MIROperation getDatabaseOperation() {
        return this.hasDatabaseOperation;
    }

    public final boolean removeDatabaseOperation() {
        if (this.hasDatabaseOperation != null) {
            this.hasDatabaseOperation.classifierMaps.remove(this);
            if (this.hasDatabaseOperation.classifierMaps.isEmpty()) {
                this.hasDatabaseOperation.classifierMaps = null;
            }
            this.hasDatabaseOperation = null;
            return true;
        }
        return false;
    }

    public final void addDestinationClassifier(MIRClassifier mIRClassifier) {
        if (mIRClassifier == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("ClassifierMap", "DestinationClassifier"));
        }
        if (mIRClassifier._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("ClassifierMap", "DestinationClassifier"));
        }
        if (this.hasDestinationClassifier != null) {
            if (this.hasDestinationClassifier._equals(mIRClassifier)) {
                throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("ClassifierMap", "DestinationClassifier"));
            }
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("ClassifierMap", "DestinationClassifier"));
        }
        this.hasDestinationClassifier = mIRClassifier;
        mIRClassifier.getDestinationOfClassifierMapCollection().add(this);
    }

    public final MIRClassifier getDestinationClassifier() {
        return this.hasDestinationClassifier;
    }

    public final boolean removeDestinationClassifier() {
        if (this.hasDestinationClassifier != null) {
            this.hasDestinationClassifier.destinationOfClassifierMaps.remove(this);
            if (this.hasDestinationClassifier.destinationOfClassifierMaps.isEmpty()) {
                this.hasDestinationClassifier.destinationOfClassifierMaps = null;
            }
            this.hasDestinationClassifier = null;
            return true;
        }
        return false;
    }

    public final void addDiModel(MIRDiModel mIRDiModel) {
        if (mIRDiModel == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("ClassifierMap", "DiModel"));
        }
        if (mIRDiModel._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("ClassifierMap", "DiModel"));
        }
        if (this.hasDiModel != null) {
            if (this.hasDiModel._equals(mIRDiModel)) {
                throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("ClassifierMap", "DiModel"));
            }
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("ClassifierMap", "DiModel"));
        }
        this.hasDiModel = mIRDiModel;
        mIRDiModel.getClassifierMapCollection().add(this);
    }

    public final MIRDiModel getDiModel() {
        return this.hasDiModel;
    }

    public final boolean removeDiModel() {
        if (this.hasDiModel != null) {
            this.hasDiModel.classifierMaps.remove(this);
            if (this.hasDiModel.classifierMaps.isEmpty()) {
                this.hasDiModel.classifierMaps = null;
            }
            this.hasDiModel = null;
            return true;
        }
        return false;
    }

    public final void addExpression(MIRExpression mIRExpression) {
        if (mIRExpression == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("ClassifierMap", "Expression"));
        }
        if (mIRExpression._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("ClassifierMap", "Expression"));
        }
        if (this.hasExpression != null) {
            if (this.hasExpression._equals(mIRExpression)) {
                throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("ClassifierMap", "Expression"));
            }
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("ClassifierMap", "Expression"));
        }
        if (mIRExpression.hasClassifierMap != null) {
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("Expression", "ClassifierMap"));
        }
        this.hasExpression = mIRExpression;
        mIRExpression.hasClassifierMap = this;
    }

    public final MIRExpression getExpression() {
        return this.hasExpression;
    }

    public final boolean removeExpression() {
        if (this.hasExpression != null) {
            this.hasExpression.hasClassifierMap = null;
            this.hasExpression = null;
            return true;
        }
        return false;
    }

    protected MIRObjectCollection<MIRFeatureMap> getFeatureMapCollection() {
        this.featureMaps = MIRObjectCollections.get(this.featureMaps, MIRSdkCollection.Type.OBJECT);
        return this.featureMaps;
    }

    public SortedSet<MIRFeatureMap> getFeatureMaps() {
        return MIRObjectCollections.sortedSet(this.featureMaps);
    }

    public final void addFeatureMap(MIRFeatureMap mIRFeatureMap) {
        if (mIRFeatureMap == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("ClassifierMap", "FeatureMap"));
        }
        if (mIRFeatureMap._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("ClassifierMap", "FeatureMap"));
        }
        if (mIRFeatureMap.hasClassifierMap != null) {
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("FeatureMap", "ClassifierMap"));
        }
        if (this.featureMaps != null && this.featureMaps.contains(mIRFeatureMap)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("ClassifierMap", "FeatureMap"));
        }
        this.getFeatureMapCollection().add(mIRFeatureMap);
        mIRFeatureMap.hasClassifierMap = this;
    }

    public final int getFeatureMapCount() {
        if (this.featureMaps != null) {
            return this.featureMaps.size();
        }
        return 0;
    }

    public final boolean containsFeatureMap(MIRFeatureMap mIRFeatureMap) {
        if (mIRFeatureMap != null && this.featureMaps != null) {
            return this.featureMaps.contains(mIRFeatureMap);
        }
        return false;
    }

    public final MIRFeatureMap getFeatureMap(String string) {
        if (this.featureMaps != null) {
            return this.featureMaps.get(string);
        }
        return null;
    }

    public final Iterator<MIRFeatureMap> getFeatureMapIterator() {
        if (this.featureMaps != null) {
            return this.featureMaps.iterator();
        }
        return MIRObjectCollections.emptySet().iterator();
    }

    public final List<MIRFeatureMap> getFeatureMapByPosition() {
        if (this.featureMaps != null) {
            ArrayList<MIRFeatureMap> arrayList = new ArrayList<MIRFeatureMap>();
            arrayList.addAll(this.featureMaps.values());
            MIRObjectCollections.sort(arrayList, MIRFeatureMap.ByPosition);
            return arrayList;
        }
        return MIRObjectCollections.emptyList();
    }

    public final boolean removeFeatureMap(MIRFeatureMap mIRFeatureMap) {
        if (mIRFeatureMap != null && this.featureMaps != null && this.featureMaps.remove(mIRFeatureMap)) {
            mIRFeatureMap.hasClassifierMap = null;
            if (this.featureMaps.isEmpty()) {
                this.featureMaps = null;
            }
            return true;
        }
        return false;
    }

    public final void removeFeatureMaps() {
        if (this.featureMaps != null) {
            for (MIRFeatureMap mIRFeatureMap : this.featureMaps) {
                mIRFeatureMap.hasClassifierMap = null;
            }
            this.featureMaps = null;
        }
    }

    protected MIRObjectCollection<MIRClassifier> getSourceClassifierCollection() {
        this.sourceClassifiers = MIRObjectCollections.get(this.sourceClassifiers, MIRSdkCollection.Type.OBJECT);
        return this.sourceClassifiers;
    }

    public SortedSet<MIRClassifier> getSourceClassifiers() {
        return MIRObjectCollections.sortedSet(this.sourceClassifiers);
    }

    public final void addSourceClassifier(MIRClassifier mIRClassifier) {
        if (mIRClassifier == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("ClassifierMap", "SourceClassifier"));
        }
        if (mIRClassifier._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("ClassifierMap", "SourceClassifier"));
        }
        if (this.sourceClassifiers != null && this.sourceClassifiers.contains(mIRClassifier)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("ClassifierMap", "SourceClassifier"));
        }
        this.getSourceClassifierCollection().add(mIRClassifier);
        mIRClassifier.getSourceOfClassifierMapCollection().add(this);
    }

    public final int getSourceClassifierCount() {
        if (this.sourceClassifiers != null) {
            return this.sourceClassifiers.size();
        }
        return 0;
    }

    public final boolean containsSourceClassifier(MIRClassifier mIRClassifier) {
        if (mIRClassifier != null && this.sourceClassifiers != null) {
            return this.sourceClassifiers.contains(mIRClassifier);
        }
        return false;
    }

    public final MIRClassifier getSourceClassifier(String string) {
        if (this.sourceClassifiers != null) {
            return this.sourceClassifiers.get(string);
        }
        return null;
    }

    public final Iterator<MIRClassifier> getSourceClassifierIterator() {
        if (this.sourceClassifiers != null) {
            return this.sourceClassifiers.iterator();
        }
        return MIRObjectCollections.emptySet().iterator();
    }

    public final boolean removeSourceClassifier(MIRClassifier mIRClassifier) {
        if (mIRClassifier != null && this.sourceClassifiers != null && this.sourceClassifiers.remove(mIRClassifier)) {
            mIRClassifier.sourceOfClassifierMaps.remove(this);
            if (mIRClassifier.sourceOfClassifierMaps.isEmpty()) {
                mIRClassifier.sourceOfClassifierMaps = null;
            }
            if (this.sourceClassifiers.isEmpty()) {
                this.sourceClassifiers = null;
            }
            return true;
        }
        return false;
    }

    public final void removeSourceClassifiers() {
        if (this.sourceClassifiers != null) {
            for (MIRClassifier mIRClassifier : this.sourceClassifiers) {
                mIRClassifier.sourceOfClassifierMaps.remove(this);
                if (!mIRClassifier.sourceOfClassifierMaps.isEmpty()) continue;
                mIRClassifier.sourceOfClassifierMaps = null;
            }
            this.sourceClassifiers = null;
        }
    }

    public final void addTransformation(MIRTransformation mIRTransformation) {
        if (mIRTransformation == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("ClassifierMap", "Transformation"));
        }
        if (mIRTransformation._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("ClassifierMap", "Transformation"));
        }
        if (this.hasTransformation != null) {
            if (this.hasTransformation._equals(mIRTransformation)) {
                throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("ClassifierMap", "Transformation"));
            }
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("ClassifierMap", "Transformation"));
        }
        this.hasTransformation = mIRTransformation;
        mIRTransformation.getClassifierMapCollection().add(this);
    }

    public final MIRTransformation getTransformation() {
        return this.hasTransformation;
    }

    public final boolean removeTransformation() {
        if (this.hasTransformation != null) {
            this.hasTransformation.classifierMaps.remove(this);
            if (this.hasTransformation.classifierMaps.isEmpty()) {
                this.hasTransformation.classifierMaps = null;
            }
            this.hasTransformation = null;
            return true;
        }
        return false;
    }

    protected MIRObjectCollection<MIRUsedParameter> getUsedParameterCollection() {
        this.usedParameters = MIRObjectCollections.get(this.usedParameters, MIRSdkCollection.Type.NAME);
        return this.usedParameters;
    }

    public SortedSet<MIRUsedParameter> getUsedParameters() {
        return MIRObjectCollections.sortedSet(this.usedParameters);
    }

    public final void addUsedParameter(MIRUsedParameter mIRUsedParameter) {
        if (mIRUsedParameter == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("ClassifierMap", "UsedParameter"));
        }
        if (mIRUsedParameter._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("ClassifierMap", "UsedParameter"));
        }
        if (mIRUsedParameter.hasClassifierMap != null) {
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("UsedParameter", "ClassifierMap"));
        }
        if (this.usedParameters != null) {
            if (this.usedParameters.contains(mIRUsedParameter)) {
                throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("ClassifierMap", "UsedParameter"));
            }
            if (!this._allowName(this.usedParameters, mIRUsedParameter)) {
                throw new IllegalArgumentException(MIRSDK.NAME_COLLISION.getMessage("ClassifierMap", this.getPath(), "UsedParameter", "Name", mIRUsedParameter.getPath()));
            }
        }
        this.getUsedParameterCollection().add(mIRUsedParameter);
        mIRUsedParameter.hasClassifierMap = this;
    }

    public final boolean addUsedParameterUniqueName(MIRUsedParameter mIRUsedParameter) {
        return this.addUsedParameterUniqueName(mIRUsedParameter, '/');
    }

    public final boolean addUsedParameterUniqueName(MIRUsedParameter mIRUsedParameter, char c) {
        if (mIRUsedParameter == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("ClassifierMap", "UsedParameter"));
        }
        if (mIRUsedParameter._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("ClassifierMap", "UsedParameter"));
        }
        if (mIRUsedParameter.hasClassifierMap != null) {
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("UsedParameter", "ClassifierMap"));
        }
        boolean bl = false;
        if (this.usedParameters != null) {
            if (this.usedParameters.contains(mIRUsedParameter)) {
                throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("ClassifierMap", "UsedParameter"));
            }
            if (!this._allowName(this.usedParameters, mIRUsedParameter)) {
                mIRUsedParameter._rename(mIRUsedParameter._setUniqueName(this.usedParameters, c));
                bl = true;
            }
        }
        this.getUsedParameterCollection().add(mIRUsedParameter);
        mIRUsedParameter.hasClassifierMap = this;
        return bl;
    }

    public final int getUsedParameterCount() {
        if (this.usedParameters != null) {
            return this.usedParameters.size();
        }
        return 0;
    }

    public final boolean containsUsedParameter(MIRUsedParameter mIRUsedParameter) {
        if (mIRUsedParameter != null && this.usedParameters != null) {
            return this.usedParameters.contains(mIRUsedParameter);
        }
        return false;
    }

    public final MIRUsedParameter getUsedParameter(String string) {
        if (this.usedParameters != null) {
            return this.usedParameters.get(string);
        }
        return null;
    }

    public final Iterator<MIRUsedParameter> getUsedParameterIterator() {
        if (this.usedParameters != null) {
            return this.usedParameters.iterator();
        }
        return MIRObjectCollections.emptySet().iterator();
    }

    public final boolean removeUsedParameter(MIRUsedParameter mIRUsedParameter) {
        if (mIRUsedParameter != null && this.usedParameters != null && this.usedParameters.remove(mIRUsedParameter)) {
            mIRUsedParameter.hasClassifierMap = null;
            if (this.usedParameters.isEmpty()) {
                this.usedParameters = null;
            }
            return true;
        }
        return false;
    }

    public final void removeUsedParameters() {
        if (this.usedParameters != null) {
            for (MIRUsedParameter mIRUsedParameter : this.usedParameters) {
                mIRUsedParameter.hasClassifierMap = null;
            }
            this.usedParameters = null;
        }
    }

    public static MIRMetaClass staticGetMetaClass() {
        if (metaClass == null) {
            metaClass = new MIRMetaClass(MIRElement.staticGetMetaClass(), 76, "ClassifierMap", false);
            new MIRMetaAttribute(metaClass, 50, "Operation", "java.lang.String", null, "");
            new MIRMetaLink(metaClass, 544, "Classifier", true, 2, 75, 543);
            new MIRMetaLink(metaClass, 545, "ControlClassifier", false, 0, 75, 546);
            new MIRMetaLink(metaClass, 1103, "DatabaseOperation", true, 2, 23, 1109);
            new MIRMetaLink(metaClass, 71, "DestinationClassifier", true, 0, 75, 64);
            new MIRMetaLink(metaClass, 542, "DiModel", true, 2, 258, 541);
            new MIRMetaLink(metaClass, 270, "Expression", true, 3, 112, 287);
            new MIRMetaLink(metaClass, 68, "FeatureMap", false, 3, 78, 117);
            new MIRMetaLink(metaClass, 70, "SourceClassifier", false, 0, 75, 63);
            new MIRMetaLink(metaClass, 69, "Transformation", true, 2, 79, 236);
            new MIRMetaLink(metaClass, 796, "UsedParameter", false, 3, 268, 795);
        }
        return metaClass;
    }

    @Override
    public MIRMetaClass getMetaClass() {
        return MIRClassifierMap.staticGetMetaClass();
    }

    @Override
    protected void _rename(String string) {
        if (this.controlClassifiers != null) {
            for (MIRClassifier mIRClassifier : this.controlClassifiers) {
                mIRClassifier.controlOfClassifierMaps.rename(this, string);
            }
        }
        if (this.hasDatabaseOperation != null) {
            this.hasDatabaseOperation.classifierMaps.rename(this, string);
        }
        if (this.hasDestinationClassifier != null) {
            this.hasDestinationClassifier.destinationOfClassifierMaps.rename(this, string);
        }
        if (this.hasDiModel != null) {
            this.hasDiModel.classifierMaps.rename(this, string);
        }
        if (this.sourceClassifiers != null) {
            for (MIRClassifier mIRClassifier : this.sourceClassifiers) {
                mIRClassifier.sourceOfClassifierMaps.rename(this, string);
            }
        }
        if (this.hasTransformation != null) {
            this.hasTransformation.classifierMaps.rename(this, string);
        }
        super._rename(string);
    }
}

