/*
 * Decompiled with CFR 0.152.
 */
package MITI.sdk;

import MITI.messages.MIR.MIRSDK;
import MITI.sdk.MIRBusinessRuleType;
import MITI.sdk.MIRMetaAttribute;
import MITI.sdk.MIRMetaClass;
import MITI.sdk.MIRMetaLink;
import MITI.sdk.MIRModelObject;
import MITI.sdk.MIRObject;
import MITI.sdk.MIRObjectCollections;
import MITI.sdk.MIRStoreModel;
import MITI.sdk.MIRTypeValue;
import MITI.sdk.MIR_Object;
import MITI.sdk.collections.MIRObjectCollection;
import MITI.sdk.collections.MIRSdkCollection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;

public class MIRBusinessRule
extends MIRModelObject {
    protected transient String aLowerBound = "";
    protected transient byte aType = (byte)3;
    protected transient String aUpperBound = "";
    protected transient String aValue = "";
    protected transient MIRObjectCollection<MIRModelObject> modelObjects = null;
    protected transient MIRStoreModel hasStoreModel = null;
    protected transient MIRObjectCollection<MIRTypeValue> typeValues = null;
    private static MIRMetaClass metaClass = MIRBusinessRule.staticGetMetaClass();

    public MIRBusinessRule() {
    }

    public MIRBusinessRule(MIRBusinessRule mIRBusinessRule) {
        this.setFrom(mIRBusinessRule);
    }

    @Override
    public Object clone() {
        return new MIRBusinessRule(this);
    }

    @Override
    public short getElementType() {
        return 100;
    }

    @Override
    public void setFrom(MIR_Object mIR_Object) {
        super.setFrom(mIR_Object);
        if (mIR_Object.isInstanceOf((short)100)) {
            this.setLowerBound(((MIRBusinessRule)mIR_Object).getLowerBound());
            this.setType(((MIRBusinessRule)mIR_Object).getType());
            this.setUpperBound(((MIRBusinessRule)mIR_Object).getUpperBound());
            this.setValue(((MIRBusinessRule)mIR_Object).getValue());
            if (((MIRBusinessRule)mIR_Object).getTypeValueCount() > 0) {
                Iterator<MIRTypeValue> iterator = ((MIRBusinessRule)mIR_Object).getTypeValueIterator();
                while (iterator.hasNext()) {
                    this.addTypeValue(new MIRTypeValue(iterator.next()));
                }
            }
        }
    }

    @Override
    public MIRObject getParent() {
        if (this.hasStoreModel != null) {
            return this.hasStoreModel;
        }
        return super.getParent();
    }

    @Override
    public int getParentCount() {
        return (this.hasStoreModel != null ? 1 : 0) + super.getParentCount();
    }

    public final void setLowerBound(String string) {
        this.aLowerBound = string == null ? "" : string;
    }

    public final String getLowerBound() {
        return this.aLowerBound;
    }

    public final void setType(byte by) {
        this.aType = by;
    }

    public final byte getType() {
        return this.aType;
    }

    public final void setUpperBound(String string) {
        this.aUpperBound = string == null ? "" : string;
    }

    public final String getUpperBound() {
        return this.aUpperBound;
    }

    public final void setValue(String string) {
        this.aValue = string == null ? "" : string;
    }

    public final String getValue() {
        return this.aValue;
    }

    protected MIRObjectCollection<MIRModelObject> getModelObjectCollection() {
        this.modelObjects = MIRObjectCollections.get(this.modelObjects, MIRSdkCollection.Type.OBJECT);
        return this.modelObjects;
    }

    public SortedSet<MIRModelObject> getModelObjects() {
        return MIRObjectCollections.sortedSet(this.modelObjects);
    }

    public final void addModelObject(MIRModelObject mIRModelObject) {
        if (mIRModelObject == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("BusinessRule", "ModelObject"));
        }
        if (mIRModelObject._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("BusinessRule", "ModelObject"));
        }
        if (this.modelObjects != null && this.modelObjects.contains(mIRModelObject)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("BusinessRule", "ModelObject"));
        }
        this.getModelObjectCollection().add(mIRModelObject);
        mIRModelObject.getAssociatedBusinessRuleCollection().add(this);
    }

    public final int getModelObjectCount() {
        if (this.modelObjects != null) {
            return this.modelObjects.size();
        }
        return 0;
    }

    public final boolean containsModelObject(MIRModelObject mIRModelObject) {
        if (mIRModelObject != null && this.modelObjects != null) {
            return this.modelObjects.contains(mIRModelObject);
        }
        return false;
    }

    public final MIRModelObject getModelObject(String string) {
        if (this.modelObjects != null) {
            return this.modelObjects.get(string);
        }
        return null;
    }

    public final Iterator<MIRModelObject> getModelObjectIterator() {
        if (this.modelObjects != null) {
            return this.modelObjects.iterator();
        }
        return MIRObjectCollections.emptySet().iterator();
    }

    public final boolean removeModelObject(MIRModelObject mIRModelObject) {
        if (mIRModelObject != null && this.modelObjects != null && this.modelObjects.remove(mIRModelObject)) {
            mIRModelObject.associatedBusinessRules.remove(this);
            if (mIRModelObject.associatedBusinessRules.isEmpty()) {
                mIRModelObject.associatedBusinessRules = null;
            }
            if (this.modelObjects.isEmpty()) {
                this.modelObjects = null;
            }
            return true;
        }
        return false;
    }

    public final void removeModelObjects() {
        if (this.modelObjects != null) {
            for (MIRModelObject mIRModelObject : this.modelObjects) {
                mIRModelObject.associatedBusinessRules.remove(this);
                if (!mIRModelObject.associatedBusinessRules.isEmpty()) continue;
                mIRModelObject.associatedBusinessRules = null;
            }
            this.modelObjects = null;
        }
    }

    public final void addStoreModel(MIRStoreModel mIRStoreModel) {
        if (mIRStoreModel == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("BusinessRule", "StoreModel"));
        }
        if (mIRStoreModel._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("BusinessRule", "StoreModel"));
        }
        if (this.hasStoreModel != null) {
            if (this.hasStoreModel._equals(mIRStoreModel)) {
                throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("BusinessRule", "StoreModel"));
            }
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("BusinessRule", "StoreModel"));
        }
        this.hasStoreModel = mIRStoreModel;
        mIRStoreModel.getBusinessRuleCollection().add(this);
    }

    public final MIRStoreModel getStoreModel() {
        return this.hasStoreModel;
    }

    public final boolean removeStoreModel() {
        if (this.hasStoreModel != null) {
            this.hasStoreModel.businessRules.remove(this);
            if (this.hasStoreModel.businessRules.isEmpty()) {
                this.hasStoreModel.businessRules = null;
            }
            this.hasStoreModel = null;
            return true;
        }
        return false;
    }

    protected MIRObjectCollection<MIRTypeValue> getTypeValueCollection() {
        this.typeValues = MIRObjectCollections.get(this.typeValues, MIRSdkCollection.Type.NAME_VALUE);
        return this.typeValues;
    }

    public SortedSet<MIRTypeValue> getTypeValues() {
        return MIRObjectCollections.sortedSet(this.typeValues);
    }

    public final void addTypeValue(MIRTypeValue mIRTypeValue) {
        if (mIRTypeValue == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("BusinessRule", "TypeValue"));
        }
        if (mIRTypeValue._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("BusinessRule", "TypeValue"));
        }
        if (mIRTypeValue.hasBusinessRule != null) {
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("TypeValue", "BusinessRule"));
        }
        if (this.typeValues != null) {
            if (this.typeValues.contains(mIRTypeValue)) {
                throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("BusinessRule", "TypeValue"));
            }
            if (!this._allowName(this.typeValues, mIRTypeValue)) {
                throw new IllegalArgumentException(MIRSDK.NAME_COLLISION.getMessage("BusinessRule", this.getPath(), "TypeValue", "NameValue", mIRTypeValue.getPath()));
            }
        }
        this.getTypeValueCollection().add(mIRTypeValue);
        mIRTypeValue.hasBusinessRule = this;
    }

    public final boolean addTypeValueUniqueName(MIRTypeValue mIRTypeValue) {
        return this.addTypeValueUniqueName(mIRTypeValue, '/');
    }

    public final boolean addTypeValueUniqueName(MIRTypeValue mIRTypeValue, char c) {
        if (mIRTypeValue == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("BusinessRule", "TypeValue"));
        }
        if (mIRTypeValue._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("BusinessRule", "TypeValue"));
        }
        if (mIRTypeValue.hasBusinessRule != null) {
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("TypeValue", "BusinessRule"));
        }
        boolean bl = false;
        if (this.typeValues != null) {
            if (this.typeValues.contains(mIRTypeValue)) {
                throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("BusinessRule", "TypeValue"));
            }
            if (!this._allowName(this.typeValues, mIRTypeValue)) {
                mIRTypeValue._rename(mIRTypeValue._setUniqueName(this.typeValues, c));
                bl = true;
            }
        }
        this.getTypeValueCollection().add(mIRTypeValue);
        mIRTypeValue.hasBusinessRule = this;
        return bl;
    }

    public final int getTypeValueCount() {
        if (this.typeValues != null) {
            return this.typeValues.size();
        }
        return 0;
    }

    public final boolean containsTypeValue(MIRTypeValue mIRTypeValue) {
        if (mIRTypeValue != null && this.typeValues != null) {
            return this.typeValues.contains(mIRTypeValue);
        }
        return false;
    }

    public final MIRTypeValue getTypeValue(String string) {
        if (this.typeValues != null) {
            return this.typeValues.get(string);
        }
        return null;
    }

    public final Iterator<MIRTypeValue> getTypeValueIterator() {
        if (this.typeValues != null) {
            return this.typeValues.iterator();
        }
        return MIRObjectCollections.emptySet().iterator();
    }

    public final List<MIRTypeValue> getTypeValueByPosition() {
        if (this.typeValues != null) {
            ArrayList<MIRTypeValue> arrayList = new ArrayList<MIRTypeValue>();
            arrayList.addAll(this.typeValues.values());
            MIRObjectCollections.sort(arrayList, MIRTypeValue.ByPosition);
            return arrayList;
        }
        return MIRObjectCollections.emptyList();
    }

    public final boolean removeTypeValue(MIRTypeValue mIRTypeValue) {
        if (mIRTypeValue != null && this.typeValues != null && this.typeValues.remove(mIRTypeValue)) {
            mIRTypeValue.hasBusinessRule = null;
            if (this.typeValues.isEmpty()) {
                this.typeValues = null;
            }
            return true;
        }
        return false;
    }

    public final void removeTypeValues() {
        if (this.typeValues != null) {
            for (MIRTypeValue mIRTypeValue : this.typeValues) {
                mIRTypeValue.hasBusinessRule = null;
            }
            this.typeValues = null;
        }
    }

    public static MIRMetaClass staticGetMetaClass() {
        if (metaClass == null) {
            metaClass = new MIRMetaClass(MIRModelObject.staticGetMetaClass(), 100, "BusinessRule", false);
            new MIRMetaAttribute(metaClass, 26, "Type", "java.lang.Byte", MIRBusinessRuleType.class, (byte)3);
            new MIRMetaAttribute(metaClass, 28, "Value", "java.lang.String", null, "");
            new MIRMetaAttribute(metaClass, 25, "LowerBound", "java.lang.String", null, "");
            new MIRMetaAttribute(metaClass, 27, "UpperBound", "java.lang.String", null, "");
            new MIRMetaLink(metaClass, 32, "ModelObject", false, 0, 59, 189);
            new MIRMetaLink(metaClass, 33, "StoreModel", true, 2, 2, 178);
            new MIRMetaLink(metaClass, 31, "TypeValue", false, 3, 7, 257);
        }
        return metaClass;
    }

    @Override
    public MIRMetaClass getMetaClass() {
        return MIRBusinessRule.staticGetMetaClass();
    }

    @Override
    protected void _rename(String string) {
        if (this.modelObjects != null) {
            for (MIRModelObject mIRModelObject : this.modelObjects) {
                mIRModelObject.associatedBusinessRules.rename(this, string);
            }
        }
        if (this.hasStoreModel != null) {
            this.hasStoreModel.businessRules.rename(this, string);
        }
        super._rename(string);
    }
}

