/*
 * Decompiled with CFR 0.152.
 */
package MITI.sdk;

import MITI.messages.MIR.MIRSDK;
import MITI.sdk.MIRExpressionNode;
import MITI.sdk.MIRMetaClass;
import MITI.sdk.MIRMetaLink;
import MITI.sdk.MIRObjectCollections;
import MITI.sdk.MIRParserNode;
import MITI.sdk.collections.MIRObjectCollection;
import MITI.sdk.collections.MIRSdkCollection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;

public class MIRBranchingNode
extends MIRParserNode {
    protected transient MIRObjectCollection<MIRExpressionNode> expressionNodes = null;
    private static MIRMetaClass metaClass = MIRBranchingNode.staticGetMetaClass();

    public MIRBranchingNode() {
    }

    public MIRBranchingNode(MIRBranchingNode mIRBranchingNode) {
        this.setFrom(mIRBranchingNode);
    }

    @Override
    public Object clone() {
        return new MIRBranchingNode(this);
    }

    @Override
    public short getElementType() {
        return 103;
    }

    protected MIRObjectCollection<MIRExpressionNode> getExpressionNodeCollection() {
        this.expressionNodes = MIRObjectCollections.get(this.expressionNodes, MIRSdkCollection.Type.OBJECT);
        return this.expressionNodes;
    }

    public SortedSet<MIRExpressionNode> getExpressionNodes() {
        return MIRObjectCollections.sortedSet(this.expressionNodes);
    }

    public final void addExpressionNode(MIRExpressionNode mIRExpressionNode) {
        if (mIRExpressionNode == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("BranchingNode", "ExpressionNode"));
        }
        if (mIRExpressionNode._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("BranchingNode", "ExpressionNode"));
        }
        if (mIRExpressionNode.hasBranchingNode != null) {
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("ExpressionNode", "BranchingNode"));
        }
        if (this.expressionNodes != null && this.expressionNodes.contains(mIRExpressionNode)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("BranchingNode", "ExpressionNode"));
        }
        this.getExpressionNodeCollection().add(mIRExpressionNode);
        mIRExpressionNode.hasBranchingNode = this;
    }

    public final int getExpressionNodeCount() {
        if (this.expressionNodes != null) {
            return this.expressionNodes.size();
        }
        return 0;
    }

    public final boolean containsExpressionNode(MIRExpressionNode mIRExpressionNode) {
        if (mIRExpressionNode != null && this.expressionNodes != null) {
            return this.expressionNodes.contains(mIRExpressionNode);
        }
        return false;
    }

    public final MIRExpressionNode getExpressionNode(String string) {
        if (this.expressionNodes != null) {
            return this.expressionNodes.get(string);
        }
        return null;
    }

    public final Iterator<MIRExpressionNode> getExpressionNodeIterator() {
        if (this.expressionNodes != null) {
            return this.expressionNodes.iterator();
        }
        return MIRObjectCollections.emptySet().iterator();
    }

    public final List<MIRExpressionNode> getExpressionNodeByPosition() {
        if (this.expressionNodes != null) {
            ArrayList<MIRExpressionNode> arrayList = new ArrayList<MIRExpressionNode>();
            arrayList.addAll(this.expressionNodes.values());
            MIRObjectCollections.sort(arrayList, MIRExpressionNode.ByPosition);
            return arrayList;
        }
        return MIRObjectCollections.emptyList();
    }

    public final boolean removeExpressionNode(MIRExpressionNode mIRExpressionNode) {
        if (mIRExpressionNode != null && this.expressionNodes != null && this.expressionNodes.remove(mIRExpressionNode)) {
            mIRExpressionNode.hasBranchingNode = null;
            if (this.expressionNodes.isEmpty()) {
                this.expressionNodes = null;
            }
            return true;
        }
        return false;
    }

    public final void removeExpressionNodes() {
        if (this.expressionNodes != null) {
            for (MIRExpressionNode mIRExpressionNode : this.expressionNodes) {
                mIRExpressionNode.hasBranchingNode = null;
            }
            this.expressionNodes = null;
        }
    }

    public static MIRMetaClass staticGetMetaClass() {
        if (metaClass == null) {
            metaClass = new MIRMetaClass(MIRParserNode.staticGetMetaClass(), 103, "BranchingNode", false);
            new MIRMetaLink(metaClass, 269, "ExpressionNode", false, 3, 113, 295);
        }
        return metaClass;
    }

    @Override
    public MIRMetaClass getMetaClass() {
        return MIRBranchingNode.staticGetMetaClass();
    }
}

