/*
 * Decompiled with CFR 0.152.
 */
package MITI.sdk;

import MITI.messages.MIR.MIRSDK;
import MITI.sdk.MIRArgumentType;
import MITI.sdk.MIRClass;
import MITI.sdk.MIRMetaAttribute;
import MITI.sdk.MIRMetaClass;
import MITI.sdk.MIRMetaLink;
import MITI.sdk.MIRModelObject;
import MITI.sdk.MIRObject;
import MITI.sdk.MIROperation;
import MITI.sdk.MIRType;
import MITI.sdk.MIR_Object;
import java.util.Comparator;

public class MIRArgument
extends MIRModelObject {
    protected transient String aDefaultValue = "";
    protected transient byte aKind = 0;
    protected transient short aPosition = 0;
    protected transient MIROperation hasOperation = null;
    protected transient MIRClass hasParameterizedClass = null;
    protected transient MIRType hasType = null;
    private static MIRMetaClass metaClass = MIRArgument.staticGetMetaClass();
    protected static final Comparator<MIRArgument> ByPosition = new Comparator<MIRArgument>(){

        @Override
        public int compare(MIRArgument mIRArgument, MIRArgument mIRArgument2) {
            return mIRArgument.getPosition() - mIRArgument2.getPosition();
        }
    };

    public MIRArgument() {
    }

    public MIRArgument(MIRArgument mIRArgument) {
        this.setFrom(mIRArgument);
    }

    @Override
    public Object clone() {
        return new MIRArgument(this);
    }

    @Override
    public short getElementType() {
        return 24;
    }

    @Override
    public void setFrom(MIR_Object mIR_Object) {
        super.setFrom(mIR_Object);
        if (mIR_Object.isInstanceOf((short)24)) {
            this.setDefaultValue(((MIRArgument)mIR_Object).getDefaultValue());
            this.setKind(((MIRArgument)mIR_Object).getKind());
            this.setPosition(((MIRArgument)mIR_Object).getPosition());
        }
    }

    @Override
    public MIRObject getParent() {
        if (this.hasOperation != null) {
            return this.hasOperation;
        }
        if (this.hasParameterizedClass != null) {
            return this.hasParameterizedClass;
        }
        return super.getParent();
    }

    @Override
    public int getParentCount() {
        return (this.hasOperation != null ? 1 : 0) + (this.hasParameterizedClass != null ? 1 : 0) + super.getParentCount();
    }

    public final void setDefaultValue(String string) {
        this.aDefaultValue = string == null ? "" : string;
    }

    public final String getDefaultValue() {
        return this.aDefaultValue;
    }

    public final void setKind(byte by) {
        this.aKind = by;
    }

    public final byte getKind() {
        return this.aKind;
    }

    public final void setPosition(short s) {
        this.aPosition = s;
    }

    public final short getPosition() {
        return this.aPosition;
    }

    public final void addOperation(MIROperation mIROperation) {
        if (mIROperation == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("Argument", "Operation"));
        }
        if (mIROperation._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("Argument", "Operation"));
        }
        if (this.hasOperation != null) {
            if (this.hasOperation._equals(mIROperation)) {
                throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("Argument", "Operation"));
            }
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("Argument", "Operation"));
        }
        if (mIROperation.arguments != null && !mIROperation._allowName(mIROperation.arguments, this)) {
            throw new IllegalArgumentException(MIRSDK.NAME_COLLISION.getMessage("Operation", mIROperation.getPath(), "Argument", "Object", this.getName()));
        }
        this.hasOperation = mIROperation;
        mIROperation.getArgumentCollection().add(this);
    }

    public final MIROperation getOperation() {
        return this.hasOperation;
    }

    public final boolean removeOperation() {
        if (this.hasOperation != null) {
            this.hasOperation.arguments.remove(this);
            if (this.hasOperation.arguments.isEmpty()) {
                this.hasOperation.arguments = null;
            }
            this.hasOperation = null;
            return true;
        }
        return false;
    }

    public final void addParameterizedClass(MIRClass mIRClass) {
        if (mIRClass == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("Argument", "ParameterizedClass"));
        }
        if (mIRClass._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("Argument", "ParameterizedClass"));
        }
        if (this.hasParameterizedClass != null) {
            if (this.hasParameterizedClass._equals(mIRClass)) {
                throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("Argument", "ParameterizedClass"));
            }
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("Argument", "ParameterizedClass"));
        }
        if (mIRClass.arguments != null && !mIRClass._allowName(mIRClass.arguments, this)) {
            throw new IllegalArgumentException(MIRSDK.NAME_COLLISION.getMessage("Class", mIRClass.getPath(), "Argument", "Object", this.getName()));
        }
        this.hasParameterizedClass = mIRClass;
        mIRClass.getArgumentCollection().add(this);
    }

    public final MIRClass getParameterizedClass() {
        return this.hasParameterizedClass;
    }

    public final boolean removeParameterizedClass() {
        if (this.hasParameterizedClass != null) {
            this.hasParameterizedClass.arguments.remove(this);
            if (this.hasParameterizedClass.arguments.isEmpty()) {
                this.hasParameterizedClass.arguments = null;
            }
            this.hasParameterizedClass = null;
            return true;
        }
        return false;
    }

    public final void addType(MIRType mIRType) {
        if (mIRType == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("Argument", "Type"));
        }
        if (mIRType._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("Argument", "Type"));
        }
        if (this.hasType != null) {
            if (this.hasType._equals(mIRType)) {
                throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("Argument", "Type"));
            }
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("Argument", "Type"));
        }
        this.hasType = mIRType;
        mIRType.getArgumentCollection().add(this);
    }

    public final MIRType getType() {
        return this.hasType;
    }

    public final boolean removeType() {
        if (this.hasType != null) {
            this.hasType.arguments.remove(this);
            if (this.hasType.arguments.isEmpty()) {
                this.hasType.arguments = null;
            }
            this.hasType = null;
            return true;
        }
        return false;
    }

    public static MIRMetaClass staticGetMetaClass() {
        if (metaClass == null) {
            metaClass = new MIRMetaClass(MIRModelObject.staticGetMetaClass(), 24, "Argument", false);
            new MIRMetaAttribute(metaClass, 3, "Position", "java.lang.Short", null, (short)0);
            new MIRMetaAttribute(metaClass, 1, "DefaultValue", "java.lang.String", null, "");
            new MIRMetaAttribute(metaClass, 2, "Kind", "java.lang.Byte", MIRArgumentType.class, (byte)0);
            new MIRMetaLink(metaClass, 3, "Operation", true, 2, 23, 192);
            new MIRMetaLink(metaClass, 5, "ParameterizedClass", true, 2, 13, 39);
            new MIRMetaLink(metaClass, 4, "Type", true, 0, 3, 248);
        }
        return metaClass;
    }

    @Override
    public MIRMetaClass getMetaClass() {
        return MIRArgument.staticGetMetaClass();
    }

    @Override
    protected boolean _isValidName() {
        if (this.hasOperation != null && !this.hasOperation._allowName(this.hasOperation.arguments, this)) {
            return false;
        }
        if (this.hasParameterizedClass != null && !this.hasParameterizedClass._allowName(this.hasParameterizedClass.arguments, this)) {
            return false;
        }
        return super._isValidName();
    }

    @Override
    protected void _rename(String string) {
        if (this.hasOperation != null) {
            this.hasOperation.arguments.rename(this, string);
        }
        if (this.hasParameterizedClass != null) {
            this.hasParameterizedClass.arguments.rename(this, string);
        }
        if (this.hasType != null) {
            this.hasType.arguments.rename(this, string);
        }
        super._rename(string);
    }
}

