/*
 * Decompiled with CFR 0.152.
 */
package com.sas.rpf.expr;

import antlr.CommonAST;
import antlr.RecognitionException;
import antlr.collections.AST;
import com.sas.rpf.data.Level;
import com.sas.rpf.expr.ExpressionElement;
import com.sas.rpf.expr.PrimitiveInterface;
import com.sas.rpf.expr.RB;
import com.sas.rpf.expr.SerializationException;
import com.sas.rpf.expr.parser.ExpressionSerializer;
import java.text.NumberFormat;
import java.util.List;
import java.util.Locale;

public class Primitive
extends ExpressionElement
implements PrimitiveInterface {
    private static final NumberFormat _numberFormat = NumberFormat.getNumberInstance(Locale.US);

    public static Primitive createNumber(double value) {
        return new Primitive(value, 15);
    }

    private static synchronized String convertDoubleToString(double value) {
        return _numberFormat.format(value);
    }

    private Primitive(double value, int type) {
        this(Primitive.convertDoubleToString(value), type);
    }

    public static Primitive createCharacterValue(String value) {
        return new Primitive(value, 21);
    }

    private Primitive(String dataItem, int type) {
        super((AST)new CommonAST());
        this.getAST().setType(type);
        this.getAST().setText(dataItem);
    }

    Primitive(AST ast) {
        super(ast);
        assert (ExpressionElement.isPrimitive(ast.getType())) : "Tried to instantiate expression as simple type";
        if (ast.getType() != 18 && ast.getType() != 17) assert (ast.getNumberOfChildren() == 0) : "Primitive types are atomic values";
    }

    public static Primitive createVariable(String variableName, List levels) {
        return new Primitive(variableName, levels, 18);
    }

    public static Primitive createFormattedVariable(String variableName, List levels) {
        Primitive variable = new Primitive(variableName, levels, 18);
        Primitive format = new Primitive("formatted", null, 17);
        format.getAST().addChild(variable.getAST());
        return format;
    }

    private Primitive(String dataItem, List levels, int type) {
        super((AST)new CommonAST());
        this.getAST().setType(type);
        this.getAST().setText(dataItem);
        if (levels != null) {
            for (Level level : levels) {
                CommonAST parentNode = new CommonAST();
                parentNode.setType(20);
                parentNode.setText(".");
                CommonAST dimensionNode = new CommonAST();
                dimensionNode.setType(19);
                dimensionNode.setText(level.getDimension());
                parentNode.addChild((AST)dimensionNode);
                CommonAST hierarchyNode = new CommonAST();
                hierarchyNode.setType(19);
                hierarchyNode.setText(level.getHierarchy());
                parentNode.addChild((AST)hierarchyNode);
                CommonAST levelNode = new CommonAST();
                levelNode.setType(19);
                levelNode.setText(level.getLevel());
                parentNode.addChild((AST)levelNode);
                this.getAST().addChild((AST)parentNode);
            }
        }
    }

    @Override
    public boolean isPrimitive() {
        return true;
    }

    @Override
    public boolean hasChildren() {
        return false;
    }

    @Override
    public int getType() {
        return this.getAST().getType();
    }

    @Override
    public String getExpressionString() throws SerializationException {
        ExpressionSerializer serializer = new ExpressionSerializer();
        AST ast = this.getAST();
        String result = "";
        try {
            result = serializer.serializePrimitive(ast);
        }
        catch (RecognitionException e) {
            throw new SerializationException(e, RB.getStringResource("Primitive.getExpressionString.Recognition.txt"));
        }
        return result;
    }

    public static PrimitiveInterface createMissingValue() {
        return new Primitive("missing", 16);
    }

    static {
        _numberFormat.setMinimumFractionDigits(0);
        _numberFormat.setMaximumFractionDigits(20);
        _numberFormat.setGroupingUsed(false);
    }
}

