/*
 * Decompiled with CFR 0.152.
 */
package com.sas.rpf.expr;

import antlr.collections.AST;
import com.sas.rpf.data.Level;
import com.sas.rpf.data.Variable;
import com.sas.rpf.expr.ExpressionElementInterface;
import com.sas.rpf.expr.ExpressionUtilInterface;
import com.sas.rpf.expr.IncompatibleExpressionElementsException;
import com.sas.rpf.expr.Primitive;
import com.sas.rpf.expr.RB;
import java.util.ArrayList;
import java.util.List;

public class ASTExpressionUtil
implements ExpressionUtilInterface {
    ASTExpressionUtil() {
    }

    @Override
    public Variable getVariable(ExpressionElementInterface expressionElt) {
        if (expressionElt.getType() != 18) {
            throw new RuntimeException(RB.getStringResource("ASTExpressionUtil.NotAVariable.txt"));
        }
        if (!(expressionElt instanceof Primitive)) {
            throw new IncompatibleExpressionElementsException(RB.getStringResource("ASTExpressionUtil.WrongType.txt"));
        }
        Primitive varNode = (Primitive)expressionElt;
        return new Variable(varNode.getAST().getText());
    }

    @Override
    public List getLevels(ExpressionElementInterface expressionElt) {
        if (expressionElt.getType() != 18 && expressionElt.getType() != 17) {
            throw new RuntimeException(RB.getStringResource("ASTExpressionUtil.NotAVariable.txt"));
        }
        if (!(expressionElt instanceof Primitive)) {
            throw new IncompatibleExpressionElementsException(RB.getStringResource("ASTExpressionUtil.WrongType.txt"));
        }
        ArrayList<Level> result = new ArrayList<Level>();
        Primitive varNode = (Primitive)expressionElt;
        AST levelNode = varNode.getAST().getFirstChild();
        if (varNode.getType() == 17) {
            levelNode = varNode.getAST().getFirstChild().getFirstChild();
        }
        while (levelNode != null) {
            String dimension = levelNode.getFirstChild().getText();
            String hierarchy = levelNode.getFirstChild().getNextSibling().getText();
            String level = levelNode.getFirstChild().getNextSibling().getNextSibling().getText();
            result.add(new Level(dimension, hierarchy, level));
            levelNode = levelNode.getNextSibling();
        }
        return result;
    }

    @Override
    public Variable getFormattedVariable(ExpressionElementInterface expressionElt) {
        if (expressionElt.getType() != 17) {
            throw new RuntimeException(RB.getStringResource("ASTExpressionUtil.NotAVariable.txt"));
        }
        if (!(expressionElt instanceof Primitive)) {
            throw new IncompatibleExpressionElementsException(RB.getStringResource("ASTExpressionUtil.WrongType.txt"));
        }
        Primitive varNode = (Primitive)expressionElt;
        return new Variable(varNode.getAST().getFirstChild().getText(), true);
    }
}

