/*
 * Decompiled with CFR 0.152.
 */
package com.sas.rpf.data;

import com.sas.rpf.data.IncompatibleTypeException;
import com.sas.rpf.data.MissingValue;
import com.sas.rpf.data.RB;
import com.sas.rpf.data.ValueInterface;
import java.text.MessageFormat;

public final class NumericValue
implements ValueInterface {
    private final double _value;

    public NumericValue(double value) {
        this._value = value;
    }

    @Override
    public boolean eq(ValueInterface other) throws IncompatibleTypeException {
        boolean returnValue;
        if (other instanceof MissingValue) {
            returnValue = other.eq(this);
        } else {
            NumericValue that = this.getNumberVariable(other);
            returnValue = this._value == that._value;
        }
        return returnValue;
    }

    @Override
    public boolean ge(ValueInterface other) throws IncompatibleTypeException {
        boolean returnValue;
        if (other instanceof MissingValue) {
            returnValue = other.lt(this);
        } else {
            NumericValue that = this.getNumberVariable(other);
            returnValue = this._value >= that._value;
        }
        return returnValue;
    }

    @Override
    public boolean gt(ValueInterface other) throws IncompatibleTypeException {
        boolean returnValue;
        if (other instanceof MissingValue) {
            returnValue = other.le(this);
        } else {
            NumericValue that = this.getNumberVariable(other);
            returnValue = this._value > that._value;
        }
        return returnValue;
    }

    @Override
    public boolean le(ValueInterface other) throws IncompatibleTypeException {
        boolean returnValue;
        if (other instanceof MissingValue) {
            returnValue = other.gt(this);
        } else {
            NumericValue that = this.getNumberVariable(other);
            returnValue = this._value <= that._value;
        }
        return returnValue;
    }

    @Override
    public boolean lt(ValueInterface other) throws IncompatibleTypeException {
        boolean returnValue;
        if (other instanceof MissingValue) {
            returnValue = other.ge(this);
        } else {
            NumericValue that = this.getNumberVariable(other);
            returnValue = this._value < that._value;
        }
        return returnValue;
    }

    @Override
    public boolean ne(ValueInterface other) throws IncompatibleTypeException {
        boolean returnValue;
        if (other instanceof MissingValue) {
            returnValue = other.ne(this);
        } else {
            NumericValue that = this.getNumberVariable(other);
            returnValue = this._value != that._value;
        }
        return returnValue;
    }

    private NumericValue getNumberVariable(ValueInterface other) throws IncompatibleTypeException {
        if (!(other instanceof NumericValue)) {
            Object[] args = new Object[]{this.getClass(), other.getClass()};
            String message = MessageFormat.format(RB.getStringResource("NumericValue.getStringVariable.IncompatibleType.fmt.txt"), args);
            throw new IncompatibleTypeException(message);
        }
        return (NumericValue)other;
    }

    public double getValue() {
        return this._value;
    }

    public String toString() {
        return Double.toString(this._value);
    }
}

