/*
 * Decompiled with CFR 0.152.
 */
package com.sas.rpf.data;

import com.sas.rpf.data.RB;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class Level {
    private final String _dimension;
    private final String _level;
    private final String _hierarchy;
    private String _toString = null;
    private int _hashCode = Integer.MIN_VALUE;

    public Level(String dimension, String hierarchy, String level) {
        this._dimension = dimension.toUpperCase();
        this._hierarchy = hierarchy.toUpperCase();
        this._level = level.toUpperCase();
    }

    public Level(String levelString) throws IllegalArgumentException {
        StringTokenizer tokens = new StringTokenizer(levelString, "[].", true);
        String dimension = null;
        String hierarchy = null;
        String level = null;
        boolean correctSyntax = true;
        try {
            correctSyntax &= tokens.nextToken().equals("[");
            dimension = tokens.nextToken();
            correctSyntax &= tokens.nextToken().equals("]");
            correctSyntax &= tokens.nextToken().equals(".");
            correctSyntax &= tokens.nextToken().equals("[");
            hierarchy = tokens.nextToken();
            correctSyntax &= tokens.nextToken().equals("]");
            if (tokens.hasMoreTokens()) {
                correctSyntax &= tokens.nextToken().equals(".");
                correctSyntax &= tokens.nextToken().equals("[");
                level = tokens.nextToken();
                correctSyntax &= tokens.nextToken().equals("]");
            } else {
                level = hierarchy;
                hierarchy = dimension;
            }
        }
        catch (NoSuchElementException e) {
            correctSyntax = false;
        }
        if (!correctSyntax) {
            throw new IllegalArgumentException(RB.getStringResource("Level.Constructor.IllegalArgument.txt"));
        }
        this._dimension = dimension.toUpperCase();
        this._hierarchy = hierarchy.toUpperCase();
        this._level = level.toUpperCase();
    }

    public String getLevel() {
        return this._level;
    }

    public String getDimension() {
        return this._dimension;
    }

    public String getHierarchy() {
        return this._hierarchy;
    }

    public String toString() {
        if (this._toString == null) {
            this._toString = "[" + this._dimension + "].[" + this._hierarchy + "].[" + this._level + "]";
        }
        return this._toString;
    }

    public int hashCode() {
        if (this._hashCode == Integer.MIN_VALUE) {
            this._hashCode = this.toString().toUpperCase().hashCode();
        }
        return this._hashCode;
    }

    public boolean equals(Object other) {
        if (other instanceof Level) {
            Level that = (Level)other;
            return this.toString().equalsIgnoreCase(that.toString());
        }
        return false;
    }
}

