/*
 * Decompiled with CFR 0.152.
 */
package com.sas.rpf.data;

import com.sas.rpf.data.DataVectorInterface;
import com.sas.rpf.data.Level;
import com.sas.rpf.data.RB;
import com.sas.rpf.data.ValueInterface;
import com.sas.rpf.data.VariableNotFoundException;
import java.text.MessageFormat;
import java.util.HashMap;

public class DataVector
implements DataVectorInterface {
    private HashMap _variables = new HashMap();
    private HashMap _drillLevels = new HashMap();
    private HashMap _formattedVariables = new HashMap();

    @Override
    public ValueInterface getValue(String variableName) throws VariableNotFoundException {
        Object result = this._variables.get(variableName);
        if (result == null) {
            throw new VariableNotFoundException(MessageFormat.format(RB.getStringResource("DataVector.getValue.VariableNotFound.fmt.txt"), variableName));
        }
        return (ValueInterface)result;
    }

    @Override
    public ValueInterface getFormattedValue(String variableName) throws VariableNotFoundException {
        Object result = this._formattedVariables.get(variableName);
        if (result == null) {
            Object[] args = new Object[]{variableName};
            throw new VariableNotFoundException(MessageFormat.format(RB.getStringResource("DataVector.getFormattedValue.VariableNotFound.fmt.txt"), args));
        }
        return (ValueInterface)result;
    }

    public void setValue(String variableName, ValueInterface value) {
        this._variables.put(variableName, value);
    }

    public void setFormattedValue(String variableName, ValueInterface value) {
        this._formattedVariables.put(variableName, value);
    }

    public void setDrillLevel(String dimension, String hierarchy, String level) {
        this.setDrillLevel(new Level(dimension, hierarchy, level));
    }

    public void setDrillLevel(Level drillLevel) {
        String key = DataVector.getKey(drillLevel);
        this._drillLevels.put(key, drillLevel);
    }

    @Override
    public boolean isDrilledToLevel(Level level) {
        Level drillLevel = (Level)this._drillLevels.get(DataVector.getKey(level));
        return drillLevel == null ? false : drillLevel.equals(level);
    }

    private static final String getKey(Level level) {
        return DataVector.getKey(level.getDimension(), level.getHierarchy());
    }

    private static final String getKey(String dimension, String hierarchy) {
        return '[' + dimension + "].[" + hierarchy + ']';
    }

    public String toString() {
        return "Drill Levels: " + this._drillLevels + " Variables: " + this._variables + this._formattedVariables;
    }

    @Override
    public void clear() {
        this._variables.clear();
        this._drillLevels.clear();
    }
}

