/*
 * Decompiled with CFR 0.152.
 */
package com.sas.rpf;

import com.sas.rpf.ActionInterface;
import com.sas.rpf.RuleInterface;
import com.sas.rpf.TargetInterface;
import com.sas.rpf.data.DataVectorInterface;
import com.sas.rpf.data.IncompatibleTypeException;
import com.sas.rpf.data.VariableNotFoundException;
import com.sas.rpf.exception.ParseException;
import com.sas.rpf.expr.EvaluateException;
import com.sas.rpf.expr.Expression;
import com.sas.rpf.expr.ExpressionInterface;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class Rule
implements RuleInterface {
    private Map _targetsToActionSets = new HashMap();
    private Map _targetsToActionArrays = new HashMap();
    private TargetInterface[] _targets = EMPTY_TARGET_ARRAY;
    private static final TargetInterface[] EMPTY_TARGET_ARRAY = new TargetInterface[0];
    private ExpressionInterface _expression = null;
    private boolean _processible = true;

    public Rule(String expressionString) throws ParseException {
        this._expression = Expression.compile(expressionString);
    }

    public Rule(ExpressionInterface expression) {
        this._expression = expression;
    }

    protected boolean evaluate(DataVectorInterface dataVector) throws VariableNotFoundException, IncompatibleTypeException, EvaluateException {
        return this._expression.evaluate(dataVector);
    }

    @Override
    public Set extractVariables() throws EvaluateException {
        return this._expression.extractVariables();
    }

    @Override
    public ExpressionInterface getExpression() {
        return this._expression;
    }

    @Override
    public void setExpression(ExpressionInterface expression) {
        this._expression = expression;
    }

    public String toString() {
        return this._expression.toString();
    }

    @Override
    public void add(TargetInterface target, ActionInterface action) {
        assert (target != null) : "Tried to add null as a target.";
        assert (action != null) : "Tried to add null as an action.";
        LinkedHashSet actionSet = this.addTarget(target);
        ActionInterface[] array = null;
        if (actionSet.add(action)) {
            array = new ActionInterface[actionSet.size()];
            Iterator iterator = actionSet.iterator();
            int i = 0;
            while (iterator.hasNext()) {
                array[i] = (ActionInterface)iterator.next();
                ++i;
            }
            this._targetsToActionArrays.put(target, array);
        }
    }

    @Override
    public boolean execute(DataVectorInterface dataVector) throws VariableNotFoundException, IncompatibleTypeException, EvaluateException {
        boolean returnValue = false;
        if (this.evaluate(dataVector)) {
            returnValue = true;
            for (int i = 0; i < this._targets.length; ++i) {
                TargetInterface target = this._targets[i];
                ActionInterface[] actions = this.getActionsForTarget(target);
                for (int j = 0; j < actions.length; ++j) {
                    ActionInterface action = actions[j];
                    target.execute(action);
                }
            }
        }
        return returnValue;
    }

    private LinkedHashSet addTarget(TargetInterface target) {
        LinkedHashSet actionSet = null;
        if (this._targetsToActionSets.containsKey(target)) {
            actionSet = (LinkedHashSet)this._targetsToActionSets.get(target);
        } else {
            actionSet = new LinkedHashSet();
            this._targetsToActionSets.put(target, actionSet);
            int targetCount = 0;
            if (this._targets != null) {
                targetCount = this._targets.length;
            }
            TargetInterface[] targets = new TargetInterface[targetCount + 1];
            for (int i = 0; i < targetCount; ++i) {
                targets[i] = this._targets[i];
            }
            targets[targetCount] = target;
            this._targets = targets;
        }
        return actionSet;
    }

    @Override
    public void add(TargetInterface target, ActionInterface[] actions) {
        LinkedHashSet actionSet = this.addTarget(target);
        ActionInterface[] array = null;
        boolean hasNewActions = false;
        for (int i = 0; i < actions.length; ++i) {
            if (!actionSet.add(actions[i])) continue;
            hasNewActions = true;
        }
        if (hasNewActions) {
            array = new ActionInterface[actionSet.size()];
            Iterator iterator = actionSet.iterator();
            int i = 0;
            while (iterator.hasNext()) {
                array[i] = (ActionInterface)iterator.next();
                ++i;
            }
            this._targetsToActionArrays.put(target, array);
        }
    }

    public ActionInterface[] getActionsForTarget(TargetInterface target) {
        return (ActionInterface[])this._targetsToActionArrays.get(target);
    }

    public TargetInterface[] getTargets() {
        TargetInterface[] result = new TargetInterface[this._targets.length];
        System.arraycopy(this._targets, 0, result, 0, this._targets.length);
        return result;
    }

    @Override
    public boolean isProcessible() {
        return this._processible;
    }

    @Override
    public void setProcessible(boolean processible) {
        this._processible = processible;
    }
}

