/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.content.streaming.client;

import com.sas.svcs.commons.ObjectIdentity;
import com.sas.svcs.content.client.util.ContentRESTUtils;
import com.sas.svcs.content.framework.client.ContentObject;
import com.sas.svcs.content.framework.client.ObjectNotFoundException;
import com.sas.svcs.content.objecttype.client.ObjectType;
import com.sas.svcs.content.objecttype.client.ObjectTypeService;
import com.sas.svcs.content.streaming.client.HttpClientInputStreamContents;
import com.sas.svcs.content.streaming.client.InputStreamContents;
import com.sas.svcs.content.streaming.client.StreamContents;
import com.sas.svcs.content.streaming.client.StreamService;
import com.sas.svcs.registry.client.RegisteredService;
import com.sas.svcs.registry.client.ServiceParameters;
import com.sas.svcs.registry.client.ServiceRegistryInterface;
import com.sas.svcs.registry.client.ServiceType;
import com.sas.svcs.security.authentication.client.AuthenticationClient;
import com.sas.svcs.security.authentication.client.AuthenticationClientHolder;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.util.Assert;

public class RegistryStreamService
implements StreamService {
    private static final Logger log = LogManager.getLogger(RegistryStreamService.class);
    private ServiceRegistryInterface registry;
    private String ticket;
    private String tgt;
    private ObjectTypeService objectTypeService;
    private HttpClient httpClient = HttpClientBuilder.create().build();

    @Autowired
    public void setObjectTypeService(ObjectTypeService objectTypeService) {
        this.objectTypeService = objectTypeService;
    }

    public void setServiceRegistry(ServiceRegistryInterface registry) {
        this.registry = registry;
    }

    public void setHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    @Override
    public void setStreamContents(ObjectIdentity id, String contentType, InputStream contents) throws IOException, ObjectNotFoundException {
        ObjectType type = this.objectTypeService.getTypeById(id.getObjectType());
        if (type == null) {
            throw new ObjectNotFoundException("Object type not found for object type: " + id.getObjectType(), id.getId());
        }
        this.setStreamContents(id.getId(), type.getName(), contentType, contents);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setStreamContents(String id, String typeName, String contentType, InputStream contents) throws IOException, ObjectNotFoundException {
        this.ticket = null;
        String baseURL = this.getBaseURL();
        String url = baseURL + "/" + typeName + "/" + ContentRESTUtils.getIdForLink((String)id);
        url = this.decorateURL(url);
        HttpPut httpPut = new HttpPut(url);
        InputStreamEntity requestEntity = new InputStreamEntity(contents);
        requestEntity.setContentType(contentType);
        requestEntity.setChunked(true);
        httpPut.setEntity((HttpEntity)requestEntity);
        try {
            this.execute(id, (HttpRequestBase)httpPut);
        }
        finally {
            httpPut.reset();
        }
    }

    @Override
    public StreamContents getStreamContents(ContentObject contentObject, OutputStream output) throws IOException {
        return this.getStreamContents(contentObject.getId(), contentObject.getObjectTypeName(), null, output);
    }

    @Override
    public void setStreamContents(ContentObject contentObject, String contentType, InputStream contents) throws IOException, ObjectNotFoundException {
        this.setStreamContents(contentObject.getId(), contentObject.getObjectTypeName(), contentType, contents);
    }

    @Override
    public StreamContents getStreamContents(ObjectIdentity id, OutputStream stream) throws IOException {
        ObjectType type = this.objectTypeService.getTypeById(id.getObjectType());
        if (type == null) {
            return null;
        }
        return this.getStreamContents(id.getId(), type.getName(), null, stream);
    }

    @Override
    public StreamContents getStreamContents(ObjectIdentity id, String versionName, OutputStream stream) throws IOException {
        ObjectType type = this.objectTypeService.getTypeById(id.getObjectType());
        if (type == null) {
            return null;
        }
        return this.getStreamContents(id.getId(), type.getName(), versionName, stream);
    }

    @Override
    public StreamContents getStreamContents(ContentObject contentObject, String versionName, OutputStream stream) throws IOException {
        return this.getStreamContents(contentObject.getId(), contentObject.getObjectTypeName(), versionName, stream);
    }

    @Override
    public InputStreamContents getInputStreamContents(ObjectIdentity oi) throws IOException {
        return this.getInputStreamContents(oi, null);
    }

    @Override
    public InputStreamContents getInputStreamContents(ObjectIdentity oi, String versionName) throws IOException {
        return this.getInputStreamContentsInternal(oi, versionName, true);
    }

    private InputStreamContents getInputStreamContentsInternal(ObjectIdentity oi, String versionName, boolean retryOnAuthFailure) throws IOException {
        String objectTypeName = this.objectTypeService.getTypeById(oi.getObjectType()).getName();
        String baseURL = this.getBaseURL();
        String url = baseURL + "/" + objectTypeName + "/" + ContentRESTUtils.getIdForLink((String)oi.getId());
        if (versionName != null) {
            url = url + "/" + versionName;
        }
        url = this.decorateURL(url);
        HttpGet httpGet = new HttpGet(url);
        try {
            HttpResponse httpResponse = this.execute(oi.getId(), (HttpRequestBase)httpGet);
            HttpClientInputStreamContents ret = new HttpClientInputStreamContents(new StreamContents(httpResponse.getEntity().getContentType().getValue(), httpResponse.getEntity().getContentLength()), (HttpRequestBase)httpGet, httpResponse);
            return ret;
        }
        catch (ObjectNotFoundException e) {
            return null;
        }
        catch (AccessDeniedException e) {
            if (retryOnAuthFailure) {
                this.ticket = null;
                return this.getInputStreamContentsInternal(oi, versionName, false);
            }
            throw e;
        }
    }

    private HttpResponse execute(String id, HttpRequestBase httpRequestBase) throws IOException, ClientProtocolException, ObjectNotFoundException {
        int respCode;
        HttpResponse httpResponse = this.httpClient.execute((HttpUriRequest)httpRequestBase);
        StatusLine statusLine = httpResponse.getStatusLine();
        if (statusLine != null && (respCode = statusLine.getStatusCode()) != 200) {
            if (respCode == 404) {
                log.warn(statusLine.getStatusCode() + " - " + statusLine.getReasonPhrase());
                throw new ObjectNotFoundException("Object not found : " + id, id);
            }
            if (respCode == 401) {
                throw new AccessDeniedException(statusLine.getReasonPhrase());
            }
            log.error("ERROR: " + EntityUtils.toString((HttpEntity)httpResponse.getEntity()));
            throw new RuntimeException("ERROR: " + statusLine.getReasonPhrase());
        }
        return httpResponse;
    }

    private ObjectIdentity getObjectIdentity(String objectTypeName, String objectId) {
        ObjectType type = this.objectTypeService.getTypeByName(objectTypeName);
        if (type == null) {
            return null;
        }
        return new ObjectIdentity(type.getId(), objectId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected StreamContents getStreamContents(String id, String objectTypeName, String versionName, OutputStream stream) throws IOException {
        ObjectIdentity oi = this.getObjectIdentity(objectTypeName, id);
        if (oi == null) {
            return null;
        }
        InputStreamContents isc = this.getInputStreamContents(oi, versionName);
        InputStream responseStream = isc.getInputStream();
        try {
            IOUtils.copy((InputStream)responseStream, (OutputStream)stream);
            responseStream.close();
        }
        finally {
            isc.releaseInputStream();
        }
        return isc.getStreamContents();
    }

    protected String getBaseURL() {
        RegisteredService service = this.registry.getService(new ServiceParameters("ContentStreamingService", ServiceType.REST));
        if (service == null) {
            throw new RuntimeException("ContentStreamingService not found");
        }
        String url = service.getUrl();
        if (url.contains(":80/")) {
            url = url.replace(":80/", "/");
            if (log.isDebugEnabled()) {
                log.debug("Removed :80/ from service url, new url is '" + url + "' for stream service: " + url);
            }
        } else if (url.contains(":443/")) {
            url = url.replace(":443/", "/");
            if (log.isDebugEnabled()) {
                log.debug("Removed :443/ from service url, new url is '" + url + "' for stream service: " + url);
            }
        }
        return url;
    }

    protected String decorateURL(String url) {
        AuthenticationClient authClient = AuthenticationClientHolder.get();
        Assert.notNull((Object)authClient, (String)"User must be logged in via the AuthenticationClient to access stream service.");
        Assert.notNull((Object)authClient.getTicketGrantingTicket(), (String)"User has logged out of the AuthenticationClient.  User must be logged in via the AuthenticationClient to access stream service.");
        if (this.ticket == null || this.tgt == null || !this.tgt.equals(authClient.getTicketGrantingTicket())) {
            log.debug("Getting a service ticket.");
            this.ticket = authClient.acquireTicket(url);
            this.tgt = authClient.getTicketGrantingTicket();
        }
        return url + "?ticket=" + this.ticket;
    }
}

