/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.content.streaming.client;

import com.sas.framework.services.config.dao.ServiceAlias;
import com.sas.framework.services.config.dao.ServiceURLDAO;
import com.sas.svcs.cluster.balance.LoadBalancePolicyInterface;
import com.sas.svcs.cluster.httpinvoker.RetryableException;
import com.sas.svcs.cluster.httpinvoker.ServiceCallback;
import com.sas.svcs.cluster.httpinvoker.ServiceExecutor;
import com.sas.svcs.commons.Identifiable;
import com.sas.svcs.commons.ObjectIdentity;
import com.sas.svcs.content.client.util.ContentRESTUtils;
import com.sas.svcs.content.framework.client.ContentObject;
import com.sas.svcs.content.framework.client.ObjectNotFoundException;
import com.sas.svcs.content.objecttype.client.ObjectType;
import com.sas.svcs.content.objecttype.client.ObjectTypeService;
import com.sas.svcs.content.streaming.client.HttpClientInputStreamContents;
import com.sas.svcs.content.streaming.client.InputStreamContents;
import com.sas.svcs.content.streaming.client.StreamContents;
import com.sas.svcs.content.streaming.client.StreamService;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.impl.client.HttpClientBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.cas.authentication.CasAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;

public class CacheStreamService
implements StreamService {
    private static final String SERVICE = "com.sas.svcs.content.streaming.spi.StreamSupportService";
    public static final String SERVICE_PREFIX = "/sas/auto/stream/com.sas.svcs.content.streaming.spi.StreamSupportService";
    public static final String ALIAS_PREFIX = "/sas/auto/content/aliases/com.sas.svcs.content.streaming.spi.StreamSupportService/";
    private ServiceURLDAO serviceURLDAO;
    private ObjectTypeService objectTypeService;
    private ServiceExecutor serviceExecutor;

    @Autowired
    public void setObjectTypeService(ObjectTypeService objectTypeService) {
        this.objectTypeService = objectTypeService;
    }

    @Autowired
    public void setLoadBalancePolicy(@Qualifier(value="com.sas.svcs.loadBalancePolicy") LoadBalancePolicyInterface lbPolicy) {
        this.serviceExecutor = new ServiceExecutor();
        this.serviceExecutor.setLoadBalancePolicy(lbPolicy);
    }

    public void setServiceURLDAO(ServiceURLDAO serviceURLDAO) {
        this.serviceURLDAO = serviceURLDAO;
    }

    @Autowired
    public void setProxyTicketHolder(Map<String, String> ticketHolder) {
    }

    private HttpClient getHttpClient() {
        return HttpClientBuilder.create().build();
    }

    @Override
    public StreamContents getStreamContents(ObjectIdentity id, OutputStream stream) throws IOException {
        return this.getStreamContents(id, null, stream);
    }

    @Override
    public StreamContents getStreamContents(ObjectIdentity id, String versionName, OutputStream stream) throws IOException {
        ObjectType objectType = this.objectTypeService.getTypeById(id.getObjectType());
        if (objectType == null) {
            throw new RuntimeException("Object type " + id.getObjectType() + " was not found.");
        }
        return this.getStreamContents(id, objectType.getName(), versionName, stream);
    }

    @Override
    public StreamContents getStreamContents(ContentObject contentObject, OutputStream stream) throws IOException {
        return this.getStreamContents(contentObject, null, stream);
    }

    @Override
    public StreamContents getStreamContents(ContentObject contentObject, String versionName, OutputStream stream) throws IOException {
        ObjectIdentity oi = new ObjectIdentity((Identifiable)contentObject);
        return this.getStreamContents(oi, contentObject.getObjectTypeName(), versionName, stream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StreamContents getStreamContents(ObjectIdentity oi, String objectTypeName, String versionName, OutputStream stream) throws IOException {
        String key = this.getServiceForObjectType(objectTypeName);
        GetStreamServiceCallback serviceCallback = new GetStreamServiceCallback(oi, objectTypeName, versionName);
        try {
            this.serviceExecutor.executeService(key, SERVICE, (ServiceCallback)serviceCallback);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        InputStreamContents isc = serviceCallback.streamContents;
        try {
            if (serviceCallback.statusCode != 200) {
                if (serviceCallback.statusCode == 404) {
                    StreamContents streamContents = null;
                    return streamContents;
                }
                if (serviceCallback.statusCode == 401) {
                    throw new AccessDeniedException(serviceCallback.statusText);
                }
                throw new RuntimeException(serviceCallback.statusText);
            }
            IOUtils.copy((InputStream)isc.getInputStream(), (OutputStream)stream);
            stream.close();
        }
        finally {
            if (isc != null) {
                isc.releaseInputStream();
            }
        }
        return serviceCallback.streamContents.getStreamContents();
    }

    @Override
    public void setStreamContents(ObjectIdentity id, String contentType, InputStream contents) throws ObjectNotFoundException, IOException {
        String objectTypeName = this.getObjectTypeName(id.getObjectType());
        if (objectTypeName == null) {
            throw new ObjectNotFoundException("Object type not found for object id: " + id.getObjectType(), id.getId());
        }
        String key = this.getServiceForObjectType(objectTypeName);
        PutStreamServiceCallback serviceCallback = new PutStreamServiceCallback(id, objectTypeName, contentType, contents);
        try {
            this.serviceExecutor.executeService(key, SERVICE, (ServiceCallback)serviceCallback);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        if (serviceCallback.statusCode != 200) {
            if (serviceCallback.statusCode == 404) {
                throw new ObjectNotFoundException("Not found", id.getId());
            }
            if (serviceCallback.statusCode == 401) {
                throw new AccessDeniedException(serviceCallback.statusText);
            }
            throw new RuntimeException(serviceCallback.statusText);
        }
    }

    @Override
    public void setStreamContents(ContentObject contentObject, String contentType, InputStream contents) throws ObjectNotFoundException, IOException {
        this.setStreamContents(new ObjectIdentity((Identifiable)contentObject), contentType, contents);
    }

    private String getObjectTypeName(long objectTypeId) {
        ObjectType type = this.objectTypeService.getTypeById(objectTypeId);
        if (type == null) {
            return null;
        }
        return type.getName();
    }

    private String getProxyTicketforURL(String baseURL, String url) {
        String proxyTicket = null;
        if (proxyTicket == null) {
            Authentication auth = SecurityContextHolder.getContext().getAuthentication();
            if (!(auth instanceof CasAuthenticationToken)) {
                throw new RuntimeException("ERROR: Authentication token is of wrong type: " + auth.getClass());
            }
            CasAuthenticationToken casAuth = (CasAuthenticationToken)auth;
            proxyTicket = casAuth.getAssertion().getPrincipal().getProxyTicketFor(url);
        }
        return proxyTicket;
    }

    private HttpResponse execute(String id, HttpRequestBase httpRequestBase) throws ClientProtocolException, IOException {
        return this.getHttpClient().execute((HttpUriRequest)httpRequestBase);
    }

    private String getAlias(String objectType) {
        String alias = null;
        if (null != this.serviceURLDAO) {
            ServiceAlias desiredServiceAlias = new ServiceAlias();
            desiredServiceAlias.setServiceInterface(SERVICE);
            desiredServiceAlias.setContext("/sas/auto/content/aliases/");
            desiredServiceAlias.setObjectType(objectType);
            ServiceAlias serviceAlias = this.serviceURLDAO.getAlias(desiredServiceAlias);
            if (null != serviceAlias) {
                alias = serviceAlias.getAliasType();
            }
        }
        return alias;
    }

    private String getServiceForObjectType(String objectType) {
        String alias = this.getAlias(objectType);
        String serviceObjectType = alias == null ? objectType : alias;
        return "/sas/auto/stream/com.sas.svcs.content.streaming.spi.StreamSupportService-" + serviceObjectType;
    }

    @Override
    public InputStreamContents getInputStreamContents(ObjectIdentity id) throws IOException {
        return this.getInputStreamContents(id, null);
    }

    @Override
    public InputStreamContents getInputStreamContents(ObjectIdentity id, String versionName) throws IOException {
        String objectTypeName = this.getObjectTypeName(id.getObjectType());
        if (objectTypeName == null) {
            return null;
        }
        String key = this.getServiceForObjectType(objectTypeName);
        GetStreamServiceCallback serviceCallback = new GetStreamServiceCallback(id, objectTypeName, versionName);
        try {
            this.serviceExecutor.executeService(key, SERVICE, (ServiceCallback)serviceCallback);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        if (serviceCallback.statusCode != 200) {
            if (serviceCallback.statusCode == 404) {
                return null;
            }
            if (serviceCallback.statusCode == 401) {
                throw new AccessDeniedException(serviceCallback.statusText);
            }
            throw new RuntimeException(serviceCallback.statusText);
        }
        return serviceCallback.streamContents;
    }

    public class GetStreamServiceCallback
    implements ServiceCallback {
        ObjectIdentity oi;
        String objectTypeName;
        String versionName;
        InputStreamContents streamContents = null;
        int statusCode = 200;
        String statusText = null;

        public GetStreamServiceCallback(ObjectIdentity oi, String objectTypeName, String versionName) {
            this.oi = oi;
            this.objectTypeName = objectTypeName;
            this.versionName = versionName;
        }

        public void callService(String inUrl) throws RetryableException, IOException {
            String url = inUrl + "/" + this.objectTypeName + "/" + ContentRESTUtils.getIdForLink((String)this.oi.getId());
            if (this.versionName != null) {
                url = url + "/" + this.versionName;
            }
            url = url + "?ticket=" + CacheStreamService.this.getProxyTicketforURL(inUrl, url);
            HttpGet httpGet = new HttpGet(url);
            try {
                HttpResponse httpResponse = CacheStreamService.this.execute(this.oi.getId(), (HttpRequestBase)httpGet);
                StatusLine statusLine = httpResponse.getStatusLine();
                if (statusLine != null && statusLine.getStatusCode() != 200) {
                    this.statusCode = statusLine.getStatusCode();
                    this.statusText = statusLine.getReasonPhrase();
                    return;
                }
                long length = httpResponse.getEntity().getContentLength();
                String contentType = httpResponse.getEntity().getContentType().getValue();
                this.streamContents = new HttpClientInputStreamContents(new StreamContents(contentType, length), (HttpRequestBase)httpGet, httpResponse);
            }
            catch (ClientProtocolException e) {
                throw new RetryableException((Throwable)e);
            }
            catch (IOException e) {
                throw new RetryableException((Throwable)e);
            }
        }
    }

    private class PutStreamServiceCallback
    implements ServiceCallback {
        ObjectIdentity oi;
        String objectTypeName;
        String contentType;
        InputStream in;
        int statusCode = 200;
        String statusText = null;

        public PutStreamServiceCallback(ObjectIdentity oi, String objectTypeName, String contentType, InputStream in) {
            this.oi = oi;
            this.objectTypeName = objectTypeName;
            this.contentType = contentType;
            this.in = in;
        }

        public void callService(String inUrl) throws RetryableException {
            String url = inUrl + "/" + this.objectTypeName + "/" + ContentRESTUtils.getIdForLink((String)this.oi.getId());
            url = url + "?ticket=" + CacheStreamService.this.getProxyTicketforURL(inUrl, url);
            HttpPut httpPut = new HttpPut(url);
            InputStreamEntity requestEntity = new InputStreamEntity(this.in);
            requestEntity.setContentType(this.contentType);
            requestEntity.setChunked(true);
            httpPut.setEntity((HttpEntity)requestEntity);
            try {
                HttpResponse httpResponse = CacheStreamService.this.execute(this.oi.getId(), (HttpRequestBase)httpPut);
                StatusLine statusLine = httpResponse.getStatusLine();
                if (statusLine != null && statusLine.getStatusCode() != 200) {
                    this.statusCode = statusLine.getStatusCode();
                    this.statusText = statusLine.getReasonPhrase();
                    return;
                }
            }
            catch (ClientProtocolException e) {
                throw new RetryableException((Throwable)e);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            finally {
                httpPut.releaseConnection();
            }
        }
    }
}

