/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.content.search.client.value;

import com.sas.svcs.content.search.client.namepath.ValueFormatException;
import com.sas.svcs.content.search.client.value.BaseNonStreamValue;
import com.sas.svcs.content.search.client.value.BooleanValue;
import com.sas.svcs.content.search.client.value.DoubleValue;
import com.sas.svcs.content.search.client.value.ISO8601;
import com.sas.svcs.content.search.client.value.LongValue;
import com.sas.svcs.content.search.client.value.StatefulValue;
import java.io.Serializable;
import java.util.Calendar;

public class StringValue
extends BaseNonStreamValue
implements Serializable,
StatefulValue {
    private static final long serialVersionUID = -6456025645604163205L;
    private final String value;

    protected StringValue(String value) {
        this.value = value;
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public String getString() {
        return this.value;
    }

    @Override
    public long getLong() throws ValueFormatException {
        return LongValue.toLong(this.value);
    }

    @Override
    public double getDouble() throws ValueFormatException {
        return DoubleValue.toDouble(this.value);
    }

    @Override
    public Calendar getDate() throws ValueFormatException {
        return ISO8601.parse(this.value);
    }

    @Override
    public boolean getBoolean() {
        return BooleanValue.toBoolean(this.value);
    }
}

