/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.content.search.client.value;

import com.sas.svcs.content.search.client.namepath.ValueFormatException;
import com.sas.svcs.content.search.client.value.BaseNonStreamValue;
import com.sas.svcs.content.search.client.value.StatefulValue;
import java.io.Serializable;
import java.util.Calendar;

public class DoubleValue
extends BaseNonStreamValue
implements Serializable,
StatefulValue {
    private static final long serialVersionUID = 1008752925622023274L;
    private final double value;

    protected DoubleValue(double value) {
        this.value = value;
    }

    protected DoubleValue(String value) throws ValueFormatException {
        this(DoubleValue.toDouble(value));
    }

    protected static double toDouble(String value) throws ValueFormatException {
        try {
            return Double.valueOf(value);
        }
        catch (NumberFormatException e) {
            throw new ValueFormatException(e);
        }
    }

    @Override
    public int getType() {
        return 4;
    }

    @Override
    public Calendar getDate() throws ValueFormatException {
        Calendar date = Calendar.getInstance();
        date.setTimeInMillis((long)this.value);
        return date;
    }

    @Override
    public double getDouble() {
        return this.value;
    }

    @Override
    public String getString() {
        return Double.toString(this.value);
    }

    @Override
    public long getLong() {
        return (long)this.value;
    }
}

