/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.content.search.client.value;

import com.sas.svcs.content.search.client.namepath.ValueFormatException;
import com.sas.svcs.content.search.client.value.StatefulValue;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Calendar;

public class BinaryValue
implements Serializable,
StatefulValue {
    private static final long serialVersionUID = -2410070522924274051L;
    private InputStream stream;

    protected BinaryValue(InputStream stream) {
        this.stream = stream;
    }

    protected BinaryValue(String value) throws ValueFormatException {
        this(BinaryValue.toStream(value));
    }

    protected static InputStream toStream(String value) throws ValueFormatException {
        try {
            return new ByteArrayInputStream(value.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new ValueFormatException("Invalid string value encoding", e);
        }
    }

    @Override
    public InputStream getStream() {
        return this.stream;
    }

    @Override
    public int getType() {
        return 2;
    }

    @Override
    public String getString() throws IllegalStateException {
        throw new IllegalStateException("Stream already retrieved");
    }

    @Override
    public long getLong() throws IllegalStateException {
        throw new IllegalStateException("Stream already retrieved");
    }

    @Override
    public double getDouble() throws IllegalStateException {
        throw new IllegalStateException("Stream already retrieved");
    }

    @Override
    public Calendar getDate() throws IllegalStateException {
        throw new IllegalStateException("Stream already retrieved");
    }

    @Override
    public boolean getBoolean() throws IllegalStateException {
        throw new IllegalStateException("Stream already retrieved");
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        byte[] buffer = new byte[4096];
        int bytes = 0;
        while ((bytes = this.stream.read(buffer)) >= 0) {
            if (bytes <= 0) continue;
            out.writeInt(bytes);
            out.write(buffer, 0, bytes);
        }
        out.writeInt(0);
        this.stream.close();
    }

    private void readObject(ObjectInputStream in) throws IOException {
        final File file = File.createTempFile("jcr-value", "bin");
        FileOutputStream out = new FileOutputStream(file);
        byte[] buffer = new byte[4096];
        int bytes = in.readInt();
        while (bytes > 0) {
            if (buffer.length < bytes) {
                buffer = new byte[bytes];
            }
            in.readFully(buffer, 0, bytes);
            ((OutputStream)out).write(buffer, 0, bytes);
            bytes = in.readInt();
        }
        ((OutputStream)out).close();
        this.stream = new FileInputStream(file){
            private boolean closed;
            {
                super(arg0);
                this.closed = false;
            }

            @Override
            public void close() throws IOException {
                super.close();
                this.closed = true;
                file.delete();
            }

            protected void finalize() throws IOException {
                try {
                    if (!this.closed) {
                        file.delete();
                    }
                }
                finally {
                    super.finalize();
                }
            }
        };
    }
}

